/*
 * Decompiled with CFR 0.152.
 */
package ome.services;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.NonWritableChannelException;
import java.sql.SQLException;
import java.sql.Timestamp;
import ome.annotations.RolesAllowed;
import ome.api.IAdmin;
import ome.api.IRepositoryInfo;
import ome.api.RawFileStore;
import ome.api.ServiceInterface;
import ome.conditions.ApiUsageException;
import ome.conditions.InternalException;
import ome.conditions.ResourceError;
import ome.conditions.RootException;
import ome.conditions.SecurityViolation;
import ome.io.nio.FileBuffer;
import ome.io.nio.OriginalFilesService;
import ome.model.core.OriginalFile;
import ome.services.AbstractStatefulBean;
import ome.services.RawPixelsBean;
import ome.util.ShallowCopy;
import ome.util.checksum.ChecksumProviderFactory;
import ome.util.checksum.ChecksumType;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
public class RawFileBean
extends AbstractStatefulBean
implements RawFileStore {
    private static final long serialVersionUID = -450924529925301925L;
    private static Logger log = LoggerFactory.getLogger(RawPixelsBean.class);
    private static final ImmutableMap<String, ChecksumType> checksumAlgorithms = ImmutableMap.builder().put("Adler-32", ChecksumType.ADLER32).put("CRC-32", ChecksumType.CRC32).put("MD5-128", ChecksumType.MD5).put("Murmur3-32", ChecksumType.MURMUR32).put("Murmur3-128", ChecksumType.MURMUR128).put("SHA1-160", ChecksumType.SHA1).put("File-Size-64", ChecksumType.FILE_SIZE).build();
    private Long id;
    private transient Long reset = null;
    private transient OriginalFile file;
    private transient FileBuffer buffer;
    private transient OriginalFilesService ioService;
    private transient IRepositoryInfo iRepositoryInfo;
    private transient IAdmin admin;
    private transient ChecksumProviderFactory checksumProviderFactory;
    private transient boolean diskSpaceChecking;

    public RawFileBean() {
    }

    public RawFileBean(boolean checking) {
        this.diskSpaceChecking = checking;
    }

    @Override
    public Class<? extends ServiceInterface> getServiceInterface() {
        return RawFileStore.class;
    }

    public final void setOriginalFilesService(OriginalFilesService ioService) {
        this.getBeanHelper().throwIfAlreadySet(this.ioService, ioService);
        this.ioService = ioService;
    }

    public final void setIRepositoryInfo(IRepositoryInfo iRepositoryInfo) {
        this.getBeanHelper().throwIfAlreadySet(this.iRepositoryInfo, iRepositoryInfo);
        this.iRepositoryInfo = iRepositoryInfo;
    }

    public final void setAdminService(IAdmin admin) {
        this.getBeanHelper().throwIfAlreadySet(this.admin, admin);
        this.admin = admin;
    }

    public final void setChecksumProviderFactory(ChecksumProviderFactory checksumProviderFactory) {
        this.getBeanHelper().throwIfAlreadySet(this.checksumProviderFactory, checksumProviderFactory);
        this.checksumProviderFactory = checksumProviderFactory;
    }

    @Override
    @RolesAllowed(value={"user"})
    @Transactional(readOnly=true)
    public void passivate() {
    }

    @Override
    @RolesAllowed(value={"user"})
    @Transactional(readOnly=true)
    public void activate() {
        if (this.id != null) {
            this.reset = this.id;
            this.id = null;
        }
    }

    @Override
    protected boolean isModified() {
        long fileSize;
        if (super.isModified()) {
            return true;
        }
        if (this.file == null || this.buffer == null || this.file.getSize() == null) {
            return false;
        }
        long dbSize = this.file.getSize();
        return dbSize != (fileSize = this.size());
    }

    @Override
    @RolesAllowed(value={"user"})
    @Transactional(readOnly=false)
    public synchronized OriginalFile save() {
        Long id;
        Long l = id = this.file == null ? null : this.file.getId();
        if (id == null) {
            return null;
        }
        if (this.isModified() || this.buffer != null && this.size() == 0L) {
            String path = this.buffer.getPath();
            try {
                this.buffer.flush(true);
            }
            catch (IOException ie) {
                String msg = "cannot flush " + path + ": " + ie;
                log.warn(msg);
                this.clean();
                throw new ResourceError(msg);
            }
            try {
                if (this.file.getHasher() != null) {
                    ChecksumType checksumType = checksumAlgorithms.get(this.file.getHasher().getValue());
                    this.file.setHash(this.checksumProviderFactory.getProvider(checksumType).putFile(path).checksumAsString());
                }
                File f = new File(path);
                long size = f.length();
                this.file.setSize(size);
                this.file.setMtime(new Timestamp(f.lastModified()));
            }
            catch (RuntimeException re) {
                if (re.getCause() instanceof FileNotFoundException) {
                    String msg = "Cannot find path. Deleted? " + path;
                    log.warn(msg);
                    this.clean();
                    throw new ResourceError(msg);
                }
                throw re;
            }
            this.iUpdate.flush();
            this.modified = false;
            return new ShallowCopy().copy(this.file);
        }
        return null;
    }

    @Override
    @RolesAllowed(value={"user"})
    @Transactional(readOnly=false)
    public synchronized void close() {
        try {
            this.save();
        }
        catch (RootException root) {
            throw root;
        }
        catch (RuntimeException re) {
            Long id = this.file == null ? null : this.file.getId();
            log.error("Failed to update file: " + id, re);
        }
        finally {
            this.clean();
        }
    }

    public void clean() {
        this.ioService = null;
        this.file = null;
        this.closeFileBuffer();
        this.buffer = null;
    }

    private void closeFileBuffer() {
        try {
            if (this.buffer != null) {
                this.buffer.close();
            }
        }
        catch (IOException e) {
            if (log.isDebugEnabled()) {
                log.debug("Buffer could not be closed successfully.", e);
            }
            throw new ResourceError(e.getMessage() + " Please check server log.");
        }
    }

    @Override
    @RolesAllowed(value={"user"})
    @Transactional(readOnly=true)
    public synchronized Long getFileId() {
        return this.id;
    }

    @Override
    @RolesAllowed(value={"user"})
    @Transactional(readOnly=true)
    public synchronized void setFileId(long fileId) {
        this.setFileIdWithBuffer(fileId, null);
    }

    public synchronized void setFileIdWithBuffer(final long fileId, FileBuffer buffer) {
        if (this.id == null || this.id != fileId) {
            this.id = new Long(fileId);
            this.file = null;
            this.closeFileBuffer();
            this.buffer = null;
            this.modified = false;
            this.file = this.iQuery.get(OriginalFile.class, fileId);
            String mode = "r";
            try {
                if (this.admin.canUpdate(this.file)) {
                    mode = "rw";
                }
            }
            catch (InternalException ie) {
                log.warn("No permissions info: using 'r' as mode for file " + fileId);
            }
            if (buffer == null) {
                String repo = (String)this.iQuery.execute((HibernateCallback)new HibernateCallback<String>(){

                    public String doInHibernate(Session arg0) throws HibernateException, SQLException {
                        return (String)arg0.createSQLQuery("select repo from originalfile where id = ?").setParameter(0, (Object)fileId).uniqueResult();
                    }
                });
                if (repo != null) {
                    throw new RuntimeException(repo);
                }
                this.buffer = this.ioService.getFileBuffer(this.file, mode);
            } else {
                this.buffer = buffer;
            }
        }
    }

    private synchronized void errorIfNotLoaded() {
        if (this.reset != null) {
            this.id = null;
            this.setFileId(this.reset);
            this.reset = null;
        }
        if (this.buffer == null) {
            throw new ApiUsageException("This RawFileStore has not been properly initialized.\nPlease set the file id before executing any other methods.\n");
        }
    }

    @Override
    @RolesAllowed(value={"user"})
    public boolean exists() {
        this.errorIfNotLoaded();
        return new File(this.buffer.getPath()).exists();
    }

    @Override
    @RolesAllowed(value={"user"})
    public byte[] read(long position, int length) {
        this.errorIfNotLoaded();
        this.sec.checkRestriction("RESTRICT-BINARY-ACCESS", this.file);
        byte[] rawBuf = new byte[length];
        ByteBuffer buf = ByteBuffer.wrap(rawBuf);
        try {
            this.buffer.read(buf, position);
        }
        catch (IOException e) {
            if (log.isDebugEnabled()) {
                log.debug("Buffer could not be read.", e);
            }
            throw new ResourceError(e.getMessage());
        }
        return rawBuf;
    }

    @Override
    @RolesAllowed(value={"user"})
    public boolean truncate(long length) {
        this.errorIfNotLoaded();
        try {
            if (length < this.buffer.size()) {
                this.buffer.truncate(length);
                this.modified();
                return true;
            }
            return false;
        }
        catch (NonWritableChannelException nwce) {
            throw new SecurityViolation("File not writeable!");
        }
        catch (IOException e) {
            if (log.isDebugEnabled()) {
                log.debug("Buffer write did not occur.", e);
            }
            throw new ResourceError(e.getMessage());
        }
    }

    @Override
    @RolesAllowed(value={"user"})
    public long size() {
        this.errorIfNotLoaded();
        try {
            return this.buffer.size();
        }
        catch (IOException e) {
            if (log.isDebugEnabled()) {
                log.debug("Buffer write did not occur.", e);
            }
            throw new ResourceError(e.getMessage());
        }
    }

    @Override
    @RolesAllowed(value={"user"})
    public void write(byte[] buf, long position, int length) {
        this.errorIfNotLoaded();
        ByteBuffer nioBuffer = MappedByteBuffer.wrap(buf);
        nioBuffer.limit(length);
        if (this.diskSpaceChecking) {
            this.iRepositoryInfo.sanityCheckRepository();
        }
        try {
            do {
                position += (long)this.buffer.write(nioBuffer, position);
            } while (nioBuffer.hasRemaining());
            this.modified();
        }
        catch (NonWritableChannelException nwce) {
            throw new SecurityViolation("File not writeable!");
        }
        catch (IOException e) {
            if (log.isDebugEnabled()) {
                log.debug("Buffer write did not occur.", e);
            }
            throw new ResourceError(e.getMessage());
        }
    }

    public boolean isDiskSpaceChecking() {
        return this.diskSpaceChecking;
    }

    public void setDiskSpaceChecking(boolean diskSpaceChecking) {
        this.diskSpaceChecking = diskSpaceChecking;
    }
}

