/*
 * Decompiled with CFR 0.152.
 */
package ome.security.sharing;

import java.util.Set;
import ome.conditions.SecurityViolation;
import ome.model.IObject;
import ome.model.internal.Details;
import ome.model.internal.Permissions;
import ome.security.ACLVoter;
import ome.security.SystemTypes;
import ome.security.basic.CurrentDetails;
import ome.security.basic.TokenHolder;
import ome.services.sharing.ShareStore;
import ome.services.sharing.data.ShareData;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class SharingACLVoter
implements ACLVoter {
    private static final Logger log = LoggerFactory.getLogger(SharingACLVoter.class);
    private final SystemTypes sysTypes;
    private final ShareStore store;
    private final CurrentDetails cd;
    private final TokenHolder tokenHolder;

    public SharingACLVoter(CurrentDetails cd, SystemTypes sysTypes, ShareStore store, TokenHolder tokenHolder) {
        this.tokenHolder = tokenHolder;
        this.sysTypes = sysTypes;
        this.store = store;
        this.cd = cd;
    }

    @Override
    public boolean allowChmod(IObject iObject) {
        return false;
    }

    @Override
    public boolean allowLoad(Session session, Class<? extends IObject> klass, Details d, long id) {
        Assert.notNull(klass);
        if (d == null || this.sysTypes.isSystemType(klass) || this.sysTypes.isInSystemGroup(d)) {
            return true;
        }
        long sessionID = this.cd.getCurrentEventContext().getCurrentShareId();
        ShareData data = this.store.get(sessionID);
        if (data.enabled) {
            return this.store.contains(sessionID, klass, id);
        }
        return false;
    }

    @Override
    public void throwLoadViolation(IObject iObject) throws SecurityViolation {
        Assert.notNull(iObject);
        throw new SecurityViolation(iObject + " not contained in share");
    }

    @Override
    public boolean allowCreation(IObject iObject) {
        return this.tokenHolder.hasPrivilegedToken(iObject);
    }

    @Override
    public void throwCreationViolation(IObject iObject) throws SecurityViolation {
        this.throwDisabled("Creation");
    }

    @Override
    public boolean allowAnnotate(IObject iObject, Details trustedDetails) {
        return false;
    }

    @Override
    public boolean allowUpdate(IObject iObject, Details trustedDetails) {
        return false;
    }

    @Override
    public void throwUpdateViolation(IObject iObject) throws SecurityViolation {
        this.throwDisabled("Update");
    }

    @Override
    public boolean allowDelete(IObject iObject, Details trustedDetails) {
        return false;
    }

    @Override
    public void throwDeleteViolation(IObject iObject) throws SecurityViolation {
        this.throwDisabled("Delete");
    }

    @Override
    public Set<String> restrictions(IObject object) {
        return null;
    }

    @Override
    public void postProcess(IObject object) {
        if (object != null && object.isLoaded()) {
            Details d = object.getDetails();
            Permissions p = d.getPermissions();
            Permissions copy = new Permissions(p);
            copy.copyRestrictions(0, null);
            d.setPermissions(copy);
        }
    }

    protected void throwDisabled(String action) {
        throw new SecurityViolation(action + " is not allowed while in share.");
    }

    private Long group(Details d) {
        if (d == null || d.getGroup() == null) {
            return null;
        }
        return d.getGroup().getId();
    }
}

