/*
 * Decompiled with CFR 0.152.
 */
package ome.security.policy;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import ome.conditions.SecurityViolation;
import ome.model.IObject;
import ome.model.core.Image;
import ome.model.core.OriginalFile;
import ome.model.fs.Fileset;
import ome.model.fs.FilesetEntry;
import ome.model.internal.NamedValue;
import ome.model.meta.ExperimenterGroup;
import ome.model.screen.Plate;
import ome.model.screen.PlateAcquisition;
import ome.model.screen.Well;
import ome.model.screen.WellSample;
import ome.security.ACLVoter;
import ome.security.policy.BasePolicy;
import org.hibernate.AssertionFailure;
import org.hibernate.Hibernate;

public class BinaryAccessPolicy
extends BasePolicy {
    public static final String NAME = "RESTRICT-BINARY-ACCESS";
    private final ACLVoter voter;
    private final Set<String> global;

    public BinaryAccessPolicy(Set<Class<IObject>> types, ACLVoter voter) {
        this(types, voter, null);
    }

    public BinaryAccessPolicy(Set<Class<IObject>> types, ACLVoter voter, String[] config) {
        super(types);
        this.voter = voter;
        this.global = config == null ? Collections.emptySet() : new HashSet<String>(Arrays.asList(config));
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean isRestricted(IObject obj) {
        Set<String> group = this.groupRestrictions(obj);
        if (this.notAorB("+write", "-write", group)) {
            return true;
        }
        if (this.notAorB("+read", "-read", group) && !this.voter.allowUpdate(obj, obj.getDetails())) {
            return true;
        }
        boolean noImage = this.notAorB("+image", "-image", group);
        boolean noPlate = this.notAorB("+plate", "-plate", group);
        if (obj instanceof OriginalFile) {
            OriginalFile ofile = (OriginalFile)obj;
            boolean isTxt = ofile.getName().endsWith(".txt");
            if (isTxt) {
                return false;
            }
            Iterator<FilesetEntry> it = ofile.iterateFilesetEntries();
            while (it.hasNext()) {
                Fileset f;
                FilesetEntry fe = it.next();
                if (fe == null || fe.getFileset() == null || !this.has(f = fe.getFileset(), "ome.model.fs.Fileset_images")) continue;
                if (noImage) {
                    return true;
                }
                if (!noPlate) continue;
                Iterator<Image> it2 = f.iterateImages();
                while (it2.hasNext()) {
                    Image img = it2.next();
                    if (img == null || !this.has(img, "ome.model.core.Image_wellSamples")) continue;
                    return true;
                }
            }
        } else if (obj instanceof Image) {
            Image img;
            if (noImage) {
                return true;
            }
            if (noPlate && this.has(img = (Image)obj, "ome.model.core.Image_wellSamples")) {
                return true;
            }
        } else if ((obj instanceof Plate || obj instanceof PlateAcquisition || obj instanceof Well || obj instanceof WellSample) && (noImage || noPlate)) {
            return true;
        }
        return false;
    }

    protected Set<String> groupRestrictions(IObject obj) {
        ExperimenterGroup grp = obj.getDetails().getGroup();
        if (grp != null && grp.getConfig() != null && grp.getConfig().size() > 0) {
            HashSet<String> rv = null;
            for (NamedValue nv : grp.getConfig()) {
                if (!"omero.policy.binary_access".equals(nv.getName())) continue;
                if (rv == null) {
                    rv = new HashSet<String>();
                }
                String setting = nv.getValue();
                rv.add(setting);
            }
            if (rv != null) {
                return rv;
            }
        }
        return Collections.emptySet();
    }

    private final boolean notAorB(String plus, String minus, Collection<String> group) {
        if (this.global.contains(minus) || group.contains(minus)) {
            return true;
        }
        return !this.global.contains(plus) && !group.contains(plus);
    }

    private boolean has(IObject obj, String field) {
        try {
            Collection c = (Collection)obj.retrieve(field);
            Hibernate.initialize((Object)c);
            if (c != null && !c.isEmpty()) {
                return true;
            }
        }
        catch (AssertionFailure assertionFailure) {
            // empty catch block
        }
        return false;
    }

    @Override
    public void checkRestriction(IObject obj) {
        if (this.isRestricted(obj)) {
            throw new SecurityViolation(String.format("Download is restricted for %s", obj));
        }
    }
}

