/*
 * Decompiled with CFR 0.152.
 */
package ome.security.basic;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import ome.model.core.Image;
import ome.model.internal.Details;
import ome.security.basic.AbstractSecurityFilter;
import ome.services.sharing.ShareStore;
import ome.services.sharing.data.ShareData;
import ome.system.EventContext;
import ome.system.Roles;
import org.apache.commons.collections.CollectionUtils;
import org.hibernate.Filter;
import org.hibernate.Session;

public class SharingSecurityFilter
extends AbstractSecurityFilter {
    private static final ImmutableMap<String, String> PARAMETER_TYPES = ImmutableMap.of("is_admin", "int", "is_share", "int", "images", "long");
    private ShareStore shares;

    public SharingSecurityFilter(Roles roles, ShareStore shares) {
        super(roles);
        this.shares = shares;
    }

    @Override
    public Map<String, String> getParameterTypes() {
        return PARAMETER_TYPES;
    }

    @Override
    public String getDefaultCondition() {
        return null;
    }

    @Override
    public boolean passesFilter(Session session, Details details, EventContext ec) {
        Long shareId = ec.getCurrentShareId();
        if (shareId == null) {
            return true;
        }
        ShareData share = this.shares.get(shareId);
        return ec.isCurrentUserAdmin() || share != null && share.enabled;
    }

    @Override
    public void enable(Session session, EventContext ec) {
        ShareData shareData;
        List<Long> imageIds = null;
        Long shareId = ec.getCurrentShareId();
        if (shareId != null && (shareData = this.shares.get(shareId)) != null && shareData.enabled) {
            imageIds = (List)shareData.objectMap.get(Image.class.getName());
        }
        if (CollectionUtils.isEmpty(imageIds)) {
            imageIds = ImmutableList.of(Long.valueOf(-1L));
        }
        int isAdmin01 = ec.isCurrentUserAdmin() ? 1 : 0;
        int isShare01 = this.isShare(ec) ? 1 : 0;
        Filter filter = session.enableFilter(this.getName());
        filter.setParameter("is_admin", (Object)isAdmin01);
        filter.setParameter("is_share", (Object)isShare01);
        filter.setParameterList("images", imageIds);
        this.enableBaseFilters(session, isAdmin01, ec.getCurrentUserId());
    }
}

