/*
 * Decompiled with CFR 0.152.
 */
package ome.security.basic;

import com.google.common.base.Splitter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import ome.conditions.ApiUsageException;
import ome.conditions.GroupSecurityViolation;
import ome.conditions.InternalException;
import ome.conditions.OptimisticLockException;
import ome.conditions.PermissionMismatchGroupSecurityViolation;
import ome.conditions.ReadOnlyGroupSecurityViolation;
import ome.conditions.SecurityViolation;
import ome.conditions.ValidationException;
import ome.model.IAnnotationLink;
import ome.model.IMutable;
import ome.model.IObject;
import ome.model.core.Image;
import ome.model.core.OriginalFile;
import ome.model.core.Pixels;
import ome.model.display.RenderingDef;
import ome.model.display.Thumbnail;
import ome.model.internal.Details;
import ome.model.internal.NamedValue;
import ome.model.internal.Permissions;
import ome.model.meta.Experimenter;
import ome.model.meta.ExperimenterGroup;
import ome.model.meta.ExternalInfo;
import ome.model.roi.Roi;
import ome.security.SystemTypes;
import ome.security.basic.BasicEventContext;
import ome.security.basic.CurrentDetails;
import ome.security.basic.TokenHolder;
import ome.services.sessions.stats.SessionStats;
import ome.system.EventContext;
import ome.system.Roles;
import ome.tools.hibernate.ExtendedMetadata;
import ome.tools.hibernate.HibernateUtils;
import ome.tools.lsid.LsidUtils;
import org.hibernate.CallbackException;
import org.hibernate.EmptyInterceptor;
import org.hibernate.EntityMode;
import org.hibernate.Interceptor;
import org.hibernate.Transaction;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.collection.PersistentList;
import org.hibernate.engine.CollectionEntry;
import org.hibernate.engine.PersistenceContext;
import org.hibernate.type.ComponentType;
import org.hibernate.type.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class OmeroInterceptor
implements Interceptor {
    static volatile String last = null;
    static volatile int count = 1;
    private static Logger log = LoggerFactory.getLogger(OmeroInterceptor.class);
    private static final String IDX_FILE_PATH = LsidUtils.parseField("ome.model.core.OriginalFile_path");
    private static final String IDX_FILE_NAME = LsidUtils.parseField("ome.model.core.OriginalFile_name");
    private final Interceptor EMPTY = EmptyInterceptor.INSTANCE;
    private final SystemTypes sysTypes;
    private final CurrentDetails currentUser;
    private final TokenHolder tokenHolder;
    private final ExtendedMetadata em;
    private final SessionStats stats;
    private final Roles roles;
    private static final long serialVersionUID = 7616611615023614920L;

    public OmeroInterceptor(Roles roles, SystemTypes sysTypes, ExtendedMetadata em, CurrentDetails cd, TokenHolder tokenHolder, SessionStats stats) {
        Assert.notNull(tokenHolder);
        Assert.notNull(sysTypes);
        Assert.notNull(stats);
        Assert.notNull(roles);
        this.tokenHolder = tokenHolder;
        this.currentUser = cd;
        this.sysTypes = sysTypes;
        this.stats = stats;
        this.roles = roles;
        this.em = em;
    }

    public Object instantiate(String entityName, EntityMode entityMode, Serializable id) throws CallbackException {
        this.debug("Intercepted instantiate.");
        return this.EMPTY.instantiate(entityName, entityMode, id);
    }

    public boolean onLoad(Object entity, Serializable id, Object[] state, String[] propertyNames, Type[] types) throws CallbackException {
        this.debug("Intercepted load.");
        this.stats.loadedObjects(1);
        return this.EMPTY.onLoad(entity, id, state, propertyNames, types);
    }

    public int[] findDirty(Object entity, Serializable id, Object[] currentState, Object[] previousState, String[] propertyNames, Type[] types) {
        this.debug("Intercepted dirty check.");
        return this.EMPTY.findDirty(entity, id, currentState, previousState, propertyNames, types);
    }

    public boolean onSave(Object entity, Serializable id, Object[] state, String[] propertyNames, Type[] types) {
        this.debug("Intercepted save.");
        this.stats.updatedObjects(1);
        if (entity instanceof IObject) {
            IObject iobj = (IObject)entity;
            int idx = HibernateUtils.detailsIndex(propertyNames);
            Details d = this.evaluateLinkages(iobj);
            d = this.newTransientDetails(iobj, d);
            state[idx] = d;
        }
        return true;
    }

    private static boolean isProblemFilepath(String filepath) {
        Iterator<String> iterator = Splitter.on('/').split(filepath).iterator();
        while (iterator.hasNext()) {
            String component;
            switch (component = iterator.next()) {
                case ".": 
                case "..": {
                    return true;
                }
            }
        }
        return false;
    }

    public boolean onFlushDirty(Object entity, Serializable id, Object[] currentState, Object[] previousState, String[] propertyNames, Type[] types) {
        this.debug("Intercepted update.");
        this.stats.updatedObjects(1);
        boolean altered = false;
        if (entity instanceof IObject) {
            IObject iobj = (IObject)entity;
            int idx = HibernateUtils.detailsIndex(propertyNames);
            Details newDetails = this.evaluateLinkages(iobj);
            if (previousState != null && iobj instanceof OriginalFile && !this.currentUser.current().isCurrentUserAdmin()) {
                int pathIndex = HibernateUtils.index(IDX_FILE_PATH, propertyNames);
                int nameIndex = HibernateUtils.index(IDX_FILE_NAME, propertyNames);
                String currentPath = (String)currentState[pathIndex];
                String currentName = (String)currentState[nameIndex];
                if (!(currentPath == null || currentName == null || currentPath.equals(previousState[pathIndex]) && currentName.equals(previousState[nameIndex]) || !OmeroInterceptor.isProblemFilepath(currentPath + currentName))) {
                    throw new SecurityViolation("only administrators may introduce non-canonical OriginalFile path or name");
                }
            }
            altered |= this.resetDetails(iobj, currentState, previousState, idx, newDetails);
        }
        return altered;
    }

    public void onDelete(Object entity, Serializable id, Object[] state, String[] propertyNames, Type[] types) throws CallbackException {
        this.debug("Intercepted delete.");
        this.EMPTY.onDelete(entity, id, state, propertyNames, types);
    }

    public void onCollectionRecreate(Object collection, Serializable key) throws CallbackException {
        this.debug("Intercepted collection recreate.");
    }

    public void onCollectionRemove(Object collection, Serializable key) throws CallbackException {
        this.debug("Intercepted collection remove.");
    }

    public void onCollectionUpdate(Object collection, Serializable key) throws CallbackException {
        this.debug("Intercepted collection update.");
        if (collection instanceof PersistentList) {
            PersistentList list = (PersistentList)collection;
            PersistenceContext context = list.getSession().getPersistenceContext();
            CollectionEntry entry = context.getCollectionEntry((PersistentCollection)list);
            if (!(entry.getCurrentPersister().getElementType() instanceof ComponentType)) {
                return;
            }
            List snapshot = (List)((Object)entry.getSnapshot());
            Object owner = list.getOwner();
            if (list.size() == 0 && snapshot.size() == 0) {
                return;
            }
            boolean equals = true;
            if (list.size() == snapshot.size()) {
                for (int i = 0; i < list.size(); ++i) {
                    Object lhs;
                    if (list.get(i) == null ? snapshot.get(i) == null : (lhs = list.get(i)) instanceof NamedValue && ((NamedValue)lhs).equals(snapshot.get(i))) continue;
                    equals = false;
                    break;
                }
                if (equals) {
                    return;
                }
            }
            try {
                IObject iobj = (IObject)owner;
                Method getter = iobj.getClass().getMethod("getVersion", new Class[0]);
                Integer oldVersion = (Integer)getter.invoke((Object)iobj, new Object[0]);
                Integer newVersion = oldVersion == null ? 1 : oldVersion + 1;
                Method setter = iobj.getClass().getMethod("setVersion", Integer.class);
                setter.invoke((Object)iobj, newVersion);
                log.info("Updating version for collections from {} to {}", (Object)oldVersion, (Object)newVersion);
            }
            catch (Exception e) {
                InternalException ie = new InternalException("Failed to set version");
                ie.initCause(e);
                throw ie;
            }
        }
    }

    public void preFlush(Iterator entities) throws CallbackException {
        this.debug("Intercepted preFlush.");
        this.EMPTY.preFlush(entities);
    }

    public void postFlush(Iterator entities) throws CallbackException {
        this.debug("Intercepted postFlush.");
        this.EMPTY.postFlush(entities);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
    }

    public void afterTransactionBegin(Transaction tx) {
    }

    public void afterTransactionCompletion(Transaction tx) {
    }

    public void beforeTransactionCompletion(Transaction tx) {
    }

    public Object getEntity(String entityName, Serializable id) throws CallbackException {
        return this.EMPTY.getEntity(entityName, id);
    }

    public String getEntityName(Object object) throws CallbackException {
        return this.EMPTY.getEntityName(object);
    }

    public Boolean isTransient(Object entity) {
        return this.EMPTY.isTransient(entity);
    }

    public String onPrepareStatement(String sql) {
        if (!log.isDebugEnabled()) {
            return sql;
        }
        StringBuilder sb = new StringBuilder();
        String[] first = sql.split("\\sfrom\\s");
        sb.append(first[0]);
        for (int i = 1; i < first.length; ++i) {
            sb.append("\n from ");
            sb.append(first[i]);
        }
        String[] second = sb.toString().split("\\swhere\\s");
        sb = new StringBuilder();
        sb.append(second[0]);
        for (int j = 1; j < second.length; ++j) {
            sb.append("\n where ");
            sb.append(second[j]);
        }
        return sb.toString();
    }

    protected boolean resetDetails(IObject entity, Object[] currentState, Object[] previousState, int idx, Details newDetails) {
        if (previousState == null) {
            log.warn(String.format("Null previousState for %s(loaded=%s). Details=%s", entity, entity.isLoaded(), currentState[idx]));
            throw new InternalException("Previous state is null. Possibly caused by evict. See ticket:3929");
        }
        Details previous = (Details)previousState[idx];
        Details result = this.checkManagedDetails(entity, previous, newDetails);
        if (previous != result) {
            currentState[idx] = result;
            return true;
        }
        return false;
    }

    protected void log(String msg) {
        if (msg.equals(last)) {
            ++count;
        } else if (log.isDebugEnabled()) {
            String times = " ( " + count + " times )";
            log.debug(msg + times);
            last = msg;
            count = 1;
        }
    }

    private void debug(String msg) {
        if (log.isDebugEnabled()) {
            this.log(msg);
        }
    }

    public Details evaluateLinkages(IObject changedObject) {
        IObject[] candidates;
        if (changedObject == null) {
            return null;
        }
        Class<?> changedClass = changedObject.getClass();
        Details rv = changedObject.getDetails().newInstance();
        if (this.sysTypes.isSystemType(changedObject.getClass()) || this.sysTypes.isInSystemGroup(changedObject.getDetails())) {
            return rv;
        }
        Long currentGroupId = this.currentUser.getGroup().getId();
        boolean currentGroupNegative = currentGroupId < 0L;
        for (IObject linkedObject : candidates = this.em.getLockCandidates(changedObject)) {
            if (this.sysTypes.isSystemType(linkedObject.getClass()) || this.sysTypes.isInSystemGroup(linkedObject.getDetails()) || this.sysTypes.isInUserGroup(linkedObject.getDetails())) continue;
            Class<?> linkedClass = linkedObject.getClass();
            Details linkedDetails = linkedObject.getDetails();
            if (linkedDetails == null) continue;
            if (currentGroupNegative) {
                if (rv.getGroup() == null) {
                    rv.setGroup(linkedDetails.getGroup());
                } else {
                    this.throwIfGroupsDontMatch(rv.getGroup(), changedObject, linkedDetails.getGroup(), linkedObject);
                }
            } else {
                this.throwIfGroupsDontMatch(this.currentUser.getGroup(), changedObject, linkedDetails.getGroup(), linkedObject);
            }
            Experimenter linkedOwner = linkedObject.getDetails().getOwner();
            ExperimenterGroup linkedGroup = linkedObject.getDetails().getGroup();
            if (linkedOwner == null || linkedGroup == null) continue;
            Long linkedUid = linkedOwner.getId();
            Long linkedGid = linkedGroup.getId();
            if (linkedUid == null || linkedGid == null) continue;
            EventContext ec = this.currentUser.getCurrentEventContext();
            boolean isOwner = ec.getCurrentUserId().equals(linkedUid);
            boolean isOwnerOrSupervisor = this.currentUser.isOwnerOrSupervisor(linkedObject);
            boolean isSupervisor = !isOwner && isOwnerOrSupervisor;
            boolean isMember = ec.getMemberOfGroupsList().contains(linkedGid);
            Permissions p = this.currentUser.getCurrentEventContext().getCurrentGroupPermissions();
            if (!isOwner && this.currentUser.isGraphCritical(rv)) {
                String gname = this.currentUser.getGroup().getName();
                String oname = this.currentUser.getOwner().getOmeName();
                Long changedUid = null;
                if (changedObject.getDetails().getOwner() != null) {
                    changedUid = changedObject.getDetails().getOwner().getId();
                }
                if (changedUid == null || !changedUid.equals(linkedUid)) {
                    throw new ReadOnlyGroupSecurityViolation(String.format("Cannot link to %s\nCurrent user (%s) is an admin or the owner of\nthe private group (%s=%s). It is not allowed to\nlink to users' data.", linkedObject, oname, gname, p));
                }
            }
            Permissions.Right neededRight = this.neededRight(changedClass, linkedClass);
            Permissions.Role neededRole = this.neededRole(isOwner, isMember);
            if (isSupervisor) continue;
            this.throwIfNotGranted(p, neededRole, neededRight, linkedObject);
        }
        return rv;
    }

    private Permissions.Role neededRole(boolean isOwner, boolean isMember) {
        if (isOwner) {
            return Permissions.Role.USER;
        }
        if (isMember) {
            return Permissions.Role.GROUP;
        }
        return Permissions.Role.WORLD;
    }

    protected Permissions.Right neededRight(Class<?> changedClass, Class<?> linkedClass) {
        Permissions.Right neededRight = Permissions.Right.WRITE;
        if (RenderingDef.class.isAssignableFrom(linkedClass) || RenderingDef.class.isAssignableFrom(changedClass) || Pixels.class.isAssignableFrom(linkedClass) && Thumbnail.class.isAssignableFrom(changedClass)) {
            neededRight = Permissions.Right.READ;
        } else if (IAnnotationLink.class.isAssignableFrom(changedClass) || Roi.class.isAssignableFrom(changedClass) && Image.class.isAssignableFrom(linkedClass)) {
            neededRight = Permissions.Right.ANNOTATE;
        }
        return neededRight;
    }

    public Details newTransientDetails(IObject obj) {
        if (obj == null) {
            throw new ApiUsageException("Argument cannot be null.");
        }
        Details newDetails = obj.getDetails().newInstance();
        return this.newTransientDetails(obj, newDetails);
    }

    protected Details newTransientDetails(IObject obj, Details newDetails) {
        if (this.tokenHolder.hasPrivilegedToken(obj)) {
            return obj.getDetails();
        }
        Details source = obj.getDetails();
        BasicEventContext bec = this.currentUser.current();
        newDetails.copyWhereUnset(null, this.currentUser.createDetails());
        if (source.getOwner() != null && !newDetails.getOwner().getId().equals(source.getOwner().getId())) {
            if (bec.isCurrentUserAdmin()) {
                newDetails.setOwner(source.getOwner());
            } else {
                throw new SecurityViolation(String.format("You are not authorized to set the Experimenter for %s to %s", obj, source.getOwner()));
            }
        }
        if (source.getGroup() != null && source.getGroup().getId() != null) {
            long sourceGroupId = source.getGroup().getId();
            boolean isAdmin = bec.isCurrentUserAdmin();
            if (bec.getCurrentGroupId().equals(sourceGroupId)) {
                newDetails.setGroup(source.getGroup());
            } else if (bec.isCurrentUserAdmin() && Long.valueOf(this.roles.getUserGroupId()).equals(source.getGroup().getId())) {
                newDetails.setGroup(source.getGroup());
            } else if (bec.getCurrentGroupId() < 0L && (isAdmin || bec.getMemberOfGroupsList().contains(sourceGroupId))) {
                newDetails.setGroup(source.getGroup());
            } else {
                throw new SecurityViolation(String.format("You are not authorized to set the ExperimenterGroup for %s to %s", obj, source.getGroup()));
            }
        }
        if (source.getPermissions() != null) {
            Permissions groupPerms = this.currentUser.getCurrentEventContext().getCurrentGroupPermissions();
            boolean isInSysGrp = this.sysTypes.isInSystemGroup(newDetails);
            boolean isInUsrGrp = this.sysTypes.isInUserGroup(newDetails);
            if (!(groupPerms.identical(source.getPermissions()) || this.sysTypes.isSystemType(obj.getClass()) || isInSysGrp || isInUsrGrp)) {
                throw new PermissionMismatchGroupSecurityViolation("Manually setting permissions currently disallowed");
            }
            newDetails.setPermissions(source.getPermissions());
        }
        newDetails.setExternalInfo(source.getExternalInfo());
        return newDetails;
    }

    public Details checkManagedDetails(IObject iobj, Details previousDetails) {
        if (iobj == null) {
            throw new ApiUsageException("Argument cannot be null.");
        }
        return this.checkManagedDetails(iobj, previousDetails, iobj.getDetails().newInstance());
    }

    protected Details checkManagedDetails(IObject iobj, Details previousDetails, Details newDetails) {
        Integer version;
        if (iobj == null) {
            throw new ApiUsageException("Argument cannot be null.");
        }
        if (iobj.getId() == null) {
            throw new ValidationException("Id required on all detached instances.");
        }
        if (!(iobj instanceof IMutable) || (version = ((IMutable)iobj).getVersion()) == null || version < 0) {
            // empty if block
        }
        boolean altered = false;
        Details currentDetails = iobj.getDetails();
        newDetails.copyWhereUnset(previousDetails, this.currentUser.createDetails());
        if (previousDetails == null) {
            newDetails = null;
            altered = true;
            if (log.isDebugEnabled()) {
                log.debug("Setting details on " + iobj + " to null like original");
            }
        } else if (currentDetails == null) {
            newDetails = previousDetails.copy();
            altered = true;
            if (log.isDebugEnabled()) {
                log.debug("Setting details on " + iobj + " to copy of original details.");
            }
        } else {
            boolean privileged = false;
            if (this.tokenHolder.hasPrivilegedToken(iobj)) {
                privileged = true;
            }
            BasicEventContext bec = this.currentUser.current();
            boolean sysType = this.sysTypes.isSystemType(iobj.getClass());
            if (!sysType) {
                altered |= this.managedOwner(privileged, iobj, previousDetails, currentDetails, newDetails, bec);
            }
            if (!sysType) {
                altered |= this.managedGroup(privileged, iobj, previousDetails, currentDetails, newDetails, bec);
            }
            if (!sysType) {
                altered |= this.managedEvent(privileged, iobj, previousDetails, currentDetails, newDetails);
            }
        }
        return altered ? newDetails : previousDetails;
    }

    @Deprecated
    protected boolean managedExternalInfo(boolean privileged, IObject obj, Details previousDetails, Details currentDetails, Details newDetails) {
        ExternalInfo current;
        boolean altered = false;
        ExternalInfo previous = previousDetails == null ? null : previousDetails.getExternalInfo();
        ExternalInfo externalInfo = current = currentDetails == null ? null : currentDetails.getExternalInfo();
        if (previous == null) {
            if (current != null) {
                newDetails.setExternalInfo(current);
                altered = true;
            }
        } else if (!HibernateUtils.idEqual(previous, current)) {
            throw new SecurityViolation(String.format("Cannot update ExternalInfo for %s from %s to %s", obj, previous, current));
        }
        return altered;
    }

    protected boolean managedOwner(boolean privileged, IObject obj, Details previousDetails, Details currentDetails, Details newDetails, BasicEventContext bec) {
        if (!HibernateUtils.idEqual(previousDetails.getOwner(), currentDetails.getOwner())) {
            if (currentDetails.getOwner() == null) {
                newDetails.setOwner(previousDetails.getOwner());
                return true;
            }
            if (!bec.isCurrentUserAdmin() && !privileged) {
                throw new SecurityViolation(String.format("You are not authorized to change the owner for %s from %s to %s", obj, previousDetails.getOwner(), currentDetails.getOwner()));
            }
        } else {
            newDetails.setOwner(previousDetails.getOwner());
        }
        return false;
    }

    protected boolean managedGroup(boolean privileged, IObject obj, Details previousDetails, Details currentDetails, Details newDetails, BasicEventContext bec) {
        if (null != previousDetails.getGroup()) {
            long objGroupId = previousDetails.getGroup().getId();
            long sessGroupId = this.currentUser.getGroup().getId();
            long userGroupId = this.roles.getUserGroupId();
            if (sessGroupId != objGroupId && objGroupId != userGroupId) {
                throw new SecurityViolation(String.format("Currently logged into group %s. Cannot alter object in group %s", sessGroupId, objGroupId));
            }
        }
        if (!HibernateUtils.idEqual(previousDetails.getGroup(), currentDetails.getGroup())) {
            if (currentDetails.getGroup() == null) {
                newDetails.setGroup(previousDetails.getGroup());
                return true;
            }
            if (!currentDetails.getGroup().getId().equals(this.roles.getUserGroupId()) && bec.getMemberOfGroupsList().contains(currentDetails.getGroup().getId()) || bec.isCurrentUserAdmin() || privileged) {
                newDetails.setGroup(currentDetails.getGroup());
                return true;
            }
            throw new SecurityViolation(String.format("You are not authorized to change the group for %s from %s to %s", obj, previousDetails.getGroup(), currentDetails.getGroup()));
        }
        newDetails.setGroup(previousDetails.getGroup());
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean managedEvent(boolean privileged, IObject obj, Details previousDetails, Details currentDetails, Details newDetails) {
        boolean altered = false;
        if (!HibernateUtils.idEqual(previousDetails.getCreationEvent(), currentDetails.getCreationEvent())) {
            if (currentDetails.getCreationEvent() != null) throw new SecurityViolation(String.format("You are not authorized to change the creation event for %s from %s to %s", obj, previousDetails.getCreationEvent(), currentDetails.getCreationEvent()));
            newDetails.setCreationEvent(previousDetails.getCreationEvent());
            altered = true;
        } else {
            newDetails.setCreationEvent(previousDetails.getCreationEvent());
        }
        if (!HibernateUtils.idEqual(previousDetails.getUpdateEvent(), currentDetails.getUpdateEvent())) {
            if (currentDetails.getUpdateEvent() != null) throw new OptimisticLockException(String.format("You are not authorized to change the update event for %s from %s to %s\nYou may need to reload the object before continuing.", obj, previousDetails.getUpdateEvent(), currentDetails.getUpdateEvent()));
            newDetails.setUpdateEvent(previousDetails.getUpdateEvent());
            return true;
        }
        newDetails.setUpdateEvent(previousDetails.getUpdateEvent());
        return altered;
    }

    boolean copyNonNullPermissions(Details target, Permissions p) {
        if (p != null) {
            target.setPermissions(p);
            return true;
        }
        return false;
    }

    void throwIfGroupsDontMatch(ExperimenterGroup changedObjectGroup, IObject changedObject, ExperimenterGroup linkedGroup, IObject linkedObject) {
        if (linkedGroup != null && !HibernateUtils.idEqual(linkedGroup, changedObjectGroup)) {
            throw new GroupSecurityViolation(String.format("MIXED GROUP: %s(group=%s) and %s(group=%s) cannot be linked.", changedObject, changedObjectGroup, linkedObject, linkedGroup));
        }
    }

    void throwIfNotGranted(Permissions p, Permissions.Role role, Permissions.Right right, IObject linkedObject) {
        if (!p.isGranted(role, right)) {
            StringBuilder sb = new StringBuilder();
            sb.append(String.format("Group is %s. ", p));
            sb.append("Cannot link to object: ");
            sb.append(linkedObject);
            throw new SecurityViolation(sb.toString());
        }
    }
}

