/*
 * Decompiled with CFR 0.152.
 */
package ome.security.basic;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import ome.conditions.ApiUsageException;
import ome.conditions.GroupSecurityViolation;
import ome.conditions.InternalException;
import ome.conditions.SecurityViolation;
import ome.model.IObject;
import ome.model.internal.Permissions;
import ome.model.meta.ExperimenterGroup;
import ome.security.ChmodStrategy;
import ome.security.basic.BasicACLVoter;
import ome.services.messages.ContextMessage;
import ome.services.messages.EventLogMessage;
import ome.system.OmeroContext;
import ome.tools.hibernate.ExtendedMetadata;
import ome.tools.hibernate.SessionFactory;
import ome.util.SqlAction;
import ome.util.Utils;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class GroupChmodStrategy
implements ChmodStrategy,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(GroupChmodStrategy.class);
    private final BasicACLVoter voter;
    private final SessionFactory osf;
    private final SqlAction sql;
    private final ExtendedMetadata em;
    private OmeroContext ctx;

    public GroupChmodStrategy(BasicACLVoter voter, SessionFactory osf, SqlAction sql, ExtendedMetadata em) {
        this.voter = voter;
        this.osf = osf;
        this.sql = sql;
        this.em = em;
    }

    public void setApplicationContext(ApplicationContext ctx) throws BeansException {
        this.ctx = (OmeroContext)ctx;
    }

    @Override
    public Object[] getChecks(IObject obj, String permissions) {
        ExperimenterGroup trusted = this.load(obj);
        if (!this.voter.allowChmod(trusted)) {
            throw new SecurityViolation("chmod not permitted");
        }
        PermDrop drop = new PermDrop(trusted, permissions);
        if (!drop.found()) {
            return new Object[0];
        }
        ArrayList<Check> checks = new ArrayList<Check>();
        Set<String> classeNames = this.em.getClasses();
        for (String className : classeNames) {
            Class<IObject> k = this.em.getHibernateClass(className);
            if (this.voter.sysTypes.isSystemType(k)) continue;
            String[][] lockChecks = this.em.getLockChecks(k);
            checks.add(new Check(trusted.getId(), permissions, k, lockChecks, drop));
        }
        return checks.toArray(new Object[checks.size()]);
    }

    @Override
    public void chmod(IObject obj, String permissions) {
        this.handleGroupChange(obj, Permissions.parseString(permissions));
    }

    @Override
    public void check(IObject obj, Object check) {
        if (!(check instanceof Check)) {
            throw new InternalException("Bad check:" + check);
        }
        Check c = (Check)check;
        Map<String, Long> counts = this.performRun(c);
        long total = counts.get("*");
        if (total > 0L) {
            throw new SecurityViolation(String.format("Cannot change permissions on %s to %s due to locks:\n%s", obj, c.perms, counts));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Long> performRun(Check c) {
        Map<String, Long> counts = null;
        HashMap<String, String> grpCtx = new HashMap<String, String>();
        grpCtx.put("omero.group", "-1");
        try {
            this.ctx.publishMessage(new ContextMessage.Push(this, grpCtx));
            try {
                counts = c.run(this.osf.getSession(), this.em);
            }
            finally {
                this.ctx.publishMessage(new ContextMessage.Pop(this, grpCtx));
            }
        }
        catch (Throwable t) {
            log.error("Could not perform check!", t);
            throw new InternalException("Could not perform check! See server logs");
        }
        return counts;
    }

    private ExperimenterGroup load(IObject obj) {
        if (!(obj instanceof ExperimenterGroup)) {
            throw new SecurityViolation("Only groups allowed");
        }
        if (obj.getId() == null) {
            throw new ApiUsageException("ID cannot be null");
        }
        Session s = this.osf.getSession();
        return (ExperimenterGroup)s.get(ExperimenterGroup.class, (Serializable)obj.getId());
    }

    private void handleGroupChange(IObject obj, Permissions newPerms) {
        ExperimenterGroup group = this.load(obj);
        if (newPerms == null) {
            throw new ApiUsageException("PERMS cannot be null");
        }
        Permissions oldPerms = group.getDetails().getPermissions();
        if (oldPerms.sameRights(newPerms)) {
            log.debug(String.format("Ignoring unchanged permissions: %s", newPerms));
            return;
        }
        Long internal = (Long)Utils.internalForm(newPerms);
        this.sql.changeGroupPermissions(obj.getId(), internal);
        log.info(String.format("Changed permissions for %s to %s", obj.getId(), internal));
        this.eventlog(obj.getId(), newPerms.toString());
    }

    private void eventlog(long id, String perms) {
        EventLogMessage elm = new EventLogMessage(this, String.format("CHMOD(%s)", perms), ExperimenterGroup.class, Collections.singletonList(id));
        try {
            this.ctx.publishMessage(elm);
        }
        catch (Throwable t) {
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException(t);
        }
    }

    private static class Check {
        final long groupID;
        final String perms;
        final Class<?> k;
        final String[][] lockChecks;
        final PermDrop drop;

        Check(long groupID, String perms, Class<?> k, String[][] lockChecks, PermDrop drop) {
            this.groupID = groupID;
            this.perms = perms;
            this.k = k;
            this.lockChecks = lockChecks;
            this.drop = drop;
        }

        public Map<String, Long> run(Session session, ExtendedMetadata em) {
            StringBuilder sb = new StringBuilder();
            sb.append("x.details.group.id = ");
            sb.append(this.groupID);
            sb.append(" and ");
            sb.append("y.details.group.id = ");
            sb.append(this.groupID);
            if (this.drop.reduceGroup) {
                sb.append(" and x.details.owner.id <> y.details.owner.id");
            }
            return em.countLocks(session, null, this.lockChecks, sb.toString());
        }
    }

    private static class PermDrop {
        static final Permissions.Role u = Permissions.Role.USER;
        static final Permissions.Role g = Permissions.Role.GROUP;
        static final Permissions.Role a = Permissions.Role.WORLD;
        static final Permissions.Right r = Permissions.Right.READ;
        final Permissions oldPerms;
        final Permissions newPerms;
        final boolean reduceGroup;

        PermDrop(ExperimenterGroup trusted, String permissions) {
            this.oldPerms = trusted.getDetails().getPermissions();
            this.newPerms = Permissions.parseString(permissions);
            if (!this.newPerms.isGranted(u, r)) {
                throw new GroupSecurityViolation("Cannot remove user read: " + trusted);
            }
            this.reduceGroup = this.oldPerms.isGranted(g, r) && !this.newPerms.isGranted(g, r);
        }

        boolean found() {
            return this.reduceGroup;
        }
    }
}

