/*
 * Decompiled with CFR 0.152.
 */
package ome.security.basic;

import java.util.ArrayList;
import ome.api.StatefulServiceInterface;
import ome.conditions.ApiUsageException;
import ome.conditions.InternalException;
import ome.conditions.SessionTimeoutException;
import ome.model.meta.Event;
import ome.model.meta.EventLog;
import ome.security.basic.BasicSecuritySystem;
import ome.security.basic.BasicSecurityWiring;
import ome.security.basic.CurrentDetails;
import ome.services.messages.ContextMessage;
import ome.system.EventContext;
import ome.tools.hibernate.SessionFactory;
import ome.util.SqlAction;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.transaction.interceptor.TransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttributeSource;

public class EventHandler
implements MethodInterceptor,
ApplicationListener<ContextMessage> {
    private static Logger log = LoggerFactory.getLogger(EventHandler.class);
    protected final TransactionAttributeSource txSource;
    protected final BasicSecuritySystem secSys;
    protected final SessionFactory factory;
    protected final SqlAction sql;
    protected final boolean readOnly;

    public EventHandler(SqlAction sql, BasicSecuritySystem securitySystem, SessionFactory factory, TransactionAttributeSource txSource) {
        this(sql, securitySystem, factory, txSource, false);
    }

    public EventHandler(SqlAction sql, BasicSecuritySystem securitySystem, SessionFactory factory, TransactionAttributeSource txSource, boolean readOnly) {
        this.secSys = securitySystem;
        this.txSource = txSource;
        this.factory = factory;
        this.sql = sql;
        this.readOnly = readOnly;
    }

    public void onApplicationEvent(ContextMessage msg) {
        CurrentDetails cd = this.secSys.cd;
        Session session = this.factory.getSession();
        if (msg instanceof ContextMessage.Pop) {
            this.secSys.disableReadFilter(session);
            cd.logout();
            this.secSys.enableReadFilter(session);
        } else if (msg instanceof ContextMessage.Push) {
            EventContext curr = cd.getCurrentEventContext();
            boolean readOnly = curr.isReadOnly();
            boolean isClose = false;
            this.secSys.disableReadFilter(session);
            cd.login(cd.getLast());
            cd.setContext(msg.context);
            if (!this.doLogin(readOnly, false)) {
                throw new InternalException("Failed to login on Push: " + msg.context);
            }
            this.secSys.enableReadFilter(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodInvocation arg0) throws Throwable {
        boolean isClose;
        boolean readOnly = this.checkReadOnly(arg0);
        boolean stateful = StatefulServiceInterface.class.isAssignableFrom(arg0.getThis().getClass());
        boolean bl = isClose = stateful && "close".equals(arg0.getMethod().getName());
        if (!readOnly && this.readOnly) {
            throw new ApiUsageException("This instance is read-only");
        }
        Session session = this.factory.getSession();
        if (!readOnly) {
            this.sql.deferConstraints();
        }
        if (!this.doLogin(readOnly, isClose)) {
            return null;
        }
        boolean failure = false;
        Object retVal = null;
        try {
            this.secSys.enableReadFilter(session);
            retVal = arg0.proceed();
            this.saveLogs(readOnly, session);
            this.secSys.cd.loadPermissions(session);
            Object object = retVal;
            return object;
        }
        catch (Throwable ex) {
            failure = true;
            throw ex;
        }
        finally {
            try {
                if (failure) {
                } else if (stateful) {
                } else if (readOnly) {
                    if (session.isDirty()) {
                        if (log.isDebugEnabled()) {
                            log.debug("Clearing dirty session.");
                        }
                        session.clear();
                    }
                } else {
                    session.flush();
                    if (session.isDirty()) {
                        throw new InternalException("Session is dirty. Cannot properly reset security system. Must rollback.\n Session=" + session);
                    }
                    this.secSys.disableReadFilter(session);
                    session.clear();
                }
            }
            finally {
                this.secSys.disableReadFilter(session);
                this.secSys.invalidateEventContext();
            }
        }
    }

    public boolean doLogin(boolean readOnly, boolean isClose) {
        try {
            this.secSys.loadEventContext(readOnly, isClose);
        }
        catch (SessionTimeoutException ste) {
            if (ste.sessionContext instanceof BasicSecurityWiring.CloseOnNoSessionContext) {
                log.debug("CloseOnNoSessionContext. Skipping");
                return false;
            }
            throw ste;
        }
        EventContext ec = this.secSys.getEventContext();
        if (!readOnly) {
            this.sql.prepareSession(ec.getCurrentEventId(), ec.getCurrentUserId(), ec.getCurrentGroupId());
        }
        if (log.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append(" Auth:\tuser=");
            sb.append(ec.getCurrentUserId());
            sb.append(",group=");
            sb.append(ec.getCurrentGroupId());
            sb.append(",event=");
            sb.append(ec.getCurrentEventId());
            sb.append("(");
            sb.append(ec.getCurrentEventType());
            sb.append("),sess=");
            sb.append(ec.getCurrentSessionUuid());
            Long shareId = ec.getCurrentShareId();
            if (shareId != null) {
                sb.append(",share=");
                sb.append(shareId);
            }
            log.info(sb.toString());
        }
        return true;
    }

    boolean checkReadOnly(MethodInvocation mi) {
        TransactionAttribute ta = this.txSource.getTransactionAttribute(mi.getMethod(), mi.getThis().getClass());
        return ta == null ? true : ta.isReadOnly();
    }

    void saveLogs(boolean readOnly, Session session) {
        ArrayList<EventLog> logs = new ArrayList<EventLog>(this.secSys.getLogs());
        this.secSys.clearLogs();
        if (logs == null || logs.size() == 0) {
            return;
        }
        if (readOnly) {
            StringBuilder sb = new StringBuilder();
            sb.append("EventLogs in readOnly transaction:\n");
            for (EventLog eventLog : logs) {
                sb.append(eventLog.getAction());
                sb.append(" ");
                sb.append(eventLog);
                sb.append(eventLog.getEntityType());
                sb.append(" ");
                sb.append(eventLog.getEntityId());
                sb.append("\b");
            }
            throw new InternalException(sb.toString());
        }
        try {
            long lastValue = this.sql.nextValue("seq_eventlog", logs.size());
            long id = lastValue - (long)logs.size() + 1L;
            ArrayList<Object[]> batchData = new ArrayList<Object[]>();
            for (EventLog l : logs) {
                Event e = l.getEvent();
                if (e.getId() == null) {
                    throw new RuntimeException("Transient event");
                }
                batchData.add(new Object[]{id++, -35L, l.getEntityId(), l.getEntityType(), l.getAction(), l.getEvent().getId()});
            }
            this.sql.insertLogs(batchData);
        }
        catch (Exception ex) {
            log.error("Error saving event logs: " + logs, ex);
        }
        if (this.secSys.getLogs().size() > 0) {
            throw new InternalException("More logs present after saveLogs()");
        }
    }
}

