/*
 * Decompiled with CFR 0.152.
 */
package ome.security.basic;

import com.google.common.collect.ArrayListMultimap;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import ome.api.local.LocalAdmin;
import ome.api.local.LocalQuery;
import ome.api.local.LocalUpdate;
import ome.conditions.ApiUsageException;
import ome.conditions.InternalException;
import ome.conditions.SecurityViolation;
import ome.conditions.SessionTimeoutException;
import ome.model.IObject;
import ome.model.enums.EventType;
import ome.model.internal.Details;
import ome.model.internal.GraphHolder;
import ome.model.internal.Permissions;
import ome.model.meta.Event;
import ome.model.meta.EventLog;
import ome.model.meta.Experimenter;
import ome.model.meta.ExperimenterGroup;
import ome.model.meta.GroupExperimenterMap;
import ome.model.meta.Session;
import ome.security.AdminAction;
import ome.security.SecureAction;
import ome.security.SecurityFilter;
import ome.security.SecurityFilterHolder;
import ome.security.SecuritySystem;
import ome.security.SystemTypes;
import ome.security.basic.AllGroupsSecurityFilter;
import ome.security.basic.BasicEventContext;
import ome.security.basic.BasicSecurityWiring;
import ome.security.basic.CurrentDetails;
import ome.security.basic.OmeroInterceptor;
import ome.security.basic.OneGroupSecurityFilter;
import ome.security.basic.SharingSecurityFilter;
import ome.security.basic.TokenHolder;
import ome.security.policy.DefaultPolicyService;
import ome.security.policy.PolicyService;
import ome.services.messages.EventLogMessage;
import ome.services.messages.EventLogsMessage;
import ome.services.sessions.SessionManager;
import ome.services.sessions.events.UserGroupUpdateEvent;
import ome.services.sessions.state.SessionCache;
import ome.services.sessions.stats.PerSessionStats;
import ome.services.sharing.ShareStore;
import ome.system.EventContext;
import ome.system.OmeroContext;
import ome.system.Principal;
import ome.system.Roles;
import ome.system.ServiceFactory;
import ome.tools.hibernate.ExtendedMetadata;
import org.hibernate.HibernateException;
import org.hibernate.proxy.HibernateProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.util.Assert;

public class BasicSecuritySystem
implements SecuritySystem,
ApplicationContextAware,
ApplicationListener<EventLogMessage> {
    private static final Logger log = LoggerFactory.getLogger(BasicSecuritySystem.class);
    protected final OmeroInterceptor interceptor;
    protected final SystemTypes sysTypes;
    protected final CurrentDetails cd;
    protected final TokenHolder tokenHolder;
    protected final Roles roles;
    protected final SessionManager sessionManager;
    protected final ServiceFactory sf;
    protected final SecurityFilter filter;
    protected final PolicyService policyService;
    protected OmeroContext ctx;
    protected ShareStore store;

    public static BasicSecuritySystem selfConfigure(SessionManager sm, ServiceFactory sf, SessionCache cache) {
        CurrentDetails cd = new CurrentDetails(cache);
        SystemTypes st = new SystemTypes();
        TokenHolder th = new TokenHolder();
        OmeroInterceptor oi = new OmeroInterceptor(new Roles(), st, new ExtendedMetadata.Impl(), cd, th, new PerSessionStats(cd));
        Roles roles = new Roles();
        SecurityFilterHolder holder = new SecurityFilterHolder(cd, new OneGroupSecurityFilter(roles), new AllGroupsSecurityFilter(null, roles), new SharingSecurityFilter(roles, null));
        BasicSecuritySystem sec = new BasicSecuritySystem(oi, st, cd, sm, roles, sf, new TokenHolder(), holder, new DefaultPolicyService());
        return sec;
    }

    public BasicSecuritySystem(OmeroInterceptor interceptor, SystemTypes sysTypes, CurrentDetails cd, SessionManager sessionManager, Roles roles, ServiceFactory sf, TokenHolder tokenHolder, SecurityFilter filter, PolicyService policyService) {
        this.sessionManager = sessionManager;
        this.policyService = policyService;
        this.tokenHolder = tokenHolder;
        this.interceptor = interceptor;
        this.sysTypes = sysTypes;
        this.filter = filter;
        this.roles = roles;
        this.cd = cd;
        this.sf = sf;
    }

    public void setApplicationContext(ApplicationContext arg0) throws BeansException {
        this.ctx = (OmeroContext)arg0;
        this.store = (ShareStore)this.ctx.getBean("shareStore", ShareStore.class);
    }

    @Override
    public void login(Principal principal) {
        this.cd.login(principal);
    }

    @Override
    public int logout() {
        return this.cd.logout();
    }

    @Override
    public boolean isReady() {
        return this.cd.isReady();
    }

    @Override
    public boolean isSystemType(Class<? extends IObject> klass) {
        return this.sysTypes.isSystemType(klass);
    }

    public boolean isOwnerOrSupervisor(IObject iObject) {
        return this.cd.isOwnerOrSupervisor(iObject);
    }

    public void enableReadFilter(Object session) {
        if (session == null || !(session instanceof org.hibernate.Session)) {
            throw new ApiUsageException("The Object argument to enableReadFilter in the BasicSystemSecurity implementation must be a  non-null org.hibernate.Session.");
        }
        this.checkReady("enableReadFilter");
        EventContext ec = this.getEventContext();
        org.hibernate.Session sess = (org.hibernate.Session)session;
        this.filter.enable(sess, ec);
    }

    public void updateReadFilter(org.hibernate.Session session) {
        this.filter.disable(session);
        this.enableReadFilter(session);
    }

    public void disableReadFilter(Object session) {
        org.hibernate.Session sess = (org.hibernate.Session)session;
        this.filter.disable(sess);
    }

    @Override
    public void disable(String ... ids) {
        if (ids == null || ids.length == 0) {
            throw new ApiUsageException("Ids should not be empty.");
        }
        this.cd.addAllDisabled(ids);
    }

    @Override
    public void enable(String ... ids) {
        if (ids == null || ids.length == 0) {
            this.cd.clearDisabled();
        }
        this.cd.removeAllDisabled(ids);
    }

    @Override
    public boolean isDisabled(String id) {
        if (id == null) {
            throw new ApiUsageException("Id should not be null.");
        }
        return this.cd.isDisabled(id);
    }

    @Override
    public Details newTransientDetails(IObject object) throws ApiUsageException, SecurityViolation {
        this.checkReady("transientDetails");
        return this.interceptor.newTransientDetails(object);
    }

    @Override
    public Details checkManagedDetails(IObject object, Details trustedDetails) throws ApiUsageException, SecurityViolation {
        this.checkReady("managedDetails");
        return this.interceptor.checkManagedDetails(object, trustedDetails);
    }

    @Override
    public boolean isGraphCritical(Details details) {
        this.checkReady("isGraphCritical");
        return this.cd.isGraphCritical(details);
    }

    @Override
    public void loadEventContext(boolean isReadOnly) {
        this.loadEventContext(isReadOnly, false);
    }

    public void loadEventContext(boolean isReadOnly, boolean isClose) {
        Permissions callPerms;
        LocalAdmin admin = (LocalAdmin)this.sf.getAdminService();
        LocalUpdate update = (LocalUpdate)this.sf.getUpdateService();
        Principal p = this.clearAndCheckPrincipal();
        EventContext ec = this.cd.getCurrentEventContext();
        if (ec instanceof BasicSecurityWiring.CloseOnNoSessionContext) {
            throw new SessionTimeoutException("closing", ec);
        }
        try {
            ec = this.sessionManager.getEventContext(p);
        }
        catch (SessionTimeoutException ste) {
            if (!isClose) {
                throw ste;
            }
            ec = (EventContext)ste.sessionContext;
        }
        this.cd.checkAndInitialize(ec, admin, this.store);
        ec = this.cd.getCurrentEventContext();
        Experimenter exp = isReadOnly ? new Experimenter(ec.getCurrentUserId(), false) : admin.userProxy(ec.getCurrentUserId());
        this.tokenHolder.setToken(exp.getGraphHolder());
        boolean isAdmin = false;
        for (long gid : ec.getMemberOfGroupsList()) {
            if (this.roles.getSystemGroupId() != gid) continue;
            isAdmin = true;
            break;
        }
        Long shareId = ec.getCurrentShareId();
        Long groupId = ec.getCurrentGroupId();
        ExperimenterGroup callGroup = null;
        ExperimenterGroup eventGroup = null;
        if (groupId >= 0L) {
            long eventGroupId = groupId;
            eventGroup = callGroup = admin.groupProxy(groupId);
            callPerms = callGroup.getDetails().getPermissions();
            if (!(isAdmin || ec.getMemberOfGroupsList().contains(groupId) || callPerms.isGranted(Permissions.Role.WORLD, Permissions.Right.READ))) {
                throw new SecurityViolation(String.format("User %s is not a member of group %s and cannot login", ec.getCurrentUserId(), groupId));
            }
        } else {
            List<Long> memList = ec.getMemberOfGroupsList();
            long eventGroupId = memList.get(0);
            if (eventGroupId == this.roles.getUserGroupId() && memList.size() > 1) {
                eventGroupId = memList.get(1);
            }
            log.debug("Choice for event group: " + eventGroupId);
            eventGroup = admin.getGroup(eventGroupId);
            callGroup = new ExperimenterGroup(groupId, false);
            callPerms = Permissions.DUMMY;
        }
        long sessionId = ec.getCurrentSessionId();
        Session sess = null;
        sess = isReadOnly ? new Session(sessionId, false) : this.sf.getQueryService().get(Session.class, sessionId);
        this.tokenHolder.setToken(callGroup.getGraphHolder());
        this.cd.setValues(exp, callGroup, callPerms, isAdmin, isReadOnly, shareId);
        String t = p.getEventType();
        if (t == null) {
            t = ec.getCurrentEventType();
        }
        EventType type = new EventType(t);
        this.tokenHolder.setToken(type.getGraphHolder());
        Event event = this.cd.newEvent(sess, type, this.tokenHolder);
        this.tokenHolder.setToken(event.getGraphHolder());
        if (!isReadOnly) {
            if (event.getExperimenterGroup().getId() < 0L) {
                event.setExperimenterGroup(eventGroup);
            }
            this.cd.updateEvent(update.saveAndReturnObject(event));
        }
    }

    private Principal clearAndCheckPrincipal() {
        this.invalidateEventContext();
        if (this.cd.size() == 0) {
            throw new SecurityViolation("Principal is null. Not logged in to SecuritySystem.");
        }
        Principal p = this.cd.getLast();
        if (p.getName() == null) {
            throw new InternalException("Principal.name is null. Security system failure.");
        }
        return p;
    }

    public void addLog(String action, Class klass, Long id) {
        this.cd.addLog(action, klass, id);
    }

    public List<EventLog> getLogs() {
        return this.cd.getLogs();
    }

    public void clearLogs() {
        List<EventLog> logs;
        if (log.isDebugEnabled()) {
            log.debug("Clearing EventLogs.");
        }
        if (!(logs = this.getLogs()).isEmpty()) {
            boolean foundAdminType = false;
            ArrayListMultimap<String, EventLog> map = ArrayListMultimap.create();
            for (EventLog el : this.getLogs()) {
                String t = el.getEntityType();
                if (Experimenter.class.getName().equals(t) || ExperimenterGroup.class.getName().equals(t) || GroupExperimenterMap.class.getName().equals(t)) {
                    foundAdminType = true;
                }
                map.put(t, el);
            }
            if (this.ctx == null) {
                log.error("No context found for publishing");
            } else {
                if (foundAdminType) {
                    this.ctx.publishEvent(new UserGroupUpdateEvent(this));
                }
                this.ctx.publishEvent(new EventLogsMessage(this, map));
            }
        }
        this.cd.clearLogs();
    }

    @Override
    public void invalidateEventContext() {
        if (log.isDebugEnabled()) {
            log.debug("Invalidating current EventContext.");
        }
        this.cd.invalidateCurrentEventContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends IObject> T doAction(SecureAction action, T ... objs) {
        IObject retVal;
        Assert.notNull(objs);
        Assert.notEmpty(objs);
        Assert.notNull(action);
        LocalQuery query = (LocalQuery)this.sf.getQueryService();
        ArrayList<GraphHolder> ghs = new ArrayList<GraphHolder>();
        for (T obj : objs) {
            if (obj.getId() != null && !query.contains(obj)) {
                throw new SecurityViolation("Services are not allowed to call doAction() on non-Session-managed entities.");
            }
            if (obj instanceof HibernateProxy) {
                HibernateProxy hp = (HibernateProxy)obj;
                IObject obj2 = (IObject)hp.getHibernateLazyInitializer().getImplementation();
                ghs.add(obj2.getGraphHolder());
            }
            ghs.add(obj.getGraphHolder());
        }
        for (GraphHolder graphHolder : ghs) {
            this.tokenHolder.setToken(graphHolder);
        }
        try {
            retVal = action.updateObject((IObject[])objs);
        }
        finally {
            for (GraphHolder graphHolder : ghs) {
                this.tokenHolder.clearToken(graphHolder);
            }
        }
        return (T)retVal;
    }

    @Override
    public void runAsAdmin(AdminAction action) {
        this.runAsAdmin(null, action);
    }

    @Override
    public void runAsAdmin(final ExperimenterGroup group, final AdminAction action) {
        Assert.notNull(action);
        this.checkReady("runAsAdmin");
        LocalQuery query = (LocalQuery)this.sf.getQueryService();
        query.execute(new HibernateCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                BasicEventContext c = BasicSecuritySystem.this.cd.current();
                boolean wasAdmin = c.isCurrentUserAdmin();
                ExperimenterGroup oldGroup = c.getGroup();
                try {
                    c.setAdmin(true);
                    if (group != null) {
                        c.setGroup(group, group.getDetails().getPermissions());
                    }
                    BasicSecuritySystem.this.disable("MergeEvent");
                    BasicSecuritySystem.this.enableReadFilter(session);
                    action.runAsAdmin();
                    c.setAdmin(wasAdmin);
                    if (group != null) {
                        c.setGroup(oldGroup, oldGroup.getDetails().getPermissions());
                    }
                }
                catch (Throwable throwable) {
                    c.setAdmin(wasAdmin);
                    if (group != null) {
                        c.setGroup(oldGroup, oldGroup.getDetails().getPermissions());
                    }
                    BasicSecuritySystem.this.enable("MergeEvent");
                    BasicSecuritySystem.this.enableReadFilter(session);
                    throw throwable;
                }
                BasicSecuritySystem.this.enable("MergeEvent");
                BasicSecuritySystem.this.enableReadFilter(session);
                return null;
            }
        });
    }

    public void copyToken(IObject source, IObject copy) {
        this.tokenHolder.copyToken(source, copy);
    }

    @Override
    public boolean hasPrivilegedToken(IObject obj) {
        return this.tokenHolder.hasPrivilegedToken(obj);
    }

    @Override
    public void checkRestriction(String name, IObject obj) {
        this.policyService.checkRestriction(name, obj);
    }

    @Override
    public Roles getSecurityRoles() {
        return this.roles;
    }

    @Override
    public EventContext getEventContext(boolean refresh) {
        EventContext ec = this.cd.getCurrentEventContext();
        if (refresh) {
            String uuid = ec.getCurrentSessionUuid();
            ec = this.sessionManager.reload(uuid);
        }
        return ec;
    }

    @Override
    public EventContext getEventContext() {
        return this.getEventContext(false);
    }

    @Override
    public Long getEffectiveUID() {
        EventContext ec = this.getEventContext();
        Long shareId = ec.getCurrentShareId();
        if (shareId != null) {
            if (shareId < 0L) {
                return null;
            }
            Session s = this.sf.getQueryService().get(Session.class, shareId);
            return s.getOwner().getId();
        }
        return ec.getCurrentUserId();
    }

    protected void checkReady(String method) {
        if (!this.isReady()) {
            throw new ApiUsageException("The security system is not ready.\nCannot execute: " + method);
        }
    }

    public void onApplicationEvent(EventLogMessage elm) {
        if (elm != null) {
            for (Long id : elm.entityIds) {
                this.addLog(elm.action, elm.entityType, id);
            }
        }
    }
}

