/*
 * Decompiled with CFR 0.152.
 */
package ome.security.basic;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ome.api.local.LocalAdmin;
import ome.conditions.InternalException;
import ome.conditions.SecurityViolation;
import ome.model.IObject;
import ome.model.internal.Permissions;
import ome.model.meta.Event;
import ome.model.meta.EventLog;
import ome.model.meta.Experimenter;
import ome.model.meta.ExperimenterGroup;
import ome.services.messages.RegisterServiceCleanupMessage;
import ome.services.sessions.stats.SessionStats;
import ome.services.sharing.ShareStore;
import ome.services.sharing.data.ShareData;
import ome.system.EventContext;
import ome.system.Principal;
import ome.system.SimpleEventContext;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicEventContext
extends SimpleEventContext {
    private static final Logger log = LoggerFactory.getLogger(BasicEventContext.class);
    private final Principal p;
    private final SessionStats stats;
    private Set<String> disabledSubsystems;
    private Set<RegisterServiceCleanupMessage> serviceCleanups;
    private Set<IObject> lockCandidates;
    private List<EventLog> logs;
    private Event event;
    private Experimenter owner;
    private ExperimenterGroup group;
    private Map<String, String> callContext;
    private Map<Long, Permissions> groupPermissionsMap;

    public BasicEventContext(Principal p, SessionStats stats) {
        if (p == null || stats == null) {
            throw new RuntimeException("Principal and stats canot be null.");
        }
        this.p = p;
        this.stats = stats;
    }

    public BasicEventContext(Principal p, SessionStats stats, EventContext ec) {
        this(p, stats);
        this.copyContext(ec);
    }

    void invalidate() {
        this.owner = null;
        this.group = null;
        this.event = null;
    }

    void copyContext(EventContext ec) {
        super.copy(ec);
    }

    void checkAndInitialize(EventContext ec, LocalAdmin admin, ShareStore store) {
        Long gid;
        this.copyContext(ec);
        ArrayList<String> toPrint = null;
        Long sid = BasicEventContext.parseId(this.callContext, "omero.share");
        if (sid != null) {
            ShareData data;
            if (!this.isAdmin && (data = store.getShareIfAccessible(sid, this.isAdmin, this.cuId)) == null) {
                throw new SecurityViolation(String.format("User %s cannot access share %s", this.cuId, sid));
            }
            this.setShareId(sid);
            if (toPrint == null) {
                toPrint = new ArrayList<String>();
            }
            toPrint.add("share=" + sid);
            return;
        }
        Long uid = BasicEventContext.parseId(this.callContext, "omero.user");
        if (uid != null) {
            if (this.cuId != null && !this.isAdmin && !this.cuId.equals(uid)) {
                throw new SecurityViolation(String.format("User %s is not an admin and so cannot set uid to %s", this.cuId, uid));
            }
            this.setOwner(admin.userProxy(uid));
            if (toPrint == null) {
                toPrint = new ArrayList();
            }
            toPrint.add("owner=" + uid);
        }
        if ((gid = BasicEventContext.parseId(this.callContext, "omero.group")) != null) {
            if (gid < 0L) {
                this.setGroup(new ExperimenterGroup(gid, false), Permissions.DUMMY);
            } else {
                ExperimenterGroup g = admin.groupProxy(gid);
                this.setGroup(g, g.getDetails().getPermissions());
            }
            if (toPrint == null) {
                toPrint = new ArrayList();
            }
            toPrint.add("group=" + gid);
        }
        if (toPrint != null && toPrint.size() > 0) {
            log.info(" cctx:\t" + StringUtils.join(toPrint, ","));
        }
    }

    static Long parseId(Map<String, String> ctx, String key) {
        Long rv = null;
        if (ctx != null && ctx.containsKey(key)) {
            String s = ctx.get(key);
            try {
                rv = Long.valueOf(ctx.get(key));
                log.debug("Using call requested group: " + key + "=" + s);
            }
            catch (Exception e) {
                log.warn("Ignoring invalid requested group: " + key + "=" + s);
            }
        }
        return rv;
    }

    public Map<String, String> getCallContext() {
        return this.callContext;
    }

    public Map<String, String> setCallContext(Map<String, String> ctx) {
        Map<String, String> rv = this.callContext;
        this.callContext = ctx;
        return rv;
    }

    public void setUmask(Permissions umask) {
        this.umask = umask;
    }

    public void setAdmin(boolean admin) {
        this.isAdmin = admin;
    }

    public void setReadOnly(boolean readOnly) {
        this.isReadOnly = readOnly;
    }

    public void setShareId(Long id) {
        this.shareId = id;
    }

    public Principal getPrincipal() {
        return this.p;
    }

    public SessionStats getStats() {
        return this.stats;
    }

    public Event getEvent() {
        return this.event;
    }

    public void setEvent(Event event) {
        this.event = event;
        this.ceId = event.getId();
        if (event.isLoaded() && event.getType().isLoaded()) {
            this.ceType = event.getType().getValue();
        }
    }

    public Experimenter getOwner() {
        return this.owner;
    }

    public void setOwner(Experimenter owner) {
        this.owner = owner;
        this.cuId = owner.getId();
        if (owner.isLoaded()) {
            this.cuName = owner.getOmeName();
        }
    }

    public ExperimenterGroup getGroup() {
        return this.group;
    }

    public void setGroup(ExperimenterGroup group, Permissions p) {
        this.group = group;
        this.setGroupPermissions(p);
        if (!this.cgId.equals(group.getId())) {
            this.cgId = group.getId();
            this.cgName = null;
            if (group.isLoaded()) {
                this.cgName = group.getName();
            }
        }
    }

    public Set<String> getDisabledSubsystems() {
        return this.disabledSubsystems;
    }

    public void setDisabledSubsystems(Set<String> disabledSubsystems) {
        this.disabledSubsystems = disabledSubsystems;
    }

    public Set<RegisterServiceCleanupMessage> getServiceCleanups() {
        return this.serviceCleanups;
    }

    public void setServiceCleanups(Set<RegisterServiceCleanupMessage> serviceCleanups) {
        this.serviceCleanups = serviceCleanups;
    }

    public Set<IObject> getLockCandidates() {
        return this.lockCandidates;
    }

    public void setLockCandidates(Set<IObject> lockCandidates) {
        this.lockCandidates = lockCandidates;
    }

    public List<EventLog> getLogs() {
        return this.logs;
    }

    public void setLogs(List<EventLog> logs) {
        this.logs = logs;
    }

    @Override
    public List<Long> getMemberOfGroupsList() {
        return this.memberOfGroups;
    }

    @Override
    public List<Long> getLeaderOfGroupsList() {
        return this.leaderOfGroups;
    }

    public void setMemberOfGroups(List<Long> groupIds) {
        this.memberOfGroups = groupIds;
    }

    public void setLeaderOfGroups(List<Long> groupIds) {
        this.leaderOfGroups = groupIds;
    }

    public Permissions getPermissionsForGroup(Long group) {
        if (group == null || this.groupPermissionsMap == null) {
            return null;
        }
        return this.groupPermissionsMap.get(group);
    }

    public Permissions setPermissionsForGroup(Long group, Permissions perms) {
        if (perms == Permissions.DUMMY) {
            throw new InternalException("DUMMY permissions passed to setPermissionsForGroup!");
        }
        if (this.groupPermissionsMap == null) {
            this.groupPermissionsMap = new HashMap<Long, Permissions>();
        }
        return this.groupPermissionsMap.put(group, perms);
    }

    public void loadPermissions(Session session) {
        if (this.groupPermissionsMap != null) {
            for (Map.Entry<Long, Permissions> entry : this.groupPermissionsMap.entrySet()) {
                if (entry.getValue() != null) continue;
                Long id = entry.getKey();
                ExperimenterGroup g = (ExperimenterGroup)session.get(ExperimenterGroup.class, (Serializable)id);
                entry.setValue(g.getDetails().getPermissions());
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append("(");
        sb.append("Principal:" + this.p);
        sb.append(";");
        sb.append(this.owner);
        sb.append(";");
        sb.append(this.group);
        sb.append(";");
        sb.append(this.event);
        sb.append(";");
        sb.append("ReadOnly:" + this.isReadOnly);
        sb.append(")");
        return sb.toString();
    }
}

