/*
 * Decompiled with CFR 0.152.
 */
package ome.security.basic;

import java.util.Set;
import ome.conditions.GroupSecurityViolation;
import ome.conditions.InternalException;
import ome.conditions.SecurityViolation;
import ome.model.IObject;
import ome.model.core.OriginalFile;
import ome.model.internal.Details;
import ome.model.internal.Permissions;
import ome.model.meta.Experimenter;
import ome.model.meta.ExperimenterGroup;
import ome.security.ACLVoter;
import ome.security.SecurityFilter;
import ome.security.SystemTypes;
import ome.security.basic.BasicEventContext;
import ome.security.basic.CurrentDetails;
import ome.security.basic.TokenHolder;
import ome.security.policy.PolicyService;
import ome.system.EventContext;
import ome.system.Roles;
import org.hibernate.LazyInitializationException;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class BasicACLVoter
implements ACLVoter {
    private static final Logger log = LoggerFactory.getLogger(BasicACLVoter.class);
    protected final CurrentDetails currentUser;
    protected final SystemTypes sysTypes;
    protected final TokenHolder tokenHolder;
    protected final SecurityFilter securityFilter;
    protected final PolicyService policyService;
    protected final Roles roles;

    public BasicACLVoter(CurrentDetails cd, SystemTypes sysTypes, TokenHolder tokenHolder, SecurityFilter securityFilter, PolicyService policyService) {
        this(cd, sysTypes, tokenHolder, securityFilter, policyService, new Roles());
    }

    public BasicACLVoter(CurrentDetails cd, SystemTypes sysTypes, TokenHolder tokenHolder, SecurityFilter securityFilter, PolicyService policyService, Roles roles) {
        this.currentUser = cd;
        this.sysTypes = sysTypes;
        this.securityFilter = securityFilter;
        this.tokenHolder = tokenHolder;
        this.roles = roles;
        this.policyService = policyService;
    }

    @Override
    public boolean allowChmod(IObject iObject) {
        return this.currentUser.isOwnerOrSupervisor(iObject);
    }

    @Override
    public boolean allowLoad(Session session, Class<? extends IObject> klass, Details d, long id) {
        Assert.notNull(klass);
        if (d == null || this.sysTypes.isSystemType(klass)) {
            return true;
        }
        boolean rv = false;
        rv = this.sysTypes.isInSystemGroup(d) || this.sysTypes.isInUserGroup(d) ? true : this.securityFilter.passesFilter(session, d, this.currentUser.current());
        if (this.currentUser.getCurrentEventContext().getCurrentGroupId() < 0L) {
            ExperimenterGroup g = d.getGroup();
            if (g == null) {
                log.warn(String.format("Group null while loading %s:%s", klass.getName(), id));
            }
            if (g != null) {
                Long gid = g.getId();
                Permissions p = g.getDetails().getPermissions();
                if (p == null) {
                    log.warn(String.format("Permissions null for group %s while loading %s:%s", gid, klass.getName(), id));
                } else {
                    this.currentUser.current().setPermissionsForGroup(gid, p);
                }
            }
        }
        return rv;
    }

    @Override
    public void throwLoadViolation(IObject iObject) throws SecurityViolation {
        Assert.notNull(iObject);
        throw new SecurityViolation("Cannot read " + iObject);
    }

    @Override
    public boolean allowCreation(IObject iObject) {
        boolean sysType;
        Assert.notNull(iObject);
        Class<?> cls = iObject.getClass();
        boolean bl = sysType = this.sysTypes.isSystemType(cls) || this.sysTypes.isInSystemGroup(iObject.getDetails());
        if (this.tokenHolder.hasPrivilegedToken(iObject) || this.currentUser.getCurrentEventContext().isCurrentUserAdmin()) {
            return true;
        }
        return !sysType;
    }

    @Override
    public void throwCreationViolation(IObject iObject) throws SecurityViolation {
        boolean sysType;
        Assert.notNull(iObject);
        boolean bl = sysType = this.sysTypes.isSystemType(iObject.getClass()) || this.sysTypes.isInSystemGroup(iObject.getDetails());
        if (!sysType && this.currentUser.isGraphCritical(iObject.getDetails())) {
            throw new GroupSecurityViolation(iObject + "-insertion violates group-security.");
        }
        throw new SecurityViolation(iObject + " is a System-type, and may only be created through privileged APIs.");
    }

    @Override
    public boolean allowAnnotate(IObject iObject, Details trustedDetails) {
        BasicEventContext c = this.currentUser.current();
        return 1 == this.allowUpdateOrDelete(c, iObject, trustedDetails, Scope.ANNOTATE);
    }

    @Override
    public boolean allowUpdate(IObject iObject, Details trustedDetails) {
        BasicEventContext c = this.currentUser.current();
        return 1 == this.allowUpdateOrDelete(c, iObject, trustedDetails, Scope.EDIT);
    }

    @Override
    public void throwUpdateViolation(IObject iObject) throws SecurityViolation {
        boolean sysType;
        Assert.notNull(iObject);
        boolean bl = sysType = this.sysTypes.isSystemType(iObject.getClass()) || this.sysTypes.isInSystemGroup(iObject.getDetails());
        if (!sysType && this.currentUser.isGraphCritical(iObject.getDetails())) {
            throw new GroupSecurityViolation(iObject + "-modification violates group-security.");
        }
        throw new SecurityViolation("Updating " + iObject + " not allowed.");
    }

    @Override
    public boolean allowDelete(IObject iObject, Details trustedDetails) {
        BasicEventContext c = this.currentUser.current();
        return 1 == this.allowUpdateOrDelete(c, iObject, trustedDetails, Scope.DELETE);
    }

    @Override
    public void throwDeleteViolation(IObject iObject) throws SecurityViolation {
        Assert.notNull(iObject);
        throw new SecurityViolation("Deleting " + iObject + " not allowed.");
    }

    boolean owner(Long o, EventContext c) {
        return o != null && o.equals(c.getCurrentUserId());
    }

    boolean owner(Details d, EventContext c) {
        Long o = d.getOwner() == null ? null : d.getOwner().getId();
        return o != null && o.equals(c.getCurrentUserId());
    }

    boolean member(Long g, EventContext c) {
        return g != null && c.getMemberOfGroupsList().contains(g);
    }

    boolean member(Details d, EventContext c) {
        Long g = d.getGroup() == null ? null : d.getGroup().getId();
        return this.member(g, c);
    }

    boolean leader(Long g, EventContext c) {
        return g != null && c.getLeaderOfGroupsList().contains(g);
    }

    boolean leader(Details d, EventContext c) {
        Long g = d.getGroup() == null ? null : d.getGroup().getId();
        return this.leader(g, c);
    }

    private int allowUpdateOrDelete(BasicEventContext c, IObject iObject, Details trustedDetails, Scope ... scopes) {
        boolean sysTypeOrUsrGroup;
        int rv = 0;
        if (iObject == null) {
            throw new IllegalArgumentException("null object");
        }
        Details d = trustedDetails;
        if (d == null) {
            throw new InternalException("trustedDetails are null!");
        }
        boolean sysType = this.sysTypes.isSystemType(iObject.getClass()) || this.sysTypes.isInSystemGroup(d);
        boolean bl = sysTypeOrUsrGroup = sysType || this.sysTypes.isInUserGroup(d);
        if (this.tokenHolder.hasPrivilegedToken(iObject)) {
            return 1;
        }
        if (!sysTypeOrUsrGroup && this.currentUser.isGraphCritical(d)) {
            Boolean belongs = null;
            Long uid = c.getCurrentUserId();
            for (int i = 0; i < scopes.length; ++i) {
                if (!scopes[i].equals((Object)Scope.LINK) && !scopes[i].equals((Object)Scope.ANNOTATE)) continue;
                if (belongs == null) {
                    belongs = this.objectBelongsToUser(iObject, uid);
                }
                if (belongs.booleanValue()) continue;
                scopes[i] = null;
            }
        }
        if (c.isCurrentUserAdmin()) {
            for (int i = 0; i < scopes.length; ++i) {
                if (scopes[i] == null) continue;
                rv |= 1 << i;
            }
            return rv;
        }
        if (sysType) {
            return 0;
        }
        Permissions grpPermissions = c.getCurrentGroupPermissions();
        ExperimenterGroup grp = d.getGroup();
        if (!sysType && grp != null) {
            try {
                if (!(!grp.isLoaded() || iObject instanceof OriginalFile && iObject.isLoaded() && grp.getId().longValue() == this.roles.getUserGroupId() && "Directory".equals(((OriginalFile)iObject).getMimetype()))) {
                    grpPermissions = grp.getDetails().getPermissions();
                }
            }
            catch (LazyInitializationException i) {
                // empty catch block
            }
        }
        if (grpPermissions == null || grpPermissions == Permissions.DUMMY) {
            Long gid;
            if (d.getGroup() != null && (grpPermissions = c.getPermissionsForGroup(gid = d.getGroup().getId())) == null && gid.equals(this.roles.getUserGroupId())) {
                grpPermissions = new Permissions(Permissions.EMPTY);
            }
            if (grpPermissions == null) {
                throw new InternalException("Permissions are null! Security system failure -- refusing to continue. The Permissions should be set to a default value.");
            }
        }
        boolean owner = this.owner(d, (EventContext)c);
        boolean leader = this.leader(d, (EventContext)c);
        boolean member = this.member(d, (EventContext)c);
        for (int i = 0; i < scopes.length; ++i) {
            Scope scope = scopes[i];
            if (scope == null) continue;
            if (leader) {
                rv |= 1 << i;
                continue;
            }
            if (grpPermissions.isGranted(Permissions.Role.WORLD, scope.right)) {
                rv |= 1 << i;
                continue;
            }
            if (owner && grpPermissions.isGranted(Permissions.Role.USER, scope.right)) {
                rv |= 1 << i;
                continue;
            }
            if (!member || !grpPermissions.isGranted(Permissions.Role.GROUP, scope.right)) continue;
            rv |= 1 << i;
        }
        return rv;
    }

    @Override
    public Set<String> restrictions(IObject object) {
        return this.policyService.listActiveRestrictions(object);
    }

    @Override
    public void postProcess(IObject object) {
        if (object.isLoaded()) {
            Details details = object.getDetails();
            this.currentUser.applyContext(details, !(object instanceof ExperimenterGroup));
            BasicEventContext c = this.currentUser.current();
            Permissions p = details.getPermissions();
            int allow = this.allowUpdateOrDelete(c, object, details, Scope.LINK, Scope.EDIT, Scope.DELETE, Scope.ANNOTATE);
            Permissions copy = new Permissions(p);
            copy.copyRestrictions(allow, this.restrictions(object));
            details.setPermissions(copy);
        }
    }

    private boolean objectBelongsToUser(IObject iObject, Long uid) {
        Experimenter e = iObject.getDetails().getOwner();
        if (e == null) {
            if (iObject.getId() == null) {
                return true;
            }
            throw new NullPointerException("Null owner for " + iObject);
        }
        Long oid = e.getId();
        return uid.equals(oid);
    }

    private static enum Scope {
        ANNOTATE(Permissions.Right.ANNOTATE),
        DELETE(Permissions.Right.WRITE),
        EDIT(Permissions.Right.WRITE),
        LINK(Permissions.Right.WRITE);

        final Permissions.Right right;

        private Scope(Permissions.Right right) {
            this.right = right;
        }
    }
}

