/*
 * Decompiled with CFR 0.152.
 */
package ome.security.basic;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ome.model.internal.Details;
import ome.model.internal.Permissions;
import ome.model.meta.ExperimenterGroup;
import ome.security.basic.AbstractSecurityFilter;
import ome.system.EventContext;
import ome.system.Roles;
import ome.util.SqlAction;
import ome.util.Utils;
import org.hibernate.Filter;
import org.hibernate.Session;

public class AllGroupsSecurityFilter
extends AbstractSecurityFilter {
    public static final String is_admin = "is_admin";
    public static final String member_of_groups = "member_of_groups";
    public static final String leader_of_groups = "leader_of_groups";
    public static final String filterName = "securityFilter";
    final SqlAction sql;

    public AllGroupsSecurityFilter(SqlAction sql) {
        this(sql, new Roles());
    }

    public AllGroupsSecurityFilter(SqlAction sql, Roles roles) {
        super(roles);
        this.sql = sql;
    }

    protected String myFilterCondition() {
        return String.format("\n( \n  1 = :is_share OR \n  1 = :is_admin OR \n  (group_id in (:leader_of_groups)) OR \n  (owner_id = :current_user AND %s) OR \n  (group_id in (:member_of_groups) AND %s) OR \n  (%s) \n)\n", AllGroupsSecurityFilter.isGranted(Permissions.Role.USER, Permissions.Right.READ), AllGroupsSecurityFilter.isGranted(Permissions.Role.GROUP, Permissions.Right.READ), AllGroupsSecurityFilter.isGranted(Permissions.Role.WORLD, Permissions.Right.READ));
    }

    @Override
    public String getDefaultCondition() {
        return this.myFilterCondition();
    }

    @Override
    public Map<String, String> getParameterTypes() {
        HashMap<String, String> parameterTypes = new HashMap<String, String>();
        parameterTypes.put("is_share", "int");
        parameterTypes.put(is_admin, "int");
        parameterTypes.put("current_user", "long");
        parameterTypes.put(member_of_groups, "long");
        parameterTypes.put(leader_of_groups, "long");
        return parameterTypes;
    }

    @Override
    public boolean passesFilter(Session session, Details d, EventContext c) {
        Long currentUserId = c.getCurrentUserId();
        boolean admin = c.isCurrentUserAdmin();
        boolean share = this.isShare(c);
        List<Long> memberOfGroups = c.getMemberOfGroupsList();
        List<Long> leaderOfGroups = c.getLeaderOfGroupsList();
        Long o = d.getOwner().getId();
        Long g = d.getGroup().getId();
        ExperimenterGroup group = (ExperimenterGroup)session.get(ExperimenterGroup.class, (Serializable)g);
        Permissions p = group.getDetails().getPermissions();
        if (p == null) {
            p = Utils.toPermissions(this.sql.getGroupPermissions(g));
            group.getDetails().setPermissions(p);
            this.log.warn(String.format("Forced to reload permissions for group %s: %s", g, p));
        }
        if (share || admin) {
            return true;
        }
        if (p.isGranted(Permissions.Role.WORLD, Permissions.Right.READ)) {
            return true;
        }
        if (currentUserId.equals(o) && p.isGranted(Permissions.Role.USER, Permissions.Right.READ)) {
            return true;
        }
        if (memberOfGroups.contains(g) && p.isGranted(Permissions.Role.GROUP, Permissions.Right.READ)) {
            return true;
        }
        return leaderOfGroups.contains(g);
    }

    @Override
    public void enable(Session sess, EventContext ec) {
        Filter filter = sess.enableFilter(this.getName());
        int share01 = this.isShare(ec) ? 1 : 0;
        int admin01 = ec.isCurrentUserAdmin() ? 1 : 0;
        filter.setParameter(is_admin, (Object)admin01);
        filter.setParameter("is_share", (Object)share01);
        filter.setParameter("current_user", (Object)ec.getCurrentUserId());
        filter.setParameterList(member_of_groups, this.configGroup(ec, ec.getMemberOfGroupsList()));
        filter.setParameterList(leader_of_groups, this.configGroup(ec, ec.getLeaderOfGroupsList()));
        this.enableBaseFilters(sess, admin01, ec.getCurrentUserId());
    }

    protected Collection<Long> configGroup(EventContext ec, List<Long> list) {
        List<Long> rv = null;
        if (ec.isCurrentUserAdmin()) {
            rv = Collections.singletonList(-1L);
        } else {
            rv = list;
            if (rv == null || rv.size() == 0) {
                rv = Collections.singletonList(Long.MIN_VALUE);
            }
        }
        return rv;
    }

    protected static String isGranted(Permissions.Role role, Permissions.Right right) {
        String bit = "" + Permissions.bit(role, right);
        String isGranted = String.format("(select (__g.permissions & %s) = %s from experimentergroup __g where __g.id = group_id)", bit, bit);
        return isGranted;
    }
}

