/*
 * Decompiled with CFR 0.152.
 */
package ome.security.auth;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Random;
import ome.conditions.ApiUsageException;
import ome.conditions.InternalException;
import ome.system.Roles;
import ome.util.SqlAction;
import ome.util.checksum.ChecksumProviderFactoryImpl;
import ome.util.checksum.ChecksumType;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PasswordUtil {
    public static final String DEFAULT_ENCODING = "UTF-8";
    private static final Logger log = LoggerFactory.getLogger(PasswordUtil.class);
    private final SqlAction sql;
    private final Roles roles;
    private final boolean passwordRequired;
    private final Charset encoding;

    public PasswordUtil(SqlAction sql) {
        this(sql, new Roles(), true);
    }

    public PasswordUtil(SqlAction sql, boolean passwordRequired) {
        this(sql, new Roles(), passwordRequired);
    }

    public PasswordUtil(SqlAction sql, Charset encoding) {
        this(sql, true, encoding);
    }

    public PasswordUtil(SqlAction sql, boolean passwordRequired, Charset encoding) {
        this(sql, new Roles(), passwordRequired, encoding);
    }

    public PasswordUtil(SqlAction sql, Roles roles, boolean passwordRequired) {
        this(sql, roles, passwordRequired, Charset.forName(DEFAULT_ENCODING));
    }

    public PasswordUtil(SqlAction sql, Roles roles, boolean passwordRequired, Charset encoding) {
        this.sql = sql;
        this.roles = roles;
        this.passwordRequired = passwordRequired;
        this.encoding = encoding;
    }

    public static void main(String[] args) {
        if (args == null || args.length < 1 || args.length > 2) {
            throw new IllegalArgumentException("PasswordUtil password [user-id]");
        }
        PasswordUtil util = new PasswordUtil(null);
        String pw = args[0];
        if (args.length == 1) {
            System.out.println(util.preparePassword(pw));
        } else {
            Long userId = Long.valueOf(args[1]);
            System.out.println(util.prepareSaltedPassword(userId, pw));
        }
    }

    public String generateRandomPasswd() {
        StringBuffer buffer = new StringBuffer();
        Random random = new Random();
        char[] chars = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
        for (int i = 0; i < 10; ++i) {
            buffer.append(chars[random.nextInt(chars.length)]);
        }
        return buffer.toString();
    }

    public boolean getDnById(Long id) {
        return this.sql.isLdapExperimenter(id);
    }

    public void changeUserPasswordById(Long id, String password) {
        this.changeUserPasswordById(id, password, METHOD.LEGACY);
    }

    public void changeUserPasswordById(Long id, String password, METHOD meth) {
        String prepared = password;
        if (meth.hash) {
            prepared = this.preparePassword(id, password, meth.salt);
        }
        if (!this.sql.setUserPassword(id, prepared)) {
            throw new InternalException("0 results for password insert.");
        }
        this.sql.clearPermissionsBit("experimenter", id, 16);
    }

    public String getUserPasswordHash(Long id) {
        return this.sql.getPasswordHash(id);
    }

    public Long userId(String name) {
        return this.sql.getUserId(name);
    }

    public String userName(long id) {
        return this.sql.getUsername(id);
    }

    public List<String> userGroups(String name) {
        return this.sql.getUserGroups(name);
    }

    public String preparePassword(String newPassword) {
        return this.preparePassword(null, newPassword, false);
    }

    public String prepareSaltedPassword(Long userId, String newPassword) {
        return this.preparePassword(userId, newPassword, true);
    }

    protected String preparePassword(Long userId, String newPassword, boolean salt) {
        return newPassword == null || newPassword.trim().isEmpty() && this.isPasswordRequired(userId) ? null : (newPassword.trim().isEmpty() ? newPassword : this.passwordDigest(userId, newPassword, salt));
    }

    public String passwordDigest(String clearText) {
        return this.passwordDigest(null, clearText, false);
    }

    public String saltedPasswordDigest(Long userId, String clearText) {
        return this.passwordDigest(userId, clearText, true);
    }

    protected String passwordDigest(Long userId, String clearText, boolean salt) {
        if (clearText == null) {
            throw new ApiUsageException("Value for digesting may not be null");
        }
        byte[] bytes = clearText.getBytes(this.encoding);
        if (userId != null && salt) {
            byte[] saltedBytes = ByteBuffer.allocate(8).putLong(userId).array();
            byte[] newValue = new byte[saltedBytes.length + bytes.length];
            System.arraycopy(saltedBytes, 0, newValue, 0, saltedBytes.length);
            System.arraycopy(bytes, 0, newValue, saltedBytes.length, bytes.length);
            bytes = newValue;
        }
        String hashedText = null;
        ChecksumProviderFactoryImpl cpf = new ChecksumProviderFactoryImpl();
        try {
            bytes = cpf.getProvider(ChecksumType.MD5).putBytes(bytes).checksumAsBytes();
            bytes = Base64.encodeBase64((byte[])bytes);
            hashedText = new String(bytes);
        }
        catch (Exception e) {
            log.error("Could not hash password", e);
        }
        if (hashedText == null) {
            throw new InternalException("Failed to obtain digest.");
        }
        return hashedText;
    }

    public boolean isPasswordRequired(Long id) {
        if (id == null) {
            return this.passwordRequired;
        }
        return !id.equals(this.roles.getGuestId()) && this.passwordRequired;
    }

    public static enum METHOD {
        CLEAR(false, false),
        LEGACY(true, false),
        ALL(true, true);

        private final boolean hash;
        private final boolean salt;

        private METHOD(boolean hash, boolean salt) {
            this.hash = hash;
            this.salt = salt;
        }
    }
}

