/*
 * Decompiled with CFR 0.152.
 */
package ome.security.auth;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import ome.services.messages.LoginAttemptMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;

public class LoginAttemptListener
implements ApplicationListener<LoginAttemptMessage> {
    private static final Logger log = LoggerFactory.getLogger(LoginAttemptListener.class);
    private final LoadingCache<String, AtomicInteger> counts = CacheBuilder.newBuilder().build(new CacheLoader<String, AtomicInteger>(){

        @Override
        public AtomicInteger load(String key) {
            return new AtomicInteger(0);
        }
    });
    private final int throttleCount;
    private final long throttleTime;

    public LoginAttemptListener(int throttleCount, long throttleTime) {
        this.throttleCount = throttleCount;
        this.throttleTime = throttleTime;
    }

    public void onApplicationEvent(LoginAttemptMessage lam) {
        if (lam.success == null) {
            return;
        }
        AtomicInteger ai = null;
        try {
            ai = this.counts.get(lam.user);
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        if (lam.success.booleanValue()) {
            int previous = ai.getAndSet(0);
            if (previous > 0) {
                log.info(String.format("Resetting failed login count of %s for %s", previous, lam.user));
            }
        } else {
            int value = ai.incrementAndGet();
            if (value > this.throttleCount) {
                log.warn(String.format("%s failed logins for %s. Throttling for %s", value, lam.user, this.throttleTime));
                if (this.throttleTime > 0L) {
                    try {
                        Thread.sleep(this.throttleTime);
                    }
                    catch (InterruptedException e) {
                        log.debug("Interrupt while throttling for " + lam.user);
                    }
                }
            }
        }
    }
}

