/*
 * Decompiled with CFR 0.152.
 */
package ome.security.auth;

import ome.conditions.ApiUsageException;
import ome.conditions.ValidationException;
import ome.logic.LdapImpl;
import ome.model.meta.Experimenter;
import ome.security.auth.ConfigurablePasswordProvider;
import ome.security.auth.PasswordUtil;
import org.springframework.util.Assert;

public class LdapPasswordProvider
extends ConfigurablePasswordProvider {
    protected final LdapImpl ldapUtil;

    public LdapPasswordProvider(PasswordUtil util, LdapImpl ldap) {
        super(util);
        Assert.notNull(ldap);
        this.ldapUtil = ldap;
    }

    public LdapPasswordProvider(PasswordUtil util, LdapImpl ldap, boolean ignoreUnknown) {
        super(util, ignoreUnknown);
        Assert.notNull(ldap);
        this.ldapUtil = ldap;
    }

    @Override
    public boolean hasPassword(String user) {
        String dn;
        Long id;
        return this.ldapUtil.getSetting() && (id = this.util.userId(user)) != null && (dn = this.ldapUtil.lookupLdapAuthExperimenter(id)) != null;
    }

    @Override
    public Boolean checkPassword(String user, String password, boolean readOnly) {
        String dn1;
        if (!this.ldapUtil.getSetting()) {
            return null;
        }
        if (password == null || password.equals("")) {
            this.log.warn("Empty password for user: " + user);
            this.loginAttempt(user, false);
            return false;
        }
        Long id = this.util.userId(user);
        if (null == id) {
            try {
                if (readOnly) {
                    throw new IllegalStateException("Cannot create user!");
                }
                Experimenter experimenter = this.ldapUtil.createUser(user, password);
                if (experimenter != null) {
                    this.loginAttempt(user, true);
                    return true;
                }
            }
            catch (ApiUsageException e) {
                this.log.info(String.format("Default choice on create user: %s (%s)", user, e));
            }
        }
        String string = dn1 = id == null ? null : this.getOmeroDN(id);
        if (dn1 != null) {
            String dn2 = this.getLdapDN(user);
            if (dn2 == null) {
                this.log.info(String.format("User not found in LDAP: {username=%s, dn=%s}", user, dn1));
                return this.loginAttempt(user, false);
            }
            if (!dn1.equals(dn2)) {
                String msg = String.format("DNs don't match: '%s' and '%s'", dn1, dn2);
                this.log.warn(msg);
                this.loginAttempt(user, false);
                throw new ValidationException(msg);
            }
            this.ldapUtil.synchronizeLdapUser(user);
            return this.loginAttempt(user, this.ldapUtil.validatePassword(dn1, password));
        }
        return super.checkPassword(user, password, readOnly);
    }

    private String getOmeroDN(long id) {
        try {
            String dn = this.ldapUtil.lookupLdapAuthExperimenter(id);
            if (this.log.isDebugEnabled()) {
                this.log.debug(String.format("lookupLdap(%s)=%s", id, dn));
            }
            return dn;
        }
        catch (ApiUsageException e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug(String.format("lookupLdap(%s) is empty", id));
            }
            return null;
        }
    }

    private String getLdapDN(String user) {
        try {
            String dn = this.ldapUtil.findDN(user);
            if (this.log.isDebugEnabled()) {
                this.log.debug(String.format("findDN(%s)=%s", user, dn));
            }
            return dn;
        }
        catch (ApiUsageException e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug(String.format("findDN(%s) is empty", user));
            }
            return null;
        }
    }
}

