/*
 * Decompiled with CFR 0.152.
 */
package ome.security.auth;

import javax.naming.directory.SearchControls;
import ome.model.meta.ExperimenterGroup;
import ome.security.auth.AttributeSet;
import ome.security.auth.LdapConfig;
import ome.security.auth.OmeroModelContextMapper;
import org.springframework.ldap.core.DirContextAdapter;

public class GroupContextMapper
extends OmeroModelContextMapper {
    public GroupContextMapper(LdapConfig cfg, String base) {
        this(cfg, base, null);
    }

    public GroupContextMapper(LdapConfig cfg, String base, String attribute) {
        super(cfg, base, attribute);
    }

    public String get(String attribute, DirContextAdapter context) {
        String attributeName = this.cfg.getGroupAttribute(attribute);
        if (attributeName != null) {
            return context.getStringAttribute(attributeName);
        }
        return null;
    }

    @Override
    public Object mapFromContext(Object obj) {
        DirContextAdapter ctx = (DirContextAdapter)obj;
        ExperimenterGroup group = new ExperimenterGroup();
        group.setName(this.get("name", ctx));
        group.setDescription(this.get("description", ctx));
        group.setLdap(true);
        group.putAt("LDAP_DN", ctx.getNameInNamespace());
        if (this.attribute != null) {
            group.putAt("LDAP_ATTR", ctx.getAttributeSortedStringSet(this.attribute));
        }
        group.putAt("LDAP_PROPS", new AttributeSet(ctx));
        return group;
    }

    public SearchControls getControls() {
        SearchControls controls = new SearchControls();
        controls.setSearchScope(2);
        controls.setReturningObjFlag(true);
        if (this.attribute == null) {
            return controls;
        }
        String name = this.cfg.getGroupAttribute("name");
        String description = this.cfg.getUserAttribute("description");
        String[] attrs = new String[]{"dn", this.attribute, this.cfg.getGroupAttribute("name"), this.cfg.getUserAttribute("description")};
        controls.setReturningAttributes(attrs);
        return controls;
    }
}

