/*
 * Decompiled with CFR 0.152.
 */
package ome.security.auth;

import ome.security.auth.PasswordChangeException;
import ome.security.auth.PasswordProvider;
import ome.security.auth.PasswordUtil;
import ome.security.auth.PasswordUtility;
import ome.services.messages.LoginAttemptMessage;
import ome.system.OmeroContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public abstract class ConfigurablePasswordProvider
implements PasswordProvider,
PasswordUtility,
ApplicationContextAware {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final String hash;
    protected final boolean salt;
    protected final boolean ignoreUnknown;
    protected final PasswordUtil util;
    protected PasswordUtil legacyUtil;
    protected OmeroContext ctx;

    public ConfigurablePasswordProvider(PasswordUtil util) {
        this(util, false);
    }

    public ConfigurablePasswordProvider(PasswordUtil util, boolean ignoreUnknown) {
        this(util, ignoreUnknown, false);
    }

    public ConfigurablePasswordProvider(PasswordUtil util, boolean ignoreUnknown, boolean salt) {
        this.util = util;
        this.hash = "MD5";
        this.salt = salt;
        this.ignoreUnknown = ignoreUnknown;
    }

    public void setApplicationContext(ApplicationContext ctx) throws BeansException {
        this.ctx = (OmeroContext)ctx;
    }

    public void setLegacyUtil(PasswordUtil legacy) {
        this.legacyUtil = legacy;
    }

    protected Boolean loginAttempt(String user, Boolean success) {
        try {
            this.ctx.publishMessage(new LoginAttemptMessage(this, user, success));
        }
        catch (Throwable e) {
            this.log.error("LoginAttemptMessage error", e);
        }
        return success;
    }

    @Override
    public boolean hasPassword(String user) {
        return false;
    }

    @Override
    public Boolean checkPassword(String user, String password, boolean readOnly) {
        if (this.ignoreUnknown) {
            return null;
        }
        return Boolean.FALSE;
    }

    @Override
    public void changePassword(String user, String password) throws PasswordChangeException {
        throw new PasswordChangeException("Cannot change password with this implementation: " + this.getClass().getName());
    }

    @Override
    public String encodePassword(String newPassword) {
        return this.encodePassword(null, newPassword, false, this.util);
    }

    public String encodeSaltedPassword(Long userId, String newPassword) {
        return this.encodePassword(userId, newPassword, this.salt, this.util);
    }

    protected String encodePassword(Long userId, String newPassword, boolean salt, PasswordUtil util) {
        if (salt) {
            return util.prepareSaltedPassword(userId, newPassword);
        }
        return util.preparePassword(newPassword);
    }

    @Override
    public Boolean comparePasswords(String trusted, String provided) {
        return this.comparePasswords(null, trusted, provided);
    }

    public Boolean comparePasswords(Long userId, String trusted, String provided) {
        if (this.comparePasswords(userId, trusted, provided, this.util)) {
            return true;
        }
        if (this.legacyUtil != null && this.comparePasswords(userId, trusted, provided, this.legacyUtil)) {
            this.log.error("Matched LEGACY password for Experimenter:{}!", (Object)userId);
            String username = this.util.userName(userId);
            if (username != null) {
                try {
                    this.changePassword(username, provided);
                    this.log.info("Upgraded password for Experimenter:{}", (Object)userId);
                }
                catch (PasswordChangeException passwordChangeException) {
                    // empty catch block
                }
            }
            return true;
        }
        return false;
    }

    protected boolean comparePasswords(Long userId, String trusted, String provided, PasswordUtil util) {
        if (trusted == null) {
            return false;
        }
        if ("".equals(trusted.trim())) {
            return !util.isPasswordRequired(userId);
        }
        boolean salt = userId != null && this.salt;
        String encoded = this.encodePassword(userId, provided, salt, util);
        if (trusted.equals(encoded)) {
            return true;
        }
        encoded = this.encodePassword(userId, provided, false, util);
        return trusted.equals(encoded);
    }
}

