/*
 * Decompiled with CFR 0.152.
 */
package ome.security.auth;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ldap.core.DirContextAdapter;

public class AttributeSet {
    Logger log = LoggerFactory.getLogger(AttributeSet.class);
    private final Map<String, String> singleProperties = new HashMap<String, String>();
    private final SetMultimap<String, String> multiProperties = HashMultimap.create();

    public AttributeSet(DirContextAdapter ctx) {
        NamingEnumeration<String> ids = ctx.getAttributes().getIDs();
        Attributes attrs = ctx.getAttributes();
        while (ids.hasMoreElements()) {
            String id = (String)ids.nextElement();
            Attribute attr = attrs.get(id);
            String key = this.key(id);
            if (attr.size() > 1) {
                Object[] objects;
                if (this.size(key) > 0) {
                    throw new IllegalStateException("Duplicate key: " + key);
                }
                for (Object object : objects = ctx.getObjectAttributes(id)) {
                    if (object == null) continue;
                    if (object instanceof String) {
                        this.multiProperties.put(key, (String)object);
                        continue;
                    }
                    if (object instanceof byte[]) {
                        try {
                            this.multiProperties.put(key, new String((byte[])object));
                        }
                        catch (Exception e) {
                            this.log.warn("Error trying to parse byte[] for {}: length={}", (Object)key, (Object)((byte[])object).length);
                        }
                        continue;
                    }
                    this.multiProperties.put(key, object.toString());
                }
                continue;
            }
            if (this.size(key) > 0) {
                throw new IllegalStateException("Duplicate key: " + key);
            }
            this.singleProperties.put(key, ctx.getObjectAttribute(id).toString());
        }
    }

    public String key(String id) {
        return id.toLowerCase();
    }

    public String getFirst(String id) {
        String key = this.key(id);
        if (this.singleProperties.containsKey(key)) {
            return this.singleProperties.get(key);
        }
        if (this.multiProperties.containsKey(key)) {
            return this.multiProperties.get(key).iterator().next();
        }
        return null;
    }

    public Set<String> getAll(String id) {
        String key = this.key(id);
        HashSet<String> rv = new HashSet<String>();
        if (this.singleProperties.containsKey(key)) {
            rv.add(this.singleProperties.get(key));
        } else if (this.multiProperties.containsKey(key)) {
            rv.addAll(this.multiProperties.get(key));
        }
        return rv;
    }

    public int size(String id) {
        String key = this.key(id);
        if (this.singleProperties.containsKey(key)) {
            return 1;
        }
        if (this.multiProperties.containsKey(key)) {
            return this.multiProperties.get(key).size();
        }
        return 0;
    }

    public String put(String id, String value) {
        String key = this.key(id);
        if (this.size(key) > 0) {
            throw new IllegalStateException("Duplicate key: " + key);
        }
        return this.singleProperties.put(key, value);
    }
}

