/*
 * Decompiled with CFR 0.152.
 */
package ome.security;

import java.util.Set;
import ome.conditions.SecurityViolation;
import ome.model.IObject;
import ome.model.internal.Details;
import ome.security.ACLVoter;
import ome.security.basic.BasicACLVoter;
import ome.security.basic.CurrentDetails;
import ome.security.sharing.SharingACLVoter;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeACLVoter
implements ACLVoter {
    private static final Logger log = LoggerFactory.getLogger(CompositeACLVoter.class);
    private final CurrentDetails cd;
    private final BasicACLVoter basic;
    private final SharingACLVoter sharing;

    public CompositeACLVoter(CurrentDetails cd, BasicACLVoter basic, SharingACLVoter sharing) {
        this.basic = basic;
        this.sharing = sharing;
        this.cd = cd;
    }

    public ACLVoter choose() {
        Long shareId = this.cd.getCurrentEventContext().getCurrentShareId();
        if (shareId == null || shareId < 0L) {
            return this.basic;
        }
        return this.sharing;
    }

    @Override
    public boolean allowChmod(IObject object) {
        return this.choose().allowChmod(object);
    }

    @Override
    public boolean allowCreation(IObject object) {
        return this.choose().allowCreation(object);
    }

    @Override
    public boolean allowDelete(IObject object, Details trustedDetails) {
        return this.choose().allowDelete(object, trustedDetails);
    }

    @Override
    public boolean allowLoad(Session session, Class<? extends IObject> klass, Details trustedDetails, long id) {
        return this.choose().allowLoad(session, klass, trustedDetails, id);
    }

    @Override
    public boolean allowAnnotate(IObject object, Details trustedDetails) {
        return this.choose().allowAnnotate(object, trustedDetails);
    }

    @Override
    public boolean allowUpdate(IObject object, Details trustedDetails) {
        return this.choose().allowUpdate(object, trustedDetails);
    }

    @Override
    public void throwCreationViolation(IObject object) throws SecurityViolation {
        this.choose().throwCreationViolation(object);
    }

    @Override
    public void throwDeleteViolation(IObject object) throws SecurityViolation {
        this.choose().throwDeleteViolation(object);
    }

    @Override
    public void throwLoadViolation(IObject object) throws SecurityViolation {
        this.choose().throwLoadViolation(object);
    }

    @Override
    public void throwUpdateViolation(IObject object) throws SecurityViolation {
        this.choose().throwUpdateViolation(object);
    }

    @Override
    public Set<String> restrictions(IObject object) {
        return this.choose().restrictions(object);
    }

    @Override
    public void postProcess(IObject object) {
        this.choose().postProcess(object);
    }
}

