/*
 * Decompiled with CFR 0.152.
 */
package ome.model.units;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import ome.model.units.Unit;
import ome.util.Filter;
import ome.util.Filterable;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.enums.UnitsTime;
import ome.xml.model.enums.handlers.UnitsTimeEnumHandler;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;

@Embeddable
public class Time
implements Serializable,
Filterable,
Unit {
    private static final long serialVersionUID = 1L;
    public static final String VALUE = "ome.model.units.Time_value";
    public static final String UNIT = "ome.model.units.Time_unit";
    private double value;
    private ome.model.enums.UnitsTime unit = null;

    public static UnitsTime makeTimeUnitXML(String unit) {
        try {
            return UnitsTime.fromString(unit);
        }
        catch (EnumerationException e) {
            throw new RuntimeException("Bad Time unit: " + unit, e);
        }
    }

    public static ome.units.quantity.Time makeTimeXML(double d, String unit) {
        ome.units.unit.Unit<ome.units.quantity.Time> units = UnitsTimeEnumHandler.getBaseUnit(Time.makeTimeUnitXML(unit));
        return new ome.units.quantity.Time(d, units);
    }

    public static ome.units.quantity.Time convertTime(Time t) {
        if (t == null) {
            return null;
        }
        Double v = t.getValue();
        String u = t.getUnit().getSymbol();
        UnitsTime units = Time.makeTimeUnitXML(u);
        ome.units.unit.Unit<ome.units.quantity.Time> units2 = UnitsTimeEnumHandler.getBaseUnit(units);
        return new ome.units.quantity.Time(v, units2);
    }

    public static Time convertTime(Time value, ome.units.unit.Unit<ome.units.quantity.Time> ul) {
        return Time.convertTime(value, ul.getSymbol());
    }

    public static Time convertTime(Time value, String target) {
        String source = value.getUnit().getSymbol();
        if (target.equals(source)) {
            return value;
        }
        throw new RuntimeException(String.format("%f %s cannot be converted to %s", value.getValue(), value.getUnit().getSymbol(), source));
    }

    @Deprecated
    public Time() {
    }

    public Time(double d, String u) {
        this.value = d;
        this.unit = ome.model.enums.UnitsTime.valueOf(u);
    }

    public Time(double d, ome.model.enums.UnitsTime u) {
        this.value = d;
        this.unit = u;
    }

    public Time(double d, ome.units.unit.Unit<ome.units.quantity.Time> unit) {
        this(d, ome.model.enums.UnitsTime.bySymbol(unit.getSymbol()));
    }

    public Time(ome.units.quantity.Time value) {
        this(value.value().doubleValue(), ome.model.enums.UnitsTime.bySymbol(value.unit().getSymbol()));
    }

    @Override
    @Column(name="value", nullable=false)
    public double getValue() {
        return this.value;
    }

    @Override
    @Column(name="unit", nullable=false, unique=false, insertable=true, updatable=true)
    @Type(type="ome.model.units.GenericEnumType", parameters={@Parameter(name="unit", value="TIME")})
    public ome.model.enums.UnitsTime getUnit() {
        return this.unit;
    }

    @Override
    public void setValue(double value) {
        this.value = value;
    }

    public void setUnit(ome.model.enums.UnitsTime unit) {
        this.unit = unit;
    }

    @Override
    public boolean acceptFilter(Filter filter) {
        this.unit = (ome.model.enums.UnitsTime)filter.filter(UNIT, this.unit);
        this.value = (Double)filter.filter(VALUE, this.value);
        return true;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.unit == null ? 0 : this.unit.hashCode());
        long temp = Double.doubleToLongBits(this.value);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public String toString() {
        return "Time(" + this.value + " " + this.unit + ")";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Time other = (Time)obj;
        if (this.unit != other.unit) {
            return false;
        }
        return Double.doubleToLongBits(this.value) == Double.doubleToLongBits(other.value);
    }
}

