/*
 * Decompiled with CFR 0.152.
 */
package ome.model.units;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import ome.model.enums.UnitsTemperature;
import ome.model.units.Unit;
import ome.util.Filter;
import ome.util.Filterable;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.enums.handlers.UnitsTemperatureEnumHandler;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;

@Embeddable
public class Temperature
implements Serializable,
Filterable,
Unit {
    private static final long serialVersionUID = 1L;
    public static final String VALUE = "ome.model.units.Temperature_value";
    public static final String UNIT = "ome.model.units.Temperature_unit";
    private double value;
    private UnitsTemperature unit = null;

    public static ome.xml.model.enums.UnitsTemperature makeTemperatureUnitXML(String unit) {
        try {
            return ome.xml.model.enums.UnitsTemperature.fromString(unit);
        }
        catch (EnumerationException e) {
            throw new RuntimeException("Bad Temperature unit: " + unit, e);
        }
    }

    public static ome.units.quantity.Temperature makeTemperatureXML(double d, String unit) {
        ome.units.unit.Unit<ome.units.quantity.Temperature> units = UnitsTemperatureEnumHandler.getBaseUnit(Temperature.makeTemperatureUnitXML(unit));
        return new ome.units.quantity.Temperature(d, units);
    }

    public static ome.units.quantity.Temperature convertTemperature(Temperature t) {
        if (t == null) {
            return null;
        }
        Double v = t.getValue();
        String u = t.getUnit().getSymbol();
        ome.xml.model.enums.UnitsTemperature units = Temperature.makeTemperatureUnitXML(u);
        ome.units.unit.Unit<ome.units.quantity.Temperature> units2 = UnitsTemperatureEnumHandler.getBaseUnit(units);
        return new ome.units.quantity.Temperature(v, units2);
    }

    public static Temperature convertTemperature(Temperature value, ome.units.unit.Unit<ome.units.quantity.Temperature> ul) {
        return Temperature.convertTemperature(value, ul.getSymbol());
    }

    public static Temperature convertTemperature(Temperature value, String target) {
        String source = value.getUnit().getSymbol();
        if (target.equals(source)) {
            return value;
        }
        throw new RuntimeException(String.format("%f %s cannot be converted to %s", value.getValue(), value.getUnit().getSymbol(), source));
    }

    @Deprecated
    public Temperature() {
    }

    public Temperature(double d, String u) {
        this.value = d;
        this.unit = UnitsTemperature.valueOf(u);
    }

    public Temperature(double d, UnitsTemperature u) {
        this.value = d;
        this.unit = u;
    }

    public Temperature(double d, ome.units.unit.Unit<ome.units.quantity.Temperature> unit) {
        this(d, UnitsTemperature.bySymbol(unit.getSymbol()));
    }

    public Temperature(ome.units.quantity.Temperature value) {
        this(value.value().doubleValue(), UnitsTemperature.bySymbol(value.unit().getSymbol()));
    }

    @Override
    @Column(name="value", nullable=false)
    public double getValue() {
        return this.value;
    }

    @Override
    @Column(name="unit", nullable=false, unique=false, insertable=true, updatable=true)
    @Type(type="ome.model.units.GenericEnumType", parameters={@Parameter(name="unit", value="TEMPERATURE")})
    public UnitsTemperature getUnit() {
        return this.unit;
    }

    @Override
    public void setValue(double value) {
        this.value = value;
    }

    public void setUnit(UnitsTemperature unit) {
        this.unit = unit;
    }

    @Override
    public boolean acceptFilter(Filter filter) {
        this.unit = (UnitsTemperature)filter.filter(UNIT, this.unit);
        this.value = (Double)filter.filter(VALUE, this.value);
        return true;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.unit == null ? 0 : this.unit.hashCode());
        long temp = Double.doubleToLongBits(this.value);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public String toString() {
        return "Temperature(" + this.value + " " + this.unit + ")";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Temperature other = (Temperature)obj;
        if (this.unit != other.unit) {
            return false;
        }
        return Double.doubleToLongBits(this.value) == Double.doubleToLongBits(other.value);
    }
}

