/*
 * Decompiled with CFR 0.152.
 */
package ome.model.units;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import ome.model.enums.UnitsLength;
import ome.model.units.Unit;
import ome.util.Filter;
import ome.util.Filterable;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.enums.handlers.UnitsLengthEnumHandler;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;

@Embeddable
public class Length
implements Serializable,
Filterable,
Unit {
    private static final long serialVersionUID = 1L;
    public static final String VALUE = "ome.model.units.Length_value";
    public static final String UNIT = "ome.model.units.Length_unit";
    private double value;
    private UnitsLength unit = null;

    public static ome.xml.model.enums.UnitsLength makeLengthUnitXML(String unit) {
        try {
            return ome.xml.model.enums.UnitsLength.fromString(unit);
        }
        catch (EnumerationException e) {
            throw new RuntimeException("Bad Length unit: " + unit, e);
        }
    }

    public static ome.units.quantity.Length makeLengthXML(double d, String unit) {
        ome.units.unit.Unit<ome.units.quantity.Length> units = UnitsLengthEnumHandler.getBaseUnit(Length.makeLengthUnitXML(unit));
        return new ome.units.quantity.Length(d, units);
    }

    public static ome.units.quantity.Length convertLength(Length t) {
        if (t == null) {
            return null;
        }
        Double v = t.getValue();
        String u = t.getUnit().getSymbol();
        ome.xml.model.enums.UnitsLength units = Length.makeLengthUnitXML(u);
        ome.units.unit.Unit<ome.units.quantity.Length> units2 = UnitsLengthEnumHandler.getBaseUnit(units);
        return new ome.units.quantity.Length(v, units2);
    }

    public static Length convertLength(Length value, ome.units.unit.Unit<ome.units.quantity.Length> ul) {
        return Length.convertLength(value, ul.getSymbol());
    }

    public static Length convertLength(Length value, String target) {
        String source = value.getUnit().getSymbol();
        if (target.equals(source)) {
            return value;
        }
        throw new RuntimeException(String.format("%f %s cannot be converted to %s", value.getValue(), value.getUnit().getSymbol(), source));
    }

    @Deprecated
    public Length() {
    }

    public Length(double d, String u) {
        this.value = d;
        this.unit = UnitsLength.valueOf(u);
    }

    public Length(double d, UnitsLength u) {
        this.value = d;
        this.unit = u;
    }

    public Length(double d, ome.units.unit.Unit<ome.units.quantity.Length> unit) {
        this(d, UnitsLength.bySymbol(unit.getSymbol()));
    }

    public Length(ome.units.quantity.Length value) {
        this(value.value().doubleValue(), UnitsLength.bySymbol(value.unit().getSymbol()));
    }

    @Override
    @Column(name="value", nullable=false)
    public double getValue() {
        return this.value;
    }

    @Override
    @Column(name="unit", nullable=false, unique=false, insertable=true, updatable=true)
    @Type(type="ome.model.units.GenericEnumType", parameters={@Parameter(name="unit", value="LENGTH")})
    public UnitsLength getUnit() {
        return this.unit;
    }

    @Override
    public void setValue(double value) {
        this.value = value;
    }

    public void setUnit(UnitsLength unit) {
        this.unit = unit;
    }

    @Override
    public boolean acceptFilter(Filter filter) {
        this.unit = (UnitsLength)filter.filter(UNIT, this.unit);
        this.value = (Double)filter.filter(VALUE, this.value);
        return true;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.unit == null ? 0 : this.unit.hashCode());
        long temp = Double.doubleToLongBits(this.value);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public String toString() {
        return "Length(" + this.value + " " + this.unit + ")";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Length other = (Length)obj;
        if (this.unit != other.unit) {
            return false;
        }
        return Double.doubleToLongBits(this.value) == Double.doubleToLongBits(other.value);
    }
}

