/*
 * Decompiled with CFR 0.152.
 */
package ome.model.units;

import java.math.BigDecimal;
import java.math.MathContext;

public abstract class Conversion {
    protected final Conversion[] conversions;

    public static Conversion Add(Conversion ... conversions) {
        return new Add(conversions);
    }

    public static Conversion Int(long i) {
        return new Int(i);
    }

    public static Conversion Int(String i) {
        return new Int(i);
    }

    public static Conversion Mul(Conversion ... conversions) {
        return new Mul(conversions);
    }

    public static Conversion Pow(long num, int den) {
        return new Pow(num, den);
    }

    public static Conversion Rat(long num, long den) {
        return new Rat(num, den);
    }

    public static Conversion Rat(Conversion ... conversions) {
        return new Rat(conversions);
    }

    public static Conversion Sym(String sym2) {
        return new Sym(sym2);
    }

    public Conversion(Conversion ... conversions) {
        this.conversions = conversions;
    }

    public abstract BigDecimal convert(double var1);

    public static class Sym
    extends Conversion {
        public Sym(char sym2) {
            super(new Conversion[0]);
        }

        public Sym(String sym2) {
            super(new Conversion[0]);
        }

        @Override
        public BigDecimal convert(double original) {
            return new BigDecimal(original);
        }
    }

    public static class Rat
    extends Conversion {
        private final long num;
        private final long denom;
        private final boolean delay;

        public Rat(long num, long denom) {
            super(new Conversion[0]);
            this.num = num;
            this.denom = denom;
            this.delay = false;
        }

        public Rat(Conversion ... conversions) {
            super(conversions);
            this.num = 0L;
            this.denom = 0L;
            if (conversions.length != 2) {
                throw new IllegalArgumentException("Too many conversions: " + conversions.length);
            }
            this.delay = true;
        }

        @Override
        public BigDecimal convert(double original) {
            if (!this.delay) {
                return new BigDecimal(this.num).divide(new BigDecimal(this.denom), MathContext.DECIMAL128);
            }
            return this.conversions[0].convert(original).divide(this.conversions[1].convert(original), MathContext.DECIMAL128);
        }
    }

    public static class Pow
    extends Conversion {
        private final long base;
        private final int exp;

        public Pow(long base, int exp) {
            super(new Conversion[0]);
            this.base = base;
            this.exp = exp;
        }

        @Override
        public BigDecimal convert(double original) {
            return new BigDecimal(this.base).pow(this.exp);
        }
    }

    public static class Mul
    extends Conversion {
        public Mul(Conversion[] conversions) {
            super(conversions);
        }

        @Override
        public BigDecimal convert(double original) {
            BigDecimal big = BigDecimal.ONE;
            for (Conversion c : this.conversions) {
                big = big.multiply(c.convert(original));
            }
            return big;
        }
    }

    public static class Int
    extends Conversion {
        private final long i;
        private final String s;

        public Int(long i) {
            super(new Conversion[0]);
            this.i = i;
            this.s = null;
        }

        public Int(String s) {
            super(new Conversion[0]);
            this.s = s;
            this.i = 0L;
        }

        @Override
        public BigDecimal convert(double original) {
            if (this.s == null) {
                return new BigDecimal(this.i);
            }
            return new BigDecimal(this.s);
        }
    }

    public static class Add
    extends Conversion {
        public Add(Conversion[] conversions) {
            super(conversions);
        }

        @Override
        public BigDecimal convert(double original) {
            BigDecimal big = BigDecimal.ZERO;
            for (Conversion c : this.conversions) {
                big = big.add(c.convert(original));
            }
            return big;
        }
    }
}

