/*
 * Decompiled with CFR 0.152.
 */
package ome.model.internal;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Transient;
import ome.conditions.ApiUsageException;

public class Permissions
implements Serializable {
    private static final long serialVersionUID = 708953452345658023L;
    private long perm1 = -1L;
    public static final int LINKRESTRICTION = 0;
    public static final int EDITRESTRICTION = 1;
    public static final int DELETERESTRICTION = 2;
    public static final int ANNOTATERESTRICTION = 3;
    private boolean[] restrictions;
    private String[] extendedRestrictions;
    public static final Permissions EMPTY = new ImmutablePermissions(new Permissions().revoke(Role.USER, Right.READ, Right.ANNOTATE, Right.WRITE).revoke(Role.GROUP, Right.READ, Right.ANNOTATE, Right.WRITE).revoke(Role.WORLD, Right.READ, Right.ANNOTATE, Right.WRITE));
    public static final Permissions DUMMY = new ImmutablePermissions(EMPTY);
    public static final Permissions USER_IMMUTABLE = new ImmutablePermissions(new Permissions(EMPTY).grant(Role.USER, Right.READ));
    public static final Permissions USER_PRIVATE = new ImmutablePermissions(new Permissions(EMPTY).grant(Role.USER, Right.READ, Right.ANNOTATE, Right.WRITE));
    public static final Permissions GROUP_READABLE = new ImmutablePermissions(new Permissions(USER_PRIVATE).grant(Role.GROUP, Right.READ));
    public static final Permissions GROUP_PRIVATE = new ImmutablePermissions(new Permissions(GROUP_READABLE).grant(Role.GROUP, Right.ANNOTATE, Right.WRITE));
    public static final Permissions GROUP_WRITEABLE = new ImmutablePermissions(new Permissions(GROUP_PRIVATE).grant(Role.WORLD, Right.READ));
    public static final Permissions WORLD_WRITEABLE = new ImmutablePermissions(new Permissions(GROUP_WRITEABLE).grant(Role.WORLD, Right.ANNOTATE, Right.WRITE));
    public static final Permissions USER_WRITEABLE = new ImmutablePermissions(new Permissions(GROUP_READABLE).grant(Role.WORLD, Right.READ));
    public static final Permissions WORLD_IMMUTABLE = new ImmutablePermissions(new Permissions(USER_WRITEABLE).revoke(Role.USER, Right.ANNOTATE, Right.WRITE));
    public static final Permissions GROUP_IMMUTABLE = new ImmutablePermissions(new Permissions(WORLD_IMMUTABLE).revoke(Role.WORLD, Right.READ));
    public static final Permissions READ_ONLY = WORLD_IMMUTABLE;
    public static final Permissions PRIVATE = USER_PRIVATE;
    public static final Permissions COLLAB_READONLY = GROUP_READABLE;
    public static final Permissions COLLAB_READLINK = GROUP_PRIVATE;
    public static final Permissions PUBLIC = WORLD_WRITEABLE;

    public Permissions() {
    }

    public Permissions(Permissions p) {
        if (p == null) {
            throw new IllegalArgumentException("Permissions argument cannot be null.");
        }
        if (p == DUMMY) {
            throw new IllegalArgumentException("No valid permissions available! DUMMY permissions are not intended for copying. Make sure that you have not passed omero.group=-1 for a save without context");
        }
        this.revokeAll(p);
        this.copyRestrictions(p.restrictions, p.extendedRestrictions);
    }

    public boolean isGranted(Role role, Right right) {
        return (this.perm1 & (long)(right.mask() << role.shift())) == (long)(right.mask() << role.shift());
    }

    public boolean isSet(Flag flag) {
        return (this.perm1 & (long)flag.bit()) != (long)flag.bit();
    }

    public static int bit(Flag flag) {
        return flag.bit();
    }

    public static int bit(Role role, Right right) {
        return right.mask() << role.shift();
    }

    public static Permissions parseString(String rwrwrw) {
        Permissions p = new Permissions(EMPTY);
        String regex = "([Rr_-][AaWw_-]){3}";
        if (rwrwrw == null || !rwrwrw.matches(regex)) {
            throw new ApiUsageException("Permissions are of the form: " + regex);
        }
        char c = rwrwrw.charAt(0);
        if (c == 'r' || c == 'R') {
            p.grant(Role.USER, Right.READ);
        }
        if ((c = rwrwrw.charAt(1)) == 'a' || c == 'A') {
            p.grant(Role.USER, Right.ANNOTATE);
        } else if (c == 'w' || c == 'W') {
            p.grant(Role.USER, Right.ANNOTATE);
            p.grant(Role.USER, Right.WRITE);
        }
        c = rwrwrw.charAt(2);
        if (c == 'r' || c == 'R') {
            p.grant(Role.GROUP, Right.READ);
        }
        if ((c = rwrwrw.charAt(3)) == 'a' || c == 'A') {
            p.grant(Role.GROUP, Right.ANNOTATE);
        } else if (c == 'w' || c == 'W') {
            p.grant(Role.GROUP, Right.ANNOTATE);
            p.grant(Role.GROUP, Right.WRITE);
        }
        c = rwrwrw.charAt(4);
        if (c == 'r' || c == 'R') {
            p.grant(Role.WORLD, Right.READ);
        }
        if ((c = rwrwrw.charAt(5)) == 'a' || c == 'A') {
            p.grant(Role.WORLD, Right.ANNOTATE);
        } else if (c == 'w' || c == 'W') {
            p.grant(Role.WORLD, Right.ANNOTATE);
            p.grant(Role.WORLD, Right.WRITE);
        }
        return p;
    }

    public static boolean isDisallow(boolean[] restrictions, int restriction) {
        if (restrictions != null && restrictions.length > restriction) {
            return restrictions[restriction];
        }
        return false;
    }

    @Transient
    public boolean isDisallowAnnotate() {
        return Permissions.isDisallow(this.restrictions, 3);
    }

    @Transient
    public boolean isDisallowDelete() {
        return Permissions.isDisallow(this.restrictions, 2);
    }

    @Transient
    public boolean isDisallowEdit() {
        return Permissions.isDisallow(this.restrictions, 1);
    }

    @Transient
    public boolean isDisallowLink() {
        return Permissions.isDisallow(this.restrictions, 0);
    }

    public void addExtendedRestrictions(Set<String> extendedRestrictions) {
        if (extendedRestrictions == null || extendedRestrictions.isEmpty()) {
            return;
        }
        if (this.extendedRestrictions == null) {
            this.extendedRestrictions = extendedRestrictions.toArray(new String[extendedRestrictions.size()]);
        } else {
            HashSet<String> copy = new HashSet<String>();
            for (String er : this.extendedRestrictions) {
                copy.add(er);
            }
            copy.addAll(extendedRestrictions);
            this.extendedRestrictions = copy.toArray(new String[copy.size()]);
        }
    }

    public boolean[] copyRestrictions() {
        if (this.restrictions == null) {
            return null;
        }
        boolean[] copy = new boolean[this.restrictions.length];
        System.arraycopy(this.restrictions, 0, copy, 0, this.restrictions.length);
        return copy;
    }

    public String[] copyExtendedRestrictions() {
        if (this.extendedRestrictions == null) {
            return null;
        }
        String[] copy = new String[this.extendedRestrictions.length];
        System.arraycopy(this.extendedRestrictions, 0, copy, 0, this.extendedRestrictions.length);
        return copy;
    }

    public void copyRestrictions(boolean[] source, String[] extendedRestrictions) {
        if (extendedRestrictions == null || extendedRestrictions.length == 0) {
            this.extendedRestrictions = null;
        } else {
            int sz = extendedRestrictions.length;
            this.extendedRestrictions = new String[sz];
            System.arraycopy(extendedRestrictions, 0, this.extendedRestrictions, 0, sz);
        }
        if (Permissions.noTrues(source)) {
            this.restrictions = null;
        } else {
            if (this.restrictions == null || source.length != this.restrictions.length) {
                this.restrictions = new boolean[source.length];
            }
            System.arraycopy(source, 0, this.restrictions, 0, source.length);
        }
    }

    public void copyRestrictions(int allow, Set<String> extendedRestrictions) {
        this.extendedRestrictions = extendedRestrictions == null || extendedRestrictions.isEmpty() ? null : extendedRestrictions.toArray(new String[extendedRestrictions.size()]);
        if (allow == 15) {
            this.restrictions = null;
            return;
        }
        if (this.restrictions == null) {
            this.restrictions = new boolean[4];
        }
        this.restrictions[0] = this.restrictions[0] | 0 == (allow & 1);
        this.restrictions[1] = this.restrictions[1] | 0 == (allow & 2);
        this.restrictions[2] = this.restrictions[2] | 0 == (allow & 4);
        this.restrictions[3] = this.restrictions[3] | 0 == (allow & 8);
    }

    private static boolean noTrues(boolean[] source) {
        if (source == null) {
            return true;
        }
        for (int i = 0; i < source.length; ++i) {
            if (!source[i]) continue;
            return false;
        }
        return true;
    }

    public Permissions grant(Role role, Right ... rights) {
        if (rights != null && rights.length > 0) {
            for (Right right : rights) {
                this.perm1 |= Permissions.singleBitOn(role, right);
            }
        }
        return this;
    }

    public Permissions revoke(Role role, Right ... rights) {
        if (rights != null && rights.length > 0) {
            for (Right right : rights) {
                this.perm1 &= Permissions.singleBitOut(role, right);
            }
        }
        return this;
    }

    public Permissions grantAll(Permissions mask) {
        if (mask == null) {
            return this;
        }
        long maskPerm1 = mask.getPerm1();
        this.perm1 |= maskPerm1;
        return this;
    }

    public Permissions revokeAll(Permissions mask) {
        if (mask == null) {
            return this;
        }
        long maskPerm1 = mask.getPerm1();
        this.perm1 &= maskPerm1;
        return this;
    }

    public Permissions set(Flag flag) {
        if (flag == null) {
            return this;
        }
        this.perm1 &= 0xFFFFFFFFFFFFFFFFL ^ (long)flag.bit();
        return this;
    }

    public Permissions unSet(Flag flag) {
        if (flag == null) {
            return this;
        }
        this.perm1 |= 0L ^ (long)flag.bit();
        return this;
    }

    public static void setDisallow(boolean[] restrictions, int restriction, boolean disallow) {
        if (restrictions != null && restrictions.length >= restriction) {
            restrictions[restriction] = disallow;
        } else if (disallow) {
            boolean[] copy = new boolean[restriction + 1];
            if (restrictions != null) {
                System.arraycopy(restrictions, 0, copy, 0, restrictions.length);
            }
            copy[restriction] = disallow;
            restrictions = copy;
        }
    }

    public Permissions setDisallowAnnotate(boolean disallowAnnotate) {
        Permissions.setDisallow(this.restrictions, 3, disallowAnnotate);
        return this;
    }

    public Permissions setDisallowDelete(boolean disallowDelete) {
        Permissions.setDisallow(this.restrictions, 2, disallowDelete);
        return this;
    }

    public Permissions setDisallowEdit(boolean disallowEdit) {
        Permissions.setDisallow(this.restrictions, 1, disallowEdit);
        return this;
    }

    public Permissions setDisallowLink(boolean disallowLink) {
        Permissions.setDisallow(this.restrictions, 0, disallowLink);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(16);
        sb.append(this.isGranted(Role.USER, Right.READ) ? "r" : "-");
        sb.append(this.annotateOrWorld(Role.USER));
        sb.append(this.isGranted(Role.GROUP, Right.READ) ? "r" : "-");
        sb.append(this.annotateOrWorld(Role.GROUP));
        sb.append(this.isGranted(Role.WORLD, Right.READ) ? "r" : "-");
        sb.append(this.annotateOrWorld(Role.WORLD));
        return sb.toString();
    }

    private String annotateOrWorld(Role role) {
        if (this.isGranted(role, Right.WRITE)) {
            return "w";
        }
        if (this.isGranted(role, Right.ANNOTATE)) {
            return "a";
        }
        return "-";
    }

    public boolean sameRights(Permissions p) {
        if (p == this) {
            return true;
        }
        for (Role ro : Role.values()) {
            for (Right rt : Right.values()) {
                if (this.isGranted(ro, rt) == p.isGranted(ro, rt)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean identical(Permissions p) {
        if (p == this) {
            return true;
        }
        return p.perm1 == this.perm1;
    }

    @Column(name="permissions", nullable=false, updatable=false)
    protected long getPerm1() {
        return this.perm1;
    }

    protected void setPerm1(long value) {
        this.perm1 = value;
    }

    protected static final long singleBitOut(Role role, Right right) {
        return 0xFFFFFFFFFFFFFFFFL ^ (long)(right.mask() << role.shift());
    }

    protected static final long singleBitOn(Role role, Right right) {
        return 0L | (long)(right.mask() << role.shift());
    }

    private static class ImmutablePermissions
    extends Permissions
    implements Serializable {
        private static final long serialVersionUID = -4407900270934589522L;
        private Permissions delegate;

        public static Permissions immutable(Permissions p) {
            return new ImmutablePermissions(p);
        }

        ImmutablePermissions(Permissions p) {
            if (p == null) {
                throw new IllegalArgumentException("Permissions may not be null");
            }
            this.delegate = new Permissions(p);
        }

        @Override
        public Permissions grant(Role role, Right ... rights) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Permissions revoke(Role role, Right ... rights) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Permissions grantAll(Permissions mask) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Permissions revokeAll(Permissions mask) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Permissions set(Flag flag) {
            return this.delegate.set(flag);
        }

        @Override
        public Permissions unSet(Flag flag) {
            return this.delegate.unSet(flag);
        }

        @Override
        public boolean isGranted(Role role, Right right) {
            return this.delegate.isGranted(role, right);
        }

        @Override
        protected long getPerm1() {
            return this.delegate.getPerm1();
        }

        @Override
        protected void setPerm1(long value) {
            this.delegate.setPerm1(value);
        }

        @Override
        public boolean isSet(Flag flag) {
            return this.delegate.isSet(flag);
        }

        @Override
        public boolean identical(Permissions p) {
            return this.delegate.identical(p);
        }

        @Override
        public boolean sameRights(Permissions p) {
            return this.delegate.sameRights(p);
        }

        @Override
        public String toString() {
            return this.delegate.toString();
        }

        private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
            Permissions p = (Permissions)s.readObject();
            if (p == null) {
                throw new IllegalArgumentException("Permissions may not be null");
            }
            this.delegate = new Permissions(p);
        }

        private void writeObject(ObjectOutputStream s) throws IOException {
            s.writeObject(this.delegate);
        }
    }

    public static enum Flag {
        UNUSED(524288);

        private final int bit;

        private Flag(int bit) {
            this.bit = bit;
        }

        int bit() {
            return this.bit;
        }
    }

    public static enum Right {
        ANNOTATE(1),
        WRITE(2),
        READ(4);

        private final int mask;

        private Right(int mask) {
            this.mask = mask;
        }

        int mask() {
            return this.mask;
        }
    }

    public static enum Role {
        USER(8),
        GROUP(4),
        WORLD(0);

        private final int shift;

        private Role(int shift) {
            this.shift = shift;
        }

        int shift() {
            return this.shift;
        }
    }
}

