/*
 * Decompiled with CFR 0.152.
 */
package ome.model.annotations;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.Transient;
import ome.conditions.ApiUsageException;
import ome.model.IMutable;
import ome.model.IObject;
import ome.model.annotations.BasicAnnotation;
import ome.util.DetailsFieldBridge;
import ome.util.Filter;
import ome.util.Validation;
import ome.util.Validator;
import org.hibernate.annotations.Type;
import org.hibernate.search.annotations.ClassBridge;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Fields;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Store;

@Entity
@DiscriminatorValue(value="/basic/term/")
@Indexed(index="FullText")
@ClassBridge(name="details", impl=DetailsFieldBridge.class, index=Index.UN_TOKENIZED, store=Store.NO)
public class TermAnnotation
extends BasicAnnotation
implements Serializable,
IObject,
IMutable {
    private static final long serialVersionUID = 0xC00020C2L;
    public static final String OWNER_FILTER = "termannotation_owner_filter";
    public static final String GROUP_FILTER = "termannotation_group_filter";
    public static final String EVENT_FILTER = "termannotation_event_filter";
    public static final String PERMS_FILTER = "termannotation_perms_filter";
    protected String termValue = null;
    public static final String TERMVALUE = "ome.model.annotations.TermAnnotation_termValue";
    public static final Set<String> FIELDS;

    public TermAnnotation() {
        this(null, true);
    }

    protected TermAnnotation(Long id) {
        this(id, true);
    }

    public TermAnnotation(Long id, boolean loaded) {
        super(id, loaded);
    }

    @Type(type="org.hibernate.type.TextType")
    @Fields(value={@Field(index=Index.TOKENIZED), @Field(index=Index.TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=true, unique=false, name="termValue", updatable=true)
    public String getTermValue() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.termValue;
    }

    public void setTermValue(String termValue) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.termValue = termValue;
    }

    @Override
    @Transient
    public boolean isValid() {
        return Validator.validate(this).isValid();
    }

    @Override
    public Validation validate() {
        return Validator.validate(this);
    }

    public TermAnnotation newInstance() {
        return new TermAnnotation();
    }

    public TermAnnotation proxy() {
        return new TermAnnotation(this.id, false);
    }

    @Override
    public boolean acceptFilter(Filter __filter) {
        try {
            this.termValue = (String)__filter.filter(TERMVALUE, this.termValue);
            return super.acceptFilter(__filter);
        }
        catch (RuntimeException re) {
            if (re.getCause() instanceof InstantiationException) {
                this.unload();
                return true;
            }
            throw re;
        }
    }

    @Override
    public String toString() {
        String name = this.getClass().getName();
        StringBuilder sb = new StringBuilder(name.length() + 24);
        sb.append(name);
        if (this.id == null) {
            sb.append(":Hash_");
            sb.append(this.hashCode());
        } else {
            sb.append(":Id_");
            sb.append(this.id);
        }
        return sb.toString();
    }

    @Override
    public Set<String> fields() {
        return FIELDS;
    }

    @Override
    public Object retrieve(String field) {
        if (field == null) {
            return null;
        }
        if (field.equals(TERMVALUE)) {
            return this.getTermValue();
        }
        return super.retrieve(field);
    }

    @Override
    public void putAt(String field, Object value) {
        if (field == null) {
            return;
        }
        if (field.equals(TERMVALUE)) {
            this.setTermValue((String)value);
        } else {
            super.putAt(field, value);
        }
    }

    @Override
    public void unload() {
        this._loaded = false;
        this.termValue = null;
        super.unload();
    }

    @Override
    protected void throwNullCollectionException(String propertyName) {
        throw new ApiUsageException("Error updating collection:" + propertyName + "\nCollection is currently null. This can be seen\nby testing \"sizeOf" + propertyName + " < 0\". This implies\nthat this collection was unloaded. Please refresh this object\nin order to update this collection.\n");
    }

    static {
        HashSet<String> raw = new HashSet<String>();
        raw.add(TERMVALUE);
        raw.addAll(BasicAnnotation.FIELDS);
        FIELDS = Collections.unmodifiableSet(raw);
    }
}

