/*
 * Decompiled with CFR 0.152.
 */
package ome.model.acquisition;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.MapKeyColumn;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import ome.conditions.ApiUsageException;
import ome.model.IAnnotated;
import ome.model.IMutable;
import ome.model.IObject;
import ome.model.acquisition.FilterSet;
import ome.model.acquisition.FilterSetEmissionFilterLink;
import ome.model.acquisition.FilterSetExcitationFilterLink;
import ome.model.acquisition.Instrument;
import ome.model.acquisition.TransmittanceRange;
import ome.model.annotations.Annotation;
import ome.model.annotations.FilterAnnotationLink;
import ome.model.enums.FilterType;
import ome.model.internal.GraphHolder;
import ome.model.internal.Permissions;
import ome.model.meta.Event;
import ome.model.meta.Experimenter;
import ome.model.meta.ExperimenterGroup;
import ome.model.meta.ExternalInfo;
import ome.util.CBlock;
import ome.util.CountCollectionPersister;
import ome.util.DetailsFieldBridge;
import ome.util.EmptyIterator;
import ome.util.Validation;
import ome.util.Validator;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.FilterDef;
import org.hibernate.annotations.FilterDefs;
import org.hibernate.annotations.Filters;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.ParamDef;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Persister;
import org.hibernate.annotations.Target;
import org.hibernate.search.annotations.ClassBridge;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Fields;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Store;

@FilterDefs(value={@FilterDef(name="filter_owner_filter", parameters={@ParamDef(name="ownerId", type="java.lang.Long")}), @FilterDef(name="filter_group_filter", parameters={@ParamDef(name="groupId", type="java.lang.Long")}), @FilterDef(name="filter_event_filter", parameters={@ParamDef(name="eventId", type="java.lang.Long")}), @FilterDef(name="filter_perms_filter", parameters={@ParamDef(name="permsStr", type="java.lang.String")}), @FilterDef(name="filter_owner_filter_EXCITATIONFILTERLINK", parameters={@ParamDef(name="ownerId", type="java.lang.Long")}), @FilterDef(name="filter_group_filter_EXCITATIONFILTERLINK", parameters={@ParamDef(name="groupId", type="java.lang.Long")}), @FilterDef(name="filter_event_filter_EXCITATIONFILTERLINK", parameters={@ParamDef(name="eventId", type="java.lang.Long")}), @FilterDef(name="filter_perms_filter_EXCITATIONFILTERLINK", parameters={@ParamDef(name="permsStr", type="java.lang.String")}), @FilterDef(name="filter_owner_filter_EMISSIONFILTERLINK", parameters={@ParamDef(name="ownerId", type="java.lang.Long")}), @FilterDef(name="filter_group_filter_EMISSIONFILTERLINK", parameters={@ParamDef(name="groupId", type="java.lang.Long")}), @FilterDef(name="filter_event_filter_EMISSIONFILTERLINK", parameters={@ParamDef(name="eventId", type="java.lang.Long")}), @FilterDef(name="filter_perms_filter_EMISSIONFILTERLINK", parameters={@ParamDef(name="permsStr", type="java.lang.String")}), @FilterDef(name="filter_owner_filter_ANNOTATIONLINKS", parameters={@ParamDef(name="ownerId", type="java.lang.Long")}), @FilterDef(name="filter_group_filter_ANNOTATIONLINKS", parameters={@ParamDef(name="groupId", type="java.lang.Long")}), @FilterDef(name="filter_event_filter_ANNOTATIONLINKS", parameters={@ParamDef(name="eventId", type="java.lang.Long")}), @FilterDef(name="filter_perms_filter_ANNOTATIONLINKS", parameters={@ParamDef(name="permsStr", type="java.lang.String")})})
@Filters(value={@org.hibernate.annotations.Filter(name="filter_owner_filter", condition=":ownerId = owner_id"), @org.hibernate.annotations.Filter(name="filter_group_filter", condition=":groupId = group_id"), @org.hibernate.annotations.Filter(name="filter_event_filter", condition=":eventId = event_id"), @org.hibernate.annotations.Filter(name="filter_perms_filter", condition=":permsStr = permissions"), @org.hibernate.annotations.Filter(name="OneGroupSecurityFilter"), @org.hibernate.annotations.Filter(name="AllGroupsSecurityFilter"), @org.hibernate.annotations.Filter(name="SharingSecurityFilter", condition="(:is_admin = 1 OR :is_share = 0 OR id IN (SELECT filter.id FROM filter*, image* WHERE filter.instrument = image.instrument AND image.id IN (:images)))")})
@Entity
@Table(name="filter", uniqueConstraints={})
@org.hibernate.annotations.Entity(selectBeforeUpdate=true)
@Inheritance(strategy=InheritanceType.JOINED)
@GenericGenerator(name="seq_filter", strategy="ome.util.TableIdGenerator", parameters={@Parameter(name="table_name", value="seq_table"), @Parameter(name="segment_value", value="seq_filter"), @Parameter(name="optimizer", value="pooled"), @Parameter(name="increment_size", value="50")})
@Indexed(index="FullText")
@ClassBridge(name="details", impl=DetailsFieldBridge.class, index=Index.UN_TOKENIZED, store=Store.NO)
public class Filter
implements Serializable,
IObject,
IMutable,
IAnnotated {
    private static final long serialVersionUID = 0xC00020C2L;
    public static final String OWNER_FILTER = "filter_owner_filter";
    public static final String GROUP_FILTER = "filter_group_filter";
    public static final String EVENT_FILTER = "filter_event_filter";
    public static final String PERMS_FILTER = "filter_perms_filter";
    public static final String ID = "ome.model.acquisition.Filter_id";
    protected Long id;
    public static final String VERSION = "ome.model.acquisition.Filter_version";
    protected Integer version = 0;
    protected String manufacturer = null;
    protected String model = null;
    protected String lotNumber = null;
    protected String serialNumber = null;
    protected String filterWheel = null;
    protected FilterType type = null;
    protected TransmittanceRange transmittanceRange = null;
    protected Instrument instrument = null;
    protected Set<FilterSetExcitationFilterLink> excitationFilterLink = new HashSet<FilterSetExcitationFilterLink>();
    public static final String OWNER_FILTER_EXCITATIONFILTERLINK = "filter_owner_filter_EXCITATIONFILTERLINK";
    public static final String GROUP_FILTER_EXCITATIONFILTERLINK = "filter_group_filter_EXCITATIONFILTERLINK";
    public static final String EVENT_FILTER_EXCITATIONFILTERLINK = "filter_event_filter_EXCITATIONFILTERLINK";
    public static final String PERMS_FILTER_EXCITATIONFILTERLINK = "filter_perms_filter_EXCITATIONFILTERLINK";
    private Map<Long, Long> excitationFilterLinkCountPerOwner = null;
    protected Set<FilterSetEmissionFilterLink> emissionFilterLink = new HashSet<FilterSetEmissionFilterLink>();
    public static final String OWNER_FILTER_EMISSIONFILTERLINK = "filter_owner_filter_EMISSIONFILTERLINK";
    public static final String GROUP_FILTER_EMISSIONFILTERLINK = "filter_group_filter_EMISSIONFILTERLINK";
    public static final String EVENT_FILTER_EMISSIONFILTERLINK = "filter_event_filter_EMISSIONFILTERLINK";
    public static final String PERMS_FILTER_EMISSIONFILTERLINK = "filter_perms_filter_EMISSIONFILTERLINK";
    private Map<Long, Long> emissionFilterLinkCountPerOwner = null;
    protected Set<FilterAnnotationLink> annotationLinks = new HashSet<FilterAnnotationLink>();
    public static final String OWNER_FILTER_ANNOTATIONLINKS = "filter_owner_filter_ANNOTATIONLINKS";
    public static final String GROUP_FILTER_ANNOTATIONLINKS = "filter_group_filter_ANNOTATIONLINKS";
    public static final String EVENT_FILTER_ANNOTATIONLINKS = "filter_event_filter_ANNOTATIONLINKS";
    public static final String PERMS_FILTER_ANNOTATIONLINKS = "filter_perms_filter_ANNOTATIONLINKS";
    private Map<Long, Long> annotationLinksCountPerOwner = null;
    protected ome.model.internal.Details details = new Details();
    public static final String MANUFACTURER = "ome.model.acquisition.Filter_manufacturer";
    public static final String MODEL = "ome.model.acquisition.Filter_model";
    public static final String LOTNUMBER = "ome.model.acquisition.Filter_lotNumber";
    public static final String SERIALNUMBER = "ome.model.acquisition.Filter_serialNumber";
    public static final String FILTERWHEEL = "ome.model.acquisition.Filter_filterWheel";
    public static final String TYPE = "ome.model.acquisition.Filter_type";
    public static final String TRANSMITTANCERANGE = "ome.model.acquisition.Filter_transmittanceRange";
    public static final String INSTRUMENT = "ome.model.acquisition.Filter_instrument";
    public static final String EXCITATIONFILTERLINKCOUNTPEROWNER = "ome.model.acquisition.Filter_excitationFilterLinkCountPerOwner";
    public static final String EXCITATIONFILTERLINK = "ome.model.acquisition.Filter_excitationFilterLink";
    public static final String EMISSIONFILTERLINKCOUNTPEROWNER = "ome.model.acquisition.Filter_emissionFilterLinkCountPerOwner";
    public static final String EMISSIONFILTERLINK = "ome.model.acquisition.Filter_emissionFilterLink";
    public static final String ANNOTATIONLINKSCOUNTPEROWNER = "ome.model.acquisition.Filter_annotationLinksCountPerOwner";
    public static final String ANNOTATIONLINKS = "ome.model.acquisition.Filter_annotationLinks";
    public static final String DETAILS = "ome.model.acquisition.Filter_details";
    public static final Set<String> FIELDS;
    @Transient
    protected Map<String, Object> _dynamicFields;
    @Transient
    protected boolean _loaded = true;
    @Transient
    private transient GraphHolder _graphHolder;

    public Filter() {
        this(null, true);
    }

    protected Filter(Long id) {
        this(id, true);
    }

    public Filter(Long id, boolean loaded) {
        this.setId(id);
        if (loaded) {
            this.getDetails().setContext(this);
        } else {
            if (this.id == null) {
                throw new ApiUsageException("Id cannot be null for a proxy");
            }
            this.unload();
        }
    }

    public Filter(Instrument _instrument) {
        this(null, true);
        this.setInstrument(_instrument);
    }

    @Override
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="seq_filter")
    @DocumentId
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    @Column(name="version")
    public Integer getVersion() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.version;
    }

    @Override
    public void setVersion(Integer version) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.version = version;
    }

    @Fields(value={@Field(index=Index.TOKENIZED), @Field(index=Index.TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=true, unique=false, name="manufacturer", updatable=true)
    public String getManufacturer() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.manufacturer;
    }

    public void setManufacturer(String manufacturer) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.manufacturer = manufacturer;
    }

    @Fields(value={@Field(index=Index.TOKENIZED), @Field(index=Index.TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=true, unique=false, name="model", updatable=true)
    public String getModel() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.model;
    }

    public void setModel(String model) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.model = model;
    }

    @Fields(value={@Field(index=Index.TOKENIZED), @Field(index=Index.TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=true, unique=false, name="lotNumber", updatable=true)
    public String getLotNumber() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.lotNumber;
    }

    public void setLotNumber(String lotNumber) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.lotNumber = lotNumber;
    }

    @Fields(value={@Field(index=Index.TOKENIZED), @Field(index=Index.TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=true, unique=false, name="serialNumber", updatable=true)
    public String getSerialNumber() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.serialNumber;
    }

    public void setSerialNumber(String serialNumber) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.serialNumber = serialNumber;
    }

    @Fields(value={@Field(index=Index.TOKENIZED), @Field(index=Index.TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=true, unique=false, name="filterWheel", updatable=true)
    public String getFilterWheel() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.filterWheel;
    }

    public void setFilterWheel(String filterWheel) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.filterWheel = filterWheel;
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH}, targetEntity=FilterType.class)
    @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
    @JoinColumn(name="type", nullable=true, unique=false, insertable=true, updatable=true)
    @ForeignKey(name="FKfilter_type_filtertype")
    public FilterType getType() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.type;
    }

    public void setType(FilterType type) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.type = type;
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH}, targetEntity=TransmittanceRange.class)
    @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
    @JoinColumn(name="transmittanceRange", nullable=true, unique=false, insertable=true, updatable=true)
    @ForeignKey(name="FKfilter_transmittanceRange_transmittancerange")
    public TransmittanceRange getTransmittanceRange() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.transmittanceRange;
    }

    public void setTransmittanceRange(TransmittanceRange transmittanceRange) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.transmittanceRange = transmittanceRange;
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH}, targetEntity=Instrument.class)
    @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
    @JoinColumn(name="instrument", nullable=false, unique=false, insertable=true, updatable=true)
    @ForeignKey(name="FKfilter_instrument_instrument")
    public Instrument getInstrument() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.instrument;
    }

    public void setInstrument(Instrument instrument) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.instrument = instrument;
    }

    @OneToMany(mappedBy="child", fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @Filters(value={@org.hibernate.annotations.Filter(name="OneGroupSecurityFilter"), @org.hibernate.annotations.Filter(name="AllGroupsSecurityFilter"), @org.hibernate.annotations.Filter(name="SharingSecurityFilter", condition="(:is_admin = 1 OR :is_share = 0 OR id IN (SELECT link.id FROM filtersetexcitationfilterlink AS link*, filter*, image* WHERE link.child = filter.id AND filter.instrument = image.instrument AND image.id IN (:images)))"), @org.hibernate.annotations.Filter(name="filter_owner_filter_EXCITATIONFILTERLINK", condition=":ownerId = owner_id"), @org.hibernate.annotations.Filter(name="filter_group_filter_EXCITATIONFILTERLINK", condition=":groupId = group_id"), @org.hibernate.annotations.Filter(name="filter_event_filter_EXCITATIONFILTERLINK", condition=":eventId = event_id"), @org.hibernate.annotations.Filter(name="filter_perms_filter_EXCITATIONFILTERLINK", condition=":permsStr = permissions")})
    protected Set<FilterSetExcitationFilterLink> getExcitationFilterLink() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.excitationFilterLink;
    }

    protected void setExcitationFilterLink(Set<FilterSetExcitationFilterLink> excitationFilterLink) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.excitationFilterLink = excitationFilterLink;
    }

    public int sizeOfExcitationFilterLink() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.excitationFilterLink == null ? -1 : this.excitationFilterLink.size();
    }

    public Iterator<FilterSetExcitationFilterLink> iterateExcitationFilterLink() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getExcitationFilterLink() == null) {
            return new EmptyIterator<FilterSetExcitationFilterLink>();
        }
        return this.getExcitationFilterLink().iterator();
    }

    public Collection<FilterSetExcitationFilterLink> unmodifiableExcitationFilterLink() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getExcitationFilterLink() == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.getExcitationFilterLink());
    }

    public <E> List<E> collectExcitationFilterLink(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<FilterSetExcitationFilterLink> it = this.iterateExcitationFilterLink();
        while (it.hasNext()) {
            IObject obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    public void addFilterSetExcitationFilterLink(FilterSetExcitationFilterLink target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getExcitationFilterLink() == null) {
            this.throwNullCollectionException("ExcitationFilterLink");
        }
        this.getExcitationFilterLink().add(target);
        if (target != null) {
            target.setChild(this);
        }
    }

    public void addFilterSetExcitationFilterLinkSet(Collection<FilterSetExcitationFilterLink> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getExcitationFilterLink() == null) {
            this.throwNullCollectionException("ExcitationFilterLink");
        }
        this.getExcitationFilterLink().addAll(targets);
        for (FilterSetExcitationFilterLink target : targets) {
            if (target == null) continue;
            target.setChild(this);
        }
    }

    public void removeFilterSetExcitationFilterLink(FilterSetExcitationFilterLink target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getExcitationFilterLink() == null) {
            this.throwNullCollectionException("ExcitationFilterLink");
        }
        this.getExcitationFilterLink().remove(target);
        target.setChild(null);
    }

    public void removeFilterSetExcitationFilterLinkSet(Collection<FilterSetExcitationFilterLink> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getExcitationFilterLink() == null) {
            this.throwNullCollectionException("ExcitationFilterLink");
        }
        this.getExcitationFilterLink().removeAll(targets);
        for (FilterSetExcitationFilterLink target : targets) {
            target.setChild(null);
        }
    }

    public FilterSetExcitationFilterLink linkExcitationFilter(FilterSet addition) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        FilterSetExcitationFilterLink link = new FilterSetExcitationFilterLink();
        link.link(addition, this);
        this.addFilterSetExcitationFilterLink(link, true);
        return link;
    }

    public void addFilterSetExcitationFilterLink(FilterSetExcitationFilterLink link, boolean bothSides) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getExcitationFilterLink() == null) {
            this.throwNullCollectionException("ExcitationFilterLink");
        }
        this.getExcitationFilterLink().add(link);
        if (bothSides && link.parent().isLoaded()) {
            link.parent().addFilterSetExcitationFilterLink(link, false);
        }
    }

    public Iterator<FilterSet> linkedExcitationFilterIterator() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getExcitationFilterLink() == null) {
            return new EmptyIterator<FilterSet>();
        }
        final Iterator<FilterSetExcitationFilterLink> it = this.getExcitationFilterLink().iterator();
        return new Iterator<FilterSet>(){

            @Override
            public boolean hasNext() {
                return it == null ? false : it.hasNext();
            }

            @Override
            public FilterSet next() {
                if (it == null) {
                    throw new NoSuchElementException("excitationFilterLink is null; no elements.");
                }
                FilterSetExcitationFilterLink link = (FilterSetExcitationFilterLink)it.next();
                return link.parent();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot call remove on this iterator.");
            }
        };
    }

    public Set<FilterSetExcitationFilterLink> findFilterSetExcitationFilterLink(FilterSet target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Iterator<FilterSetExcitationFilterLink> it = this.iterateExcitationFilterLink();
        HashSet<FilterSetExcitationFilterLink> result = new HashSet<FilterSetExcitationFilterLink>();
        while (it.hasNext()) {
            FilterSetExcitationFilterLink link = it.next();
            if (link.parent() != target) continue;
            result.add(link);
        }
        return result;
    }

    public List<FilterSet> linkedExcitationFilterList() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Iterator<FilterSet> it = this.linkedExcitationFilterIterator();
        ArrayList<FilterSet> list = new ArrayList<FilterSet>();
        while (it.hasNext()) {
            list.add(it.next());
        }
        return list;
    }

    public <E> List<E> eachLinkedExcitationFilter(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<FilterSet> it = this.linkedExcitationFilterIterator();
        while (it.hasNext()) {
            FilterSet obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    public void unlinkExcitationFilter(FilterSet removal) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Set<FilterSetExcitationFilterLink> toRemove = this.findFilterSetExcitationFilterLink(removal);
        Iterator<FilterSetExcitationFilterLink> it = toRemove.iterator();
        while (it.hasNext()) {
            this.removeFilterSetExcitationFilterLink(it.next(), true);
        }
    }

    public void removeFilterSetExcitationFilterLink(FilterSetExcitationFilterLink link, boolean bothSides) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getExcitationFilterLink() == null) {
            this.throwNullCollectionException("ExcitationFilterLink");
        }
        this.getExcitationFilterLink().remove(link);
        if (bothSides && link.parent().isLoaded()) {
            link.parent().removeFilterSetExcitationFilterLink(link, false);
        }
    }

    public void clearExcitationFilterLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<FilterSetExcitationFilterLink> list = new ArrayList<FilterSetExcitationFilterLink>(this.getExcitationFilterLink());
        for (FilterSetExcitationFilterLink link : list) {
            this.removeFilterSetExcitationFilterLink(link, true);
        }
    }

    protected void setExcitationFilterLinkCountPerOwner(Map<Long, Long> map) {
        this.excitationFilterLinkCountPerOwner = map;
    }

    @Persister(impl=CountCollectionPersister.class)
    @ForeignKey(name="FK_count_to_Filter_excitationFilterLink")
    @ElementCollection
    @MapKeyColumn(name="owner_id", insertable=false, updatable=false, nullable=false)
    @Column(name="count", insertable=false, updatable=false, nullable=false)
    @CollectionTable(name="count_Filter_excitationFilterLink_by_owner", joinColumns={@JoinColumn(name="Filter_id")})
    public Map<Long, Long> getExcitationFilterLinkCountPerOwner() {
        return this.excitationFilterLinkCountPerOwner;
    }

    @OneToMany(mappedBy="child", fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @Filters(value={@org.hibernate.annotations.Filter(name="OneGroupSecurityFilter"), @org.hibernate.annotations.Filter(name="AllGroupsSecurityFilter"), @org.hibernate.annotations.Filter(name="SharingSecurityFilter", condition="(:is_admin = 1 OR :is_share = 0 OR id IN (SELECT link.id FROM filtersetemissionfilterlink AS link*, filter*, image* WHERE link.child = filter.id AND filter.instrument = image.instrument AND image.id IN (:images)))"), @org.hibernate.annotations.Filter(name="filter_owner_filter_EMISSIONFILTERLINK", condition=":ownerId = owner_id"), @org.hibernate.annotations.Filter(name="filter_group_filter_EMISSIONFILTERLINK", condition=":groupId = group_id"), @org.hibernate.annotations.Filter(name="filter_event_filter_EMISSIONFILTERLINK", condition=":eventId = event_id"), @org.hibernate.annotations.Filter(name="filter_perms_filter_EMISSIONFILTERLINK", condition=":permsStr = permissions")})
    protected Set<FilterSetEmissionFilterLink> getEmissionFilterLink() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.emissionFilterLink;
    }

    protected void setEmissionFilterLink(Set<FilterSetEmissionFilterLink> emissionFilterLink) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.emissionFilterLink = emissionFilterLink;
    }

    public int sizeOfEmissionFilterLink() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.emissionFilterLink == null ? -1 : this.emissionFilterLink.size();
    }

    public Iterator<FilterSetEmissionFilterLink> iterateEmissionFilterLink() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getEmissionFilterLink() == null) {
            return new EmptyIterator<FilterSetEmissionFilterLink>();
        }
        return this.getEmissionFilterLink().iterator();
    }

    public Collection<FilterSetEmissionFilterLink> unmodifiableEmissionFilterLink() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getEmissionFilterLink() == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.getEmissionFilterLink());
    }

    public <E> List<E> collectEmissionFilterLink(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<FilterSetEmissionFilterLink> it = this.iterateEmissionFilterLink();
        while (it.hasNext()) {
            IObject obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    public void addFilterSetEmissionFilterLink(FilterSetEmissionFilterLink target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getEmissionFilterLink() == null) {
            this.throwNullCollectionException("EmissionFilterLink");
        }
        this.getEmissionFilterLink().add(target);
        if (target != null) {
            target.setChild(this);
        }
    }

    public void addFilterSetEmissionFilterLinkSet(Collection<FilterSetEmissionFilterLink> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getEmissionFilterLink() == null) {
            this.throwNullCollectionException("EmissionFilterLink");
        }
        this.getEmissionFilterLink().addAll(targets);
        for (FilterSetEmissionFilterLink target : targets) {
            if (target == null) continue;
            target.setChild(this);
        }
    }

    public void removeFilterSetEmissionFilterLink(FilterSetEmissionFilterLink target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getEmissionFilterLink() == null) {
            this.throwNullCollectionException("EmissionFilterLink");
        }
        this.getEmissionFilterLink().remove(target);
        target.setChild(null);
    }

    public void removeFilterSetEmissionFilterLinkSet(Collection<FilterSetEmissionFilterLink> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getEmissionFilterLink() == null) {
            this.throwNullCollectionException("EmissionFilterLink");
        }
        this.getEmissionFilterLink().removeAll(targets);
        for (FilterSetEmissionFilterLink target : targets) {
            target.setChild(null);
        }
    }

    public FilterSetEmissionFilterLink linkEmissionFilter(FilterSet addition) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        FilterSetEmissionFilterLink link = new FilterSetEmissionFilterLink();
        link.link(addition, this);
        this.addFilterSetEmissionFilterLink(link, true);
        return link;
    }

    public void addFilterSetEmissionFilterLink(FilterSetEmissionFilterLink link, boolean bothSides) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getEmissionFilterLink() == null) {
            this.throwNullCollectionException("EmissionFilterLink");
        }
        this.getEmissionFilterLink().add(link);
        if (bothSides && link.parent().isLoaded()) {
            link.parent().addFilterSetEmissionFilterLink(link, false);
        }
    }

    public Iterator<FilterSet> linkedEmissionFilterIterator() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getEmissionFilterLink() == null) {
            return new EmptyIterator<FilterSet>();
        }
        final Iterator<FilterSetEmissionFilterLink> it = this.getEmissionFilterLink().iterator();
        return new Iterator<FilterSet>(){

            @Override
            public boolean hasNext() {
                return it == null ? false : it.hasNext();
            }

            @Override
            public FilterSet next() {
                if (it == null) {
                    throw new NoSuchElementException("emissionFilterLink is null; no elements.");
                }
                FilterSetEmissionFilterLink link = (FilterSetEmissionFilterLink)it.next();
                return link.parent();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot call remove on this iterator.");
            }
        };
    }

    public Set<FilterSetEmissionFilterLink> findFilterSetEmissionFilterLink(FilterSet target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Iterator<FilterSetEmissionFilterLink> it = this.iterateEmissionFilterLink();
        HashSet<FilterSetEmissionFilterLink> result = new HashSet<FilterSetEmissionFilterLink>();
        while (it.hasNext()) {
            FilterSetEmissionFilterLink link = it.next();
            if (link.parent() != target) continue;
            result.add(link);
        }
        return result;
    }

    public List<FilterSet> linkedEmissionFilterList() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Iterator<FilterSet> it = this.linkedEmissionFilterIterator();
        ArrayList<FilterSet> list = new ArrayList<FilterSet>();
        while (it.hasNext()) {
            list.add(it.next());
        }
        return list;
    }

    public <E> List<E> eachLinkedEmissionFilter(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<FilterSet> it = this.linkedEmissionFilterIterator();
        while (it.hasNext()) {
            FilterSet obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    public void unlinkEmissionFilter(FilterSet removal) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Set<FilterSetEmissionFilterLink> toRemove = this.findFilterSetEmissionFilterLink(removal);
        Iterator<FilterSetEmissionFilterLink> it = toRemove.iterator();
        while (it.hasNext()) {
            this.removeFilterSetEmissionFilterLink(it.next(), true);
        }
    }

    public void removeFilterSetEmissionFilterLink(FilterSetEmissionFilterLink link, boolean bothSides) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getEmissionFilterLink() == null) {
            this.throwNullCollectionException("EmissionFilterLink");
        }
        this.getEmissionFilterLink().remove(link);
        if (bothSides && link.parent().isLoaded()) {
            link.parent().removeFilterSetEmissionFilterLink(link, false);
        }
    }

    public void clearEmissionFilterLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<FilterSetEmissionFilterLink> list = new ArrayList<FilterSetEmissionFilterLink>(this.getEmissionFilterLink());
        for (FilterSetEmissionFilterLink link : list) {
            this.removeFilterSetEmissionFilterLink(link, true);
        }
    }

    protected void setEmissionFilterLinkCountPerOwner(Map<Long, Long> map) {
        this.emissionFilterLinkCountPerOwner = map;
    }

    @Persister(impl=CountCollectionPersister.class)
    @ForeignKey(name="FK_count_to_Filter_emissionFilterLink")
    @ElementCollection
    @MapKeyColumn(name="owner_id", insertable=false, updatable=false, nullable=false)
    @Column(name="count", insertable=false, updatable=false, nullable=false)
    @CollectionTable(name="count_Filter_emissionFilterLink_by_owner", joinColumns={@JoinColumn(name="Filter_id")})
    public Map<Long, Long> getEmissionFilterLinkCountPerOwner() {
        return this.emissionFilterLinkCountPerOwner;
    }

    @OneToMany(mappedBy="parent", fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @Filters(value={@org.hibernate.annotations.Filter(name="OneGroupSecurityFilter"), @org.hibernate.annotations.Filter(name="AllGroupsSecurityFilter"), @org.hibernate.annotations.Filter(name="SharingSecurityFilter", condition="(:is_admin = 1 OR :is_share = 0)"), @org.hibernate.annotations.Filter(name="filter_owner_filter_ANNOTATIONLINKS", condition=":ownerId = owner_id"), @org.hibernate.annotations.Filter(name="filter_group_filter_ANNOTATIONLINKS", condition=":groupId = group_id"), @org.hibernate.annotations.Filter(name="filter_event_filter_ANNOTATIONLINKS", condition=":eventId = event_id"), @org.hibernate.annotations.Filter(name="filter_perms_filter_ANNOTATIONLINKS", condition=":permsStr = permissions")})
    protected Set<FilterAnnotationLink> getAnnotationLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.annotationLinks;
    }

    protected void setAnnotationLinks(Set<FilterAnnotationLink> annotationLinks) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.annotationLinks = annotationLinks;
    }

    @Override
    public int sizeOfAnnotationLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.annotationLinks == null ? -1 : this.annotationLinks.size();
    }

    public Iterator<FilterAnnotationLink> iterateAnnotationLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            return new EmptyIterator<FilterAnnotationLink>();
        }
        return this.getAnnotationLinks().iterator();
    }

    public Collection<FilterAnnotationLink> unmodifiableAnnotationLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.getAnnotationLinks());
    }

    @Override
    public <E> List<E> collectAnnotationLinks(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<FilterAnnotationLink> it = this.iterateAnnotationLinks();
        while (it.hasNext()) {
            IObject obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    public void addFilterAnnotationLink(FilterAnnotationLink target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().add(target);
        if (target != null) {
            target.setParent(this);
        }
    }

    public void addFilterAnnotationLinkSet(Collection<FilterAnnotationLink> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().addAll(targets);
        for (FilterAnnotationLink target : targets) {
            if (target == null) continue;
            target.setParent(this);
        }
    }

    public void removeFilterAnnotationLink(FilterAnnotationLink target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().remove(target);
        target.setParent(null);
    }

    public void removeFilterAnnotationLinkSet(Collection<FilterAnnotationLink> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().removeAll(targets);
        for (FilterAnnotationLink target : targets) {
            target.setParent(null);
        }
    }

    public FilterAnnotationLink linkAnnotation(Annotation addition) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        FilterAnnotationLink link = new FilterAnnotationLink();
        link.link(this, addition);
        this.addFilterAnnotationLink(link, true);
        return link;
    }

    public void addFilterAnnotationLink(FilterAnnotationLink link, boolean bothSides) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().add(link);
    }

    @Override
    public Iterator<Annotation> linkedAnnotationIterator() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            return new EmptyIterator<Annotation>();
        }
        final Iterator<FilterAnnotationLink> it = this.getAnnotationLinks().iterator();
        return new Iterator<Annotation>(){

            @Override
            public boolean hasNext() {
                return it == null ? false : it.hasNext();
            }

            @Override
            public Annotation next() {
                if (it == null) {
                    throw new NoSuchElementException("annotationLinks is null; no elements.");
                }
                FilterAnnotationLink link = (FilterAnnotationLink)it.next();
                return link.child();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot call remove on this iterator.");
            }
        };
    }

    public Set<FilterAnnotationLink> findFilterAnnotationLink(Annotation target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Iterator<FilterAnnotationLink> it = this.iterateAnnotationLinks();
        HashSet<FilterAnnotationLink> result = new HashSet<FilterAnnotationLink>();
        while (it.hasNext()) {
            FilterAnnotationLink link = it.next();
            if (link.child() != target) continue;
            result.add(link);
        }
        return result;
    }

    @Override
    public List<Annotation> linkedAnnotationList() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Iterator<Annotation> it = this.linkedAnnotationIterator();
        ArrayList<Annotation> list = new ArrayList<Annotation>();
        while (it.hasNext()) {
            list.add(it.next());
        }
        return list;
    }

    @Override
    public <E> List<E> eachLinkedAnnotation(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<Annotation> it = this.linkedAnnotationIterator();
        while (it.hasNext()) {
            Annotation obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    @Override
    public void unlinkAnnotation(Annotation removal) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Set<FilterAnnotationLink> toRemove = this.findFilterAnnotationLink(removal);
        Iterator<FilterAnnotationLink> it = toRemove.iterator();
        while (it.hasNext()) {
            this.removeFilterAnnotationLink(it.next(), true);
        }
    }

    public void removeFilterAnnotationLink(FilterAnnotationLink link, boolean bothSides) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().remove(link);
    }

    @Override
    public void clearAnnotationLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<FilterAnnotationLink> list = new ArrayList<FilterAnnotationLink>(this.getAnnotationLinks());
        for (FilterAnnotationLink link : list) {
            this.removeFilterAnnotationLink(link, true);
        }
    }

    protected void setAnnotationLinksCountPerOwner(Map<Long, Long> map) {
        this.annotationLinksCountPerOwner = map;
    }

    @Persister(impl=CountCollectionPersister.class)
    @ForeignKey(name="FK_count_to_Filter_annotationLinks")
    @ElementCollection
    @MapKeyColumn(name="owner_id", insertable=false, updatable=false, nullable=false)
    @Column(name="count", insertable=false, updatable=false, nullable=false)
    @CollectionTable(name="count_Filter_annotationLinks_by_owner", joinColumns={@JoinColumn(name="Filter_id")})
    public Map<Long, Long> getAnnotationLinksCountPerOwner() {
        return this.annotationLinksCountPerOwner;
    }

    @Override
    @Embedded
    @Target(value=Details.class)
    public ome.model.internal.Details getDetails() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.details;
    }

    protected void setDetails(ome.model.internal.Details details) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.details = (Details)details;
    }

    @Override
    @Transient
    public boolean isValid() {
        return Validator.validate(this).isValid();
    }

    @Override
    public Validation validate() {
        return Validator.validate(this);
    }

    public Filter newInstance() {
        return new Filter();
    }

    public Filter proxy() {
        return new Filter(this.id, false);
    }

    @Override
    public boolean acceptFilter(ome.util.Filter __filter) {
        try {
            this.id = (Long)__filter.filter(ID, this.id);
            this.version = (Integer)__filter.filter(VERSION, this.version);
            this.manufacturer = (String)__filter.filter(MANUFACTURER, this.manufacturer);
            this.model = (String)__filter.filter(MODEL, this.model);
            this.lotNumber = (String)__filter.filter(LOTNUMBER, this.lotNumber);
            this.serialNumber = (String)__filter.filter(SERIALNUMBER, this.serialNumber);
            this.filterWheel = (String)__filter.filter(FILTERWHEEL, this.filterWheel);
            this.type = (FilterType)__filter.filter(TYPE, this.type);
            this.transmittanceRange = (TransmittanceRange)__filter.filter(TRANSMITTANCERANGE, this.transmittanceRange);
            this.instrument = (Instrument)__filter.filter(INSTRUMENT, this.instrument);
            this.excitationFilterLinkCountPerOwner = __filter.filter(EXCITATIONFILTERLINKCOUNTPEROWNER, this.excitationFilterLinkCountPerOwner);
            this.excitationFilterLink = (Set)__filter.filter(EXCITATIONFILTERLINK, this.excitationFilterLink);
            this.emissionFilterLinkCountPerOwner = __filter.filter(EMISSIONFILTERLINKCOUNTPEROWNER, this.emissionFilterLinkCountPerOwner);
            this.emissionFilterLink = (Set)__filter.filter(EMISSIONFILTERLINK, this.emissionFilterLink);
            this.annotationLinksCountPerOwner = __filter.filter(ANNOTATIONLINKSCOUNTPEROWNER, this.annotationLinksCountPerOwner);
            this.annotationLinks = (Set)__filter.filter(ANNOTATIONLINKS, this.annotationLinks);
            this.details = (ome.model.internal.Details)__filter.filter(DETAILS, this.details);
            return true;
        }
        catch (RuntimeException re) {
            if (re.getCause() instanceof InstantiationException) {
                this.unload();
                return true;
            }
            throw re;
        }
    }

    public String toString() {
        String name = this.getClass().getName();
        StringBuilder sb = new StringBuilder(name.length() + 24);
        sb.append(name);
        if (this.id == null) {
            sb.append(":Hash_");
            sb.append(this.hashCode());
        } else {
            sb.append(":Id_");
            sb.append(this.id);
        }
        return sb.toString();
    }

    @Override
    public Set<String> fields() {
        return FIELDS;
    }

    @Override
    public Object retrieve(String field) {
        if (field == null) {
            return null;
        }
        if (field.equals(ID)) {
            return this.getId();
        }
        if (field.equals(VERSION)) {
            return this.getVersion();
        }
        if (field.equals(MANUFACTURER)) {
            return this.getManufacturer();
        }
        if (field.equals(MODEL)) {
            return this.getModel();
        }
        if (field.equals(LOTNUMBER)) {
            return this.getLotNumber();
        }
        if (field.equals(SERIALNUMBER)) {
            return this.getSerialNumber();
        }
        if (field.equals(FILTERWHEEL)) {
            return this.getFilterWheel();
        }
        if (field.equals(TYPE)) {
            return this.getType();
        }
        if (field.equals(TRANSMITTANCERANGE)) {
            return this.getTransmittanceRange();
        }
        if (field.equals(INSTRUMENT)) {
            return this.getInstrument();
        }
        if (field.equals(EXCITATIONFILTERLINKCOUNTPEROWNER)) {
            return this.getExcitationFilterLinkCountPerOwner();
        }
        if (field.equals(EXCITATIONFILTERLINK)) {
            return this.getExcitationFilterLink();
        }
        if (field.equals(EMISSIONFILTERLINKCOUNTPEROWNER)) {
            return this.getEmissionFilterLinkCountPerOwner();
        }
        if (field.equals(EMISSIONFILTERLINK)) {
            return this.getEmissionFilterLink();
        }
        if (field.equals(ANNOTATIONLINKSCOUNTPEROWNER)) {
            return this.getAnnotationLinksCountPerOwner();
        }
        if (field.equals(ANNOTATIONLINKS)) {
            return this.getAnnotationLinks();
        }
        if (field.equals(DETAILS)) {
            return this.getDetails();
        }
        if (this._dynamicFields != null) {
            return this._dynamicFields.get(field);
        }
        return null;
    }

    @Override
    public void putAt(String field, Object value) {
        if (field == null) {
            return;
        }
        if (field.equals(ID)) {
            this.setId((Long)value);
        } else if (field.equals(VERSION)) {
            this.setVersion((Integer)value);
        } else if (field.equals(MANUFACTURER)) {
            this.setManufacturer((String)value);
        } else if (field.equals(MODEL)) {
            this.setModel((String)value);
        } else if (field.equals(LOTNUMBER)) {
            this.setLotNumber((String)value);
        } else if (field.equals(SERIALNUMBER)) {
            this.setSerialNumber((String)value);
        } else if (field.equals(FILTERWHEEL)) {
            this.setFilterWheel((String)value);
        } else if (field.equals(TYPE)) {
            this.setType((FilterType)value);
        } else if (field.equals(TRANSMITTANCERANGE)) {
            this.setTransmittanceRange((TransmittanceRange)value);
        } else if (field.equals(INSTRUMENT)) {
            this.setInstrument((Instrument)value);
        } else if (field.equals(EXCITATIONFILTERLINKCOUNTPEROWNER)) {
            this.setExcitationFilterLinkCountPerOwner((Map)value);
        } else if (field.equals(EXCITATIONFILTERLINK)) {
            this.setExcitationFilterLink((Set)value);
        } else if (field.equals(EMISSIONFILTERLINKCOUNTPEROWNER)) {
            this.setEmissionFilterLinkCountPerOwner((Map)value);
        } else if (field.equals(EMISSIONFILTERLINK)) {
            this.setEmissionFilterLink((Set)value);
        } else if (field.equals(ANNOTATIONLINKSCOUNTPEROWNER)) {
            this.setAnnotationLinksCountPerOwner((Map)value);
        } else if (field.equals(ANNOTATIONLINKS)) {
            this.setAnnotationLinks((Set)value);
        } else if (field.equals(DETAILS)) {
            this.setDetails((ome.model.internal.Details)value);
        } else {
            if (this._dynamicFields == null) {
                this._dynamicFields = new HashMap<String, Object>();
            }
            this._dynamicFields.put(field, value);
        }
    }

    @Override
    @Transient
    public boolean isLoaded() {
        return this._loaded;
    }

    protected void errorIfUnloaded() {
        throw new IllegalStateException("Object unloaded:" + this);
    }

    @Override
    public void unload() {
        this._loaded = false;
        this.version = null;
        this.manufacturer = null;
        this.model = null;
        this.lotNumber = null;
        this.serialNumber = null;
        this.filterWheel = null;
        this.type = null;
        this.transmittanceRange = null;
        this.instrument = null;
        this.excitationFilterLinkCountPerOwner = null;
        this.excitationFilterLink = null;
        this.emissionFilterLinkCountPerOwner = null;
        this.emissionFilterLink = null;
        this.annotationLinksCountPerOwner = null;
        this.annotationLinks = null;
        this.details = null;
    }

    @Override
    @Transient
    public final GraphHolder getGraphHolder() {
        if (this._graphHolder == null) {
            this._graphHolder = new GraphHolder();
        }
        return this._graphHolder;
    }

    protected void throwNullCollectionException(String propertyName) {
        throw new ApiUsageException("Error updating collection:" + propertyName + "\nCollection is currently null. This can be seen\nby testing \"sizeOf" + propertyName + " < 0\". This implies\nthat this collection was unloaded. Please refresh this object\nin order to update this collection.\n");
    }

    static {
        HashSet<String> raw = new HashSet<String>();
        raw.add(ID);
        raw.add(VERSION);
        raw.add(MANUFACTURER);
        raw.add(MODEL);
        raw.add(LOTNUMBER);
        raw.add(SERIALNUMBER);
        raw.add(FILTERWHEEL);
        raw.add(TYPE);
        raw.add(TRANSMITTANCERANGE);
        raw.add(INSTRUMENT);
        raw.add(EXCITATIONFILTERLINKCOUNTPEROWNER);
        raw.add(EXCITATIONFILTERLINK);
        raw.add(EMISSIONFILTERLINKCOUNTPEROWNER);
        raw.add(EMISSIONFILTERLINK);
        raw.add(ANNOTATIONLINKSCOUNTPEROWNER);
        raw.add(ANNOTATIONLINKS);
        raw.add(DETAILS);
        FIELDS = Collections.unmodifiableSet(raw);
    }

    public static class Details
    extends ome.model.internal.Details {
        private static final long serialVersionUID = 3221233857L;

        public Details() {
        }

        public Details(Object[] contexts) {
            super(contexts);
        }

        @Override
        public ome.model.internal.Details newInstance() {
            return new Details(this.contexts);
        }

        @Override
        @Embedded
        public Permissions getPermissions() {
            return super.getPermissions();
        }

        @Override
        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="external_id", nullable=true, unique=true, insertable=true, updatable=true)
        @ForeignKey(name="FKfilter_external_id_externalinfo")
        public ExternalInfo getExternalInfo() {
            return super.getExternalInfo();
        }

        @Override
        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="owner_id", nullable=false, unique=false, insertable=true, updatable=true)
        @ForeignKey(name="FKfilter_owner_id_experimenter")
        public Experimenter getOwner() {
            return super.getOwner();
        }

        @Override
        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="creation_id", nullable=false, unique=false, insertable=true, updatable=false)
        @ForeignKey(name="FKfilter_creation_id_event")
        public Event getCreationEvent() {
            return super.getCreationEvent();
        }

        @Override
        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="group_id", nullable=false, unique=false, insertable=true, updatable=true)
        @ForeignKey(name="FKfilter_group_id_experimentergroup")
        public ExperimenterGroup getGroup() {
            return super.getGroup();
        }

        @Override
        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="update_id", nullable=false, unique=false, insertable=true, updatable=true)
        @ForeignKey(name="FKfilter_update_id_event")
        public Event getUpdateEvent() {
            return super.getUpdateEvent();
        }
    }
}

