/*
 * Decompiled with CFR 0.152.
 */
package ome.model.acquisition;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.Table;
import javax.persistence.Transient;
import ome.conditions.ApiUsageException;
import ome.model.IMutable;
import ome.model.IObject;
import ome.model.acquisition.LightSource;
import ome.model.enums.ArcType;
import ome.util.DetailsFieldBridge;
import ome.util.Filter;
import ome.util.Validation;
import ome.util.Validator;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.search.annotations.ClassBridge;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Store;

@Entity
@PrimaryKeyJoinColumn(name="lightsource_id")
@Table(name="arc")
@ForeignKey(name="FKarc_lightsource_id_lightsource")
@Indexed(index="FullText")
@ClassBridge(name="details", impl=DetailsFieldBridge.class, index=Index.UN_TOKENIZED, store=Store.NO)
public class Arc
extends LightSource
implements Serializable,
IObject,
IMutable {
    private static final long serialVersionUID = 0xC00020C2L;
    public static final String OWNER_FILTER = "arc_owner_filter";
    public static final String GROUP_FILTER = "arc_group_filter";
    public static final String EVENT_FILTER = "arc_event_filter";
    public static final String PERMS_FILTER = "arc_perms_filter";
    protected ArcType type = null;
    public static final String TYPE = "ome.model.acquisition.Arc_type";
    public static final Set<String> FIELDS;

    public Arc() {
        this(null, true);
    }

    protected Arc(Long id) {
        this(id, true);
    }

    public Arc(Long id, boolean loaded) {
        super(id, loaded);
    }

    public Arc(ArcType _type) {
        this(null, true);
        this.setType(_type);
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH}, targetEntity=ArcType.class)
    @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
    @JoinColumn(name="type", nullable=false, unique=false, insertable=true, updatable=true)
    @ForeignKey(name="FKarc_type_arctype")
    public ArcType getType() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.type;
    }

    public void setType(ArcType type) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.type = type;
    }

    @Override
    @Transient
    public boolean isValid() {
        return Validator.validate(this).isValid();
    }

    @Override
    public Validation validate() {
        return Validator.validate(this);
    }

    public Arc newInstance() {
        return new Arc();
    }

    public Arc proxy() {
        return new Arc(this.id, false);
    }

    @Override
    public boolean acceptFilter(Filter __filter) {
        try {
            this.type = (ArcType)__filter.filter(TYPE, this.type);
            return super.acceptFilter(__filter);
        }
        catch (RuntimeException re) {
            if (re.getCause() instanceof InstantiationException) {
                this.unload();
                return true;
            }
            throw re;
        }
    }

    @Override
    public String toString() {
        String name = this.getClass().getName();
        StringBuilder sb = new StringBuilder(name.length() + 24);
        sb.append(name);
        if (this.id == null) {
            sb.append(":Hash_");
            sb.append(this.hashCode());
        } else {
            sb.append(":Id_");
            sb.append(this.id);
        }
        return sb.toString();
    }

    @Override
    public Set<String> fields() {
        return FIELDS;
    }

    @Override
    public Object retrieve(String field) {
        if (field == null) {
            return null;
        }
        if (field.equals(TYPE)) {
            return this.getType();
        }
        return super.retrieve(field);
    }

    @Override
    public void putAt(String field, Object value) {
        if (field == null) {
            return;
        }
        if (field.equals(TYPE)) {
            this.setType((ArcType)value);
        } else {
            super.putAt(field, value);
        }
    }

    @Override
    public void unload() {
        this._loaded = false;
        this.type = null;
        super.unload();
    }

    @Override
    protected void throwNullCollectionException(String propertyName) {
        throw new ApiUsageException("Error updating collection:" + propertyName + "\nCollection is currently null. This can be seen\nby testing \"sizeOf" + propertyName + " < 0\". This implies\nthat this collection was unloaded. Please refresh this object\nin order to update this collection.\n");
    }

    static {
        HashSet<String> raw = new HashSet<String>();
        raw.add(TYPE);
        raw.addAll(LightSource.FIELDS);
        FIELDS = Collections.unmodifiableSet(raw);
    }
}

