/*
 * Decompiled with CFR 0.152.
 */
package ome.logic;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import ome.annotations.RolesAllowed;
import ome.api.IUpdate;
import ome.api.ServiceInterface;
import ome.api.local.LocalQuery;
import ome.api.local.LocalUpdate;
import ome.conditions.ApiUsageException;
import ome.conditions.ValidationException;
import ome.logic.AbstractLevel1Service;
import ome.logic.CreationLogLoader;
import ome.model.IObject;
import ome.services.fulltext.FullTextBridge;
import ome.services.fulltext.FullTextIndexer;
import ome.services.fulltext.FullTextThread;
import ome.services.sessions.SessionManager;
import ome.services.util.Executor;
import ome.tools.hibernate.ReloadFilter;
import ome.tools.hibernate.UpdateFilter;
import ome.util.Utils;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.orm.hibernate3.SessionFactoryUtils;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=false)
public class UpdateImpl
extends AbstractLevel1Service
implements LocalUpdate {
    private final Logger log = LoggerFactory.getLogger(UpdateImpl.class);
    protected transient LocalQuery localQuery;
    protected transient Executor executor;
    protected transient SessionManager sessionManager;
    protected transient FullTextBridge fullTextBridge;

    public final void setQueryService(LocalQuery query) {
        this.getBeanHelper().throwIfAlreadySet(this.localQuery, query);
        this.localQuery = query;
    }

    public void setExecutor(Executor executor) {
        this.getBeanHelper().throwIfAlreadySet(this.executor, executor);
        this.executor = executor;
    }

    public void setSessionManager(SessionManager sessionManager) {
        this.getBeanHelper().throwIfAlreadySet(this.sessionManager, sessionManager);
        this.sessionManager = sessionManager;
    }

    public void setFullTextBridge(FullTextBridge fullTextBridge) {
        this.getBeanHelper().throwIfAlreadySet(this.fullTextBridge, fullTextBridge);
        this.fullTextBridge = fullTextBridge;
    }

    @Override
    public Class<? extends ServiceInterface> getServiceInterface() {
        return IUpdate.class;
    }

    @Override
    @RolesAllowed(value={"user"})
    public void flush() {
        this.session().flush();
    }

    @Override
    @RolesAllowed(value={"user"})
    public void saveObject(IObject graph) {
        this.doAction(graph, new UpdateAction<IObject>(){

            @Override
            public IObject run(IObject value, UpdateFilter filter, Session s) {
                return UpdateImpl.this.internalMerge(value, filter, s);
            }
        });
    }

    @RolesAllowed(value={"user"})
    public IObject saveAndReturnObject(IObject graph) {
        return this.doAction(graph, new UpdateAction<IObject>(){

            @Override
            public IObject run(IObject value, UpdateFilter filter, Session s) {
                return UpdateImpl.this.internalMerge(value, filter, s);
            }
        });
    }

    @RolesAllowed(value={"user"})
    public void saveCollection(Collection graph) {
        this.doAction(graph, new UpdateAction<Collection>(){

            @Override
            public Collection run(Collection value, UpdateFilter filter, Session s) {
                for (Object o : value) {
                    IObject obj = (IObject)o;
                    obj = UpdateImpl.this.internalMerge(obj, filter, s);
                }
                return null;
            }
        });
    }

    @Override
    @RolesAllowed(value={"user"})
    public IObject[] saveAndReturnArray(IObject[] graph) {
        return this.doAction(graph, new UpdateAction<IObject[]>(){

            @Override
            public IObject[] run(IObject[] value, UpdateFilter filter, Session s) {
                IObject[] copy = new IObject[value.length];
                for (int i = 0; i < value.length; ++i) {
                    copy[i] = UpdateImpl.this.internalMerge(value[i], filter, s);
                }
                return copy;
            }
        });
    }

    @Override
    @RolesAllowed(value={"user"})
    public List<Long> saveAndReturnIds(IObject[] graph) {
        if (graph == null || graph.length == 0) {
            return Collections.emptyList();
        }
        final ArrayList<Long> ids = new ArrayList<Long>(graph.length);
        ReloadFilter filter = new ReloadFilter(this.session());
        this.doAction(graph, filter, new UpdateAction<IObject[]>(){

            @Override
            public IObject[] run(IObject[] value, UpdateFilter filter, Session s) {
                for (int i = 0; i < value.length; ++i) {
                    ids.add(i, UpdateImpl.this.internalSave(value[i], (ReloadFilter)filter, s));
                }
                return null;
            }
        });
        return ids;
    }

    @Override
    @RolesAllowed(value={"user"})
    public void saveArray(IObject[] graph) {
        this.doAction(graph, new UpdateAction<IObject[]>(){

            @Override
            public IObject[] run(IObject[] value, UpdateFilter filter, Session s) {
                IObject[] copy = new IObject[value.length];
                for (int i = 0; i < value.length; ++i) {
                    copy[i] = UpdateImpl.this.internalMerge(value[i], filter, s);
                }
                return copy;
            }
        });
    }

    @Override
    @RolesAllowed(value={"user"})
    public void deleteObject(IObject row) {
        if (row == null) {
            return;
        }
        if (row.getId() == null) {
            throw new ApiUsageException("Non-managed IObject entity cannot be deleted. Must have an id.");
        }
        try {
            this.doAction(row, new UpdateAction<IObject>(){

                @Override
                public IObject run(IObject value, UpdateFilter filter, Session s) {
                    UpdateImpl.this.internalDelete(value, filter, s);
                    return null;
                }
            });
        }
        catch (InvalidDataAccessApiUsageException idaaue) {
            throw new ApiUsageException("Cannot delete " + row + "\nOriginal message: " + idaaue.getMessage() + "\nConsider using IDelete instead.");
        }
    }

    @Override
    @RolesAllowed(value={"system"})
    public void indexObject(IObject row) {
        if (row == null || row.getId() == null) {
            throw new ValidationException("Non-managed object cannot be indexed.");
        }
        CreationLogLoader logs = new CreationLogLoader(this.localQuery, row);
        FullTextIndexer fti = new FullTextIndexer(logs);
        fti.setApplicationContext((ApplicationContext)this.executor.getContext());
        FullTextThread ftt = new FullTextThread(this.sessionManager, this.executor, fti, this.fullTextBridge, true);
        Future<Object> future = this.executor.submit(Executors.callable(ftt));
        this.executor.get(future);
    }

    private void beforeUpdate(Object argument, UpdateFilter filter) {
        if (argument == null) {
            throw new IllegalArgumentException("Argument to save cannot be null.");
        }
        if (this.getBeanHelper().getLogger().isDebugEnabled()) {
            this.getBeanHelper().getLogger().debug(" Saving event before merge. ");
        }
    }

    protected Long internalSave(IObject obj, ReloadFilter filter, Session session) {
        if (this.getBeanHelper().getLogger().isDebugEnabled()) {
            this.getBeanHelper().getLogger().debug(" Internal save. ");
        }
        IObject result = (IObject)filter.filter(null, obj);
        Long id = (Long)session.save((Object)result);
        return id;
    }

    protected IObject internalMerge(IObject obj, UpdateFilter filter, Session session) {
        if (this.getBeanHelper().getLogger().isDebugEnabled()) {
            this.getBeanHelper().getLogger().debug(" Internal merge. ");
        }
        Long previousId = obj.getId();
        IObject result = (IObject)filter.filter(null, obj);
        result = (IObject)session.merge((Object)result);
        Long currentId = result.getId();
        if (previousId != null && previousId != currentId) {
            if (this.getBeanHelper().getLogger().isDebugEnabled()) {
                this.getBeanHelper().getLogger().debug("attempt to save deleted object: " + obj);
            }
            throw new ValidationException("object no longer exists in database");
        }
        return result;
    }

    protected void internalDelete(IObject obj, UpdateFilter filter, Session session) {
        if (this.getBeanHelper().getLogger().isDebugEnabled()) {
            this.getBeanHelper().getLogger().debug(" Internal delete. ");
        }
        session.delete(session.load(Utils.trueClass(obj.getClass()), (Serializable)obj.getId()));
    }

    private void afterUpdate(UpdateFilter filter, Session session) {
        if (this.getBeanHelper().getLogger().isDebugEnabled()) {
            this.getBeanHelper().getLogger().debug(" Post-save cleanup. ");
        }
        session.flush();
        filter.unloadReplacedObjects();
    }

    private <T> T doAction(T graph, UpdateAction<T> action) {
        UpdateFilter filter = new UpdateFilter();
        return this.doAction(graph, filter, action);
    }

    private <T> T doAction(T graph, UpdateFilter filter, UpdateAction<T> action) {
        Session session = this.session();
        this.beforeUpdate(graph, filter);
        T retVal = action.run(graph, filter, session);
        this.afterUpdate(filter, session);
        return retVal;
    }

    private Session session() {
        return SessionFactoryUtils.getSession((SessionFactory)this.getSessionFactory(), (boolean)false);
    }

    private abstract class UpdateAction<T> {
        private UpdateAction() {
        }

        public abstract T run(T var1, UpdateFilter var2, Session var3);
    }
}

