/*
 * Decompiled with CFR 0.152.
 */
package ome.logic;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import ome.annotations.RolesAllowed;
import ome.api.ITypes;
import ome.api.ServiceInterface;
import ome.api.local.LocalUpdate;
import ome.conditions.ApiUsageException;
import ome.logic.AbstractLevel2Service;
import ome.model.IAnnotated;
import ome.model.IEnum;
import ome.model.IObject;
import ome.model.internal.Details;
import ome.model.internal.Permissions;
import ome.security.SecureAction;
import org.hibernate.SessionFactory;
import org.hibernate.metadata.ClassMetadata;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ResourceUtils;

@Transactional
public class TypesImpl
extends AbstractLevel2Service
implements ITypes {
    protected transient SessionFactory sf;

    public final void setSessionFactory(SessionFactory sessions) {
        this.getBeanHelper().throwIfAlreadySet(this.sf, sessions);
        this.sf = sessions;
    }

    @Override
    public final Class<? extends ServiceInterface> getServiceInterface() {
        return ITypes.class;
    }

    @Override
    @RolesAllowed(value={"user"})
    public <T extends IEnum> T createEnumeration(T newEnum) {
        final LocalUpdate up = this.iUpdate;
        Details d = this.getSecuritySystem().newTransientDetails(newEnum);
        newEnum.getDetails().copy(d);
        this.worldReadable(newEnum);
        return (T)((IEnum)this.getSecuritySystem().doAction(new SecureAction(){

            public IObject updateObject(IObject ... iObjects) {
                return up.saveAndReturnObject(iObjects[0]);
            }
        }, new IEnum[]{newEnum}));
    }

    @Override
    @RolesAllowed(value={"system"})
    public <T extends IEnum> T updateEnumeration(T oEnum) {
        return this.iUpdate.saveAndReturnObject(oEnum);
    }

    @Override
    @RolesAllowed(value={"system"})
    public <T extends IEnum> void updateEnumerations(List<T> listEnum) {
        ArrayList<IObject> colEnum = new ArrayList<IObject>();
        for (T o : listEnum) {
            IObject obj = (IObject)o;
            colEnum.add(obj);
        }
        this.iUpdate.saveCollection(colEnum);
    }

    @Override
    @RolesAllowed(value={"system"})
    public <T extends IEnum> void deleteEnumeration(T oEnum) {
        this.iUpdate.deleteObject(oEnum);
    }

    @Override
    @RolesAllowed(value={"user"})
    public <T extends IEnum> List<T> allEnumerations(Class<T> k) {
        return this.iQuery.findAll(k, null);
    }

    @Override
    @RolesAllowed(value={"user"})
    public <T extends IEnum> T getEnumeration(Class<T> k, String string) {
        IEnum e = (IEnum)this.iQuery.findByString(k, "value", string);
        this.iQuery.initialize(e);
        if (e == null) {
            throw new ApiUsageException(String.format("An %s enum does not exist with the value: %s", k.getName(), string));
        }
        return (T)((IEnum)k.cast(e));
    }

    @Override
    @RolesAllowed(value={"user"})
    public <T extends IEnum> List<Class<T>> getEnumerationTypes() {
        ArrayList<Class<T>> list = new ArrayList<Class<T>>();
        Map m = this.sf.getAllClassMetadata();
        for (String key : m.keySet()) {
            try {
                Class<?> klass = Class.forName(((ClassMetadata)m.get(key)).getEntityName());
                boolean r = IEnum.class.isAssignableFrom(klass);
                if (!r) continue;
                list.add(klass);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Class not found. Exception: " + e.getMessage());
            }
        }
        return list;
    }

    @Override
    @RolesAllowed(value={"user"})
    public <T extends IEnum> Map<Class<T>, List<T>> getEnumerationsWithEntries() {
        HashMap<Class<T>, List<T>> map = new HashMap<Class<T>, List<T>>();
        for (Class<T> klass : this.getEnumerationTypes()) {
            List<T> entryList = this.allEnumerations(klass);
            map.put(klass, entryList);
        }
        return map;
    }

    @Override
    @RolesAllowed(value={"system"})
    public <T extends IEnum> List<T> getOriginalEnumerations() {
        ArrayList<IEnum> original = new ArrayList<IEnum>();
        InputStream in = null;
        ZipFile jarFile = null;
        try {
            URL file2 = ResourceUtils.getURL("classpath:enums.properties");
            URL jar = ResourceUtils.extractJarFileURL(file2);
            jarFile = new JarFile(jar.getPath());
            JarEntry entry = ((JarFile)jarFile).getJarEntry("enums.properties");
            in = ((JarFile)jarFile).getInputStream(entry);
            Properties property = new Properties();
            property.load(in);
            Set<Object> keys = property.keySet();
            for (String string : keys) {
                String[] keySplit = string.split("\\.");
                String className = "";
                for (int i = 0; i < keySplit.length - 1; ++i) {
                    className = className + keySplit[i] + ".";
                }
                className = className.substring(0, className.length() - 1);
                String val = property.getProperty(string);
                Class<?> klass = Class.forName(className);
                IEnum originalEntry = (IEnum)klass.getConstructor(String.class).newInstance(val);
                original.add(originalEntry);
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Class not found. " + e.getMessage());
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("File not found. " + e.getMessage());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Malformed URL. " + e.getMessage());
        }
        catch (IOException e) {
            throw new RuntimeException("IO exception. " + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Illegal argument. " + e.getMessage());
        }
        catch (SecurityException e) {
            throw new RuntimeException("Security exception. " + e.getMessage());
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Instantiation exception. " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Illegal access. " + e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Invocation Target. " + e.getMessage());
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("No such method. " + e.getMessage());
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (jarFile != null) {
                    jarFile.close();
                }
            }
            catch (IOException iOException) {}
        }
        return original;
    }

    @Override
    @RolesAllowed(value={"system"})
    public <T extends IEnum> void resetEnumerations(Class<T> klass) {
        InputStream in = null;
        try {
            URL file2 = ResourceUtils.getURL("classpath:enums.properties");
            URL jar = ResourceUtils.extractJarFileURL(file2);
            JarFile jarFile = new JarFile(jar.getPath());
            JarEntry entry = jarFile.getJarEntry("enums.properties");
            in = jarFile.getInputStream(entry);
            Properties property = new Properties();
            property.load(in);
            Properties newProp = new Properties();
            Set<Object> keys = property.keySet();
            for (String string : keys) {
                if (!string.contains(klass.getName())) continue;
                newProp.setProperty(string, property.getProperty(string));
            }
            property.clear();
            List<T> listOnDB = this.allEnumerations(klass);
            ArrayList<IEnum> arrayList = new ArrayList<IEnum>();
            ArrayList<IEnum> newList = new ArrayList<IEnum>();
            int nps = newProp.size();
            int lod = listOnDB.size();
            Long i = 1L;
            while (i < (long)(nps + 1)) {
                Object val = newProp.getProperty(klass.getName() + "." + i.toString());
                IEnum newEntry = (IEnum)klass.getConstructor(String.class).newInstance(val);
                newList.add(i.intValue() - 1, newEntry);
                val = i;
                Long l = i = Long.valueOf(i + 1L);
            }
            if (lod > nps) {
                for (int j = nps - 1; j < lod; ++j) {
                    IEnum oldOb = (IEnum)listOnDB.get(j - 1);
                    arrayList.add(oldOb);
                }
            }
            for (IEnum en : arrayList) {
                this.deleteEnumeration(en);
            }
            if (newList.size() > 0) {
                this.updateEnumerations(newList);
            }
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("File not found. " + e.getMessage());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Malformed URL. " + e.getMessage());
        }
        catch (IOException e) {
            throw new RuntimeException("IO exception. " + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Illegal argument. " + e.getMessage());
        }
        catch (SecurityException e) {
            throw new RuntimeException("Security exception. " + e.getMessage());
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Instantiation exception. " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Illegal access. " + e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Invocation Target. " + e.getMessage());
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("No such method. " + e.getMessage());
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    @RolesAllowed(value={"user"})
    public List<Class<IAnnotated>> getAnnotationTypes() {
        return new ArrayList<Class<IAnnotated>>(this.metadata.getAnnotatableTypes());
    }

    @RolesAllowed(value={"user"})
    public <T extends IObject> List<Class<T>> getResultTypes() {
        return null;
    }

    @RolesAllowed(value={"user"})
    public <T extends IObject> List<Class<T>> getContainerTypes() {
        return null;
    }

    @RolesAllowed(value={"user"})
    public <T extends IObject> List<Class<T>> getPojoTypes() {
        return null;
    }

    @RolesAllowed(value={"user"})
    public <T extends IObject> List<Class<T>> getImportTypes() {
        return null;
    }

    @RolesAllowed(value={"user"})
    public <T extends IObject> Permissions permissions(Class<T> k) {
        return null;
    }

    private void worldReadable(IObject obj) {
        Permissions p = obj.getDetails().getPermissions();
        if (p == null) {
            p = new Permissions(Permissions.WORLD_IMMUTABLE);
            obj.getDetails().setPermissions(p);
        } else {
            p.grant(Permissions.Role.GROUP, Permissions.Right.READ);
            p.grant(Permissions.Role.WORLD, Permissions.Right.READ);
        }
    }
}

