/*
 * Decompiled with CFR 0.152.
 */
package ome.logic;

import java.util.List;
import ome.annotations.RolesAllowed;
import ome.api.IRepositoryInfo;
import ome.api.ServiceInterface;
import ome.conditions.InternalException;
import ome.conditions.ResourceError;
import ome.io.nio.OriginalFilesService;
import ome.io.nio.PixelsService;
import ome.io.nio.ThumbnailService;
import ome.logic.AbstractLevel2Service;
import ome.tools.RepositoryTask;
import ome.util.SqlAction;
import org.apache.commons.io.FileSystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class RepositoryInfoImpl
extends AbstractLevel2Service
implements IRepositoryInfo {
    public static final long INITIAL_DELAY = 120000L;
    public static final double CRITICAL_USAGE = 95.0;
    private static transient Logger log = LoggerFactory.getLogger(RepositoryInfoImpl.class);
    private transient String datadir;
    private transient ThumbnailService thumbnailService;
    private transient PixelsService pixelsService;
    private transient OriginalFilesService fileService;
    private transient SqlAction sql;
    private volatile long lastCheck = 0L;
    private volatile double lastUsage = 0.0;
    private final Object lastLock = new Object();
    private static final String DEPRECATED = "This UNSAFE method has been deprecated. Server side functionality has been REMOVED.";

    public void setThumbnailService(ThumbnailService thumbnailService) {
        this.getBeanHelper().throwIfAlreadySet(this.thumbnailService, thumbnailService);
        this.thumbnailService = thumbnailService;
    }

    public void setPixelsService(PixelsService pixelsService) {
        this.getBeanHelper().throwIfAlreadySet(this.pixelsService, pixelsService);
        this.pixelsService = pixelsService;
    }

    public void setFileService(OriginalFilesService fileService) {
        this.getBeanHelper().throwIfAlreadySet(this.fileService, fileService);
        this.fileService = fileService;
    }

    public void setSqlAction(SqlAction sql) {
        this.getBeanHelper().throwIfAlreadySet(this.sql, sql);
        this.sql = sql;
    }

    @Override
    @RolesAllowed(value={"user"})
    public long getFreeSpaceInKilobytes() {
        long result = 0L;
        try {
            result = FileSystemUtils.freeSpaceKb(this.datadir);
            if (log.isInfoEnabled()) {
                log.info("Total kilobytes free: " + result);
            }
        }
        catch (Throwable t) {
            log.error("Error retrieving usage in KB.", t);
            throw new ResourceError(t.getMessage());
        }
        return result;
    }

    @Override
    @RolesAllowed(value={"user"})
    @Deprecated
    public long getUsedSpaceInKilobytes() {
        throw new InternalException(DEPRECATED);
    }

    @Override
    @RolesAllowed(value={"user"})
    @Deprecated
    public double getUsageFraction() {
        throw new InternalException(DEPRECATED);
    }

    @Override
    public final Class<? extends ServiceInterface> getServiceInterface() {
        return IRepositoryInfo.class;
    }

    public void setDatadir(String datadir) {
        this.datadir = datadir;
    }

    public boolean needsSanityCheck() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @RolesAllowed(value={"user"})
    public void sanityCheckRepository() throws InternalException {
        if (this.needsSanityCheck()) {
            Object object = this.lastLock;
            synchronized (object) {
                if (this.needsSanityCheck()) {
                    try {
                        this.lastUsage = this.getUsageFraction() * 100.0;
                    }
                    catch (Throwable t) {
                        log.error("Critical failure sanity checking repository.", t);
                        throw new InternalException("Error in sanityCheckRepository(): " + t.getMessage());
                    }
                    this.lastCheck = System.currentTimeMillis();
                }
            }
        }
        if (this.lastUsage > 95.0) {
            throw new ResourceError(String.format("Server repository disk space usage (%s%%) exceeds %s%%", this.lastUsage, 95.0));
        }
    }

    @Override
    @RolesAllowed(value={"user"})
    public void removeUnusedFiles() {
        RepositoryTask task = new RepositoryTask(this.sql);
        List<Long> files = task.getFileIds();
        List<Long> pixels = task.getPixelIds();
        List<Long> thumbs = task.getThumbnailIds();
        if (files != null && files.size() > 0) {
            log.info("Removing files: " + files);
            this.fileService.removeFiles(files);
        }
        if (pixels != null && pixels.size() > 0) {
            log.info("Removing pixels: " + pixels);
            this.pixelsService.removePixels(pixels);
        }
        if (thumbs != null && thumbs.size() > 0) {
            log.info("Removing thumbnails: " + thumbs);
            this.thumbnailService.removeThumbnails(thumbs);
        }
    }
}

