/*
 * Decompiled with CFR 0.152.
 */
package ome.logic;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ome.annotations.NotNull;
import ome.annotations.RolesAllowed;
import ome.api.IPixels;
import ome.api.IRenderingSettings;
import ome.api.ServiceInterface;
import ome.conditions.ConcurrencyException;
import ome.conditions.ResourceError;
import ome.conditions.ValidationException;
import ome.io.nio.PixelBuffer;
import ome.io.nio.PixelsService;
import ome.logic.AbstractLevel2Service;
import ome.model.IObject;
import ome.model.acquisition.Filter;
import ome.model.acquisition.Laser;
import ome.model.acquisition.LightSource;
import ome.model.acquisition.TransmittanceRange;
import ome.model.containers.Dataset;
import ome.model.containers.Project;
import ome.model.core.Channel;
import ome.model.core.Image;
import ome.model.core.LogicalChannel;
import ome.model.core.Pixels;
import ome.model.display.ChannelBinding;
import ome.model.display.CodomainMapContext;
import ome.model.display.QuantumDef;
import ome.model.display.RenderingDef;
import ome.model.display.ReverseIntensityContext;
import ome.model.enums.Family;
import ome.model.enums.RenderingModel;
import ome.model.screen.Plate;
import ome.model.screen.PlateAcquisition;
import ome.model.screen.Screen;
import ome.model.stats.StatsInfo;
import ome.model.units.Length;
import ome.parameters.Parameters;
import omeis.providers.re.ColorsFactory;
import omeis.providers.re.data.PlaneDef;
import omeis.providers.re.metadata.StatsFactory;
import omeis.providers.re.quantum.QuantumFactory;
import omeis.providers.re.quantum.QuantumStrategy;
import org.perf4j.StopWatch;
import org.perf4j.slf4j.Slf4JStopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class RenderingSettingsImpl
extends AbstractLevel2Service
implements IRenderingSettings,
Serializable {
    private static final long serialVersionUID = -4383698215540637039L;
    public static final double EPSILON = 1.0E-5;
    private static transient Logger log = LoggerFactory.getLogger(RenderingSettingsImpl.class);
    protected transient PixelsService pixelsData;
    protected transient IPixels pixelsMetadata;

    private double[] initPixelsRange(Pixels pixels) {
        StatsFactory factory = new StatsFactory();
        return factory.initPixelsRange(pixels);
    }

    private Long getCurrentUserId() {
        return this.getSecuritySystem().getEventContext().getCurrentUserId();
    }

    private void checkValidContainerClass(Class<? extends IObject> klass) {
        if (!(Project.class.equals(klass) || Dataset.class.equals(klass) || Image.class.equals(klass) || Plate.class.equals(klass) || Pixels.class.equals(klass) || Screen.class.equals(klass) || PlateAcquisition.class.equals(klass))) {
            throw new IllegalArgumentException("Class parameter for changing settings must be in {Project, Dataset, Image, Plate, Screen, PlateAcquisition, Pixels}, not " + klass);
        }
    }

    private void updatePixelsForNodes(List<Pixels> pixels, Class<? extends IObject> klass, Set<Long> nodeIds) {
        if (Project.class.equals(klass)) {
            pixels.addAll(this.loadProjectPixels(nodeIds));
        } else if (Dataset.class.equals(klass)) {
            pixels.addAll(this.loadDatasetPixels(nodeIds));
        } else if (Plate.class.equals(klass)) {
            pixels.addAll(this.loadPlatePixels(nodeIds));
        } else if (PlateAcquisition.class.equals(klass)) {
            pixels.addAll(this.loadPlateAcquisitionPixels(nodeIds));
        } else if (Screen.class.equals(klass)) {
            pixels.addAll(this.loadScreenPixels(nodeIds));
        } else if (Image.class.equals(klass)) {
            pixels.addAll(this.loadPixelsByImage(nodeIds));
        } else if (Pixels.class.equals(klass)) {
            pixels.addAll(this.loadPixels(nodeIds));
        }
    }

    private List<Pixels> loadPixels(Set<Long> pixelsIds) {
        Slf4JStopWatch s1 = new Slf4JStopWatch("omero.loadPixels");
        Parameters p = new Parameters();
        p.addIds(pixelsIds);
        String sql = "select pix from Pixels as pix join fetch pix.image join fetch pix.pixelsType join fetch pix.channels as c join fetch c.logicalChannel where pix.id in (:ids)";
        List<Pixels> pixels = this.iQuery.findAllByQuery(sql, p);
        ((StopWatch)s1).stop();
        return pixels;
    }

    private List<Pixels> loadPixelsByImage(Set<Long> imageIds) {
        Slf4JStopWatch s1 = new Slf4JStopWatch("omero.loadPixelsByImage");
        Parameters p = new Parameters();
        p.addIds(imageIds);
        String sql = "select pix from Pixels as pix join fetch pix.image as i join fetch pix.pixelsType join fetch pix.channels as c join fetch c.logicalChannel where i.id in (:ids)";
        List<Pixels> pixels = this.iQuery.findAllByQuery(sql, p);
        ((StopWatch)s1).stop();
        return pixels;
    }

    private List<Pixels> loadPlatePixels(Set<Long> plateIds) {
        Slf4JStopWatch s1 = new Slf4JStopWatch("omero.loadPlatePixels");
        Parameters p = new Parameters();
        p.addIds(plateIds);
        String sql = "select pix from Pixels as pix join fetch pix.image as i join fetch pix.pixelsType join fetch pix.channels as c join fetch c.logicalChannel left outer join i.wellSamples as s left outer join s.well as w left outer join w.plate as p where p.id in (:ids)";
        List<Pixels> pixels = this.iQuery.findAllByQuery(sql, p);
        ((StopWatch)s1).stop();
        return pixels;
    }

    private List<Pixels> loadPlateAcquisitionPixels(Set<Long> ids) {
        Slf4JStopWatch s1 = new Slf4JStopWatch("omero.loadPlatePixels");
        Parameters p = new Parameters();
        p.addIds(ids);
        String sql = "select pix from Pixels as pix join fetch pix.image as i join fetch pix.pixelsType join fetch pix.channels as c join fetch c.logicalChannel left outer join i.wellSamples as s left outer join s.plateAcquisition as p where p.id in (:ids)";
        List<Pixels> pixels = this.iQuery.findAllByQuery(sql, p);
        ((StopWatch)s1).stop();
        return pixels;
    }

    private List<Pixels> loadScreenPixels(Set<Long> screenIds) {
        Slf4JStopWatch s1 = new Slf4JStopWatch("omero.loadScreenPixels");
        Parameters p = new Parameters();
        p.addIds(screenIds);
        String sql = "select pix from Pixels as pix join fetch pix.image as i join fetch pix.pixelsType join fetch pix.channels as c join fetch c.logicalChannel left outer join i.wellSamples as s left outer join s.well as w left outer join w.plate as p left outer join p.screenLinks as spl left outer join spl.parent as s where s.id in (:ids)";
        List<Pixels> pixels = this.iQuery.findAllByQuery(sql, p);
        ((StopWatch)s1).stop();
        return pixels;
    }

    private List<Pixels> loadDatasetPixels(Set<Long> datasetIds) {
        Slf4JStopWatch s1 = new Slf4JStopWatch("omero.loadDatasetPixels");
        Parameters p = new Parameters();
        p.addIds(datasetIds);
        String sql = "select pix from Pixels as pix join fetch pix.image as i join fetch pix.pixelsType join fetch pix.channels as c join fetch c.logicalChannel left outer join i.datasetLinks dil left outer join dil.parent d where d.id in (:ids)";
        List<Pixels> pixels = this.iQuery.findAllByQuery(sql, p);
        ((StopWatch)s1).stop();
        return pixels;
    }

    private List<Pixels> loadProjectPixels(Set<Long> projectIds) {
        Slf4JStopWatch s1 = new Slf4JStopWatch("omero.loadProjectPixels");
        Parameters p = new Parameters();
        p.addIds(projectIds);
        String sql = "select pix from Pixels as pix join fetch pix.image as i join fetch pix.pixelsType join fetch pix.channels as c join fetch c.logicalChannel left outer join i.datasetLinks dil left outer join dil.parent as d left outer join d.projectLinks as pdl left outer join pdl.parent as p where p.id in (:ids)";
        List<Pixels> pixels = this.iQuery.findAllByQuery(sql, p);
        ((StopWatch)s1).stop();
        return pixels;
    }

    private LogicalChannel loadLogicalChannel(Long id) {
        Slf4JStopWatch s1 = new Slf4JStopWatch("omero.loadLogicalChannel");
        Parameters p = new Parameters();
        p.addId(id);
        String sql = "select channel from LogicalChannel as channel left outer join fetch channel.filterSet as filter left outer join fetch channel.lightPath as lp left outer join fetch lp.emissionFilterLink as em_link left outer join fetch em_link.child as emFilter left outer join fetch emFilter.transmittanceRange left outer join fetch lp.excitationFilterLink as ex_link left outer join fetch ex_link.child as exFilter left outer join fetch exFilter.transmittanceRange left outer join fetch channel.lightSourceSettings as lss left outer join fetch lss.lightSource as ls where channel.id = :id";
        LogicalChannel lc = (LogicalChannel)this.iQuery.findByQuery(sql, p);
        ((StopWatch)s1).stop();
        return lc;
    }

    private Map<Long, RenderingDef> loadRenderingSettings(List<Pixels> pixels) {
        return this.loadRenderingSettings(pixels, this.getCurrentUserId());
    }

    private Map<Long, RenderingDef> loadRenderingSettings(List<Pixels> pixels, Long ownerId) {
        String sql;
        Parameters p;
        Slf4JStopWatch s1 = new Slf4JStopWatch("omero.loadRenderingSettingsByUser");
        HashSet<Long> pixelsIds = new HashSet<Long>();
        for (Pixels p2 : pixels) {
            pixelsIds.add(p2.getId());
        }
        if (ownerId >= 0L) {
            p = new Parameters();
            p.addIds(pixelsIds);
            p.addId(ownerId);
            sql = "select rdef from RenderingDef as rdef left outer join fetch rdef.details.owner left outer join fetch rdef.quantization left outer join fetch rdef.model left outer join fetch rdef.waveRendering as cb left outer join fetch cb.family left outer join fetch cb.spatialDomainEnhancement left outer join fetch rdef.projections as proj left outer join fetch proj.axis left outer join fetch proj.type where rdef.pixels.id in (:ids) and rdef.details.owner.id = :id";
        } else {
            p = new Parameters();
            p.addIds(pixelsIds);
            sql = "select rdef from RenderingDef as rdef left outer join fetch rdef.details.owner left outer join fetch rdef.quantization left outer join fetch rdef.model left outer join fetch rdef.waveRendering as cb left outer join fetch cb.family left outer join fetch cb.spatialDomainEnhancement left outer join fetch rdef.projections as proj left outer join fetch proj.axis left outer join fetch proj.type where rdef.pixels.id in (:ids) and rdef.details.owner.id = rdef.pixels.details.owner.id";
        }
        HashMap<Long, RenderingDef> settingsMap = new HashMap<Long, RenderingDef>();
        List settingsList = this.iQuery.findAllByQuery(sql, p);
        for (RenderingDef settings : settingsList) {
            settingsMap.put(settings.getPixels().getId(), settings);
        }
        ((StopWatch)s1).stop();
        return settingsMap;
    }

    private Map<Long, RenderingDef> loadRenderingSettingsByOwner(List<Pixels> pixels) {
        Slf4JStopWatch s1 = new Slf4JStopWatch("omero.loadRenderingSettingsByOwner");
        HashSet<Long> pixelsIds = new HashSet<Long>();
        for (Pixels p : pixels) {
            pixelsIds.add(p.getId());
        }
        Parameters p = new Parameters();
        p.addIds(pixelsIds);
        String sql = "select rdef from RenderingDef as rdef left outer join fetch rdef.details.owner left outer join fetch rdef.quantization left outer join fetch rdef.model left outer join fetch rdef.waveRendering as cb left outer join fetch cb.family left outer join fetch cb.spatialDomainEnhancement left outer join fetch rdef.projections as proj left outer join fetch proj.axis left outer join fetch proj.type where rdef.pixels.id in (:ids) and rdef.details.owner.id = rdef.pixels.details.owner.id";
        HashMap<Long, RenderingDef> settingsMap = new HashMap<Long, RenderingDef>();
        List settingsList = this.iQuery.findAllByQuery(sql, p);
        for (RenderingDef settings : settingsList) {
            settingsMap.put(settings.getPixels().getId(), settings);
        }
        ((StopWatch)s1).stop();
        return settingsMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RenderingDef resetDefaults(RenderingDef settings, Pixels pixels, boolean save, boolean computeStats, List<Family> families, List<RenderingModel> renderingModels) {
        if (settings == null) {
            settings = this.createNewRenderingDef(pixels);
        }
        QuantumFactory quantumFactory = new QuantumFactory(families);
        try {
            PixelBuffer buffer = null;
            if (computeStats) {
                buffer = this.pixelsData.getPixelBuffer(pixels, false);
            }
            try {
                this.resetDefaults(settings, pixels, quantumFactory, renderingModels, buffer, computeStats);
            }
            finally {
                if (buffer != null) {
                    buffer.close();
                }
            }
            settings.setVersion(settings.getVersion() + 1);
            if (save) {
                log.info("Saving settings: " + settings);
                this.pixelsMetadata.saveRndSettings(settings);
            }
            return settings;
        }
        catch (IOException e) {
            log.debug("An I/O error occurred while attempting to reset rendering settings " + settings + " for pixels set " + pixels, e);
            throw new ResourceError(e.getMessage() + " Please check server log.");
        }
    }

    private void resetDefaults(RenderingDef def, Pixels pixels, QuantumFactory quantumFactory, List<RenderingModel> renderingModels, PixelBuffer buffer, boolean computeStats) {
        def.setDefaultZ(pixels.getSizeZ() / 2);
        def.setDefaultT(0);
        RenderingModel defaultModel = null;
        int sizeC = pixels.getSizeC();
        if (sizeC > 1 && sizeC < 8) {
            for (RenderingModel model : renderingModels) {
                if (!model.getValue().equals("rgb")) continue;
                defaultModel = model;
            }
        } else {
            for (RenderingModel model : renderingModels) {
                if (!model.getValue().equals("greyscale")) continue;
                defaultModel = model;
            }
        }
        if (defaultModel == null) {
            throw new IllegalArgumentException("Unable to find default rendering model in enumerated list.");
        }
        def.setModel(defaultModel);
        QuantumDef quantumDef = def.getQuantization();
        quantumDef.setCdStart(0);
        quantumDef.setCdEnd(255);
        quantumDef.setBitResolution(255);
        def.setQuantization(quantumDef);
        this.resetChannelBindings(def, pixels, quantumFactory, buffer, computeStats);
    }

    private <T extends IObject> Set<Long> resetDefaultsInSet(Class<T> klass, Set<Long> nodeIds, boolean computeStats) {
        this.checkValidContainerClass(klass);
        Slf4JStopWatch s1 = new Slf4JStopWatch("omero.resetDefaultsInSet");
        ArrayList<Pixels> pixels = new ArrayList<Pixels>();
        this.updatePixelsForNodes(pixels, klass, nodeIds);
        HashSet<Long> imageIds = new HashSet<Long>();
        if (pixels.size() == 0) {
            return imageIds;
        }
        List<Family> families = this.pixelsMetadata.getAllEnumerations(Family.class);
        List<RenderingModel> renderingModels = this.pixelsMetadata.getAllEnumerations(RenderingModel.class);
        ArrayList<RenderingDef> toSave = new ArrayList<RenderingDef>(pixels.size());
        Map<Long, RenderingDef> settingsMap = this.loadRenderingSettings(pixels);
        for (Pixels p : pixels) {
            RenderingDef settings = settingsMap.get(p.getId());
            if (settings == null) {
                settings = this.createNewRenderingDef(p);
            }
            try {
                RenderingDef newSettings = this.resetDefaults(settings, p, false, computeStats, families, renderingModels);
                if (newSettings != null) {
                    toSave.add(newSettings);
                }
                imageIds.add(p.getImage().getId());
            }
            catch (ResourceError newSettings) {
            }
            catch (ConcurrencyException e) {
                log.warn(e.getClass().getSimpleName() + ", not resetting settings for Image:" + p.getImage().getId());
            }
            catch (Exception e) {
                log.warn("Exception while resetting settings for Image:" + p.getImage().getId(), e);
            }
        }
        Slf4JStopWatch s2 = new Slf4JStopWatch("omero.resetDefaultsInSet.saveAndReturn");
        if (toSave.size() > 0) {
            IObject[] toSaveArray = toSave.toArray(new RenderingDef[toSave.size()]);
            this.iUpdate.saveAndReturnArray(toSaveArray);
        }
        ((StopWatch)s2).stop();
        ((StopWatch)s1).stop();
        return imageIds;
    }

    private String getValueFromFilter(Filter f) {
        if (f == null) {
            return null;
        }
        TransmittanceRange transmittance = f.getTransmittanceRange();
        if (transmittance == null) {
            return null;
        }
        return "" + transmittance.getCutIn();
    }

    private String getChannelName(LogicalChannel lc) {
        Laser laser;
        LightSource src;
        Iterator<Filter> it;
        String name = null;
        Length value = lc.getEmissionWave();
        if (value != null) {
            return "" + value.getValue();
        }
        if (lc.getFilterSet() != null) {
            it = lc.getFilterSet().linkedEmissionFilterIterator();
            while (name == null && it.hasNext()) {
                name = this.getValueFromFilter(it.next());
            }
            if (name != null) {
                return name;
            }
        }
        if (lc.getLightSourceSettings() != null && (src = lc.getLightSourceSettings().getLightSource()) instanceof Laser && (value = (laser = (Laser)src).getWavelength()) != null) {
            return "" + value.getValue();
        }
        value = lc.getExcitationWave();
        if (value != null) {
            return "" + value.getValue();
        }
        if (lc.getFilterSet() != null) {
            it = lc.getFilterSet().linkedExcitationFilterIterator();
            while (name == null && it.hasNext()) {
                name = this.getValueFromFilter(it.next());
            }
            if (name != null) {
                return name;
            }
        }
        return name;
    }

    private int[] hasOriginalColor(Channel channel) {
        Integer red = channel.getRed();
        Integer green = channel.getGreen();
        Integer blue = channel.getBlue();
        Integer alpha = channel.getAlpha();
        if (red != null && green != null && blue != null && alpha != null) {
            return new int[]{red, green, blue, alpha};
        }
        return null;
    }

    private void resetChannelBindings(RenderingDef def, Pixels pixels, QuantumFactory quantumFactory, PixelBuffer buffer, boolean computeStats) {
        int[] defaultColor;
        ChannelBinding channelBinding2;
        List<ChannelBinding> channelBindings = def.collectWaveRendering(null);
        PlaneDef planeDef = this.getDefaultPlaneDef(def);
        int i = 0;
        HashMap<ChannelBinding, Boolean> m = new HashMap<ChannelBinding, Boolean>();
        ArrayList values = new ArrayList();
        int count = 0;
        ArrayList toUpdate = new ArrayList();
        for (Channel channel : pixels.collectChannels(null)) {
            Family family = quantumFactory.getFamily("linear");
            channelBinding2 = (ChannelBinding)channelBindings.get(i);
            channelBinding2.setFamily(family);
            channelBinding2.setCoefficient(1.0);
            channelBinding2.setActive(i < 3);
            defaultColor = this.hasOriginalColor(channel);
            if (defaultColor == null) {
                boolean v;
                LogicalChannel lc = channel.getLogicalChannel();
                if (lc != null) {
                    lc = this.loadLogicalChannel(lc.getId());
                }
                if (!(v = ColorsFactory.hasEmissionData(lc))) {
                    ++count;
                }
                m.put(channelBinding2, v);
                defaultColor = ColorsFactory.getColor(i, channel, lc);
            }
            channelBinding2.setRed(defaultColor[0]);
            channelBinding2.setGreen(defaultColor[1]);
            channelBinding2.setBlue(defaultColor[2]);
            channelBinding2.setAlpha(defaultColor[3]);
            channelBinding2.setNoiseReduction(false);
            channelBinding2.setLookupTable(channel.getLookupTable());
            channelBinding2.clearSpatialDomainEnhancement();
            ++i;
        }
        if (count > 0 && count != m.size()) {
            for (ChannelBinding channelBinding2 : m.keySet()) {
                if (((Boolean)m.get(channelBinding2)).booleanValue()) continue;
                defaultColor = ColorsFactory.newWhiteColor();
                channelBinding2.setRed(defaultColor[0]);
                channelBinding2.setGreen(defaultColor[1]);
                channelBinding2.setBlue(defaultColor[2]);
                channelBinding2.setAlpha(defaultColor[3]);
            }
        }
        QuantumDef qDef = def.getQuantization();
        if (computeStats) {
            this.computeLocationStats(pixels, channelBindings, planeDef, buffer, quantumFactory, qDef);
        } else {
            for (int w = 0; w < pixels.sizeOfChannels(); ++w) {
                double max;
                double min;
                channelBinding2 = channelBindings.get(w);
                StatsInfo stats = pixels.getChannel(w).getStatsInfo();
                if (stats == null) {
                    double[] range = this.initPixelsRange(pixels);
                    min = range[0];
                    max = range[1];
                } else {
                    min = stats.getGlobalMin();
                    max = stats.getGlobalMax();
                }
                if (Math.abs(min - max) < 1.0E-5) {
                    QuantumStrategy qs = quantumFactory.getStrategy(qDef, pixels);
                    min = qs.getPixelsTypeMin();
                    max = qs.getPixelsTypeMax();
                }
                channelBinding2.setInputStart(min);
                channelBinding2.setInputEnd(max);
            }
        }
        if (toUpdate.size() > 0) {
            Slf4JStopWatch s1 = new Slf4JStopWatch("omero.resetChannelBindings.saveAndReturn");
            IObject[] toSaveArray = toUpdate.toArray(new LogicalChannel[toUpdate.size()]);
            this.iUpdate.saveAndReturnArray(toSaveArray);
            ((StopWatch)s1).stop();
        }
    }

    private void computeLocationStats(Pixels pixels, List<ChannelBinding> cbs, PlaneDef planeDef, PixelBuffer buf, QuantumFactory quantumFactory, QuantumDef qDef) {
        if (planeDef == null) {
            throw new NullPointerException("No plane definition.");
        }
        StatsFactory sf = new StatsFactory();
        for (int w = 0; w < pixels.sizeOfChannels(); ++w) {
            ChannelBinding cb = cbs.get(w);
            sf.computeLocationStats(pixels, buf, planeDef, w);
            cb.setNoiseReduction(sf.isNoiseReduction());
            double min = sf.getInputStart();
            double max = sf.getInputEnd();
            if (Math.abs(min - max) < 1.0E-5) {
                QuantumStrategy qs = quantumFactory.getStrategy(qDef, pixels);
                min = qs.getPixelsTypeMin();
                max = qs.getPixelsTypeMax();
            }
            cb.setInputStart(new Double(min));
            cb.setInputEnd(new Double(max));
        }
    }

    private PlaneDef getDefaultPlaneDef(RenderingDef renderingDef) {
        PlaneDef pd = new PlaneDef(0, renderingDef.getDefaultT());
        pd.setZ(renderingDef.getDefaultZ());
        return pd;
    }

    private List<ChannelBinding> createNewChannelBindings(Pixels p) {
        ArrayList<ChannelBinding> cbs = new ArrayList<ChannelBinding>();
        for (int i = 0; i < p.getSizeC(); ++i) {
            ChannelBinding binding = new ChannelBinding();
            cbs.add(binding);
        }
        return cbs;
    }

    private CodomainMapContext copyContext(CodomainMapContext ctx, List<CodomainMapContext> l) {
        if (l != null) {
            for (CodomainMapContext c : l) {
                if (!ctx.getClass().equals(c.getClass())) continue;
                return null;
            }
        }
        if (ctx instanceof ReverseIntensityContext) {
            ReverseIntensityContext nc = new ReverseIntensityContext();
            nc.setReverse(((ReverseIntensityContext)ctx).getReverse());
            return nc;
        }
        return null;
    }

    private RenderingDef applySettings(Pixels pixelsFrom, Pixels pixelsTo, RenderingDef settingsFrom, RenderingDef settingsTo) {
        int t;
        int z;
        log.debug(String.format("Applying settings. From %s to %s and from %s to %s", pixelsFrom, pixelsTo, settingsFrom, settingsTo));
        boolean b = this.sanityCheckPixels(pixelsFrom, pixelsTo);
        if (!b) {
            return null;
        }
        if (settingsFrom == null) {
            return null;
        }
        if (settingsTo == null) {
            settingsTo = this.createNewRenderingDef(pixelsTo);
        }
        if ((z = settingsFrom.getDefaultZ().intValue()) < pixelsTo.getSizeZ()) {
            settingsTo.setDefaultZ(z);
        }
        if ((t = settingsFrom.getDefaultT().intValue()) < pixelsTo.getSizeT()) {
            settingsTo.setDefaultT(t);
        }
        settingsTo.setModel(settingsFrom.getModel());
        QuantumDef qDefFrom = settingsFrom.getQuantization();
        QuantumDef qDefTo = settingsTo.getQuantization();
        qDefTo.setBitResolution(qDefFrom.getBitResolution());
        Integer end = qDefFrom.getCdEnd();
        Integer start = qDefFrom.getCdStart();
        if (end != null && start != null && end < start) {
            end = start;
            start = qDefFrom.getCdEnd();
        }
        qDefTo.setCdEnd(end);
        qDefTo.setCdStart(start);
        Iterator<ChannelBinding> i = settingsFrom.iterateWaveRendering();
        Iterator<ChannelBinding> iTo = settingsTo.iterateWaveRendering();
        while (i.hasNext()) {
            ChannelBinding binding = i.next();
            ChannelBinding bindingTo = iTo.next();
            bindingTo.setActive(binding.getActive());
            bindingTo.setCoefficient(binding.getCoefficient());
            bindingTo.setFamily(binding.getFamily());
            bindingTo.setInputStart(binding.getInputStart());
            bindingTo.setInputEnd(binding.getInputEnd());
            bindingTo.setNoiseReduction(binding.getNoiseReduction());
            bindingTo.setAlpha(binding.getAlpha());
            bindingTo.setBlue(binding.getBlue());
            bindingTo.setGreen(binding.getGreen());
            bindingTo.setRed(binding.getRed());
            bindingTo.setLookupTable(binding.getLookupTable());
            List<CodomainMapContext> original = bindingTo.collectSpatialDomainEnhancement(null);
            Iterator<CodomainMapContext> j = binding.iterateSpatialDomainEnhancement();
            if (binding.sizeOfSpatialDomainEnhancement() == 0) {
                bindingTo.clearSpatialDomainEnhancement();
            }
            while (j.hasNext()) {
                CodomainMapContext ctx = this.copyContext(j.next(), original);
                if (ctx == null) continue;
                bindingTo.addCodomainMapContext(ctx);
            }
        }
        settingsTo.setVersion(settingsTo.getVersion() + 1);
        return settingsTo;
    }

    @Override
    public boolean sanityCheckPixels(Pixels pFrom, Pixels pTo) {
        LogicalChannel lc;
        Channel c;
        String vTo;
        if (pTo == null || pFrom == null) {
            return false;
        }
        String vFrom = pFrom.getPixelsType().getValue();
        if (!vFrom.equals(vTo = pTo.getPixelsType().getValue())) {
            return false;
        }
        if (pFrom.getSizeC().compareTo(pTo.getSizeC()) != 0) {
            return false;
        }
        Iterator<Channel> i = pFrom.iterateChannels();
        ArrayList<Length> wavelengths = new ArrayList<Length>(pFrom.sizeOfChannels());
        while (i.hasNext()) {
            c = i.next();
            lc = c.getLogicalChannel();
            if (lc == null) continue;
            wavelengths.add(lc.getEmissionWave());
        }
        i = pTo.iterateChannels();
        int r = 0;
        while (i.hasNext()) {
            c = i.next();
            lc = c.getLogicalChannel();
            if (lc == null || !wavelengths.contains(lc.getEmissionWave())) continue;
            ++r;
        }
        return r == wavelengths.size();
    }

    public void setPixelsMetadata(IPixels metaService) {
        this.getBeanHelper().throwIfAlreadySet(this.pixelsMetadata, metaService);
        this.pixelsMetadata = metaService;
    }

    public void setPixelsData(PixelsService dataService) {
        this.getBeanHelper().throwIfAlreadySet(this.pixelsData, dataService);
        this.pixelsData = dataService;
    }

    @Override
    public Class<? extends ServiceInterface> getServiceInterface() {
        return IRenderingSettings.class;
    }

    @Override
    @RolesAllowed(value={"user"})
    public <T extends IObject> Map<Boolean, List<Long>> applySettingsToSet(long from, Class<T> klass, Set<Long> nodeIds) {
        this.checkValidContainerClass(klass);
        Slf4JStopWatch s1 = new Slf4JStopWatch("omero.applySettingsToSet");
        ArrayList<Pixels> pixels = new ArrayList<Pixels>();
        this.updatePixelsForNodes(pixels, klass, nodeIds);
        Pixels pixelsFrom = null;
        for (Pixels p : pixels) {
            if (p.getId() != from) continue;
            pixelsFrom = p;
            break;
        }
        ArrayList<Long> toReturnTrue = new ArrayList<Long>();
        ArrayList<Long> toReturnFalse = new ArrayList<Long>();
        HashMap<Boolean, List<Long>> toReturn = new HashMap<Boolean, List<Long>>();
        if (pixels.size() == 0) {
            toReturn.put(true, toReturnTrue);
            toReturn.put(false, toReturnFalse);
            return toReturn;
        }
        ArrayList<RenderingDef> toSave = new ArrayList<RenderingDef>();
        Map<Long, RenderingDef> settingsMap = this.loadRenderingSettings(pixels);
        RenderingDef settingsFrom = settingsMap.get(from);
        if (pixelsFrom != null) {
            pixels.remove(pixelsFrom);
            toReturnTrue.add(pixelsFrom.getImage().getId());
        } else {
            HashSet<Long> ids = new HashSet<Long>();
            ids.add(from);
            List<Pixels> l = this.loadPixels(ids);
            if (l.size() != 1) {
                throw new ValidationException("No pixels set with ID: " + from);
            }
            pixelsFrom = (Pixels)l.get(0);
            if (settingsFrom == null) {
                ArrayList<Pixels> list = new ArrayList<Pixels>(1);
                list.add(pixelsFrom);
                Map<Long, RenderingDef> map = this.loadRenderingSettings(list);
                if (!map.containsKey(from)) {
                    map = this.loadRenderingSettings(list, -1L);
                }
                settingsFrom = map.get(from);
            }
        }
        for (Pixels p : pixels) {
            RenderingDef settingsTo = settingsMap.get(p.getId());
            if ((settingsTo = this.applySettings(pixelsFrom, p, settingsFrom, settingsTo)) == null) {
                toReturnFalse.add(p.getImage().getId());
                continue;
            }
            toSave.add(settingsTo);
            toReturnTrue.add(p.getImage().getId());
        }
        Slf4JStopWatch s2 = new Slf4JStopWatch("omero.applySettingsToSet.saveAndReturn");
        IObject[] toSaveArray = toSave.toArray(new RenderingDef[toSave.size()]);
        this.iUpdate.saveAndReturnArray(toSaveArray);
        ((StopWatch)s2).stop();
        ((StopWatch)s1).stop();
        toReturn.put(true, toReturnTrue);
        toReturn.put(false, toReturnFalse);
        return toReturn;
    }

    @Override
    @RolesAllowed(value={"user"})
    public Map<Boolean, List<Long>> applySettingsToProject(long from, long to) {
        HashSet<Long> nodeIds = new HashSet<Long>();
        nodeIds.add(to);
        return this.applySettingsToSet(from, Project.class, nodeIds);
    }

    @Override
    @RolesAllowed(value={"user"})
    public Map<Boolean, List<Long>> applySettingsToDataset(long from, long to) {
        HashSet<Long> nodeIds = new HashSet<Long>();
        nodeIds.add(to);
        return this.applySettingsToSet(from, Dataset.class, nodeIds);
    }

    @Override
    @RolesAllowed(value={"user"})
    public boolean applySettingsToImage(long from, long to) {
        HashSet<Long> nodeIds = new HashSet<Long>();
        nodeIds.add(to);
        Map<Boolean, List<Long>> returnValue = this.applySettingsToSet(from, Image.class, nodeIds);
        return returnValue.get(Boolean.TRUE).contains(to);
    }

    @Override
    @RolesAllowed(value={"user"})
    public Map<Boolean, List<Long>> applySettingsToImages(long from, List<Long> nodeIds) {
        HashSet<Long> nodeIdSet = new HashSet<Long>(nodeIds);
        return this.applySettingsToSet(from, Image.class, nodeIdSet);
    }

    @Override
    @RolesAllowed(value={"user"})
    public boolean applySettingsToPixels(long from, long to) {
        HashSet<Long> nodeIds = new HashSet<Long>();
        nodeIds.add(to);
        List<Pixels> pixels = this.loadPixels(nodeIds);
        Long imageID = pixels.get(0).getImage().getId();
        Map<Boolean, List<Long>> returnValue = this.applySettingsToSet(from, Pixels.class, nodeIds);
        return returnValue.get(Boolean.TRUE).contains(imageID);
    }

    @Override
    @RolesAllowed(value={"user"})
    public RenderingDef getRenderingSettings(long pixelsId) {
        return this.pixelsMetadata.retrieveRndSettings(pixelsId);
    }

    @Override
    public RenderingDef createNewRenderingDef(@NotNull Pixels pixels) {
        if (pixels == null) {
            return null;
        }
        RenderingDef r = new RenderingDef();
        r.setDefaultZ(pixels.getSizeZ() / 2);
        r.setDefaultT(0);
        r.setQuantization(new QuantumDef());
        List<ChannelBinding> list = this.createNewChannelBindings(pixels);
        r.clearWaveRendering();
        for (ChannelBinding channelBinding : list) {
            r.addChannelBinding(channelBinding);
        }
        Pixels unloadedPixels = new Pixels();
        unloadedPixels.setId(pixels.getId());
        unloadedPixels.unload();
        r.setPixels(unloadedPixels);
        return r;
    }

    @Override
    @RolesAllowed(value={"user"})
    public void resetDefaults(RenderingDef def, Pixels pixels) {
        List<Family> families = this.pixelsMetadata.getAllEnumerations(Family.class);
        List<RenderingModel> renderingModels = this.pixelsMetadata.getAllEnumerations(RenderingModel.class);
        this.resetDefaults(def, pixels, true, true, families, renderingModels);
    }

    @Override
    @RolesAllowed(value={"user"})
    public RenderingDef resetDefaultsNoSave(RenderingDef def, Pixels pixels) {
        List<Family> families = this.pixelsMetadata.getAllEnumerations(Family.class);
        List<RenderingModel> renderingModels = this.pixelsMetadata.getAllEnumerations(RenderingModel.class);
        return this.resetDefaults(def, pixels, false, true, families, renderingModels);
    }

    @Override
    @RolesAllowed(value={"user"})
    public void resetDefaultsInImage(long to) {
        HashSet<Long> nodeIds = new HashSet<Long>();
        nodeIds.add(to);
        this.resetDefaultsInSet(Image.class, nodeIds);
    }

    @Override
    @RolesAllowed(value={"user"})
    public void resetDefaultsForPixels(long to) {
        HashSet<Long> nodeIds = new HashSet<Long>();
        nodeIds.add(to);
        this.resetDefaultsInSet(Pixels.class, nodeIds);
    }

    @Override
    @RolesAllowed(value={"user"})
    public Set<Long> resetDefaultsInDataset(long to) {
        HashSet<Long> nodeIds = new HashSet<Long>();
        nodeIds.add(to);
        return this.resetDefaultsInSet(Dataset.class, nodeIds);
    }

    @Override
    @RolesAllowed(value={"user"})
    public <T extends IObject> Set<Long> resetDefaultsInSet(Class<T> klass, Set<Long> nodeIds) {
        return this.resetDefaultsInSet(klass, nodeIds, true);
    }

    @Override
    @RolesAllowed(value={"user"})
    public <T extends IObject> Set<Long> resetDefaultsByOwnerInSet(Class<T> klass, Set<Long> nodeIds) {
        this.checkValidContainerClass(klass);
        HashSet<Long> toReturn = new HashSet<Long>();
        ArrayList<Pixels> pixelsList = new ArrayList<Pixels>();
        this.updatePixelsForNodes(pixelsList, klass, nodeIds);
        if (pixelsList.size() == 0) {
            return toReturn;
        }
        Map<Long, RenderingDef> ownerSettings = this.loadRenderingSettingsByOwner(pixelsList);
        Map<Long, RenderingDef> mySettings = this.loadRenderingSettings(pixelsList);
        HashSet<IObject> toSave = new HashSet<IObject>();
        for (Pixels pixels : pixelsList) {
            RenderingDef from = ownerSettings.get(pixels.getId());
            RenderingDef to = mySettings.get(pixels.getId());
            try {
                RenderingDef def = this.applySettings(pixels, pixels, from, to);
                if (def == null) continue;
                toSave.add(def);
                toReturn.add(pixels.getImage().getId());
            }
            catch (Exception e) {
                log.warn(String.format("Exception while applying settings from owner. %s from %s to %s", pixels, from, to), e);
            }
        }
        if (toSave.size() > 0) {
            this.iUpdate.saveCollection(toSave);
        }
        return toReturn;
    }

    @Override
    @RolesAllowed(value={"user"})
    public <T extends IObject> Set<Long> resetMinMaxInSet(Class<T> klass, Set<Long> nodeIds) {
        this.checkValidContainerClass(klass);
        Slf4JStopWatch s1 = new Slf4JStopWatch("omero.resetMinMaxInSet");
        List<Family> families = this.pixelsMetadata.getAllEnumerations(Family.class);
        List<RenderingModel> renderingModels = this.pixelsMetadata.getAllEnumerations(RenderingModel.class);
        ArrayList<Pixels> pixelsList = new ArrayList<Pixels>();
        this.updatePixelsForNodes(pixelsList, klass, nodeIds);
        HashSet<Long> toReturn = new HashSet<Long>();
        if (pixelsList.size() == 0) {
            return toReturn;
        }
        Map<Long, RenderingDef> mySettings = this.loadRenderingSettings(pixelsList);
        HashSet<IObject> toSave = new HashSet<IObject>();
        for (Pixels pixels : pixelsList) {
            RenderingDef settings = mySettings.get(pixels.getId());
            if (settings == null) {
                try {
                    settings = this.resetDefaults(settings, pixels, false, false, families, renderingModels);
                    if (settings != null) {
                        toReturn.add(pixels.getId());
                        toSave.add(settings);
                    }
                }
                catch (Exception e) {
                    log.warn("Exception while resetting settings.", e);
                }
            } else {
                for (int i = 0; i < pixels.sizeOfChannels(); ++i) {
                    double max;
                    double min;
                    ChannelBinding cb = settings.getChannelBinding(i);
                    StatsInfo stats = pixels.getChannel(i).getStatsInfo();
                    if (stats == null) {
                        double[] range = this.initPixelsRange(pixels);
                        min = range[0];
                        max = range[1];
                    } else {
                        min = stats.getGlobalMin();
                        max = stats.getGlobalMax();
                    }
                    cb.setInputStart(min);
                    cb.setInputEnd(max);
                }
                toReturn.add(pixels.getId());
                toSave.add(settings);
            }
            settings.setVersion(settings.getVersion() + 1);
        }
        if (toSave.size() > 0) {
            this.iUpdate.saveCollection(toSave);
        }
        ((StopWatch)s1).stop();
        return toReturn;
    }

    @Override
    @RolesAllowed(value={"user"})
    public void setOriginalSettingsInImage(long to) {
        HashSet<Long> nodeIds = new HashSet<Long>();
        nodeIds.add(to);
        this.setOriginalSettingsInSet(Image.class, nodeIds);
    }

    @Override
    @RolesAllowed(value={"user"})
    public void setOriginalSettingsForPixels(long to) {
        HashSet<Long> nodeIds = new HashSet<Long>();
        nodeIds.add(to);
        this.setOriginalSettingsInSet(Pixels.class, nodeIds);
    }

    @Override
    @RolesAllowed(value={"user"})
    public Set<Long> setOriginalSettingsInDataset(long to) {
        HashSet<Long> nodeIds = new HashSet<Long>();
        nodeIds.add(to);
        return this.setOriginalSettingsInSet(Dataset.class, nodeIds);
    }

    @Override
    @RolesAllowed(value={"user"})
    public <T extends IObject> Set<Long> setOriginalSettingsInSet(Class<T> klass, Set<Long> nodeIds) {
        return this.resetDefaultsInSet(klass, nodeIds, false);
    }
}

