/*
 * Decompiled with CFR 0.152.
 */
package ome.logic;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.AuthenticationException;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.ldap.InitialLdapContext;
import ome.annotations.RolesAllowed;
import ome.api.ILdap;
import ome.api.ServiceInterface;
import ome.conditions.ApiUsageException;
import ome.conditions.SecurityViolation;
import ome.conditions.ValidationException;
import ome.logic.AbstractLevel2Service;
import ome.model.meta.Experimenter;
import ome.model.meta.ExperimenterGroup;
import ome.model.meta.GroupExperimenterMap;
import ome.parameters.Parameters;
import ome.security.auth.AttributeNewUserGroupBean;
import ome.security.auth.AttributeSet;
import ome.security.auth.GroupAttributeMapper;
import ome.security.auth.GroupContextMapper;
import ome.security.auth.LdapConfig;
import ome.security.auth.NewUserGroupBean;
import ome.security.auth.NewUserGroupOwnerBean;
import ome.security.auth.OrgUnitNewUserGroupBean;
import ome.security.auth.PersonContextMapper;
import ome.security.auth.QueryNewUserGroupBean;
import ome.security.auth.RoleProvider;
import ome.system.OmeroContext;
import ome.system.Roles;
import ome.util.SqlAction;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.ldap.core.AttributesMapper;
import org.springframework.ldap.core.ContextMapper;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.DistinguishedName;
import org.springframework.ldap.core.LdapOperations;
import org.springframework.ldap.filter.AndFilter;
import org.springframework.ldap.filter.EqualsFilter;
import org.springframework.ldap.filter.Filter;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
public class LdapImpl
extends AbstractLevel2Service
implements ILdap,
ApplicationContextAware {
    private final SqlAction sql;
    private final RoleProvider provider;
    private final ContextSource ctx;
    private final LdapOperations ldap;
    private final LdapConfig config;
    private final Roles roles;
    private OmeroContext appContext;
    private static final Pattern p = Pattern.compile("^:(ou|attribute|filtered_attribute|dn_attribute|filtered_dn_attribute|query|bean):(.*)$");

    public LdapImpl(ContextSource ctx, LdapOperations ldap, Roles roles, LdapConfig config, RoleProvider roleProvider, SqlAction sql) {
        this.ctx = ctx;
        this.sql = sql;
        this.ldap = ldap;
        this.roles = roles;
        this.config = config;
        this.provider = roleProvider;
    }

    public void setApplicationContext(ApplicationContext arg0) throws BeansException {
        this.appContext = (OmeroContext)arg0;
    }

    @Override
    public Class<? extends ServiceInterface> getServiceInterface() {
        return ILdap.class;
    }

    @Override
    @RolesAllowed(value={"system"})
    public List<Experimenter> searchAll() {
        return this.ldap.search((Name)DistinguishedName.EMPTY_PATH, this.config.getUserFilter().encode(), (ContextMapper)this.getPersonContextMapper());
    }

    @Override
    @RolesAllowed(value={"system"})
    public List<Experimenter> searchByAttribute(String dns, String attr, String value) {
        DistinguishedName dn = dns == null ? DistinguishedName.EMPTY_PATH : new DistinguishedName(dns);
        if (attr != null && !attr.equals("") && value != null && !value.equals("")) {
            AndFilter filter = new AndFilter();
            filter.and(this.config.getUserFilter());
            filter.and((Filter)new EqualsFilter(attr, value));
            return this.ldap.search((Name)dn, filter.encode(), (ContextMapper)this.getPersonContextMapper());
        }
        return Collections.emptyList();
    }

    @Override
    @RolesAllowed(value={"system"})
    public Experimenter searchByDN(String dns) {
        DistinguishedName dn = new DistinguishedName(dns);
        return (Experimenter)this.ldap.lookup((Name)dn, (ContextMapper)this.getPersonContextMapper());
    }

    @Override
    @RolesAllowed(value={"system"})
    public String findDN(String username) {
        PersonContextMapper mapper = this.getPersonContextMapper();
        return mapper.getDn(this.findExperimenter(username));
    }

    @Override
    @RolesAllowed(value={"system"})
    public String findGroupDN(String groupname) {
        GroupContextMapper mapper = this.getGroupContextMapper();
        return mapper.getDn(this.findGroup(groupname));
    }

    @Override
    @RolesAllowed(value={"system"})
    public Experimenter findExperimenter(String username) {
        PersonContextMapper mapper = this.getPersonContextMapper();
        return this.mapUserName(username, mapper);
    }

    @Override
    @RolesAllowed(value={"system"})
    public ExperimenterGroup findGroup(String groupname) {
        GroupContextMapper mapper = this.getGroupContextMapper();
        return this.mapGroupName(groupname, mapper);
    }

    private Experimenter mapUserName(String username, PersonContextMapper mapper) {
        Filter filter = this.config.usernameFilter(username);
        List p = this.ldap.search("", filter.encode(), mapper.getControls(), (ContextMapper)mapper);
        if (p.size() == 1 && p.get(0) != null) {
            Experimenter e = (Experimenter)p.get(0);
            if (this.provider.isIgnoreCaseLookup() ? e.getOmeName().equalsIgnoreCase(username) : e.getOmeName().equals(username)) {
                return (Experimenter)p.get(0);
            }
        }
        throw new ApiUsageException("Cannot find unique user DistinguishedName: found=" + p.size());
    }

    private ExperimenterGroup mapGroupName(String groupname, GroupContextMapper mapper) {
        ExperimenterGroup grp;
        Filter filter = this.config.groupnameFilter(groupname);
        List g = this.ldap.search("", filter.encode(), mapper.getControls(), (ContextMapper)mapper);
        if (g.size() == 1 && g.get(0) != null && (grp = (ExperimenterGroup)g.get(0)).getName().equals(groupname)) {
            return (ExperimenterGroup)g.get(0);
        }
        throw new ApiUsageException("Cannot find unique group DistinguishedName: found=" + g.size());
    }

    @Override
    @RolesAllowed(value={"system"})
    public List<String> searchDnInGroups(String attr, String value) {
        if (attr != null && !attr.equals("") && value != null && !value.equals("")) {
            AndFilter filter = new AndFilter();
            filter.and(this.config.getGroupFilter());
            filter.and((Filter)new EqualsFilter(attr, value));
            return this.ldap.search("", filter.encode(), (AttributesMapper)new GroupAttributeMapper(this.config));
        }
        return Collections.emptyList();
    }

    @Override
    @RolesAllowed(value={"system"})
    public List<Experimenter> searchByAttributes(String dn, String[] attributes, String[] values) {
        if (attributes.length != values.length) {
            return Collections.emptyList();
        }
        AndFilter filter = new AndFilter();
        for (int i = 0; i < attributes.length; ++i) {
            filter.and((Filter)new EqualsFilter(attributes[i], values[i]));
        }
        return this.ldap.search((Name)new DistinguishedName(dn), filter.encode(), (ContextMapper)this.getPersonContextMapper());
    }

    @Override
    @RolesAllowed(value={"system"})
    @Transactional(readOnly=false)
    @Deprecated
    public void setDN(Long experimenterID, String dn) {
        Experimenter experimenter = this.iQuery.get(Experimenter.class, experimenterID);
        experimenter.setLdap(StringUtils.isNotBlank(dn));
        this.iUpdate.saveObject(experimenter);
    }

    @Override
    @RolesAllowed(value={"system"})
    public boolean getSetting() {
        return this.config.isEnabled();
    }

    public void synchronizeLdapUser(String username) {
        if (!this.config.isSyncOnLogin()) {
            if (this.getBeanHelper().getLogger().isTraceEnabled()) {
                this.getBeanHelper().getLogger().trace("sync_on_login=false");
            }
            return;
        }
        Experimenter omeExp = this.iQuery.findByString(Experimenter.class, "omeName", username);
        Experimenter ldapExp = this.findExperimenter(username);
        String ldapDN = this.getPersonContextMapper().getDn(ldapExp);
        DistinguishedName dn = new DistinguishedName(ldapDN);
        GroupLoader loader = new GroupLoader(username, dn);
        List<Long> ldapGroups = loader.getGroups();
        List<Long> ownedGroups = loader.getOwnedGroups();
        List<Object[]> currentGroups = this.iQuery.projection("select g.id, g.ldap from ExperimenterGroup g join g.groupExperimenterMap m join m.child e where e.id = :id", new Parameters().addId(omeExp.getId()));
        HashSet<Long> currentLdapGroups = new HashSet<Long>();
        for (Object[] objs : currentGroups) {
            Long id = (Long)objs[0];
            Boolean isLdap = (Boolean)objs[1];
            if (!isLdap.booleanValue()) continue;
            currentLdapGroups.add(id);
        }
        this.modifyGroups(omeExp, currentLdapGroups, ldapGroups, false);
        this.modifyGroups(omeExp, ldapGroups, currentLdapGroups, true);
        for (Long ldapGroupId : ldapGroups) {
            this.provider.setGroupOwner(omeExp, new ExperimenterGroup(ldapGroupId, false), ownedGroups.contains(ldapGroupId));
        }
        List<String> fields = Arrays.asList("ome.model.meta.Experimenter_firstName", "ome.model.meta.Experimenter_middleName", "ome.model.meta.Experimenter_lastName", "ome.model.meta.Experimenter_email", "ome.model.meta.Experimenter_institution");
        for (String field : fields) {
            String fieldname = field.substring(field.indexOf("_") + 1);
            String ome = (String)omeExp.retrieve(field);
            String ldap = (String)ldapExp.retrieve(field);
            if (ome == null) {
                if (ldap == null) continue;
                this.getBeanHelper().getLogger().info(String.format("Nulling %s for %s, was:", fieldname, username, ome));
                omeExp.putAt(field, ldap);
                continue;
            }
            if (ome.equals(ldap)) continue;
            this.getBeanHelper().getLogger().info(String.format("Changing %s for %s: %s -> %s", fieldname, username, ome, ldap));
            omeExp.putAt(field, ldap);
        }
        this.iUpdate.flush();
    }

    private void modifyGroups(Experimenter e, Collection<Long> base, Collection<Long> minus, boolean add) {
        Logger log = this.getBeanHelper().getLogger();
        HashSet<Long> ids = new HashSet<Long>(base);
        ids.removeAll(minus);
        ids.remove(this.roles.getSystemGroupId());
        ids.remove(this.roles.getUserGroupId());
        if (ids.size() > 0) {
            log.info(String.format("%s groups for %s: %s", add ? "Adding" : "Removing", e.getOmeName(), ids));
            HashSet<ExperimenterGroup> grps = new HashSet<ExperimenterGroup>();
            for (Long id : ids) {
                grps.add(new ExperimenterGroup(id, false));
            }
            if (add) {
                this.provider.addGroups(e, grps.toArray(new ExperimenterGroup[0]));
            } else {
                this.provider.removeGroups(e, grps.toArray(new ExperimenterGroup[0]));
            }
            if (add) {
                e = this.iQuery.get(Experimenter.class, e.getId());
                log.debug("sizeOfGroupExperimenterMap=" + e.sizeOfGroupExperimenterMap());
                if (e.sizeOfGroupExperimenterMap() > 1) {
                    GroupExperimenterMap primary = e.getGroupExperimenterMap(0);
                    GroupExperimenterMap next = e.getGroupExperimenterMap(1);
                    log.debug("primary=" + primary.parent().getId());
                    log.debug("next=" + next.parent().getId());
                    if (primary.parent().getId().equals(this.roles.getUserGroupId())) {
                        log.debug("calling setDefaultGroup");
                        this.provider.setDefaultGroup(e, next.parent());
                    }
                }
            }
        }
    }

    @Deprecated
    @RolesAllowed(value={"system"})
    @Transactional(readOnly=false)
    public boolean createUserFromLdap(String username, String password) {
        return null != this.createUser(username, password, true);
    }

    @Override
    @RolesAllowed(value={"system"})
    @Transactional(readOnly=false)
    public Experimenter createUser(String username) {
        return this.createUser(username, null, false);
    }

    public Experimenter createUser(String username, String password) {
        return this.createUser(username, password, true);
    }

    public Experimenter createUser(String username, String password, boolean checkPassword) {
        if (this.provider.isIgnoreCaseLookup()) {
            username = username.toLowerCase();
        }
        if (this.iQuery.findByString(Experimenter.class, "omeName", username) != null) {
            throw new ValidationException("User already exists: " + username);
        }
        Experimenter exp = this.findExperimenter(username);
        String ldapDn = this.getPersonContextMapper().getDn(exp);
        DistinguishedName dn = new DistinguishedName(ldapDn);
        boolean access = true;
        if (checkPassword) {
            access = this.validatePassword(dn.toString(), password);
        }
        if (access) {
            GroupLoader loader = new GroupLoader(username, dn);
            List<Long> groups = loader.getGroups();
            List<Long> ownerOfGroups = loader.getOwnedGroups();
            if (groups.size() == 0) {
                throw new ValidationException("No group found for: " + dn);
            }
            Long gid = groups.remove(0);
            ExperimenterGroup grp1 = new ExperimenterGroup(gid, false);
            HashSet<Long> otherGroupIds = new HashSet<Long>(groups);
            ExperimenterGroup[] grpOther = new ExperimenterGroup[otherGroupIds.size() + 1];
            int count = 0;
            for (Long id : otherGroupIds) {
                grpOther[count++] = new ExperimenterGroup(id, false);
            }
            grpOther[count] = new ExperimenterGroup(this.roles.getUserGroupId(), false);
            long uid = this.provider.createExperimenter(exp, grp1, grpOther);
            for (Long toBeOwned : ownerOfGroups) {
                this.provider.setGroupOwner(new Experimenter(uid, false), new ExperimenterGroup(toBeOwned, false), true);
            }
            return this.iQuery.get(Experimenter.class, uid);
        }
        return null;
    }

    @Deprecated
    public List<Long> loadLdapGroups(String username, DistinguishedName dn) {
        return new GroupLoader(username, dn).getGroups();
    }

    private AttributeSet getAttributeSet(String username, PersonContextMapper mapper) {
        Experimenter exp = this.mapUserName(username, mapper);
        String dn = mapper.getDn(exp);
        AttributeSet attrSet = mapper.getAttributeSet(exp);
        attrSet.put("dn", dn);
        return attrSet;
    }

    public boolean validatePassword(String dn, String password) {
        try {
            this.isAuthContext(dn, password);
            return true;
        }
        catch (SecurityViolation sv) {
            return false;
        }
    }

    public List<Map<String, Object>> lookupLdapAuthExperimenters() {
        List<Long> ldapExperimenters = this.sql.getLdapExperimenters();
        ArrayList<Map<String, Object>> rv = Lists.newArrayListWithExpectedSize(ldapExperimenters.size());
        for (Long id : ldapExperimenters) {
            HashMap<String, Object> values = Maps.newHashMap();
            try {
                values.put("dn", this.lookupLdapAuthExperimenter(id));
            }
            catch (ApiUsageException aue) {
                values.put("dn", "ERROR");
            }
            values.put("experimenter_id", id);
            rv.add(values);
        }
        return rv;
    }

    public String lookupLdapAuthExperimenter(Long id) {
        String dn = null;
        Experimenter experimenter = this.iQuery.get(Experimenter.class, id);
        if (experimenter.getLdap().booleanValue()) {
            dn = this.findDN(experimenter.getOmeName());
        }
        return dn;
    }

    @Override
    @RolesAllowed(value={"system"})
    public List<Experimenter> discover() {
        ArrayList<Experimenter> discoveredExperimenters = Lists.newArrayList();
        Roles r = this.getSecuritySystem().getSecurityRoles();
        List localExperimenters = this.iQuery.findAllByQuery("select distinct e from Experimenter e where id not in (:ids) and ldap = :ldap", new Parameters().addIds(Lists.newArrayList(r.getRootId(), r.getGuestId())).addBoolean("ldap", false));
        for (Experimenter e : localExperimenters) {
            try {
                this.findExperimenter(e.getOmeName());
            }
            catch (ApiUsageException aue) {
                continue;
            }
            discoveredExperimenters.add(e);
        }
        return discoveredExperimenters;
    }

    @Override
    @RolesAllowed(value={"system"})
    public List<ExperimenterGroup> discoverGroups() {
        ArrayList<ExperimenterGroup> discoveredGroups = Lists.newArrayList();
        Roles r = this.getSecuritySystem().getSecurityRoles();
        List localGroups = this.iQuery.findAllByQuery("select distinct g from ExperimenterGroup g where id not in (:ids) and ldap = :ldap", new Parameters().addIds(Lists.newArrayList(r.getGuestGroupId(), r.getSystemGroupId(), r.getUserGroupId())).addBoolean("ldap", false));
        for (ExperimenterGroup g : localGroups) {
            try {
                this.findGroup(g.getName());
            }
            catch (ApiUsageException aue) {
                continue;
            }
            discoveredGroups.add(g);
        }
        return discoveredGroups;
    }

    private PersonContextMapper getPersonContextMapper() {
        return new PersonContextMapper(this.config, this.getBase());
    }

    private PersonContextMapper getPersonContextMapper(String attr) {
        return new PersonContextMapper(this.config, this.getBase(), attr);
    }

    private GroupContextMapper getGroupContextMapper() {
        return new GroupContextMapper(this.config, this.getBase());
    }

    private GroupContextMapper getGroupContextMapper(String attr) {
        return new GroupContextMapper(this.config, this.getBase(), attr);
    }

    private void isAuthContext(String username, String password) {
        Hashtable<Object, Object> env = new Hashtable(5, 0.75f);
        try {
            if (username == null || username.equals("") || password == null || password.equals("")) {
                throw new SecurityViolation("Refused to authenticate without username and password!");
            }
            env = this.ctx.getReadOnlyContext().getEnvironment();
            env.put("java.naming.security.principal", username);
            env.put("java.naming.security.credentials", password);
            new InitialLdapContext(env, null);
        }
        catch (AuthenticationException authEx) {
            throw new SecurityViolation("Authentication falilure! " + authEx.toString());
        }
        catch (NamingException e) {
            throw new SecurityViolation("Naming exception! " + e.toString());
        }
    }

    private String getBase() {
        String base = null;
        try {
            base = this.ctx.getReadOnlyContext().getNameInNamespace();
        }
        catch (NamingException e) {
            throw new ApiUsageException("Cannot get BASE from ContextSource. Naming exception! " + e.toString());
        }
        return base;
    }

    public class GroupLoader {
        final String username;
        final DistinguishedName dn;
        final String grpSpec;
        final List<Long> groups;
        final List<Long> ownedGroups;
        final NewUserGroupBean bean;
        final AttributeSet attrSet;

        List<Long> getGroups() {
            return this.groups;
        }

        public List<Long> getOwnedGroups() {
            return this.ownedGroups;
        }

        GroupLoader(String username, DistinguishedName dn) {
            this.username = username;
            this.dn = dn;
            this.grpSpec = LdapImpl.this.config.getNewUserGroup();
            this.groups = new ArrayList<Long>();
            this.ownedGroups = new ArrayList<Long>();
            if (!this.grpSpec.startsWith(":")) {
                this.groups.add(LdapImpl.this.provider.createGroup(this.grpSpec, null, false, true));
                this.bean = null;
                this.attrSet = null;
                return;
            }
            Matcher m = p.matcher(this.grpSpec);
            if (!m.matches()) {
                throw new ValidationException(this.grpSpec + " spec currently not supported.");
            }
            String type = m.group(1);
            String data = m.group(2);
            if ("ou".equals(type)) {
                this.bean = new OrgUnitNewUserGroupBean(dn);
                this.attrSet = LdapImpl.this.getAttributeSet(username, LdapImpl.this.getPersonContextMapper());
            } else if ("filtered_attribute".equals(type)) {
                this.bean = new AttributeNewUserGroupBean(data, true, false);
                this.attrSet = LdapImpl.this.getAttributeSet(username, LdapImpl.this.getPersonContextMapper(data));
            } else if ("attribute".equals(type)) {
                this.bean = new AttributeNewUserGroupBean(data, false, false);
                this.attrSet = LdapImpl.this.getAttributeSet(username, LdapImpl.this.getPersonContextMapper(data));
            } else if ("filtered_dn_attribute".equals(type)) {
                this.bean = new AttributeNewUserGroupBean(data, true, true);
                this.attrSet = LdapImpl.this.getAttributeSet(username, LdapImpl.this.getPersonContextMapper(data));
            } else if ("dn_attribute".equals(type)) {
                this.bean = new AttributeNewUserGroupBean(data, false, true);
                this.attrSet = LdapImpl.this.getAttributeSet(username, LdapImpl.this.getPersonContextMapper(data));
            } else if ("query".equals(type)) {
                this.bean = new QueryNewUserGroupBean(data);
                this.attrSet = LdapImpl.this.getAttributeSet(username, LdapImpl.this.getPersonContextMapper());
            } else if ("bean".equals(type)) {
                this.bean = (NewUserGroupBean)LdapImpl.this.appContext.getBean(data, NewUserGroupBean.class);
                this.attrSet = LdapImpl.this.getAttributeSet(username, LdapImpl.this.getPersonContextMapper());
            } else {
                throw new RuntimeException("Unknown spec: " + this.grpSpec);
            }
            this.groups.addAll(this.bean.groups(username, LdapImpl.this.config, LdapImpl.this.ldap, LdapImpl.this.provider, this.attrSet));
            if (this.bean instanceof NewUserGroupOwnerBean) {
                this.ownedGroups.addAll(((NewUserGroupOwnerBean)((Object)this.bean)).ownerOfGroups(username, LdapImpl.this.config, LdapImpl.this.ldap, LdapImpl.this.provider, this.attrSet));
            }
        }
    }
}

