/*
 * Decompiled with CFR 0.152.
 */
package ome.logic;

import com.mortennobel.imagescaling.ResampleOp;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import ome.api.IScale;
import org.perf4j.StopWatch;
import org.perf4j.slf4j.Slf4JStopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaImageScalingService
implements IScale {
    private static Logger log = LoggerFactory.getLogger(JavaImageScalingService.class);

    @Override
    public BufferedImage scaleBufferedImage(BufferedImage image, float xScale, float yScale) {
        BufferedImage toReturn;
        int thumbHeight = (int)((float)image.getHeight() * yScale);
        int thumbWidth = (int)((float)image.getWidth() * xScale);
        if (thumbHeight < 3) {
            thumbHeight = 3;
        }
        if (thumbWidth < 3) {
            thumbWidth = 3;
        }
        log.info("Scaling to: " + thumbHeight + "x" + thumbWidth);
        Slf4JStopWatch s1 = new Slf4JStopWatch("java-image-scaling.resampleOp");
        if (image.getHeight() >= 3 && image.getWidth() >= 3) {
            ResampleOp resampleOp = new ResampleOp(thumbWidth, thumbHeight);
            toReturn = resampleOp.filter(image, null);
        } else {
            toReturn = new BufferedImage(thumbWidth, thumbHeight, image.getType());
            Graphics2D g = toReturn.createGraphics();
            g.getRenderingHints().add(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF));
            g.drawImage(image, 0, 0, thumbWidth, thumbHeight, 0, 0, image.getWidth(), image.getHeight(), null);
        }
        ((StopWatch)s1).stop();
        return toReturn;
    }
}

