/*
 * Decompiled with CFR 0.152.
 */
package ome.logic;

import java.io.File;
import java.io.FileReader;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ome.annotations.PermitAll;
import ome.annotations.RolesAllowed;
import ome.api.IConfig;
import ome.api.ServiceInterface;
import ome.api.local.LocalConfig;
import ome.conditions.ApiUsageException;
import ome.conditions.InternalException;
import ome.conditions.OptimisticLockException;
import ome.conditions.SecurityViolation;
import ome.logic.AbstractLevel2Service;
import ome.security.basic.CurrentDetails;
import ome.services.db.DatabaseIdentity;
import ome.system.PreferenceContext;
import ome.util.SqlAction;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class ConfigImpl
extends AbstractLevel2Service
implements LocalConfig {
    private transient SqlAction sql;
    private transient PreferenceContext prefs;
    private transient CurrentDetails currentDetails;
    private transient DatabaseIdentity db;
    private final transient ReadWriteLock lock = new ReentrantReadWriteLock();

    public final void setSqlAction(SqlAction sql) {
        this.getBeanHelper().throwIfAlreadySet(this.sql, sql);
        this.sql = sql;
    }

    public final void setPreferenceContext(PreferenceContext prefs) {
        this.getBeanHelper().throwIfAlreadySet((Object)this.prefs, (Object)prefs);
        this.prefs = prefs;
    }

    public final void setCurrentDetails(CurrentDetails currentDetails) {
        this.getBeanHelper().throwIfAlreadySet(this.currentDetails, currentDetails);
        this.currentDetails = currentDetails;
    }

    public final void setDatabaseIdentity(DatabaseIdentity db) {
        this.db = db;
    }

    @Override
    public final Class<? extends ServiceInterface> getServiceInterface() {
        return IConfig.class;
    }

    @Override
    @PermitAll
    public Date getServerTime() {
        return new Date();
    }

    @Override
    @PermitAll
    public Date getDatabaseTime() {
        Date date = this.sql.now();
        return date;
    }

    @Override
    @PermitAll
    public String getConfigValue(String key) {
        if (key == null) {
            return "";
        }
        key = this.prefs.resolveAlias(key);
        if (!this.prefs.canRead(this.currentDetails.getCurrentEventContext(), key)) {
            throw new SecurityViolation("Cannot read configuration: " + key);
        }
        return this.getInternalValue(key);
    }

    @Override
    @PermitAll
    public Map<String, String> getConfigValues(String keyRegex) {
        if (keyRegex == null) {
            return Collections.emptyMap();
        }
        Pattern p = Pattern.compile(keyRegex);
        HashMap<String, String> rv = new HashMap<String, String>();
        Set<String> keys = this.prefs.getKeySet();
        for (String key : keys) {
            if (!p.matcher(key).find() || !this.prefs.canRead(this.currentDetails.getCurrentEventContext(), key)) continue;
            rv.put(key, this.getInternalValue(key));
        }
        return rv;
    }

    @Override
    @RolesAllowed(value={"system"})
    public Map<String, String> getConfigDefaults() {
        File etc = new File("etc");
        File omero = new File(etc, "omero.properties");
        Properties p = new Properties();
        HashMap<String, String> rv = new HashMap<String, String>();
        try {
            FileReader r = new FileReader(omero);
            p.load(r);
            for (Map.Entry<Object, Object> entry : p.entrySet()) {
                rv.put(entry.getKey().toString(), entry.getValue().toString());
            }
            return rv;
        }
        catch (Exception e) {
            InternalException ie = new InternalException(e.getMessage());
            ie.initCause(e);
            throw ie;
        }
    }

    @Override
    @PermitAll
    public Map<String, String> getClientConfigValues() {
        return this.getConfigValues("^omero\\.client\\.");
    }

    @Override
    @PermitAll
    public Map<String, String> getClientConfigDefaults() {
        Map<String, String> rv = this.getConfigDefaults();
        HashMap<String, String> copy = new HashMap<String, String>();
        for (Map.Entry<String, String> e : rv.entrySet()) {
            if (!e.getKey().startsWith("omero.client")) continue;
            copy.put(e.getKey(), e.getValue());
        }
        return copy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getInternalValue(String key) {
        key = this.prefs.resolveAlias(key);
        this.lock.readLock().lock();
        try {
            String value = null;
            if (this.prefs.checkDatabase(key)) {
                value = this.fromDatabase(key);
            }
            if (value != null) {
                String string = value;
                return string;
            }
            String string = this.prefs.getProperty(key);
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @RolesAllowed(value={"system"})
    public void setConfigValue(String key, String value) {
        key = this.prefs.resolveAlias(key);
        this.lock.writeLock().lock();
        try {
            String current;
            boolean set = false;
            if (this.prefs.checkDatabase(key) && (current = this.fromDatabase(key)) != null && current.length() > 0) {
                int count = this.sql.updateConfiguration(key, value);
                if (count != 1) {
                    throw new OptimisticLockException("Configuration tabled during modification of : " + key);
                }
                set = true;
            }
            if (!set) {
                System.setProperty(key, value);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @RolesAllowed(value={"user"})
    public boolean setConfigValueIfEquals(String key, String value, String test) throws ApiUsageException, SecurityViolation {
        key = this.prefs.resolveAlias(key);
        this.lock.writeLock().lock();
        try {
            String current = this.getInternalValue(key);
            if (test == null) {
                if (current != null) {
                    boolean bl = false;
                    return bl;
                }
            } else if (!test.equals(current)) {
                boolean bl = false;
                return bl;
            }
            this.setConfigValue(key, value);
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    @PermitAll
    public String getVersion() {
        String version = this.getInternalValue("omero.version");
        Pattern p = Pattern.compile("^.*?[-]?(\\d+[.]\\d+[.]\\d+)[-]?.*?$");
        Matcher m = p.matcher(version);
        if (!m.matches()) {
            throw new InternalException("Bad version format:" + version);
        }
        return m.group(1);
    }

    @Override
    @PermitAll
    public String getDatabaseVersion() {
        return this.sql.dbVersion();
    }

    @Override
    @PermitAll
    public String getDatabaseUuid() {
        return this.db.getUuid();
    }

    private String fromDatabase(String key) {
        String value = null;
        try {
            value = this.sql.configValue(key);
        }
        catch (EmptyResultDataAccessException emptyResultDataAccessException) {
            // empty catch block
        }
        return value;
    }
}

