/*
 * Decompiled with CFR 0.152.
 */
package ome.logic;

import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.Table;
import ome.annotations.NotNull;
import ome.annotations.PermitAll;
import ome.annotations.RolesAllowed;
import ome.api.IAdmin;
import ome.api.RawFileStore;
import ome.api.ServiceInterface;
import ome.api.local.LocalAdmin;
import ome.conditions.ApiUsageException;
import ome.conditions.AuthenticationException;
import ome.conditions.InternalException;
import ome.conditions.SecurityViolation;
import ome.conditions.ValidationException;
import ome.logic.AbstractLevel2Service;
import ome.logic.LdapImpl;
import ome.model.IGlobal;
import ome.model.IObject;
import ome.model.annotations.ExperimenterAnnotationLink;
import ome.model.annotations.FileAnnotation;
import ome.model.core.Image;
import ome.model.core.OriginalFile;
import ome.model.core.Pixels;
import ome.model.enums.ChecksumAlgorithm;
import ome.model.internal.Permissions;
import ome.model.meta.Experimenter;
import ome.model.meta.ExperimenterGroup;
import ome.model.meta.GroupExperimenterMap;
import ome.parameters.Parameters;
import ome.security.ACLVoter;
import ome.security.AdminAction;
import ome.security.ChmodStrategy;
import ome.security.SecureAction;
import ome.security.auth.PasswordChangeException;
import ome.security.auth.PasswordProvider;
import ome.security.auth.PasswordUtil;
import ome.security.auth.RoleProvider;
import ome.services.query.Definitions;
import ome.services.query.Query;
import ome.services.query.QueryParameterDef;
import ome.services.sessions.events.UserGroupUpdateEvent;
import ome.system.EventContext;
import ome.system.OmeroContext;
import ome.system.Roles;
import ome.system.SimpleEventContext;
import ome.tools.hibernate.QueryBuilder;
import ome.tools.hibernate.SecureMerge;
import ome.tools.hibernate.SessionFactory;
import ome.util.SqlAction;
import ome.util.Utils;
import ome.util.checksum.ChecksumProviderFactory;
import ome.util.checksum.ChecksumType;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.slf4j.Logger;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.mail.MailSender;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Transactional(readOnly=true)
public class AdminImpl
extends AbstractLevel2Service
implements LocalAdmin,
ApplicationContextAware {
    protected final SqlAction sql;
    protected final SessionFactory osf;
    protected final MailSender mailSender;
    protected final SimpleMailMessage templateMessage;
    protected final ACLVoter aclVoter;
    protected final PasswordProvider passwordProvider;
    protected final RoleProvider roleProvider;
    protected final PasswordUtil passwordUtil;
    protected final LdapImpl ldapUtil;
    protected final ChmodStrategy chmod;
    protected final ChecksumProviderFactory cpf;
    protected OmeroContext context;
    protected static final String NSEXPERIMENTERPHOTO = "openmicroscopy.org/omero/experimenter/photo";

    public void setApplicationContext(ApplicationContext ctx) throws BeansException {
        this.context = (OmeroContext)ctx;
    }

    public AdminImpl(SqlAction sql, SessionFactory osf, MailSender mailSender, SimpleMailMessage templateMessage, ACLVoter aclVoter, PasswordProvider passwordProvider, RoleProvider roleProvider, LdapImpl ldapUtil, PasswordUtil passwordUtil, ChmodStrategy chmod, ChecksumProviderFactory cpf) {
        this.sql = sql;
        this.osf = osf;
        this.mailSender = mailSender;
        this.templateMessage = templateMessage;
        this.aclVoter = aclVoter;
        this.passwordProvider = passwordProvider;
        this.roleProvider = roleProvider;
        this.ldapUtil = ldapUtil;
        this.passwordUtil = passwordUtil;
        this.chmod = chmod;
        this.cpf = cpf;
    }

    @Override
    public Class<? extends ServiceInterface> getServiceInterface() {
        return IAdmin.class;
    }

    @Override
    @RolesAllowed(value={"user"})
    public Experimenter userProxy(Long id) {
        if (id == null) {
            throw new ApiUsageException("Id argument cannot be null.");
        }
        Experimenter e = this.iQuery.get(Experimenter.class, id);
        return e;
    }

    @Override
    @RolesAllowed(value={"user"})
    public Experimenter userProxy(String omeName) {
        if (omeName == null) {
            throw new ApiUsageException("omeName argument cannot be null.");
        }
        Experimenter e = this.iQuery.findByString(Experimenter.class, "omeName", this.roleProvider.isIgnoreCaseLookup() ? omeName.toLowerCase() : omeName);
        if (e == null) {
            throw new ApiUsageException("No such experimenter: " + omeName);
        }
        return e;
    }

    @Override
    @RolesAllowed(value={"user"})
    public ExperimenterGroup groupProxy(Long id) {
        if (id == null) {
            throw new ApiUsageException("Id argument cannot be null.");
        }
        ExperimenterGroup g = this.iQuery.get(ExperimenterGroup.class, id);
        return g;
    }

    @Override
    @RolesAllowed(value={"user"})
    public ExperimenterGroup groupProxy(String groupName) {
        if (groupName == null) {
            throw new ApiUsageException("groupName argument cannot be null.");
        }
        ExperimenterGroup g = this.iQuery.findByString(ExperimenterGroup.class, "name", groupName);
        if (g == null) {
            throw new ApiUsageException("No such group: " + groupName);
        }
        return g;
    }

    @Override
    @RolesAllowed(value={"user"})
    public List<Long> getLeaderOfGroupIds(Experimenter e) {
        Assert.notNull(e);
        Assert.notNull(e.getId());
        final QueryBuilder qb = new QueryBuilder();
        qb.select("g.id").from("ExperimenterGroup", "g");
        qb.join("g.groupExperimenterMap", "m", false, false);
        qb.where();
        qb.and("m.owner = true");
        qb.and("m.parent.id = g.id");
        qb.and("m.child.id = :id");
        qb.param("id", (Object)e.getId());
        List groupIds = (List)this.iQuery.execute((HibernateCallback)new HibernateCallback<List<Long>>(){

            public List<Long> doInHibernate(Session session) throws HibernateException, SQLException {
                org.hibernate.Query q = qb.query(session);
                return q.list();
            }
        });
        return groupIds;
    }

    @Override
    @RolesAllowed(value={"user"})
    public List<Long> getMemberOfGroupIds(Experimenter e) {
        return this.getGroupField(e, "id");
    }

    @Override
    @RolesAllowed(value={"user"})
    public List<String> getUserRoles(Experimenter e) {
        return this.getGroupField(e, "name");
    }

    private List getGroupField(final Experimenter e, final String name) {
        Assert.notNull(e);
        Assert.notNull(e.getId());
        List groupNames = (List)this.iQuery.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                org.hibernate.Query q = session.createQuery("select m.parent." + name + " from Experimenter e join e.groupExperimenterMap m where e.id = :id order by index(m)");
                q.setParameter("id", (Object)e.getId());
                return q.list();
            }
        });
        return groupNames;
    }

    @Override
    @RolesAllowed(value={"user"})
    public boolean canAnnotate(IObject obj) {
        if (obj == null) {
            throw new ApiUsageException("Argument cannot be null");
        }
        Class<?> c = Utils.trueClass(obj.getClass());
        Object trusted = this.iQuery.get(c, obj.getId());
        return this.aclVoter.allowAnnotate((IObject)trusted, trusted.getDetails());
    }

    @Override
    @RolesAllowed(value={"user"})
    public boolean canUpdate(IObject obj) {
        if (obj == null) {
            throw new ApiUsageException("Argument cannot be null");
        }
        Class<?> c = Utils.trueClass(obj.getClass());
        Object trusted = this.iQuery.get(c, obj.getId());
        return this.aclVoter.allowUpdate((IObject)trusted, trusted.getDetails());
    }

    @Override
    @RolesAllowed(value={"user"})
    public Experimenter getExperimenter(long id) {
        Experimenter e = this.iQuery.execute(new UserQ(new Parameters().addId(id)));
        if (e == null) {
            throw new ApiUsageException("No such experimenter: " + id);
        }
        return e;
    }

    @Override
    @RolesAllowed(value={"user"})
    public Experimenter lookupExperimenter(String omeName) {
        Experimenter e = this.iQuery.execute(new UserQ(new Parameters().addString("name", this.roleProvider.isIgnoreCaseLookup() ? omeName.toLowerCase() : omeName)));
        if (e == null) {
            throw new ApiUsageException("No such experimenter: " + omeName);
        }
        return e;
    }

    @Override
    @RolesAllowed(value={"user"})
    public List<Experimenter> lookupExperimenters() {
        return this.iQuery.findAllByQuery("select distinct e from Experimenter e left outer join fetch e.groupExperimenterMap m left outer join fetch m.parent g", null);
    }

    @Override
    @RolesAllowed(value={"user"})
    public List<Map<String, Object>> lookupLdapAuthExperimenters() {
        return this.ldapUtil.lookupLdapAuthExperimenters();
    }

    @Override
    @RolesAllowed(value={"user"})
    public String lookupLdapAuthExperimenter(long id) {
        return this.ldapUtil.lookupLdapAuthExperimenter(id);
    }

    @Override
    @RolesAllowed(value={"user"})
    public ExperimenterGroup getGroup(long id) {
        ExperimenterGroup g = this.iQuery.execute(new GroupQ(new Parameters().addId(id)));
        if (g == null) {
            throw new ApiUsageException("No such group: " + id);
        }
        return g;
    }

    @Override
    @RolesAllowed(value={"user"})
    public ExperimenterGroup lookupGroup(String groupName) {
        ExperimenterGroup g = this.iQuery.execute(new GroupQ(new Parameters().addString("name", groupName)));
        if (g == null) {
            throw new ApiUsageException("No such group: " + groupName);
        }
        return g;
    }

    @Override
    @RolesAllowed(value={"user"})
    public List<ExperimenterGroup> lookupGroups() {
        return this.iQuery.findAllByQuery("select distinct g from ExperimenterGroup g left outer join fetch g.groupExperimenterMap m left outer join fetch m.child u left outer join fetch u.groupExperimenterMap m2 left outer join fetch m2.parent", null);
    }

    @Override
    @RolesAllowed(value={"user"})
    public Experimenter[] containedExperimenters(long groupId) {
        List<Experimenter> experimenters = this.iQuery.findAllByQuery("select distinct e from Experimenter as e join fetch e.groupExperimenterMap as map join fetch map.parent g where e.id in   (select m.child from GroupExperimenterMap m   where m.parent.id = :id )", new Parameters().addId(groupId));
        return experimenters.toArray(new Experimenter[experimenters.size()]);
    }

    @Override
    @RolesAllowed(value={"user"})
    public ExperimenterGroup[] containedGroups(long experimenterId) {
        List<ExperimenterGroup> groups = this.iQuery.findAllByQuery("select distinct g from ExperimenterGroup as g join fetch g.groupExperimenterMap as map join fetch map.parent e left outer join fetch map.child u left outer join fetch u.groupExperimenterMap m2 where g.id in   (select m.parent from GroupExperimenterMap m   where m.child.id = :id )", new Parameters().addId(experimenterId));
        return groups.toArray(new ExperimenterGroup[groups.size()]);
    }

    @Override
    @RolesAllowed(value={"system"})
    @Transactional(readOnly=false)
    public void synchronizeLoginCache() {
        Logger log = this.getBeanHelper().getLogger();
        List<Map<String, Object>> dnIds = this.ldapUtil.lookupLdapAuthExperimenters();
        if (dnIds.size() > 0) {
            log.info("Synchronizing " + dnIds.size() + " ldap user(s)");
        }
        for (Map<String, Object> dnId : dnIds) {
            String dn = (String)dnId.get("dn");
            Long id = (Long)dnId.get("experimenter_id");
            try {
                Experimenter e = this.userProxy(id);
                this.ldapUtil.synchronizeLdapUser(e.getOmeName());
            }
            catch (ApiUsageException aue) {
                log.debug("User not found: " + dn);
            }
            catch (Exception e) {
                log.error("synchronizeLdapUser:" + dnId, e);
            }
        }
        this.context.publishEvent(new UserGroupUpdateEvent(this));
    }

    @Override
    @RolesAllowed(value={"user"})
    @Transactional(readOnly=false)
    public void updateSelf(@NotNull Experimenter e) {
        EventContext ec = this.getSecuritySystem().getEventContext();
        Experimenter self = this.getExperimenter(ec.getCurrentUserId());
        self.setFirstName(e.getFirstName());
        self.setMiddleName(e.getMiddleName());
        self.setLastName(e.getLastName());
        self.setEmail(e.getEmail());
        self.setInstitution(e.getInstitution());
        this.getSecuritySystem().runAsAdmin(new AdminAction(){

            @Override
            public void runAsAdmin() {
                AdminImpl.this.iUpdate.flush();
            }
        });
        this.getBeanHelper().getLogger().info("Updated own user info: " + self.getOmeName());
    }

    @Override
    public List<OriginalFile> getMyUserPhotos() {
        Parameters parameters = new Parameters();
        parameters.addId(this.getEventContext().getCurrentUserId());
        parameters.addString("ns", NSEXPERIMENTERPHOTO);
        List<OriginalFile> photos = this.iQuery.findAllByQuery("select f from Experimenter e join e.annotationLinks l join l.child a join a.file f where e.id = :id and a.ns = :ns", parameters);
        return photos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @RolesAllowed(value={"user"})
    @Transactional(readOnly=false)
    public long uploadMyUserPhoto(String filename, String mimetype, byte[] data) {
        Long uid = this.getEventContext().getCurrentUserId();
        List<OriginalFile> photos = this.getMyUserPhotos();
        OriginalFile file2 = null;
        if (photos.size() > 0) {
            file2 = photos.get(0);
        }
        if (file2 == null) {
            file2 = new OriginalFile();
            file2.setName(filename);
            file2.setPath(filename);
            file2.setSize(Long.valueOf(data.length));
            file2.setHasher(new ChecksumAlgorithm("SHA1-160"));
            file2.setHash(this.cpf.getProvider(ChecksumType.SHA1).putBytes(data).checksumAsString());
            file2.setMimetype(mimetype);
            FileAnnotation fa = new FileAnnotation();
            fa.setNs(NSEXPERIMENTERPHOTO);
            fa.setFile(file2);
            ExperimenterAnnotationLink link = new ExperimenterAnnotationLink();
            link.link(new Experimenter(uid, false), fa);
            link = this.iUpdate.saveAndReturnObject(link);
            fa = (FileAnnotation)link.getChild();
            file2 = fa.getFile();
            this.internalMoveToCommonSpace(file2);
            this.internalMoveToCommonSpace(fa);
            this.internalMoveToCommonSpace(link);
        } else {
            file2.setName(filename);
            file2.setPath(filename);
            file2.setMimetype(mimetype);
            file2 = this.iUpdate.saveAndReturnObject(file2);
        }
        try (RawFileStore rfs = (RawFileStore)this.context.getBean("internal-ome.api.RawFileStore");){
            rfs.setFileId(file2.getId());
            rfs.write(data, 0L, data.length);
            file2 = rfs.save();
        }
        return file2.getId();
    }

    @Override
    @RolesAllowed(value={"user"})
    @Transactional(readOnly=false)
    public void updateExperimenter(@NotNull Experimenter experimenter) {
        try {
            this.adminOrPiOfUser(experimenter);
            String name = experimenter.getOmeName();
            this.copyAndSaveExperimenter(experimenter);
            this.getBeanHelper().getLogger().info("Updated user info for " + name);
        }
        catch (SecurityViolation sv) {
            Long currentID = this.getEventContext().getCurrentUserId();
            Long experimenterID = experimenter.getId();
            if (currentID.equals(experimenterID)) {
                this.updateSelf(experimenter);
            }
            throw sv;
        }
    }

    @Override
    @RolesAllowed(value={"user"})
    @Transactional(readOnly=false)
    public void updateExperimenterWithPassword(@NotNull Experimenter experimenter, String password) {
        this.adminOrPiOfUser(experimenter);
        this.copyAndSaveExperimenter(experimenter);
        Experimenter orig = this.userProxy(experimenter.getId());
        String name = orig.getOmeName();
        this.changeUserPassword(name, password);
        this.getBeanHelper().getLogger().info("Updated user info and password for " + name);
    }

    private void copyAndSaveExperimenter(Experimenter experimenter) {
        String newOmeName;
        Experimenter orig = this.userProxy(experimenter.getId());
        String origOmeName = orig.getOmeName();
        if (!origOmeName.equals(newOmeName = experimenter.getOmeName())) {
            Roles roles = this.getSecurityRoles();
            ImmutableSet<String> fixedExperimenterNames = ImmutableSet.of(roles.getRootName(), roles.getGuestName());
            if (fixedExperimenterNames.contains(origOmeName)) {
                throw new ValidationException("cannot change name of special experimenter '" + origOmeName + "'");
            }
            if (fixedExperimenterNames.contains(newOmeName)) {
                throw new ValidationException("cannot change name to special experimenter '" + newOmeName + "'");
            }
        }
        orig.setOmeName(newOmeName);
        orig.setEmail(experimenter.getEmail());
        orig.setFirstName(experimenter.getFirstName());
        orig.setMiddleName(experimenter.getMiddleName());
        orig.setLastName(experimenter.getLastName());
        orig.setInstitution(experimenter.getInstitution());
        this.reallySafeSave(orig);
    }

    @Override
    @RolesAllowed(value={"user"})
    @Transactional(readOnly=false)
    public void updateGroup(@NotNull ExperimenterGroup group) {
        String newName;
        ExperimenterGroup orig;
        String origName;
        this.adminOrPiOfGroup(group);
        Permissions p = group.getDetails().getPermissions();
        if (p != null) {
            this.changePermissions(group, p);
        }
        if (!(origName = (orig = this.getGroup(group.getId())).getName()).equals(newName = group.getName())) {
            Roles roles = this.getSecurityRoles();
            ImmutableSet<String> fixedGroupNames = ImmutableSet.of(roles.getGuestGroupName(), roles.getSystemGroupName(), roles.getUserGroupName());
            if (fixedGroupNames.contains(origName)) {
                throw new ValidationException("cannot change name of special group '" + origName + "'");
            }
            if (fixedGroupNames.contains(newName)) {
                throw new ValidationException("cannot change name to special group '" + newName + "'");
            }
            if (group.getId().equals(this.getEventContext().getCurrentGroupId())) {
                throw new ValidationException("cannot rename the current group context '" + origName + "'");
            }
        }
        orig.setName(newName);
        orig.setDescription(group.getDescription());
        this.reallySafeSave(orig);
        this.getBeanHelper().getLogger().info("Updated group info for " + group);
    }

    @Override
    @RolesAllowed(value={"user"})
    @Transactional(readOnly=false)
    public long createUser(Experimenter newUser, String defaultGroup) {
        ExperimenterGroup proxy = this.groupProxy(defaultGroup);
        return this.createExperimenter(newUser, proxy, this.groupProxy(this.sec.getSecurityRoles().getUserGroupName()));
    }

    @Override
    @RolesAllowed(value={"system"})
    @Transactional(readOnly=false)
    public long createSystemUser(Experimenter newSystemUser) {
        return this.createExperimenter(newSystemUser, this.groupProxy(this.sec.getSecurityRoles().getSystemGroupName()), this.groupProxy(this.sec.getSecurityRoles().getUserGroupName()));
    }

    @Override
    @RolesAllowed(value={"user"})
    @Transactional(readOnly=false)
    public long createExperimenter(Experimenter experimenter, ExperimenterGroup defaultGroup, ExperimenterGroup ... otherGroups) {
        this.adminOrPiOfNonUserGroups(defaultGroup, otherGroups);
        long uid = this.roleProvider.createExperimenter(experimenter, defaultGroup, otherGroups);
        this.changeUserPassword(experimenter.getOmeName(), " ");
        this.getBeanHelper().getLogger().info("Created user with blank password: " + experimenter.getOmeName());
        return uid;
    }

    @Override
    @RolesAllowed(value={"user"})
    @Transactional(readOnly=false)
    public long createExperimenterWithPassword(Experimenter experimenter, String password, ExperimenterGroup defaultGroup, ExperimenterGroup ... otherGroups) {
        this.adminOrPiOfNonUserGroups(defaultGroup, otherGroups);
        long uid = this.roleProvider.createExperimenter(experimenter, defaultGroup, otherGroups);
        this.changeUserPassword(experimenter.getOmeName(), password);
        this.getBeanHelper().getLogger().info("Created user with password: " + experimenter.getOmeName());
        return uid;
    }

    @Override
    @RolesAllowed(value={"system"})
    @Transactional(readOnly=false)
    public long createGroup(ExperimenterGroup group) {
        long gid = this.roleProvider.createGroup(group);
        this.getBeanHelper().getLogger().info("Created group: " + group.getName());
        return gid;
    }

    @Override
    @RolesAllowed(value={"user"})
    @Transactional(readOnly=false)
    public void addGroups(Experimenter user, ExperimenterGroup ... groups) {
        if (groups == null || groups.length == 0) {
            throw new ValidationException("Nothing to do.");
        }
        this.assertManaged(user);
        for (ExperimenterGroup group : groups) {
            this.assertManaged(group);
        }
        this.adminOrPiOfGroups(null, groups);
        this.roleProvider.addGroups(user, groups);
        this.getBeanHelper().getLogger().info(String.format("Added user %s to groups %s", this.userProxy(user.getId()).getOmeName(), Arrays.asList(groups)));
    }

    @Override
    @RolesAllowed(value={"user"})
    @Transactional(readOnly=false)
    public void removeGroups(Experimenter user, ExperimenterGroup ... groups) {
        if (user == null) {
            return;
        }
        if (groups == null) {
            return;
        }
        this.adminOrPiOfGroups(null, groups);
        Roles roles = this.getSecurityRoles();
        boolean removeSystemOrUser = Iterators.any(Iterators.forArray(groups), Predicates.or(roles.IS_SYSTEM_GROUP, roles.IS_USER_GROUP));
        if (removeSystemOrUser && roles.isRootUser(user)) {
            throw new ValidationException("experimenter '" + roles.getRootName() + "' may not be removed from the '" + roles.getSystemGroupName() + "' or '" + roles.getUserGroupName() + "' group");
        }
        EventContext eventContext = this.getEventContext();
        boolean userOperatingOnThemself = eventContext.getCurrentUserId().equals(user.getId());
        if (removeSystemOrUser && userOperatingOnThemself) {
            throw new ValidationException("experimenters may not remove themselves from the '" + roles.getSystemGroupName() + "' or '" + roles.getUserGroupName() + "' group");
        }
        Experimenter loadedUser = this.userProxy(user.getId());
        HashSet<Long> resultingGroupIds = new HashSet<Long>();
        for (GroupExperimenterMap map : loadedUser.collectGroupExperimenterMap(null)) {
            resultingGroupIds.add(map.parent().getId());
        }
        for (ExperimenterGroup group : groups) {
            resultingGroupIds.remove(group.getId());
        }
        if (resultingGroupIds.isEmpty()) {
            throw new ValidationException("experimenter must remain a member of some group");
        }
        if (resultingGroupIds.equals(Collections.singleton(roles.getUserGroupId()))) {
            throw new ValidationException("experimenter cannot be a member of only the '" + roles.getUserGroupName() + "' group, a different default group is also required");
        }
        this.roleProvider.removeGroups(user, groups);
        this.getBeanHelper().getLogger().info(String.format("Removed user %s from groups %s", user, groups));
    }

    @Override
    @RolesAllowed(value={"user"})
    @Transactional(readOnly=false)
    public void setDefaultGroup(Experimenter user, ExperimenterGroup group) {
        if (user == null) {
            return;
        }
        if (group == null) {
            return;
        }
        if (group.getId() == null) {
            throw new ApiUsageException("Group argument to setDefaultGroup must be managed (i.e. have an id)");
        }
        EventContext ec = this.getSecuritySystem().getEventContext();
        if (!ec.isCurrentUserAdmin() && !ec.getCurrentUserId().equals(user.getId())) {
            throw new SecurityViolation("User " + user.getId() + " can only set own default group.");
        }
        Roles roles = this.getSecuritySystem().getSecurityRoles();
        if (Long.valueOf(roles.getUserGroupId()).equals(group.getId())) {
            throw new ApiUsageException("Cannot set default group to: " + roles.getUserGroupName());
        }
        this.roleProvider.setDefaultGroup(user, group);
        this.getBeanHelper().getLogger().info(String.format("Changing default group for %s to %s", user, group));
    }

    @Override
    @RolesAllowed(value={"user"})
    @Transactional(readOnly=false)
    public void setGroupOwner(ExperimenterGroup group, Experimenter owner) {
        this.adminOrPiOfGroup(group);
        this.toggleGroupOwner(group, owner, Boolean.TRUE);
    }

    @Override
    @RolesAllowed(value={"user"})
    @Transactional(readOnly=false)
    public void unsetGroupOwner(ExperimenterGroup group, Experimenter owner) {
        this.adminOrPiOfGroup(group);
        this.toggleGroupOwner(group, owner, Boolean.FALSE);
    }

    @Override
    @RolesAllowed(value={"user"})
    @Transactional(readOnly=false)
    public void addGroupOwners(ExperimenterGroup group, Experimenter ... owner) {
        this.adminOrPiOfGroup(group);
        for (Experimenter o : owner) {
            this.toggleGroupOwner(group, o, Boolean.TRUE);
        }
    }

    @Override
    @RolesAllowed(value={"user"})
    @Transactional(readOnly=false)
    public void removeGroupOwners(ExperimenterGroup group, Experimenter ... owner) {
        this.adminOrPiOfGroup(group);
        for (Experimenter o : owner) {
            this.toggleGroupOwner(group, o, Boolean.FALSE);
        }
    }

    private void toggleGroupOwner(ExperimenterGroup group, Experimenter owner, Boolean value) {
        if (owner == null) {
            return;
        }
        if (group == null) {
            return;
        }
        if (group.getId() == null) {
            throw new ApiUsageException("Group argument to setGroupOwner must be managed (i.e. have an id)");
        }
        if (owner.getId() == null) {
            throw new ApiUsageException("Owner argument to setGroupOwner must be managed (i.e. have an id)");
        }
        GroupExperimenterMap m = this.findLink(group, owner);
        if (m == null) {
            this.addGroups(owner, group);
            m = this.findLink(group, owner);
        }
        m.setOwner(value);
        this.getSecuritySystem().runAsAdmin(new AdminAction(){

            @Override
            public void runAsAdmin() {
                AdminImpl.this.iUpdate.flush();
            }
        });
        this.getBeanHelper().getLogger().info(String.format("%s user %s as owner of group %s", value != false ? "Setting" : "Unsetting", owner.getId(), group.getId()));
    }

    private GroupExperimenterMap findLink(ExperimenterGroup group, Experimenter owner) {
        GroupExperimenterMap m = (GroupExperimenterMap)this.iQuery.findByQuery("select m from GroupExperimenterMap m where m.parent.id = :pid and m.child.id = :cid", new Parameters().addLong("pid", group.getId()).addLong("cid", owner.getId()));
        return m;
    }

    @Override
    @RolesAllowed(value={"user"})
    public ExperimenterGroup getDefaultGroup(@NotNull long experimenterId) {
        ExperimenterGroup g = (ExperimenterGroup)this.iQuery.findByQuery("select g from ExperimenterGroup g, Experimenter e join e.groupExperimenterMap m where e.id = :id and m.parent = g.id and g.name != :userGroup and index(m) = 0", new Parameters().addId(experimenterId).addString("userGroup", this.sec.getSecurityRoles().getUserGroupName()));
        if (g == null) {
            throw new ValidationException("The user " + experimenterId + " has no default group set.");
        }
        return g;
    }

    @Override
    @RolesAllowed(value={"user"})
    @Transactional(readOnly=false)
    public void deleteExperimenter(Experimenter user) {
        this.adminOrPiOfUser(user);
        final Experimenter e = this.userProxy(user.getId());
        int count = this.sql.removePassword(e.getId());
        if (count == 0) {
            this.getBeanHelper().getLogger().info("No password found for user " + e.getOmeName() + ". Cannot delete.");
        }
        this.getSecuritySystem().runAsAdmin(new AdminAction(){

            @Override
            public void runAsAdmin() {
                AdminImpl.this.iUpdate.deleteObject(e);
            }
        });
        this.getBeanHelper().getLogger().info("Deleted user: " + e.getOmeName());
    }

    @Override
    @RolesAllowed(value={"user"})
    @Transactional(readOnly=false)
    public void deleteGroup(ExperimenterGroup group) {
        this.adminOrPiOfGroup(group);
        final ExperimenterGroup g = this.groupProxy(group.getId());
        this.getSecuritySystem().runAsAdmin(new AdminAction(){

            @Override
            public void runAsAdmin() {
                AdminImpl.this.iUpdate.deleteObject(g);
            }
        });
        this.getBeanHelper().getLogger().info("Deleted group: " + g.getName());
    }

    @Override
    @RolesAllowed(value={"user"})
    @Transactional(readOnly=false)
    public void changeOwner(IObject iObject, String omeName) {
        Object copy = this.iQuery.get(iObject.getClass(), iObject.getId());
        Experimenter owner = this.userProxy(omeName);
        copy.getDetails().setOwner(owner);
        this.iUpdate.saveObject((IObject)copy);
    }

    @Override
    @RolesAllowed(value={"user"})
    @Transactional(readOnly=false)
    public void changeGroup(IObject iObject, String groupName) {
        Map<String, Long> locks;
        Long total;
        Object copy = this.iQuery.get(iObject.getClass(), iObject.getId());
        ExperimenterGroup group = this.groupProxy(groupName);
        EventContext ec = this.getSecuritySystem().getEventContext();
        if (!ec.getCurrentUserId().equals(copy.getDetails().getOwner().getId()) && !ec.isCurrentUserAdmin()) {
            throw new SecurityViolation("Cannot change group for:" + iObject);
        }
        if (this.getSecurityRoles().getUserGroupId() == group.getId().longValue()) {
            throw new SecurityViolation("Use moveToCommonSpace for moving to user group");
        }
        if (!ec.getMemberOfGroupsList().contains(group.getId())) {
            throw new SecurityViolation("Can't change to group; not a member of " + group.getId());
        }
        copy.getDetails().setGroup(group);
        this.secureFlush((IObject)copy);
        if (copy instanceof Image) {
            Image img = (Image)copy;
            Iterator<Pixels> it = img.iteratePixels();
            while (it.hasNext()) {
                Pixels pix = it.next();
                pix.getDetails().setGroup(group);
                this.secureFlush(pix);
            }
        }
        if ((total = (locks = this.getLockingIds(copy.getClass(), copy.getId(), group.getId())).get("*")) != null && total > 0L) {
            throw new SecurityViolation("Locks: " + locks);
        }
    }

    private void secureFlush(IObject copy) {
        this.getSecuritySystem().doAction(new SecureAction(){

            @Override
            public <T extends IObject> T updateObject(T ... objs) {
                AdminImpl.this.iUpdate.flush();
                return null;
            }
        }, new IObject[]{copy});
    }

    @Override
    @RolesAllowed(value={"user"})
    @Transactional(readOnly=false)
    public void changePermissions(IObject iObject, Permissions perms) {
        Session s = this.osf.getSession();
        String p = perms.toString();
        Object[] checks = this.chmod.getChecks(iObject, p);
        this.chmod.chmod(iObject, p);
        for (Object check : checks) {
            this.chmod.check(iObject, check);
        }
    }

    @Override
    @RolesAllowed(value={"user"})
    @Transactional(readOnly=false)
    public void moveToCommonSpace(IObject ... iObjects) {
        for (IObject object : iObjects) {
            if (object == null) continue;
            Long id = object.getId();
            Class<?> c = Utils.trueClass(object.getClass());
            Object o = this.iQuery.get(c, id);
            ExperimenterGroup g = o.getDetails().getGroup();
            if (g.getId().equals(this.getSecurityRoles().getUserGroupId())) continue;
            this.adminOrPiOfGroup(g);
            this.internalMoveToCommonSpace((IObject)o);
        }
    }

    @Override
    public void internalMoveToCommonSpace(IObject obj) {
        Session session = this.osf.getSession();
        obj.getDetails().setGroup(this.groupProxy(this.getSecurityRoles().getUserGroupId()));
        this.secureFlush(obj);
        this.getBeanHelper().getLogger().info("Moved object to common space: " + obj);
    }

    public Map<String, Long> getLockingIds(IObject object) {
        return this.getLockingIds(object.getClass(), object.getId(), null);
    }

    @Override
    public Map<String, Long> getLockingIds(Class<IObject> type, long id, Long groupId) {
        String groupClause = "";
        if (groupId != null) {
            groupClause = "and details.group.id <> " + groupId;
        }
        Class<IObject> klass = Utils.trueClass(type);
        String[][] checks = this.metadata.getLockChecks(klass);
        return this.metadata.countLocks(this.osf.getSession(), id, checks, groupClause);
    }

    @Override
    @PermitAll
    @Transactional(readOnly=false)
    public void reportForgottenPassword(final String name, final String email) throws AuthenticationException {
        if (name == null) {
            throw new IllegalArgumentException("Unexpected null username.");
        }
        if (email == null) {
            throw new IllegalArgumentException("Unexpected null e-mail.");
        }
        this.sec.runAsAdmin(new AdminAction(){

            @Override
            public void runAsAdmin() {
                Experimenter e = AdminImpl.this.iQuery.findByString(Experimenter.class, "omeName", name);
                if (e == null) {
                    throw new AuthenticationException("Unknown user.");
                }
                if (e.getEmail() == null) {
                    throw new AuthenticationException("User has no email address.");
                }
                if (!e.getEmail().equals(email)) {
                    throw new AuthenticationException("Email address does not match.");
                }
                if (AdminImpl.this.passwordUtil.getDnById(e.getId())) {
                    throw new AuthenticationException("User is authenticated by LDAP server you cannot reset this password.");
                }
                String passwd = AdminImpl.this.passwordUtil.generateRandomPasswd();
                AdminImpl.this.sendEmail(e, passwd);
                AdminImpl.this._changePassword(e.getOmeName(), passwd);
            }
        });
    }

    private boolean sendEmail(Experimenter e, String newPassword) {
        SimpleMailMessage msg = new SimpleMailMessage(this.templateMessage);
        msg.setSubject("OMERO - Reset password");
        msg.setTo(e.getEmail());
        msg.setText("Dear " + e.getFirstName() + " " + e.getLastName() + " (" + e.getOmeName() + ") your new password is: " + newPassword);
        try {
            this.mailSender.send(msg);
        }
        catch (Exception ex) {
            throw new RuntimeException("Exception: " + ex.getMessage() + ". Password was not changed because email could not be sent to user:" + e.getOmeName() + ". Please turn on the debug mode in omero.properties by the: omero.mail.debug=true");
        }
        return true;
    }

    @Override
    @PermitAll
    @Transactional(readOnly=false)
    public void changeExpiredCredentials(String name, String oldCred, String newCred) throws AuthenticationException {
        throw new UnsupportedOperationException();
    }

    @Override
    @RolesAllowed(value={"user", "HasPassword"})
    @Transactional(readOnly=false)
    public void changePassword(String newPassword) {
        String user = this.getSecuritySystem().getEventContext().getCurrentUserName();
        this._changePassword(user, newPassword);
    }

    @Override
    @RolesAllowed(value={"user"})
    @Transactional(readOnly=false)
    public void changePasswordWithOldPassword(String oldPassword, String newPassword) {
        String user = this.getSecuritySystem().getEventContext().getCurrentUserName();
        if (!this.checkPassword(user, oldPassword, false)) {
            throw new SecurityViolation("Old password is invalid");
        }
        this._changePassword(user, newPassword);
    }

    @Override
    @RolesAllowed(value={"user", "HasPassword"})
    @Transactional(readOnly=false)
    public void changeUserPassword(String user, String newPassword) {
        this.adminOrPiOfUser(this.userProxy(user));
        this._changePassword(user, newPassword);
    }

    private void _changePassword(String user, String newPassword) {
        try {
            this.passwordProvider.changePassword(user, newPassword);
            this.getBeanHelper().getLogger().info("Changed password for user: " + user);
        }
        catch (PasswordChangeException e) {
            throw new SecurityViolation("PasswordChangeException: " + e.getMessage());
        }
    }

    @Override
    public boolean checkPassword(String name, String password, boolean readOnly) {
        Boolean result = this.passwordProvider.checkPassword(name, password, readOnly);
        if (result == null) {
            this.getBeanHelper().getLogger().warn("Password provider returned null: " + this.passwordProvider);
            return false;
        }
        return result;
    }

    @Override
    @PermitAll
    public Roles getSecurityRoles() {
        return this.getSecuritySystem().getSecurityRoles();
    }

    @Override
    @PermitAll
    public EventContext getEventContext() {
        return new SimpleEventContext(this.getSecuritySystem().getEventContext(true));
    }

    @Override
    public EventContext getEventContextQuiet() {
        return new SimpleEventContext(this.getSecuritySystem().getEventContext(false));
    }

    protected void assertManaged(IObject o) {
        if (o == null) {
            throw new ApiUsageException("Argument may not be null.");
        }
        if (o.getId() == null) {
            throw new ApiUsageException(o.getClass().getName() + " has no id.");
        }
    }

    private Set<String> classes() {
        return this.getExtendedMetadata().getClasses();
    }

    private String table(String className) {
        try {
            Class<?> c = Class.forName(className);
            Table t = null;
            if (IGlobal.class.isAssignableFrom(c)) {
                return null;
            }
            if (c.getAnnotation(Table.class) == null) {
                return null;
            }
            if (c.getAnnotation(PrimaryKeyJoinColumn.class) != null) {
                return null;
            }
            t = c.getAnnotation(Table.class);
            return t.name();
        }
        catch (Exception e) {
            throw new InternalException("Miss configuration. Should never happen.");
        }
    }

    private void reallySafeSave(IObject obj) {
        final Session session = this.osf.getSession();
        this.sec.doAction(new SecureMerge(session), new IObject[]{obj});
        this.sec.runAsAdmin(new AdminAction(){

            @Override
            public void runAsAdmin() {
                session.flush();
            }
        });
    }

    private boolean isAdmin() {
        return this.getEventContext().isCurrentUserAdmin();
    }

    private boolean isPiOf(Experimenter user) {
        if (user == null) {
            return true;
        }
        List<Long> userIn = this.getMemberOfGroupIds(user);
        List<Long> piOf = this.getEventContext().getLeaderOfGroupsList();
        for (Long id : piOf) {
            if (!userIn.contains(id)) continue;
            return true;
        }
        return false;
    }

    private boolean isPiOf(ExperimenterGroup group) {
        if (group == null) {
            return true;
        }
        EventContext ec = this.getEventContext();
        List<Long> piOf = ec.getLeaderOfGroupsList();
        return piOf.contains(group.getId());
    }

    private void throwNonAdminOrPi() {
        String msg = "Current user is neither admin nor group-leader for the given user(s)/group(s)";
        throw new SecurityViolation(msg);
    }

    private void adminOrPiOfUser(Experimenter user) {
        if (!this.isAdmin() && !this.isPiOf(user)) {
            this.throwNonAdminOrPi();
        }
    }

    private void adminOrPiOfGroup(ExperimenterGroup group) {
        if (!this.isAdmin() && !this.isPiOf(group)) {
            this.throwNonAdminOrPi();
        }
    }

    private void adminOrPiOfGroups(ExperimenterGroup group, ExperimenterGroup ... groups) {
        if (!this.isAdmin()) {
            if (!this.isPiOf(group)) {
                this.throwNonAdminOrPi();
            } else {
                for (ExperimenterGroup g : groups) {
                    if (this.isPiOf(g)) continue;
                    this.throwNonAdminOrPi();
                }
            }
        }
    }

    private void adminOrPiOfNonUserGroups(ExperimenterGroup defaultGroup, ExperimenterGroup ... otherGroups) {
        HashSet<ExperimenterGroup> nonUserGroupGroups = new HashSet<ExperimenterGroup>();
        for (ExperimenterGroup eg : otherGroups) {
            if (eg.getId().equals(this.getSecurityRoles().getUserGroupId())) continue;
            nonUserGroupGroups.add(eg);
        }
        this.adminOrPiOfGroups(defaultGroup, nonUserGroupGroups.toArray(new ExperimenterGroup[0]));
    }

    static class GroupQ
    extends BaseQ<ExperimenterGroup> {
        public GroupQ(Parameters params) {
            super(params);
        }

        @Override
        protected void buildQuery(Session session) throws HibernateException, SQLException {
            QueryBuilder qb = new QueryBuilder();
            qb.select("g");
            qb.from("ExperimenterGroup", "g");
            qb.join("g.groupExperimenterMap", "m", true, true);
            qb.join("m.child", "user", true, true);
            qb.where();
            Object name = this.value("name");
            Object id = this.value("id");
            if (name != null) {
                qb.and("g.name = :name");
                qb.param("name", name);
            } else if (id != null) {
                qb.and("g.id = :id");
                qb.param("id", id);
            } else {
                throw new InternalException("Name and id are both null for group query.");
            }
            this.setQuery(qb.query(session));
        }
    }

    static class UserQ
    extends BaseQ<Experimenter> {
        public UserQ(Parameters params) {
            super(params);
        }

        @Override
        protected void buildQuery(Session session) throws HibernateException, SQLException {
            Criteria c = session.createCriteria(Experimenter.class);
            Criteria m = c.createCriteria("groupExperimenterMap", 1);
            Criteria g = m.createCriteria("parent", 1);
            if (this.value("name") != null) {
                c.add((Criterion)Restrictions.eq((String)"omeName", (Object)this.value("name")));
            } else if (this.value("id") != null) {
                c.add((Criterion)Restrictions.eq((String)"id", (Object)this.value("id")));
            } else {
                throw new InternalException("Name and id are both null for user query.");
            }
            this.setCriteria(c);
        }
    }

    static abstract class BaseQ<T>
    extends Query<T> {
        static Definitions defs = new Definitions(new QueryParameterDef("name", String.class, true), new QueryParameterDef("id", Long.class, true));

        public BaseQ(Parameters params) {
            super(defs, new Parameters().unique().addAll(params));
        }
    }
}

