/*
 * Decompiled with CFR 0.152.
 */
package ome.logic;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.WritableRaster;
import ome.api.IScale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AWTScaleService
implements IScale {
    private static Logger log = LoggerFactory.getLogger(AWTScaleService.class);

    @Override
    public BufferedImage scaleBufferedImage(BufferedImage image, float xScale, float yScale) {
        int thumbHeight = (int)((float)image.getHeight() * yScale);
        int thumbWidth = (int)((float)image.getWidth() * xScale);
        log.info("Scaling to: " + thumbHeight + "x" + thumbWidth);
        ColorModel cm = image.getColorModel();
        WritableRaster r = cm.createCompatibleWritableRaster(thumbWidth, thumbHeight);
        BufferedImage thumbImage = new BufferedImage(cm, r, false, null);
        Graphics2D graphics2D = thumbImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, thumbWidth, thumbHeight, null);
        return thumbImage;
    }
}

