/*
 * Decompiled with CFR 0.152.
 */
package ome.io.nio;

import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import loci.common.services.ServiceFactory;
import loci.formats.codec.JPEG2000CodecOptions;
import loci.formats.services.JAIIIOService;
import ome.conditions.MissingPyramidException;
import ome.io.nio.BackOff;
import ome.io.nio.ConfiguredTileSizes;
import ome.io.nio.TileLoopIteration;
import ome.io.nio.TileSizes;
import ome.io.nio.Utils;
import ome.model.core.Pixels;
import org.perf4j.StopWatch;
import org.perf4j.slf4j.Slf4JStopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleBackOff
implements BackOff {
    private static final int[] CODE_BLOCK = new int[]{4, 4};
    private static final int IMAGE_TYPE = 2;
    private static final Logger log = LoggerFactory.getLogger(SimpleBackOff.class);
    private final JAIIIOService service;
    protected final double scalingFactor;
    protected final double warmUpFactor;
    protected final int count;
    protected final TileSizes sizes;

    public SimpleBackOff() {
        this(new ConfiguredTileSizes());
    }

    public SimpleBackOff(TileSizes sizes) {
        this.sizes = sizes;
        this.count = 10;
        try {
            ServiceFactory sf = new ServiceFactory();
            this.service = sf.getInstance(JAIIIOService.class);
            this.warmUpFactor = this.calculate();
            this.scalingFactor = this.calculate();
        }
        catch (Exception e) {
            log.error("Failed to create simpleBackOff", e);
            throw new RuntimeException(e);
        }
    }

    public int getCount() {
        return this.count;
    }

    public double getScalingFactor() {
        return this.scalingFactor;
    }

    public double getWarmUpFactor() {
        return this.warmUpFactor;
    }

    @Override
    public void throwMissingPyramidException(String msg, Pixels pixels) {
        throw new MissingPyramidException(msg, this.calculate(pixels), pixels.getId());
    }

    protected long calculate(Pixels pixels) {
        return (long)(this.scalingFactor * (double)this.countTiles(pixels));
    }

    protected int countTiles(Pixels pixels) {
        final int[] count = new int[]{0};
        Utils.forEachTile(new TileLoopIteration(){

            @Override
            public void run(int z, int c, int t, int x, int y, int tileWidth, int tileHeight, int tileCount) {
                count[0] = count[0] + 1;
            }
        }, pixels.getSizeX(), pixels.getSizeY(), pixels.getSizeZ(), pixels.getSizeC(), pixels.getSizeT(), this.sizes.getTileWidth(), this.sizes.getTileHeight());
        return count[0];
    }

    protected double calculate() throws Exception {
        String key = String.format("%s.%sX%s", this.getClass().getName(), this.sizes.getTileWidth(), this.sizes.getTileHeight());
        long elapsed = 0L;
        for (int i = 0; i < this.count; ++i) {
            Slf4JStopWatch sw = new Slf4JStopWatch(key);
            JPEG2000CodecOptions options = JPEG2000CodecOptions.getDefaultOptions();
            options.lossless = false;
            options.codeBlockSize = CODE_BLOCK;
            options.quality = 1.0;
            BufferedImage image = new BufferedImage(this.sizes.getTileWidth(), this.sizes.getTileHeight(), 2);
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            this.service.writeImage(stream, image, options);
            ((StopWatch)sw).stop();
            elapsed += sw.getElapsedTime();
        }
        return (double)elapsed / (double)this.count;
    }

    public String toString() {
        return String.format("%s(factor=%s)", this.getClass().getName(), this.scalingFactor);
    }
}

