/*
 * Decompiled with CFR 0.152.
 */
package ome.io.nio;

import java.awt.Dimension;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.List;
import loci.formats.ChannelFiller;
import loci.formats.ChannelSeparator;
import loci.formats.FormatException;
import loci.formats.IFormatReader;
import loci.formats.ImageReader;
import loci.formats.Memoizer;
import loci.formats.MinMaxCalculator;
import loci.formats.meta.IMinMaxStore;
import ome.api.IQuery;
import ome.conditions.LockTimeout;
import ome.conditions.ResourceError;
import ome.io.bioformats.BfPixelBuffer;
import ome.io.bioformats.BfPyramidPixelBuffer;
import ome.io.messages.MissingPyramidMessage;
import ome.io.messages.MissingStatsInfoMessage;
import ome.io.nio.AbstractFileSystemService;
import ome.io.nio.BackOff;
import ome.io.nio.ConfiguredTileSizes;
import ome.io.nio.FilePathResolver;
import ome.io.nio.PixelBuffer;
import ome.io.nio.RomioPixelBuffer;
import ome.io.nio.SimpleBackOff;
import ome.io.nio.TileLoopIteration;
import ome.io.nio.TileSizes;
import ome.io.nio.Utils;
import ome.model.core.Pixels;
import ome.model.stats.StatsInfo;
import ome.parameters.Parameters;
import ome.system.metrics.Metrics;
import ome.system.metrics.Timer;
import ome.util.PixelData;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.FatalBeanException;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;

public class PixelsService
extends AbstractFileSystemService
implements ApplicationEventPublisherAware {
    private static transient Logger log = LoggerFactory.getLogger(PixelsService.class);
    private transient ApplicationEventPublisher pub;
    public static final String PYRAMID_SUFFIX = "_pyramid";
    public static final int NULL_PLANE_SIZE = 64;
    public static final long MEMOIZER_WAIT = 100L;
    protected FilePathResolver resolver;
    protected final BackOff backOff;
    protected final TileSizes sizes;
    protected final File memoizerDirectory;
    protected final long memoizerWait;
    private Timer tileTimes;
    private Timer minmaxTimes;
    private IQuery iQuery;
    public static final byte[] nullPlane = new byte[]{-128, 127, -128, 127, -128, 127, -128, 127, -128, 127, -128, 127, -128, 127, -128, 127, -128, 127, -128, 127, -128, 127, -128, 127, -128, 127, -128, 127, -128, 127, -128, 127, -128, 127, -128, 127, -128, 127, -128, 127, -128, 127, -128, 127, -128, 127, -128, 127, -128, 127, -128, 127, -128, 127, -128, 127, -128, 127, -128, 127, -128, 127, -128, 127};

    public PixelsService(String path) {
        this(path, null, new SimpleBackOff(), new ConfiguredTileSizes(), null);
    }

    public PixelsService(String path, FilePathResolver resolver) {
        this(path, resolver, new SimpleBackOff(), new ConfiguredTileSizes(), null);
    }

    public PixelsService(String path, FilePathResolver resolver, BackOff backOff, TileSizes sizes, IQuery iQuery) {
        this(path, new File(new File(path), "BioFormatsCache"), resolver, backOff, sizes, iQuery);
    }

    public PixelsService(String path, long memoizerWait, FilePathResolver resolver, BackOff backOff, TileSizes sizes, IQuery iQuery) {
        this(path, new File(new File(path), "BioFormatsCache"), memoizerWait, resolver, backOff, sizes, iQuery);
    }

    public PixelsService(String path, File memoizerDirectory, FilePathResolver resolver, BackOff backOff, TileSizes sizes, IQuery iQuery) {
        this(path, memoizerDirectory, 100L, resolver, backOff, sizes, iQuery);
    }

    public PixelsService(String path, File memoizerDirectory, long memoizerWait, FilePathResolver resolver, BackOff backOff, TileSizes sizes, IQuery iQuery) {
        super(path);
        this.resolver = resolver;
        this.backOff = backOff;
        this.sizes = sizes;
        this.memoizerDirectory = memoizerDirectory;
        this.memoizerWait = memoizerWait;
        if (!this.memoizerDirectory.exists()) {
            log.info("Creating Bio-Formats Cache: {}", (Object)memoizerDirectory);
            this.memoizerDirectory.mkdirs();
        } else {
            log.info("Using Bio-Formats Cache: {}", (Object)memoizerDirectory);
        }
        if (log.isInfoEnabled()) {
            log.info("PixelsService(path=" + path + ", resolver=" + resolver + ", backoff=" + backOff + ", sizes=" + sizes + ")");
        }
        this.iQuery = iQuery;
    }

    public void setMetrics(Metrics metrics) {
        this.tileTimes = metrics.timer(this, "tileTimes");
        this.minmaxTimes = metrics.timer(this, "minmaxTimes");
    }

    public long getMemoizerWait() {
        return this.memoizerWait;
    }

    public File getMemoizerDirectory() {
        return this.memoizerDirectory;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher pub) {
        if (this.pub != null) {
            throw new FatalBeanException("Publisher already set.");
        }
        this.pub = pub;
    }

    public void setFilePathResolver(FilePathResolver resolver) {
        this.resolver = resolver;
    }

    public PixelBuffer createPixelBuffer(Pixels pixels) throws IOException {
        RomioPixelBuffer pixbuf = new RomioPixelBuffer(this.getPixelsPath(pixels.getId()), pixels, true);
        this.initPixelBuffer(pixbuf);
        return pixbuf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StatsInfo[] makePyramid(Pixels pixels) {
        String pixelsFilePath = this.getPixelsPath(pixels.getId());
        File pixelsFile = new File(pixelsFilePath);
        String pixelsPyramidFilePath = pixelsFilePath + PYRAMID_SUFFIX;
        File pixelsPyramidFile = new File(pixelsPyramidFilePath);
        String originalFilePath = this.getOriginalFilePath(pixels);
        boolean requirePyramid = this.requiresPixelsPyramid(pixels);
        if (pixelsPyramidFile.exists()) {
            log.debug("Pyramid already exists: " + pixelsPyramidFilePath);
            return null;
        }
        if (!requirePyramid) {
            log.debug("Creating only StatsInfo.");
            int series = this.getSeries(pixels);
            PixelsPyramidMinMaxStore minMaxStore = new PixelsPyramidMinMaxStore(pixels.getSizeC());
            BfPixelBuffer bfPixelBuffer = this.createMinMaxBfPixelBuffer(originalFilePath, series, minMaxStore);
            try {
                for (int t = 0; t < pixels.getSizeT(); ++t) {
                    for (int c = 0; c < pixels.getSizeC(); ++c) {
                        for (int z = 0; z < pixels.getSizeZ(); ++z) {
                            Timer.Context ctx = this.minmaxTimes == null ? null : this.minmaxTimes.time();
                            try {
                                bfPixelBuffer.getPlane(z, c, t);
                                continue;
                            }
                            finally {
                                if (ctx != null) {
                                    ctx.stop();
                                }
                            }
                        }
                    }
                }
                return minMaxStore.createStatsInfo();
            }
            catch (IOException e) {
                log.error("I/O exception while calculating min/max.", e);
                return null;
            }
        }
        BfPyramidPixelBuffer pixelsPyramid = this.createPyramidPixelBuffer(pixels, pixelsPyramidFilePath, true);
        try {
            if (!pixelsFile.exists() && originalFilePath == null) {
                log.error("FAIL -- Original pixels file does not exist: " + pixelsFile.getAbsolutePath());
                StatsInfo[] minMaxStore = null;
                return minMaxStore;
            }
            PixelsPyramidMinMaxStore minMaxStore = this.performWrite(pixels, pixelsPyramidFile, pixelsPyramid, pixelsFile, pixelsFilePath, originalFilePath);
            if (minMaxStore != null) {
                StatsInfo[] statsInfoArray = minMaxStore.createStatsInfo();
                return statsInfoArray;
            }
            StatsInfo[] statsInfoArray = null;
            return statsInfoArray;
        }
        finally {
            if (pixelsPyramid != null) {
                try {
                    pixelsPyramid.close();
                }
                catch (IOException e) {
                    log.error("Error closing pixel pyramid.", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PixelsPyramidMinMaxStore performWrite(final Pixels pixels, final File pixelsPyramidFile, final BfPyramidPixelBuffer pixelsPyramid, File pixelsFile, String pixelsFilePath, String originalFilePath) {
        Dimension tileSize;
        PixelBuffer source;
        PixelsPyramidMinMaxStore minMaxStore;
        if (pixelsFile.exists()) {
            minMaxStore = null;
            source = this.createRomioPixelBuffer(pixelsFilePath, pixels, false);
            tileSize = new Dimension(Math.min(pixels.getSizeX(), this.sizes.getTileWidth()), Math.min(pixels.getSizeY(), this.sizes.getTileHeight()));
        } else {
            minMaxStore = new PixelsPyramidMinMaxStore(pixels.getSizeC());
            int series = this.getSeries(pixels);
            BfPixelBuffer bfPixelBuffer = this.createMinMaxBfPixelBuffer(originalFilePath, series, minMaxStore);
            pixelsPyramid.setByteOrder(bfPixelBuffer.isLittleEndian() ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN);
            source = bfPixelBuffer;
            Dimension sourceTileSize = source.getTileSize();
            double tileWidth = sourceTileSize.getWidth();
            double tileHeight = sourceTileSize.getHeight();
            double factor = Math.pow(2.0, 5.0);
            boolean tileDimensionTooSmall = tileWidth / factor < 1.0 || tileHeight / factor < 1.0;
            tileSize = tileWidth == (double)source.getSizeX() || tileHeight == (double)source.getSizeY() || tileDimensionTooSmall ? new Dimension(Math.min(pixels.getSizeX(), this.sizes.getTileWidth()), Math.min(pixels.getSizeY(), this.sizes.getTileHeight())) : sourceTileSize;
        }
        log.info("Destination pyramid tile size: " + tileSize);
        try {
            final double totalTiles = (double)(source.getSizeZ() * source.getSizeC() * source.getSizeT()) * Math.ceil((double)source.getSizeX() / tileSize.getWidth()) * Math.ceil((double)source.getSizeY() / tileSize.getHeight());
            final int tenPercent = Math.max((int)totalTiles / 10, 1);
            Utils.forEachTile(new TileLoopIteration(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run(int z, int c, int t, int x, int y, int w, int h, int tileCount) {
                    if (log.isInfoEnabled() && tileCount % tenPercent == 0) {
                        log.info(String.format("Pyramid creation for Pixels:%d %d/%d (%d%%).", pixels.getId(), tileCount + 1, (int)totalTiles, (int)((double)tileCount / totalTiles * 100.0)));
                    }
                    try {
                        Timer.Context ctx = PixelsService.this.tileTimes == null ? null : PixelsService.this.tileTimes.time();
                        try {
                            PixelData tile = source.getTile(z, c, t, x, y, w, h);
                            pixelsPyramid.setTile(tile.getData().array(), z, c, t, x, y, w, h);
                            tile.dispose();
                        }
                        finally {
                            if (ctx != null) {
                                ctx.stop();
                            }
                        }
                    }
                    catch (IOException e1) {
                        log.error("FAIL -- Error during tile population", e1);
                        try {
                            pixelsPyramidFile.delete();
                            FileUtils.touch(pixelsPyramidFile);
                        }
                        catch (Exception e2) {
                            log.warn("Error clearing empty or incomplete pixel buffer.", e2);
                        }
                        return;
                    }
                }
            }, source, (int)tileSize.getWidth(), (int)tileSize.getHeight());
            log.info("SUCCESS -- Pyramid created for pixels id:" + pixels.getId());
        }
        finally {
            if (source != null) {
                try {
                    source.close();
                }
                catch (IOException e) {
                    log.error("Error closing pixel pyramid.", e);
                }
            }
        }
        return minMaxStore;
    }

    @Deprecated
    public PixelBuffer getPixelBuffer(Pixels pixels) {
        return this.getPixelBuffer(pixels, true);
    }

    public PixelBuffer getPixelBuffer(Pixels pixels, boolean write) {
        PixelBuffer pb = this._getPixelBuffer(pixels, write);
        if (log.isDebugEnabled()) {
            log.debug(pb + " for " + pixels);
        }
        return pb;
    }

    public PixelBuffer _getPixelBuffer(Pixels pixels, boolean write) {
        int series;
        String originalFilePath = this.getOriginalFilePath(pixels);
        boolean requirePyramid = this.requiresPixelsPyramid(pixels);
        String pixelsFilePath = this.getPixelsPath(pixels.getId());
        File pixelsFile = new File(pixelsFilePath);
        String pixelsPyramidFilePath = pixelsFilePath + PYRAMID_SUFFIX;
        File pixelsPyramidFile = new File(pixelsPyramidFilePath);
        boolean pixelsFileExists = pixelsFile.exists();
        if ((pixelsFileExists || originalFilePath != null) && requirePyramid) {
            while (!pixelsPyramidFile.exists()) {
                BfPixelBuffer bfPixelBuffer;
                if (originalFilePath != null && (bfPixelBuffer = this.createBfPixelBuffer(originalFilePath, series = this.getSeries(pixels))).getResolutionLevels() > 1) {
                    return bfPixelBuffer;
                }
                this.handleMissingPyramid(pixels, pixelsPyramidFilePath);
            }
        }
        if (!pixelsFileExists && requirePyramid && originalFilePath != null) {
            this.handleMissingStatsInfo(pixels);
        }
        if (pixelsPyramidFile.exists()) {
            log.info("Using Pyramid BfPixelBuffer: " + pixelsPyramidFilePath);
            return this.createPyramidPixelBuffer(pixels, pixelsPyramidFilePath, write);
        }
        if (!pixelsFileExists) {
            if (requirePyramid) {
                if (!write) {
                    throw new LockTimeout("Pixels pyramid missing, being created or import in progress.", 15000L, 0);
                }
                log.info("Creating Pyramid BfPixelBuffer: " + pixelsPyramidFilePath);
                return this.createPyramidPixelBuffer(pixels, pixelsPyramidFilePath, write);
            }
            if (originalFilePath != null) {
                series = this.getSeries(pixels);
                return this.createBfPixelBuffer(originalFilePath, series);
            }
            if (!write) {
                throw new LockTimeout("Import in progress.", 15000L, 0);
            }
            log.info("Creating ROMIO Pixel buffer.");
            this.createSubpath(pixelsFilePath);
            return this.createRomioPixelBuffer(pixelsFilePath, pixels, write);
        }
        log.info("Pixel buffer file exists returning read-only ROMIO pixel buffer.");
        return this.createRomioPixelBuffer(pixelsFilePath, pixels, false);
    }

    public boolean requiresPixelsPyramid(Pixels pixels) {
        long sizeY;
        String type = pixels.getPixelsType().getValue();
        if ("float".equals(type) || "double".equals(type)) {
            return false;
        }
        long sizeX = pixels.getSizeX().intValue();
        boolean requirePyramid = sizeX * (sizeY = (long)pixels.getSizeY().intValue()) > (long)(this.sizes.getMaxPlaneWidth() * this.sizes.getMaxPlaneHeight());
        return requirePyramid;
    }

    protected String getOriginalFilePath(Pixels pixels) {
        if (this.resolver == null) {
            return null;
        }
        return this.resolver.getOriginalFilePath(this, pixels);
    }

    protected int getSeries(Pixels pixels) {
        try {
            String query = "SELECT image.series FROM Pixels WHERE id = :id";
            List<Object[]> results = this.iQuery.projection("SELECT image.series FROM Pixels WHERE id = :id", new Parameters().addId(pixels.getId()));
            return (Integer)results.get(0)[0];
        }
        catch (Exception e) {
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initPixelBuffer(RomioPixelBuffer pixbuf) throws IOException {
        String path = this.getPixelsPath(pixbuf.getId());
        this.createSubpath(path);
        Integer size = RomioPixelBuffer.safeLongToInteger(pixbuf.getPlaneSize());
        byte[] padding = new byte[size - 64];
        FileOutputStream stream = new FileOutputStream(path);
        try {
            for (int z = 0; z < pixbuf.getSizeZ(); ++z) {
                for (int c = 0; c < pixbuf.getSizeC(); ++c) {
                    for (int t = 0; t < pixbuf.getSizeT(); ++t) {
                        stream.write(nullPlane);
                        stream.write(padding);
                    }
                }
            }
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    log.error("Error closing stream.", e);
                }
            }
        }
    }

    protected void handleMissingStatsInfo(Pixels pixels) {
        for (int channel = 0; channel < pixels.sizeOfChannels(); ++channel) {
            if (pixels.getChannel(channel).getStatsInfo() == null) continue;
            return;
        }
        long pixelsId = pixels.getId();
        MissingStatsInfoMessage m = new MissingStatsInfoMessage(this, pixelsId);
        this.pub.publishEvent((ApplicationEvent)m);
        if (m.isRetry()) {
            log.debug("Retrying stats info for Pixels:" + pixelsId);
            return;
        }
        String msg = "Missing stats info for Pixels:" + pixelsId;
        log.info(msg);
        this.backOff.throwMissingPyramidException(msg, pixels);
    }

    protected void handleMissingPyramid(Pixels pixels, String pixelsPyramidFilePath) {
        MissingPyramidMessage mpm = new MissingPyramidMessage(this, pixels.getId());
        this.pub.publishEvent((ApplicationEvent)mpm);
        if (mpm.isRetry()) {
            log.debug("Retrying pyramid:" + pixelsPyramidFilePath);
            return;
        }
        String msg = "Missing pyramid:" + pixelsPyramidFilePath;
        log.info(msg);
        this.backOff.throwMissingPyramidException(msg, pixels);
    }

    protected BfPixelBuffer createMinMaxBfPixelBuffer(String filePath, int series, IMinMaxStore store) {
        try {
            IFormatReader reader = this.createBfReader();
            MinMaxCalculator calculator = new MinMaxCalculator(reader);
            calculator.setMinMaxStore(store);
            BfPixelBuffer pixelBuffer = new BfPixelBuffer(filePath, calculator);
            pixelBuffer.setSeries(series);
            log.info(String.format("Creating BfPixelBuffer: %s Series: %d", filePath, series));
            return pixelBuffer;
        }
        catch (Exception e) {
            String msg = "Error instantiating pixel buffer: " + filePath;
            log.error(msg, e);
            throw new ResourceError(msg);
        }
    }

    public IFormatReader getBfReader(Pixels pixels) throws FormatException, IOException {
        String originalFilePath = this.getOriginalFilePath(pixels);
        int series = this.getSeries(pixels);
        IFormatReader reader = this.createBfReader();
        reader.setId(originalFilePath);
        reader.setSeries(series);
        return reader;
    }

    protected IFormatReader createBfReader() {
        IFormatReader reader = new ImageReader();
        reader = new ChannelFiller(reader);
        reader = new ChannelSeparator(reader);
        reader = new Memoizer(reader, this.getMemoizerWait(), this.getMemoizerDirectory());
        reader.setFlattenedResolutions(false);
        reader.setMetadataFiltered(true);
        return reader;
    }

    protected BfPixelBuffer createBfPixelBuffer(String filePath, int series) {
        try {
            IFormatReader reader = this.createBfReader();
            BfPixelBuffer pixelBuffer = new BfPixelBuffer(filePath, reader);
            pixelBuffer.setSeries(series);
            log.info(String.format("Creating BfPixelBuffer: %s Series: %d", filePath, series));
            return pixelBuffer;
        }
        catch (Exception e) {
            String msg = "Error instantiating pixel buffer: " + filePath;
            log.error(msg, e);
            throw new ResourceError(msg);
        }
    }

    protected BfPyramidPixelBuffer createPyramidPixelBuffer(Pixels pixels, String filePath, boolean write) {
        try {
            if (write) {
                this.createSubpath(filePath);
            }
            return new BfPyramidPixelBuffer(pixels, filePath, write);
        }
        catch (Exception e) {
            if (e instanceof LockTimeout) {
                throw (LockTimeout)e;
            }
            String msg = "Error instantiating pixel buffer: " + filePath;
            log.error(msg, e);
            throw new ResourceError(msg);
        }
    }

    protected PixelBuffer createRomioPixelBuffer(String pixelsFilePath, Pixels pixels, boolean allowModification) {
        return new RomioPixelBuffer(pixelsFilePath, pixels, allowModification);
    }

    public void removePixels(List<Long> pixelIds) {
        boolean success = false;
        for (Long id : pixelIds) {
            String pixelPath = this.getPixelsPath(id);
            File file2 = new File(pixelPath);
            String fileName = file2.getName();
            if (!file2.exists()) continue;
            success = file2.delete();
            if (!success) {
                throw new ResourceError("Pixels " + fileName + " deletion failed");
            }
            if (!log.isInfoEnabled()) continue;
            log.info("INFO: Pixels " + fileName + " deleted.");
        }
    }

    class PixelsPyramidMinMaxStore
    implements IMinMaxStore {
        final double[][] channelGlobalMinMax;
        final int sizeC;

        public PixelsPyramidMinMaxStore(int sizeC) {
            this.sizeC = sizeC;
            this.channelGlobalMinMax = new double[sizeC][2];
        }

        @Override
        public void setChannelGlobalMinMax(int channel, double minimum, double maximum, int series) {
            this.channelGlobalMinMax[channel][0] = minimum;
            this.channelGlobalMinMax[channel][1] = maximum;
        }

        public StatsInfo[] createStatsInfo() {
            StatsInfo[] statsInfo = new StatsInfo[this.sizeC];
            for (int c = 0; c < this.sizeC; ++c) {
                statsInfo[c] = new StatsInfo();
                statsInfo[c].setGlobalMin(this.channelGlobalMinMax[c][0]);
                statsInfo[c].setGlobalMax(this.channelGlobalMinMax[c][1]);
            }
            return statsInfo;
        }
    }
}

