/*
 * Decompiled with CFR 0.152.
 */
package ome.io.nio;

import java.io.File;
import java.util.List;
import ome.conditions.ResourceError;
import ome.io.nio.AbstractFileSystemService;
import ome.io.nio.FileBuffer;
import ome.model.core.OriginalFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OriginalFilesService
extends AbstractFileSystemService {
    private static transient Logger log = LoggerFactory.getLogger(OriginalFilesService.class);

    public OriginalFilesService(String path) {
        super(path);
    }

    public FileBuffer getFileBuffer(OriginalFile file2, String mode) {
        String path = this.getFilesPath(file2.getId());
        this.createSubpath(path);
        return new FileBuffer(path, mode);
    }

    public void removeFiles(List<Long> fileIds) {
        boolean success = false;
        for (Long id : fileIds) {
            String filePath = this.getFilesPath(id);
            File file2 = new File(filePath);
            if (!file2.exists()) continue;
            success = file2.delete();
            if (!success) {
                throw new ResourceError("File " + file2.getName() + " deletion failed");
            }
            if (!log.isInfoEnabled()) continue;
            log.info("INFO: File " + file2.getName() + " deleted.");
        }
    }

    public boolean exists(OriginalFile file2) {
        String path = this.getFilesPath(file2.getId());
        return new File(path).exists();
    }
}

