/*
 * Decompiled with CFR 0.152.
 */
package ome.io.nio;

import java.awt.Dimension;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import ome.io.nio.DimensionsOutOfBoundsException;
import ome.io.nio.PixelBuffer;
import ome.model.core.Pixels;
import ome.util.PixelData;

public class InMemoryPlanarPixelBuffer
implements PixelBuffer {
    private byte[][][][] planes;
    private Pixels pixels;

    public InMemoryPlanarPixelBuffer(Pixels pixels, byte[][][][] planes) {
        this.pixels = pixels;
        this.planes = planes;
    }

    @Override
    public byte[] calculateMessageDigest() throws IOException {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Required SHA-1 message digest algorithm unavailable.");
        }
        for (int z = 0; z < this.getSizeZ(); ++z) {
            for (int c = 0; c < this.getSizeC(); ++c) {
                for (int t = 0; t < this.getSizeT(); ++t) {
                    try {
                        ByteBuffer buffer = this.getPlane(z, c, t).getData();
                        md.update(buffer);
                        continue;
                    }
                    catch (DimensionsOutOfBoundsException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        return md.digest();
    }

    @Override
    public void checkBounds(Integer x, Integer y, Integer z, Integer c, Integer t) throws DimensionsOutOfBoundsException {
        if (x != null && (x > this.getSizeX() - 1 || x < 0)) {
            throw new DimensionsOutOfBoundsException("X '" + x + "' greater than sizeX '" + this.getSizeX() + "'.");
        }
        if (y != null && (y > this.getSizeY() - 1 || y < 0)) {
            throw new DimensionsOutOfBoundsException("Y '" + y + "' greater than sizeY '" + this.getSizeY() + "'.");
        }
        if (z != null && (z > this.getSizeZ() - 1 || z < 0)) {
            throw new DimensionsOutOfBoundsException("Z '" + z + "' greater than sizeZ '" + this.getSizeZ() + "'.");
        }
        if (c != null && (c > this.getSizeC() - 1 || c < 0)) {
            throw new DimensionsOutOfBoundsException("C '" + c + "' greater than sizeC '" + this.getSizeC() + "'.");
        }
        if (t != null && (t > this.getSizeT() - 1 || t < 0)) {
            throw new DimensionsOutOfBoundsException("T '" + t + "' greater than sizeT '" + this.getSizeT() + "'.");
        }
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public int getByteWidth() {
        return PixelData.getBitDepth(this.pixels.getPixelsType().getValue()) / 8;
    }

    @Override
    public long getId() {
        throw new NullPointerException("In memory planar buffers have no Id.");
    }

    @Override
    public String getPath() {
        throw new NullPointerException("In memory planar buffers have no path.");
    }

    @Override
    public Long getHypercubeSize(List<Integer> offset, List<Integer> size, List<Integer> step) throws DimensionsOutOfBoundsException {
        throw new UnsupportedOperationException("Not supported with in memory planar buffers.");
    }

    @Override
    public PixelData getHypercube(List<Integer> offset, List<Integer> size, List<Integer> step) throws IOException, DimensionsOutOfBoundsException {
        throw new UnsupportedOperationException("Not supported with in memory planar buffers.");
    }

    @Override
    public byte[] getHypercubeDirect(List<Integer> offset, List<Integer> size, List<Integer> step, byte[] buffer) throws IOException, DimensionsOutOfBoundsException {
        throw new UnsupportedOperationException("Not supported with in memory planar buffers.");
    }

    @Override
    public PixelData getPlane(Integer z, Integer c, Integer t) throws IOException, DimensionsOutOfBoundsException {
        ByteBuffer buf = ByteBuffer.wrap(this.planes[z][c][t]);
        return new PixelData(this.pixels.getPixelsType().getValue(), buf);
    }

    @Override
    public byte[] getPlaneDirect(Integer z, Integer c, Integer t, byte[] buffer) throws IOException, DimensionsOutOfBoundsException {
        return this.planes[z][c][t];
    }

    @Override
    public Long getPlaneOffset(Integer z, Integer c, Integer t) throws DimensionsOutOfBoundsException {
        throw new UnsupportedOperationException("Not supported with in memory planar buffers.");
    }

    @Override
    public PixelData getPlaneRegion(Integer x, Integer y, Integer width, Integer height, Integer z, Integer c, Integer t, Integer stride) throws IOException, DimensionsOutOfBoundsException {
        return null;
    }

    @Override
    public byte[] getPlaneRegionDirect(Integer z, Integer c, Integer t, Integer count, Integer offset, byte[] buffer) throws IOException, DimensionsOutOfBoundsException {
        byte[] plane = this.planes[z][c][t];
        int sourceOffset = offset * this.getByteWidth();
        int length = count * this.getByteWidth();
        System.arraycopy(plane, sourceOffset, buffer, 0, length);
        return buffer;
    }

    @Override
    public Long getPlaneSize() {
        return (long)this.pixels.getSizeX().intValue() * (long)this.pixels.getSizeY().intValue() * (long)this.getByteWidth();
    }

    @Override
    public PixelData getRegion(Integer size, Long offset) throws IOException {
        throw new UnsupportedOperationException("Not supported with in memory planar buffers.");
    }

    @Override
    public byte[] getRegionDirect(Integer size, Long offset, byte[] buffer) throws IOException {
        throw new UnsupportedOperationException("Not supported with in memory planar buffers.");
    }

    @Override
    public PixelData getRow(Integer y, Integer z, Integer c, Integer t) throws IOException, DimensionsOutOfBoundsException {
        throw new UnsupportedOperationException("Not supported with in memory planar buffers.");
    }

    @Override
    public PixelData getCol(Integer x, Integer z, Integer c, Integer t) throws IOException, DimensionsOutOfBoundsException {
        throw new UnsupportedOperationException("Not supported with in memory planar buffers.");
    }

    @Override
    public byte[] getRowDirect(Integer y, Integer z, Integer c, Integer t, byte[] buffer) throws IOException, DimensionsOutOfBoundsException {
        throw new UnsupportedOperationException("Not supported with in memory planar buffers.");
    }

    @Override
    public byte[] getColDirect(Integer x, Integer z, Integer c, Integer t, byte[] buffer) throws IOException, DimensionsOutOfBoundsException {
        throw new UnsupportedOperationException("Not supported with in memory planar buffers.");
    }

    @Override
    public Long getRowOffset(Integer y, Integer z, Integer c, Integer t) throws DimensionsOutOfBoundsException {
        throw new UnsupportedOperationException("Not supported with in memory planar buffers.");
    }

    @Override
    public Integer getRowSize() {
        return this.getSizeX() * this.getByteWidth();
    }

    @Override
    public Integer getColSize() {
        return this.getSizeY() * this.getByteWidth();
    }

    @Override
    public int getSizeC() {
        return this.pixels.getSizeC();
    }

    @Override
    public int getSizeT() {
        return this.pixels.getSizeT();
    }

    @Override
    public int getSizeX() {
        return this.pixels.getSizeX();
    }

    @Override
    public int getSizeY() {
        return this.pixels.getSizeY();
    }

    @Override
    public int getSizeZ() {
        return this.pixels.getSizeZ();
    }

    @Override
    public PixelData getStack(Integer c, Integer t) throws IOException, DimensionsOutOfBoundsException {
        throw new UnsupportedOperationException("Not supported with in memory planar buffers.");
    }

    @Override
    public byte[] getStackDirect(Integer c, Integer t, byte[] buffer) throws IOException, DimensionsOutOfBoundsException {
        throw new UnsupportedOperationException("Not supported with in memory planar buffers.");
    }

    @Override
    public Long getStackOffset(Integer c, Integer t) throws DimensionsOutOfBoundsException {
        throw new UnsupportedOperationException("Not supported with in memory planar buffers.");
    }

    @Override
    public Long getStackSize() {
        return this.getPlaneSize() * (long)this.pixels.getSizeZ().intValue();
    }

    @Override
    public PixelData getTimepoint(Integer t) throws IOException, DimensionsOutOfBoundsException {
        throw new UnsupportedOperationException("Not supported with in memory planar buffers.");
    }

    @Override
    public byte[] getTimepointDirect(Integer t, byte[] buffer) throws IOException, DimensionsOutOfBoundsException {
        throw new UnsupportedOperationException("Not supported with in memory planar buffers.");
    }

    @Override
    public Long getTimepointOffset(Integer t) throws DimensionsOutOfBoundsException {
        throw new UnsupportedOperationException("Not supported with in memory planar buffers.");
    }

    @Override
    public Long getTimepointSize() {
        return this.getStackSize() * (long)this.pixels.getSizeC().intValue();
    }

    @Override
    public Long getTotalSize() {
        return this.getTimepointSize() * (long)this.pixels.getSizeT().intValue();
    }

    @Override
    public boolean isFloat() {
        ByteBuffer b = null;
        PixelData d = new PixelData(this.pixels.getPixelsType().getValue(), b);
        return d.isFloat();
    }

    @Override
    public boolean isSigned() {
        ByteBuffer b = null;
        PixelData d = new PixelData(this.pixels.getPixelsType().getValue(), b);
        return d.isSigned();
    }

    @Override
    public void setPlane(ByteBuffer buffer, Integer z, Integer c, Integer t) throws IOException, DimensionsOutOfBoundsException, BufferOverflowException {
        throw new UnsupportedOperationException("Not supported with in memory planar buffers.");
    }

    @Override
    public void setPlane(byte[] buffer, Integer z, Integer c, Integer t) throws IOException, DimensionsOutOfBoundsException, BufferOverflowException {
        throw new UnsupportedOperationException("Not supported with in memory planar buffers.");
    }

    @Override
    public void setRegion(Integer size, Long offset, byte[] buffer) throws IOException, BufferOverflowException {
        throw new UnsupportedOperationException("Not supported with in memory planar buffers.");
    }

    @Override
    public void setRegion(Integer size, Long offset, ByteBuffer buffer) throws IOException, BufferOverflowException {
        throw new UnsupportedOperationException("Not supported with in memory planar buffers.");
    }

    @Override
    public void setRow(ByteBuffer buffer, Integer y, Integer z, Integer c, Integer t) throws IOException, DimensionsOutOfBoundsException, BufferOverflowException {
        throw new UnsupportedOperationException("Not supported with in memory planar buffers.");
    }

    @Override
    public void setStack(ByteBuffer buffer, Integer z, Integer c, Integer t) throws IOException, DimensionsOutOfBoundsException, BufferOverflowException {
        throw new UnsupportedOperationException("Not supported with in memory planar buffers.");
    }

    @Override
    public void setStack(byte[] buffer, Integer z, Integer c, Integer t) throws IOException, DimensionsOutOfBoundsException, BufferOverflowException {
        throw new UnsupportedOperationException("Not supported with in memory planar buffers.");
    }

    @Override
    public void setTimepoint(ByteBuffer buffer, Integer t) throws IOException, DimensionsOutOfBoundsException, BufferOverflowException {
        throw new UnsupportedOperationException("Not supported with in memory planar buffers.");
    }

    @Override
    public void setTimepoint(byte[] buffer, Integer t) throws IOException, DimensionsOutOfBoundsException, BufferOverflowException {
        throw new UnsupportedOperationException("Not supported with in memory planar buffers.");
    }

    @Override
    public PixelData getTile(Integer z, Integer c, Integer t, Integer x, Integer y, Integer w, Integer h) throws IOException {
        throw new UnsupportedOperationException("Not supported with in memory planar buffers.");
    }

    @Override
    public byte[] getTileDirect(Integer z, Integer c, Integer t, Integer x, Integer y, Integer w, Integer h, byte[] buffer) throws IOException {
        throw new UnsupportedOperationException("Not supported with in memory planar buffers.");
    }

    @Override
    public void setTile(byte[] buffer, Integer z, Integer c, Integer t, Integer x, Integer y, Integer w, Integer h) throws IOException, BufferOverflowException {
        throw new UnsupportedOperationException("Not supported with in memory planar buffers.");
    }

    @Override
    public int getResolutionLevel() {
        return 0;
    }

    @Override
    public int getResolutionLevels() {
        return 1;
    }

    @Override
    public List<List<Integer>> getResolutionDescriptions() {
        List<Integer> sizes = Arrays.asList(this.getSizeX(), this.getSizeY());
        ArrayList<List<Integer>> rv = new ArrayList<List<Integer>>();
        rv.add(sizes);
        return rv;
    }

    @Override
    public Dimension getTileSize() {
        return null;
    }

    @Override
    public void setResolutionLevel(int resolutionLevel) {
        throw new UnsupportedOperationException("Cannot set resolution levels on an in memory pixel buffer.");
    }
}

