/*
 * Decompiled with CFR 0.152.
 */
package ome.io.nio;

import java.io.File;
import java.util.Formatter;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractFileSystemService {
    private static Logger log = LoggerFactory.getLogger(AbstractFileSystemService.class);
    public static final String ROOT_DEFAULT = File.separator + "OMERO" + File.separator;
    public static final String PIXELS_PATH = "Pixels" + File.separator;
    public static final String FILES_PATH = "Files" + File.separator;
    public static final String THUMBNAILS_PATH = "Thumbnails" + File.separator;
    private final String root;

    public AbstractFileSystemService(String path) {
        File rootDirectory = new File(path);
        if (!(rootDirectory.isDirectory() && rootDirectory.canRead() && rootDirectory.canWrite())) {
            throw new IllegalArgumentException("Invalid directory specified for file system service." + rootDirectory);
        }
        this.root = rootDirectory.getAbsolutePath();
        if (log.isDebugEnabled()) {
            log.debug("Using root path: '" + this.root + "'");
        }
    }

    protected void createSubpath(String path) {
        File directory;
        File file2 = new File(path);
        if (!file2.exists() && !(directory = new File(file2.getParent())).exists()) {
            directory.mkdirs();
        }
    }

    public String getPixelsPath(Long id) {
        return this.getPath(PIXELS_PATH, id);
    }

    public String getFilesPath(Long id) {
        return this.getPath(FILES_PATH, id);
    }

    public String getThumbnailPath(Long id) {
        return this.getPath(THUMBNAILS_PATH, id);
    }

    private String getPath(String prefix, Long id) {
        String suffix = "";
        Long remaining = id;
        Long dirno = 0L;
        if (id == null) {
            throw new NullPointerException("Expecting a not-null id.");
        }
        while (remaining > 999L) {
            if ((remaining = Long.valueOf(remaining / 1000L)) <= 0L) continue;
            Formatter formatter = new Formatter();
            Throwable throwable = null;
            try {
                dirno = remaining % 1000L;
                suffix = formatter.format("Dir-%03d", dirno).out().toString() + File.separator + suffix;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (formatter == null) continue;
                if (throwable != null) {
                    try {
                        formatter.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                formatter.close();
            }
        }
        return FilenameUtils.concat(this.root, prefix + suffix + id);
    }
}

