/*
 * Decompiled with CFR 0.152.
 */
package ome.io.bioformats;

import java.io.IOException;
import loci.common.RandomAccessInputStream;
import loci.formats.FormatException;
import loci.formats.in.MinimalTiffReader;
import loci.formats.tiff.IFD;
import loci.formats.tiff.TiffParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OmeroPixelsPyramidReader
extends MinimalTiffReader {
    private static final Logger log = LoggerFactory.getLogger(OmeroPixelsPyramidReader.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isThisType(String name, boolean open) {
        boolean isThisType = super.isThisType(name, open);
        if (!isThisType && open) {
            RandomAccessInputStream stream = null;
            try {
                stream = new RandomAccessInputStream(name);
                TiffParser tiffParser = new TiffParser(stream);
                if (!tiffParser.isValidHeader()) {
                    boolean bl = false;
                    return bl;
                }
                String imageDescription = tiffParser.getFirstIFD().getIFDTextValue(270);
                if (imageDescription != null && imageDescription.startsWith("OmeroPixelsPyramid")) {
                    boolean e = true;
                    return e;
                }
                boolean e = false;
                return e;
            }
            catch (IOException e) {
                log.error("I/O exception during isThisType() evaluation.", e);
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    if (stream != null) {
                        stream.close();
                    }
                }
                catch (IOException e) {
                    log.error("I/O exception during stream closure.", e);
                }
            }
        }
        return isThisType;
    }

    @Override
    public void setId(String id) throws FormatException, IOException {
        log.debug("setId(" + id + ")");
        super.setId(id);
    }

    @Override
    public void close() throws IOException {
        log.debug("close(" + this.currentId + ")");
        super.close();
    }

    @Override
    protected void setResolutionLevel(IFD ifd) {
        if (ifd.get(65000) == null) {
            super.setResolutionLevel(ifd);
        }
    }
}

