/*
 * Decompiled with CFR 0.152.
 */
package ome.io.bioformats;

import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.List;
import loci.common.services.ServiceFactory;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.meta.IMetadata;
import loci.formats.services.OMEXMLService;
import loci.formats.tiff.IFD;
import loci.formats.tiff.TiffCompression;
import ome.conditions.ApiUsageException;
import ome.conditions.LockTimeout;
import ome.conditions.ResourceError;
import ome.io.bioformats.BfPixelBuffer;
import ome.io.bioformats.OmeroPixelsPyramidReader;
import ome.io.bioformats.OmeroPixelsPyramidWriter;
import ome.io.nio.ConfiguredTileSizes;
import ome.io.nio.DimensionsOutOfBoundsException;
import ome.io.nio.PixelBuffer;
import ome.io.nio.TileSizes;
import ome.model.core.Pixels;
import ome.util.PixelData;
import ome.xml.model.enums.DimensionOrder;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.enums.PixelType;
import ome.xml.model.primitives.PositiveInteger;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BfPyramidPixelBuffer
implements PixelBuffer {
    private static final Logger log = LoggerFactory.getLogger(BfPyramidPixelBuffer.class);
    private BfPixelBuffer delegate;
    protected OmeroPixelsPyramidWriter writer;
    protected OmeroPixelsPyramidReader reader;
    private final File readerFile;
    private final TileSizes sizes;
    private final Pixels pixels;
    private IFD lastIFD;
    private int lastZ = -1;
    private int lastC = -1;
    private int lastT = -1;
    private IMetadata metadata;
    private File writerFile;
    private File lockFile;
    private RandomAccessFile lockRaf;
    private FileLock fileLock;
    private ByteOrder byteOrder = ByteOrder.BIG_ENDIAN;
    public static final String PYR_LOCK_EXT = ".pyr_lock";

    public BfPyramidPixelBuffer(Pixels pixels, String filePath, boolean write) throws IOException, FormatException {
        this(new ConfiguredTileSizes(), pixels, filePath, write);
    }

    public BfPyramidPixelBuffer(TileSizes sizes, Pixels pixels, String filePath, boolean write) throws IOException, FormatException {
        this(sizes, pixels, filePath, write, true);
    }

    protected BfPyramidPixelBuffer(TileSizes sizes, Pixels pixels, String filePath, boolean write, boolean init) throws IOException, FormatException {
        this.sizes = sizes;
        this.readerFile = new File(filePath);
        this.pixels = pixels;
        if (init) {
            this.init(filePath, write);
        }
    }

    protected void init(String filePath, boolean write) throws IOException, FormatException {
        if (!write || this.readerFile.exists()) {
            if (write) {
                log.debug("Initialized in a write-context; setting read-only for " + filePath);
            }
            if (!this.readerFile.exists() && !this.readerFile.canRead()) {
                throw new IOException("Cannot access " + filePath);
            }
            this.initializeReader();
        } else {
            File readerDir = this.readerFile.getParentFile();
            this.writerFile = File.createTempFile("." + this.readerFile.getName(), ".tmp", readerDir);
            this.writerFile.deleteOnExit();
            this.acquireLock();
        }
    }

    protected synchronized void initializeReader() throws IOException, FormatException {
        File lockFile = this.lockFile();
        if (this.readerFile.exists() && lockFile.exists()) {
            lockFile.delete();
        }
        this.reader = new OmeroPixelsPyramidReader();
        this.delegate = new BfPixelBuffer(this.readerFile.getAbsolutePath(), this.reader);
        this.byteOrder = this.delegate.isLittleEndian() ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
    }

    protected synchronized void initializeWriter(String output, String compression, boolean bigTiff, int tileWidth, int tileLength) throws FormatException {
        try {
            if (this.readerFile.exists()) {
                throw new ResourceError(" exists. Pyramid is read-only");
            }
            ServiceFactory lociServiceFactory = new ServiceFactory();
            OMEXMLService service = lociServiceFactory.getInstance(OMEXMLService.class);
            this.metadata = service.createOMEXMLMetadata();
            this.addSeries(tileWidth, tileLength);
            this.writer = new OmeroPixelsPyramidWriter();
            this.writer.setMetadataRetrieve(this.metadata);
            this.writer.setCompression(compression);
            this.writer.setWriteSequentially(true);
            this.writer.setInterleaved(true);
            this.writer.setBigTiff(bigTiff);
            this.writer.setId(output);
        }
        catch (Exception e) {
            throw new FormatException("Error instantiating service.", e);
        }
    }

    private void createSeries(int series, int sizeX, int sizeY) throws EnumerationException {
        this.metadata.setImageID("Image:" + series, series);
        this.metadata.setPixelsID("Pixels: " + series, series);
        this.metadata.setPixelsBinDataBigEndian(this.byteOrder == ByteOrder.BIG_ENDIAN, series, 0);
        this.metadata.setPixelsDimensionOrder(DimensionOrder.XYZCT, series);
        this.metadata.setPixelsType(PixelType.fromString(this.pixels.getPixelsType().getValue()), series);
        this.metadata.setPixelsSizeX(new PositiveInteger(sizeX), series);
        this.metadata.setPixelsSizeY(new PositiveInteger(sizeY), series);
        this.metadata.setPixelsSizeZ(new PositiveInteger(1), series);
        this.metadata.setPixelsSizeC(new PositiveInteger(1), series);
        int totalPlanes = this.pixels.getSizeZ() * this.pixels.getSizeC() * this.pixels.getSizeT();
        this.metadata.setPixelsSizeT(new PositiveInteger(totalPlanes), series);
        this.metadata.setChannelID("Channel:" + series, series, 0);
        this.metadata.setChannelSamplesPerPixel(new PositiveInteger(1), series, 0);
        if (log.isDebugEnabled()) {
            log.debug(String.format("Added series %d %dx%dx%d", series, sizeX, sizeY, totalPlanes));
        }
    }

    private void addSeries(int tileWidth, int tileLength) throws EnumerationException {
        int series = 0;
        for (int level : new int[]{0, 5, 4}) {
            long imageWidth = this.pixels.getSizeX().intValue();
            long imageLength = this.pixels.getSizeY().intValue();
            long factor = (long)Math.pow(2.0, level);
            long newTileWidth = Math.round((double)tileWidth / (double)factor);
            newTileWidth = newTileWidth < 1L ? 1L : newTileWidth;
            long newTileLength = Math.round((double)tileLength / (double)factor);
            newTileLength = newTileLength < 1L ? 1L : newTileLength;
            long evenTilesPerRow = imageWidth / (long)tileWidth;
            long evenTilesPerColumn = imageLength / (long)tileLength;
            double remainingWidth = (double)(imageWidth - evenTilesPerRow * (long)tileWidth) / (double)factor;
            remainingWidth = remainingWidth < 1.0 ? Math.ceil(remainingWidth) : (double)Math.round(remainingWidth);
            double remainingLength = ((double)imageLength - (double)(evenTilesPerColumn * (long)tileLength)) / (double)factor;
            remainingLength = remainingLength < 1.0 ? Math.ceil(remainingLength) : (double)Math.round(remainingLength);
            int newImageWidth = (int)((double)(evenTilesPerRow * newTileWidth) + remainingWidth);
            int newImageLength = (int)((double)(evenTilesPerColumn * newTileLength) + remainingLength);
            this.createSeries(series, newImageWidth, newImageLength);
            ++series;
        }
    }

    protected void acquireLock() {
        try {
            this.lockFile = this.lockFile();
            this.lockRaf = new RandomAccessFile(this.lockFile, "rw");
            this.fileLock = this.lockRaf.getChannel().lock();
        }
        catch (OverlappingFileLockException overlap) {
            this.closeRaf();
            throw new LockTimeout("Already locked! " + this.lockFile.getAbsolutePath(), 15000L, 0);
        }
        catch (IOException e) {
            this.closeRaf();
            throw new LockTimeout("IOException while locking " + this.lockFile.getAbsolutePath(), 15000L, 0);
        }
    }

    protected void closeRaf() {
        if (this.lockRaf != null) {
            try {
                this.lockRaf.close();
            }
            catch (Exception e) {
                log.warn("Failed to close " + this.lockFile, e);
            }
            finally {
                this.lockRaf = null;
            }
        }
    }

    protected boolean isLockedByOthers() {
        if (this.fileLock != null) {
            return false;
        }
        try {
            this.lockFile = this.lockFile();
            this.lockRaf = new RandomAccessFile(this.lockFile, "rw");
            try {
                this.fileLock = this.lockRaf.getChannel().tryLock();
            }
            catch (OverlappingFileLockException ofle) {
                log.debug("Overlapping file lock exception: " + this.readerFile);
            }
            if (this.fileLock == null) {
                this.lockFile = null;
                boolean ofle = true;
                return ofle;
            }
            boolean ofle = false;
            return ofle;
        }
        catch (IOException e) {
            this.lockFile = null;
            throw new RuntimeException(e);
        }
        finally {
            this.releaseLock();
        }
    }

    private File lockFile() {
        File parent = this.readerFile.getParentFile();
        String name = "." + this.readerFile.getName() + PYR_LOCK_EXT;
        File lock = new File(parent, name);
        return lock;
    }

    private void releaseLock() {
        try {
            if (this.fileLock != null) {
                this.fileLock.release();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.fileLock = null;
            this.closeRaf();
            if (this.lockFile != null) {
                this.lockFile.delete();
                this.lockFile = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeWriter() throws IOException {
        try {
            if (this.writer != null) {
                this.writer.close();
                this.writer = null;
            }
        }
        finally {
            block15: {
                try {
                    if (this.writerFile == null) break block15;
                    try {
                        FileUtils.moveFile(this.writerFile, this.readerFile);
                    }
                    finally {
                        this.writerFile = null;
                    }
                }
                finally {
                    this.releaseLock();
                }
            }
        }
    }

    public boolean isWrite() {
        return this.writerFile != null;
    }

    private BfPixelBuffer delegate() {
        block9: {
            if (this.isWrite()) {
                try {
                    this.closeWriter();
                    try {
                        this.initializeReader();
                        break block9;
                    }
                    catch (FormatException e) {
                        throw new RuntimeException(e);
                    }
                }
                catch (IOException e1) {
                    throw new RuntimeException(e1);
                }
            }
            if (this.delegate == null) {
                try {
                    this.initializeReader();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                catch (FormatException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return this.delegate;
    }

    @Override
    public synchronized void setTile(byte[] buffer, Integer z, Integer c, Integer t, Integer x, Integer y, Integer w, Integer h) throws IOException, BufferOverflowException {
        if (!this.isWrite()) {
            throw new ApiUsageException("In read-only mode!");
        }
        try {
            int planeCount = this.getSizeZ() * this.getSizeC() * this.getSizeT();
            int planeNumber = FormatTools.getIndex("XYZCT", this.getSizeZ(), this.getSizeC(), this.getSizeT(), planeCount, z, c, t);
            IFD ifd = this.getIFD(z, c, t, w, h);
            if (log.isDebugEnabled()) {
                log.debug(String.format("Writing tile planeNumber:%d bufferSize:%d ifd:%s x:%d y:%d w:%d h:%d", planeNumber, buffer.length, ifd.toString(), x, y, w, h));
            }
            this.writer.saveBytes(planeNumber, buffer, ifd, x, y, w, h);
        }
        catch (FormatException e) {
            throw new RuntimeException(e);
        }
    }

    private synchronized IFD getIFD(int z, int c, int t, int w, int h) {
        if (this.lastT == -1 && this.lastC == -1 && this.lastZ == -1) {
            try {
                this.initializeWriter(this.writerFile.getAbsolutePath(), TiffCompression.JPEG_2000.getCodecName(), true, w, h);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (this.lastT != t || this.lastC != c || this.lastZ != z) {
            this.lastIFD = new IFD();
            this.lastIFD.put(270, "OmeroPixelsPyramid v1.0.0");
            this.lastIFD.put(322, w);
            this.lastIFD.put(323, h);
            if (log.isDebugEnabled()) {
                log.debug(String.format("Creating new IFD z:%d c:%d t:%d w:%d: h:%d -- %s", z, c, t, w, h, this.lastIFD));
            }
        }
        this.lastT = t;
        this.lastC = c;
        this.lastZ = z;
        return this.lastIFD;
    }

    private int getRasterizedT(int z, int c, int t) {
        int rasterizedT = t * this.pixels.getSizeC() * this.pixels.getSizeZ() + c * this.pixels.getSizeZ() + z;
        if (log.isDebugEnabled()) {
            log.debug(String.format("Rasterizing z:%d c:%d t:%d to t:%d", z, c, t, rasterizedT));
        }
        return rasterizedT;
    }

    private synchronized void checkTileParameters(int x, int y, int w, int h) throws IOException {
    }

    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public void setByteOrder(ByteOrder byteOrder) {
        this.byteOrder = byteOrder;
    }

    @Override
    public synchronized byte[] calculateMessageDigest() throws IOException {
        return this.delegate().calculateMessageDigest();
    }

    @Override
    public synchronized void checkBounds(Integer x, Integer y, Integer z, Integer c, Integer t) throws DimensionsOutOfBoundsException {
        t = this.getRasterizedT(z, c, t);
        c = 0;
        z = 0;
        this.delegate().checkBounds(x, y, z, c, t);
    }

    @Override
    public synchronized void close() throws IOException {
        try {
            if (this.delegate != null) {
                this.delegate.close();
            }
        }
        catch (IOException e) {
            log.error("Failure to close delegate.", e);
        }
        this.delegate = null;
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (Exception e) {
                log.warn("Failed to close reader", e);
            }
            finally {
                this.reader = null;
            }
        }
        this.closeWriter();
    }

    @Override
    public synchronized int getByteWidth() {
        return this.delegate().getByteWidth();
    }

    @Override
    public synchronized PixelData getCol(Integer x, Integer z, Integer c, Integer t) throws IOException, DimensionsOutOfBoundsException {
        t = this.getRasterizedT(z, c, t);
        c = 0;
        z = 0;
        PixelData data = this.delegate().getCol(x, z, c, t);
        data.setOrder(this.byteOrder);
        return data;
    }

    @Override
    public synchronized byte[] getColDirect(Integer x, Integer z, Integer c, Integer t, byte[] buffer) throws IOException, DimensionsOutOfBoundsException {
        t = this.getRasterizedT(z, c, t);
        c = 0;
        z = 0;
        return this.delegate().getColDirect(x, z, c, t, buffer);
    }

    @Override
    public synchronized Integer getColSize() {
        return this.delegate().getColSize();
    }

    @Override
    public synchronized PixelData getHypercube(List<Integer> offset, List<Integer> size, List<Integer> step) throws IOException, DimensionsOutOfBoundsException {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    @Override
    public synchronized byte[] getHypercubeDirect(List<Integer> offset, List<Integer> size, List<Integer> step, byte[] buffer) throws IOException, DimensionsOutOfBoundsException {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    @Override
    public synchronized Long getHypercubeSize(List<Integer> offset, List<Integer> size, List<Integer> step) throws DimensionsOutOfBoundsException {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    @Override
    public synchronized long getId() {
        return this.delegate().getId();
    }

    @Override
    public synchronized String getPath() {
        return this.delegate().getPath();
    }

    @Override
    public synchronized PixelData getPlane(Integer z, Integer c, Integer t) throws IOException, DimensionsOutOfBoundsException {
        t = this.getRasterizedT(z, c, t);
        c = 0;
        z = 0;
        PixelData data = this.delegate().getPlane(z, c, t);
        data.setOrder(this.byteOrder);
        return data;
    }

    @Override
    public synchronized byte[] getPlaneDirect(Integer z, Integer c, Integer t, byte[] buffer) throws IOException, DimensionsOutOfBoundsException {
        t = this.getRasterizedT(z, c, t);
        c = 0;
        z = 0;
        return this.delegate().getPlaneDirect(z, c, t, buffer);
    }

    @Override
    public synchronized Long getPlaneOffset(Integer z, Integer c, Integer t) throws DimensionsOutOfBoundsException {
        t = this.getRasterizedT(z, c, t);
        c = 0;
        z = 0;
        return this.delegate().getPlaneOffset(z, c, t);
    }

    @Override
    public synchronized PixelData getPlaneRegion(Integer x, Integer y, Integer width, Integer height, Integer z, Integer c, Integer t, Integer stride) throws IOException, DimensionsOutOfBoundsException {
        t = this.getRasterizedT(z, c, t);
        c = 0;
        z = 0;
        PixelData data = this.delegate().getPlaneRegion(x, y, width, height, z, c, t, stride);
        data.setOrder(this.byteOrder);
        return data;
    }

    @Override
    public synchronized byte[] getPlaneRegionDirect(Integer z, Integer c, Integer t, Integer count, Integer offset, byte[] buffer) throws IOException, DimensionsOutOfBoundsException {
        t = this.getRasterizedT(z, c, t);
        c = 0;
        z = 0;
        return this.getPlaneRegionDirect(z, c, t, count, offset, buffer);
    }

    @Override
    public synchronized Long getPlaneSize() {
        return this.delegate().getPlaneSize();
    }

    @Override
    public PixelData getRegion(Integer size, Long offset) throws IOException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public byte[] getRegionDirect(Integer size, Long offset, byte[] buffer) throws IOException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public synchronized PixelData getRow(Integer y, Integer z, Integer c, Integer t) throws IOException, DimensionsOutOfBoundsException {
        t = this.getRasterizedT(z, c, t);
        c = 0;
        z = 0;
        PixelData data = this.delegate().getRow(y, z, c, t);
        data.setOrder(this.byteOrder);
        return data;
    }

    @Override
    public synchronized byte[] getRowDirect(Integer y, Integer z, Integer c, Integer t, byte[] buffer) throws IOException, DimensionsOutOfBoundsException {
        t = this.getRasterizedT(z, c, t);
        c = 0;
        z = 0;
        return this.delegate().getRowDirect(y, z, c, t, buffer);
    }

    @Override
    public synchronized Long getRowOffset(Integer y, Integer z, Integer c, Integer t) throws DimensionsOutOfBoundsException {
        t = this.getRasterizedT(z, c, t);
        c = 0;
        z = 0;
        return this.delegate().getRowOffset(y, z, c, t);
    }

    @Override
    public synchronized Integer getRowSize() {
        return this.delegate().getRowSize();
    }

    @Override
    public int getSizeC() {
        return this.pixels.getSizeC();
    }

    @Override
    public int getSizeT() {
        return this.pixels.getSizeT();
    }

    @Override
    public synchronized int getSizeX() {
        if (this.delegate == null || this.delegate.reader.get() == null) {
            return this.pixels.getSizeX();
        }
        return this.delegate.getSizeX();
    }

    @Override
    public synchronized int getSizeY() {
        if (this.delegate == null || this.delegate.reader.get() == null) {
            return this.pixels.getSizeY();
        }
        return this.delegate.getSizeY();
    }

    @Override
    public int getSizeZ() {
        return this.pixels.getSizeZ();
    }

    @Override
    public PixelData getStack(Integer c, Integer t) throws IOException, DimensionsOutOfBoundsException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public byte[] getStackDirect(Integer c, Integer t, byte[] buffer) throws IOException, DimensionsOutOfBoundsException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public Long getStackOffset(Integer c, Integer t) throws DimensionsOutOfBoundsException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public synchronized Long getStackSize() {
        return this.delegate().getStackSize();
    }

    @Override
    public synchronized PixelData getTile(Integer z, Integer c, Integer t, Integer x, Integer y, Integer w, Integer h) throws IOException {
        this.checkTileParameters(x, y, w, h);
        t = this.getRasterizedT(z, c, t);
        c = 0;
        z = 0;
        PixelData data = this.delegate().getTile(z, c, t, x, y, w, h);
        data.setOrder(this.byteOrder);
        return data;
    }

    @Override
    public synchronized byte[] getTileDirect(Integer z, Integer c, Integer t, Integer x, Integer y, Integer w, Integer h, byte[] buffer) throws IOException {
        this.checkTileParameters(x, y, w, h);
        t = this.getRasterizedT(z, c, t);
        c = 0;
        z = 0;
        return this.delegate().getTileDirect(z, c, t, x, y, w, h, buffer);
    }

    @Override
    public synchronized PixelData getTimepoint(Integer t) throws IOException, DimensionsOutOfBoundsException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public synchronized byte[] getTimepointDirect(Integer t, byte[] buffer) throws IOException, DimensionsOutOfBoundsException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public Long getTimepointOffset(Integer t) throws DimensionsOutOfBoundsException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public synchronized Long getTimepointSize() {
        return this.delegate().getTimepointSize();
    }

    @Override
    public synchronized Long getTotalSize() {
        return this.delegate().getTotalSize();
    }

    @Override
    public synchronized boolean isFloat() {
        return this.delegate().isFloat();
    }

    @Override
    public synchronized boolean isSigned() {
        return this.delegate().isSigned();
    }

    @Override
    public void setPlane(ByteBuffer buffer, Integer z, Integer c, Integer t) throws IOException, DimensionsOutOfBoundsException, BufferOverflowException {
        throw new UnsupportedOperationException("Non-tile based writing unsupported.");
    }

    @Override
    public void setPlane(byte[] buffer, Integer z, Integer c, Integer t) throws IOException, DimensionsOutOfBoundsException, BufferOverflowException {
        throw new UnsupportedOperationException("Non-tile based writing unsupported.");
    }

    @Override
    public void setRegion(Integer size, Long offset, byte[] buffer) throws IOException, BufferOverflowException {
        throw new UnsupportedOperationException("Non-tile based writing unsupported.");
    }

    @Override
    public void setRegion(Integer size, Long offset, ByteBuffer buffer) throws IOException, BufferOverflowException {
        throw new UnsupportedOperationException("Non-tile based writing unsupported.");
    }

    @Override
    public void setRow(ByteBuffer buffer, Integer y, Integer z, Integer c, Integer t) throws IOException, DimensionsOutOfBoundsException, BufferOverflowException {
        throw new UnsupportedOperationException("Non-tile based writing unsupported.");
    }

    @Override
    public void setStack(ByteBuffer buffer, Integer z, Integer c, Integer t) throws IOException, DimensionsOutOfBoundsException, BufferOverflowException {
        throw new UnsupportedOperationException("Non-tile based writing unsupported.");
    }

    @Override
    public void setStack(byte[] buffer, Integer z, Integer c, Integer t) throws IOException, DimensionsOutOfBoundsException, BufferOverflowException {
        throw new UnsupportedOperationException("Non-tile based writing unsupported.");
    }

    @Override
    public void setTimepoint(ByteBuffer buffer, Integer t) throws IOException, DimensionsOutOfBoundsException, BufferOverflowException {
        throw new UnsupportedOperationException("Non-tile based writing unsupported.");
    }

    @Override
    public void setTimepoint(byte[] buffer, Integer t) throws IOException, DimensionsOutOfBoundsException, BufferOverflowException {
        throw new UnsupportedOperationException("Non-tile based writing unsupported.");
    }

    @Override
    public synchronized int getResolutionLevel() {
        if (this.isWrite()) {
            throw new ApiUsageException("In write mode!");
        }
        return this.delegate().getResolutionLevel();
    }

    @Override
    public synchronized int getResolutionLevels() {
        if (this.isWrite()) {
            throw new ApiUsageException("In write mode!");
        }
        return this.delegate().getResolutionLevels();
    }

    @Override
    public synchronized List<List<Integer>> getResolutionDescriptions() {
        if (this.isWrite()) {
            throw new ApiUsageException("In write mode!");
        }
        return this.delegate().getResolutionDescriptions();
    }

    @Override
    public synchronized Dimension getTileSize() {
        if (this.isWrite()) {
            return new Dimension(this.sizes.getTileWidth(), this.sizes.getTileHeight());
        }
        return this.delegate().getTileSize();
    }

    @Override
    public synchronized void setResolutionLevel(int resolutionLevel) {
        if (this.isWrite()) {
            throw new ApiUsageException("In write mode!");
        }
        this.delegate().setResolutionLevel(resolutionLevel);
    }
}

