/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.model;

import java.io.File;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import loci.formats.IFormatReader;
import ome.formats.Index;
import ome.formats.model.IObjectContainerStore;
import ome.formats.model.ModelException;
import ome.formats.model.ModelProcessor;
import ome.formats.model.UnitsFactory;
import ome.util.LSID;
import omero.metadatastore.IObjectContainer;
import omero.model.Annotation;
import omero.model.Image;
import omero.model.Pixels;
import omero.rtypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PixelsProcessor
implements ModelProcessor {
    private Logger log = LoggerFactory.getLogger(PixelsProcessor.class);
    private Timestamp earliestMTime;
    private IFormatReader reader;

    @Override
    public void process(IObjectContainerStore store) throws ModelException {
        this.reader = store.getReader();
        List<IObjectContainer> containers = store.getIObjectContainers(Pixels.class);
        for (IObjectContainer container : containers) {
            String imageName;
            String userSpecifiedName;
            Integer imageIndex = container.indexes.get(Index.IMAGE_INDEX.getValue());
            LSID imageLSID = new LSID(Image.class, imageIndex);
            Image image = (Image)store.getSourceObject(imageLSID);
            Pixels pixels = (Pixels)container.sourceObject;
            Double[] physicalPixelSizes = store.getUserSpecifiedPhysicalPixelSizes();
            List<Annotation> annotations = store.getUserSpecifiedAnnotations();
            if (annotations == null) {
                annotations = new ArrayList<Annotation>();
            }
            Map<LSID, IObjectContainer> containerCache = store.getContainerCache();
            for (int i = 0; i < annotations.size(); ++i) {
                LSID annotationLSID = new LSID("UserSpecifiedAnnotation:" + i);
                IObjectContainer annotationContainer = new IObjectContainer();
                annotationContainer.LSID = annotationLSID.toString();
                annotationContainer.sourceObject = annotations.get(i);
                containerCache.put(annotationLSID, annotationContainer);
                store.addReference(imageLSID, annotationLSID);
            }
            if (physicalPixelSizes != null) {
                if (physicalPixelSizes[0] != null && pixels.getPhysicalSizeX() == null) {
                    pixels.setPhysicalSizeX(UnitsFactory.makeLength((double)physicalPixelSizes[0], UnitsFactory.Pixels_PhysicalSizeX));
                }
                if (physicalPixelSizes[1] != null && pixels.getPhysicalSizeY() == null) {
                    pixels.setPhysicalSizeY(UnitsFactory.makeLength((double)physicalPixelSizes[1], UnitsFactory.Pixels_PhysicalSizeY));
                }
                if (physicalPixelSizes[2] != null && pixels.getPhysicalSizeZ() == null) {
                    pixels.setPhysicalSizeZ(UnitsFactory.makeLength((double)physicalPixelSizes[2], UnitsFactory.Pixels_PhysicalSizeZ));
                }
            }
            if (image == null) {
                LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
                indexes.put(Index.IMAGE_INDEX, imageIndex);
                container = store.getIObjectContainer(Image.class, indexes);
                image = (Image)container.sourceObject;
            }
            if ((userSpecifiedName = store.getUserSpecifiedName()) != null && (userSpecifiedName = userSpecifiedName.trim()).isEmpty()) {
                userSpecifiedName = null;
            }
            if (userSpecifiedName == null) {
                File originalFile = new File(this.reader.getCurrentFile());
                userSpecifiedName = originalFile.getName();
            }
            String saveName = "";
            if (image.getName() != null && image.getName().getValue() != null) {
                imageName = image.getName().getValue().trim();
                if (imageName.isEmpty()) {
                    imageName = null;
                }
            } else {
                imageName = null;
            }
            if (userSpecifiedName != null) {
                saveName = userSpecifiedName;
                if (this.reader.getSeriesCount() > 1) {
                    if (imageName == null) {
                        imageName = Integer.toString(imageIndex);
                    }
                    saveName = saveName + " [" + imageName + "]";
                }
            } else {
                saveName = imageName;
            }
            if (saveName != null && saveName.length() > 255) {
                saveName = '\u2026' + saveName.substring(saveName.length() - 254);
            }
            image.setName(rtypes.rstring(saveName));
            String userSpecifiedDescription = store.getUserSpecifiedDescription();
            if (userSpecifiedDescription == null) continue;
            image.setDescription(rtypes.rstring(userSpecifiedDescription));
        }
    }
}

