/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.importer.util;

import ome.formats.importer.util.TimeEstimator;
import org.apache.commons.lang.time.StopWatch;

public class ProportionalTimeEstimatorImpl
implements TimeEstimator {
    private long imageContainerSize = 0L;
    private long timeLeft = 0L;
    private long totalBytes = 0L;
    private long totalTime = 0L;
    private StopWatch sw = new StopWatch();

    public ProportionalTimeEstimatorImpl(long imageContainerSize) {
        this.imageContainerSize = imageContainerSize;
    }

    @Override
    public void start() {
        this.sw.reset();
        this.sw.start();
    }

    @Override
    public void stop() {
        this.sw.stop();
        this.totalTime += this.sw.getTime();
    }

    @Override
    public void stop(long uploadedBytes) {
        this.sw.stop();
        this.totalTime += this.sw.getTime();
        this.totalBytes += uploadedBytes;
        this.imageContainerSize -= uploadedBytes;
        if (this.totalTime > 0L) {
            float averageBps = (float)this.totalBytes / ((float)this.totalTime / 1000.0f);
            this.timeLeft = (long)Math.ceil((float)this.imageContainerSize / averageBps * 1000.0f);
        }
    }

    @Override
    public long getUploadTimeLeft() {
        return this.timeLeft;
    }
}

