/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.importer.util;

import com.google.common.io.Files;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import ome.formats.importer.IObservable;
import ome.formats.importer.IObserver;
import ome.formats.importer.ImportEvent;
import ome.formats.importer.util.ErrorContainer;
import ome.formats.importer.util.HtmlMessengerException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;

public class FileUploader
implements IObservable {
    public static final String ZIP_EXTENSION = ".zip";
    private static final String TOKEN = "token";
    private static final String READER = "file_format";
    private static final String FILE = "Filedata";
    private List<IObserver> observers = new ArrayList<IObserver>();
    private CloseableHttpClient client;

    public FileUploader(CloseableHttpClient httpClient) {
        this.client = httpClient;
    }

    private void zipDir(File directory, ZipOutputStream out, String parentDirectoryName) throws Exception {
        File[] entries = directory.listFiles();
        byte[] buffer = new byte[4096];
        for (int i = 0; i < entries.length; ++i) {
            int bytesRead;
            File f = entries[i];
            if (f.isHidden()) continue;
            if (f.isDirectory()) {
                this.zipDir(f, out, f.getName());
                continue;
            }
            FileInputStream in = new FileInputStream(f);
            String zipName = f.getName();
            if (!StringUtils.isEmpty(parentDirectoryName)) {
                zipName = FilenameUtils.concat(parentDirectoryName, zipName);
            }
            out.putNextEntry(new ZipEntry(zipName));
            while ((bytesRead = in.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
            }
            out.closeEntry();
            in.close();
        }
    }

    private File zipDirectory(File zip, boolean compress) throws Exception {
        if (zip == null) {
            throw new IllegalArgumentException("No name specified.");
        }
        if (!zip.isDirectory() || !zip.exists()) {
            throw new IllegalArgumentException("Not a valid directory.");
        }
        String extension = FilenameUtils.getExtension(zip.getName());
        String name = zip.getName();
        if (StringUtils.isEmpty(extension) || !ZIP_EXTENSION.equals("." + extension)) {
            name = name + ZIP_EXTENSION;
        }
        File file2 = new File(zip.getParentFile(), name);
        try (ZipOutputStream out = null;){
            out = new ZipOutputStream(new FileOutputStream(file2));
            if (!compress) {
                out.setLevel(0);
            }
            this.zipDir(zip, out, null);
        }
        return file2;
    }

    public void uploadFiles(String path, int timeout, ErrorContainer upload) throws HtmlMessengerException {
        String[] files = upload.getFiles();
        if (files == null || files.length == 0) {
            return;
        }
        File directory = Files.createTempDir();
        File file2 = null;
        String r = "unknown";
        if (upload.getFileFormat() != null) {
            r = upload.getFileFormat();
        }
        try {
            if (files.length > 1) {
                for (String f : files) {
                    FileUtils.copyFileToDirectory(new File(f), directory, true);
                }
                file2 = this.zipDirectory(directory, false);
            } else {
                file2 = new File(files[0]);
            }
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
            builder.addPart(FILE, (ContentBody)new FileBody(file2, ContentType.APPLICATION_OCTET_STREAM, file2.getName()));
            builder.addPart(TOKEN, (ContentBody)new StringBody(upload.getToken(), ContentType.TEXT_PLAIN));
            builder.addPart(READER, (ContentBody)new StringBody(r, ContentType.TEXT_PLAIN));
            HttpPost request = new HttpPost(path);
            request.setEntity(builder.build());
            CloseableHttpResponse response = this.client.execute((HttpUriRequest)request);
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                int n;
                InputStreamReader reader = new InputStreamReader(entity.getContent());
                char[] buf = new char[32678];
                StringBuilder str = new StringBuilder();
                while ((n = reader.read(buf)) != -1) {
                    str.append(buf, 0, n);
                }
                String s = str.toString();
                this.notifyObservers(new ImportEvent.FILE_UPLOAD_FINISHED(null, 0, 0, null, null, null));
            }
        }
        catch (Exception e) {
            throw new HtmlMessengerException("Cannot Connect", e);
        }
        finally {
            if (this.client != null) {
                try {
                    this.client.close();
                }
                catch (Exception exception) {}
            }
            try {
                FileUtils.deleteDirectory(directory);
            }
            catch (Exception exception) {}
            if (file2 != null && files.length > 1) {
                file2.delete();
            }
        }
    }

    @Override
    public boolean addObserver(IObserver object) {
        return this.observers.add(object);
    }

    @Override
    public boolean deleteObserver(IObserver object) {
        return this.observers.remove(object);
    }

    @Override
    public void notifyObservers(ImportEvent event) {
        for (IObserver observer : this.observers) {
            observer.update(this, event);
        }
    }
}

