/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.importer.transfers;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.List;
import ome.formats.importer.transfers.AbstractFileTransfer;
import ome.formats.importer.transfers.CleanupFailure;
import ome.formats.importer.transfers.TransferState;
import ome.util.checksum.ChecksumProvider;
import omero.ServerError;
import omero.api.RawFileStorePrx;
import org.apache.commons.lang.ArrayUtils;

public class UploadFileTransfer
extends AbstractFileTransfer {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String transfer(TransferState state) throws IOException, ServerError {
        RawFileStorePrx rawFileStore = this.start(state);
        File file2 = state.getFile();
        byte[] buf = state.getBuffer();
        ChecksumProvider cp = state.getChecksumProvider();
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(file2);
            int rlen = 0;
            long offset = 0L;
            state.uploadStarted();
            rawFileStore.write(ArrayUtils.EMPTY_BYTE_ARRAY, offset, 0);
            state.stop();
            state.uploadBytes(offset);
            while (true) {
                byte[] bufferToWrite;
                state.start();
                rlen = stream.read(buf);
                if (rlen == -1) break;
                cp.putBytes(buf, 0, rlen);
                if (rlen < buf.length) {
                    bufferToWrite = new byte[rlen];
                    System.arraycopy(buf, 0, bufferToWrite, 0, rlen);
                } else {
                    bufferToWrite = buf;
                }
                rawFileStore.write(bufferToWrite, offset, rlen);
                state.stop(rlen);
                state.uploadBytes(offset += (long)rlen);
            }
            String string = this.finish(state, offset);
            return string;
        }
        finally {
            this.cleanupUpload(rawFileStore, stream);
        }
    }

    @Override
    public void afterTransfer(int errors, List<String> srcFiles) throws CleanupFailure {
    }
}

