/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.importer.transfers;

import Ice.ObjectNotExistException;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import ome.formats.importer.ImportEvent;
import ome.formats.importer.ImportLibrary;
import ome.formats.importer.util.TimeEstimator;
import ome.util.checksum.ChecksumProvider;
import omero.ServerError;
import omero.api.RawFileStorePrx;
import omero.grid.ImportProcessPrx;
import omero.model.OriginalFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransferState
implements TimeEstimator {
    private static final Logger log = LoggerFactory.getLogger(TransferState.class);
    private final File file;
    private final long length;
    private final int index;
    private final int total;
    private final ImportProcessPrx proc;
    private final ImportLibrary library;
    private final TimeEstimator estimator;
    private final ChecksumProvider cp;
    private final byte[] buf;
    private OriginalFile ofile;
    private String checksum;
    private RawFileStorePrx prx;

    public TransferState(File file2, int index, int total, ImportProcessPrx proc, ImportLibrary library, TimeEstimator estimator, ChecksumProvider cp, byte[] buf) throws IOException, ServerError {
        this.file = file2;
        this.length = file2.length();
        this.index = index;
        this.total = total;
        this.proc = proc;
        this.library = library;
        this.estimator = estimator;
        this.cp = cp;
        this.buf = buf;
    }

    public void save() throws ServerError {
        RawFileStorePrx rawFileStore = this.getUploader("r");
        this.checksum = this.cp.checksumAsString();
        this.ofile = rawFileStore.save();
        if (log.isDebugEnabled()) {
            log.debug(String.format("%s/%s id=%s", this.ofile.getPath().getValue(), this.ofile.getName().getValue(), this.ofile.getId().getValue()));
            log.debug(String.format("checksums: client=%s,server=%s", this.checksum, this.ofile.getHash().getValue()));
        }
    }

    public byte[] getBuffer() {
        return this.buf;
    }

    public String getChecksum() {
        return this.checksum;
    }

    public ChecksumProvider getChecksumProvider() {
        return this.cp;
    }

    public File getFile() {
        return this.file;
    }

    public long getLength() {
        return this.length;
    }

    public OriginalFile getOriginalFile() throws ServerError {
        return this.library.loadOriginalFile(this.getUploader());
    }

    public OriginalFile getRootFile() throws ServerError {
        return this.library.lookupManagedRepository().root();
    }

    public RawFileStorePrx getUploader() throws ServerError {
        return this.getUploader(null);
    }

    public RawFileStorePrx getUploader(String mode) throws ServerError {
        if (this.prx != null) {
            return this.prx;
        }
        if (mode != null) {
            HashMap<String, String> ctx = new HashMap<String, String>();
            ctx.put("omero.fs.mode", mode);
            this.prx = this.proc.getUploader(this.index, ctx);
        } else {
            this.prx = this.proc.getUploader(this.index);
        }
        return this.prx;
    }

    public void closeUploader() {
        if (this.prx != null) {
            try {
                this.prx.close();
            }
            catch (ObjectNotExistException objectNotExistException) {
            }
            catch (Exception e) {
                log.warn("Exception closing " + this.prx, e);
            }
            finally {
                this.prx = null;
            }
        }
    }

    public void uploadStarted() {
        this.library.notifyObservers(new ImportEvent.FILE_UPLOAD_STARTED(this.file.getAbsolutePath(), this.index, this.total, null, this.length, null));
    }

    public void uploadBytes(long offset) {
        this.library.notifyObservers(new ImportEvent.FILE_UPLOAD_BYTES(this.file.getAbsolutePath(), this.index, this.total, offset, this.length, this.estimator.getUploadTimeLeft(), null));
    }

    public void uploadComplete(long offset) {
        this.library.notifyObservers(new ImportEvent.FILE_UPLOAD_COMPLETE(this.file.getAbsolutePath(), this.index, this.total, offset, this.length, null));
    }

    @Override
    public void start() {
        this.estimator.start();
    }

    @Override
    public void stop() {
        this.estimator.stop();
    }

    @Override
    public void stop(long uploadedBytes) {
        this.estimator.stop(uploadedBytes);
    }

    @Override
    public long getUploadTimeLeft() {
        return this.estimator.getUploadTimeLeft();
    }
}

