/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.importer.transfers;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import ome.formats.importer.transfers.CleanupFailure;
import ome.formats.importer.transfers.CopyFileTransfer;
import ome.formats.importer.transfers.CopyMoveFileTransfer;
import ome.formats.importer.transfers.FileTransfer;
import ome.formats.importer.transfers.HardlinkFileTransfer;
import ome.formats.importer.transfers.MoveFileTransfer;
import ome.formats.importer.transfers.SymlinkFileTransfer;
import ome.formats.importer.transfers.TransferState;
import ome.formats.importer.transfers.UploadFileTransfer;
import ome.formats.importer.transfers.UploadRmFileTransfer;
import omero.ServerError;
import omero.api.RawFileStorePrx;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFileTransfer
implements FileTransfer {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());

    public static FileTransfer createTransfer(String arg) {
        Logger tmp = LoggerFactory.getLogger(AbstractFileTransfer.class);
        tmp.debug("Loading file transfer class {}", (Object)arg);
        try {
            return (FileTransfer)Transfers.valueOf((String)arg).kls.newInstance();
        }
        catch (Exception exception) {
            try {
                Class<?> c = Class.forName(arg);
                return (FileTransfer)c.newInstance();
            }
            catch (Exception e) {
                tmp.error("Failed to load file transfer class " + arg);
                throw new RuntimeException(e);
            }
        }
    }

    protected RawFileStorePrx start(TransferState state) throws ServerError {
        this.log.info("Transferring {}...", (Object)state.getFile());
        state.start();
        return state.getUploader();
    }

    protected String finish(TransferState state, long offset) throws ServerError {
        state.start();
        state.save();
        state.stop();
        state.uploadComplete(offset);
        return state.getChecksum();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanupUpload(RawFileStorePrx rawFileStore, FileInputStream stream) throws ServerError {
        try {
            if (rawFileStore != null) {
                try {
                    rawFileStore.close();
                }
                catch (Exception e) {
                    this.log.debug("error in closing raw file store", e);
                }
            }
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    this.log.error("I/O in error closing stream", e);
                }
            }
        }
    }

    protected boolean isWindows() {
        return System.getProperty("os.name").startsWith("Windows");
    }

    protected void printLine() {
        this.log.error("*******************************************");
    }

    protected void deleteTransferredFiles(int errors, List<String> srcFiles) throws CleanupFailure {
        if (errors > 0) {
            this.printLine();
            this.log.error("{} error(s) found.", (Object)errors);
            this.log.error("{} cleanup not performed!", (Object)this.getClass().getSimpleName());
            this.log.error("The following files will *not* be deleted:");
            for (String srcFile : srcFiles) {
                this.log.error("\t{}", (Object)srcFile);
            }
            this.printLine();
            return;
        }
        ArrayList<File> failedFiles = new ArrayList<File>();
        for (String path : srcFiles) {
            File srcFile = new File(path);
            try {
                this.log.info("Deleting source file {}...", (Object)srcFile);
                if (srcFile.delete()) continue;
                throw new RuntimeException("Failed to delete.");
            }
            catch (Exception e) {
                this.log.error("Failed to remove source file {}", (Object)srcFile);
                failedFiles.add(srcFile);
            }
        }
        if (!failedFiles.isEmpty()) {
            this.printLine();
            this.log.error("Cleanup failed!");
            this.log.error("{} files could not be removed and will need to be handled manually", (Object)failedFiles.size());
            for (File failedFile : failedFiles) {
                this.log.error("\t{}", (Object)failedFile.getAbsolutePath());
            }
            this.printLine();
            throw new CleanupFailure(failedFiles);
        }
    }

    public static enum Transfers {
        ln(HardlinkFileTransfer.class),
        ln_rm(MoveFileTransfer.class),
        ln_s(SymlinkFileTransfer.class),
        cp(CopyFileTransfer.class),
        cp_rm(CopyMoveFileTransfer.class),
        upload(UploadFileTransfer.class),
        upload_rm(UploadRmFileTransfer.class);

        Class<?> kls;

        private Transfers(Class<?> kls) {
            this.kls = kls;
        }
    }
}

