/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.importer.transfers;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.util.UUID;
import ome.formats.importer.transfers.AbstractFileTransfer;
import ome.formats.importer.transfers.TransferState;
import ome.util.checksum.ChecksumProvider;
import omero.ServerError;
import omero.api.RawFileStorePrx;
import omero.model.OriginalFile;
import org.apache.commons.io.FileUtils;

public abstract class AbstractExecFileTransfer
extends AbstractFileTransfer {
    private static final String LINE = "\n---------------------------------------------------\n";
    private static final String SEPARATOR = System.getProperty("line.separator");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String transfer(TransferState state) throws IOException, ServerError {
        RawFileStorePrx rawFileStore = this.start(state);
        try {
            OriginalFile root = state.getRootFile();
            OriginalFile ofile = state.getOriginalFile();
            File location = this.getLocalLocation(root, ofile);
            File file2 = state.getFile();
            long length = state.getLength();
            ChecksumProvider cp = state.getChecksumProvider();
            state.uploadStarted();
            this.checkLocation(location, rawFileStore);
            state.closeUploader();
            this.exec(file2, location);
            this.checkTarget(location, state);
            cp.putFile(file2.getAbsolutePath());
            state.stop(length);
            state.uploadBytes(length);
            String string = this.finish(state, length);
            return string;
        }
        finally {
            state.closeUploader();
        }
    }

    protected File getLocalLocation(OriginalFile root, OriginalFile ofile) {
        StringBuilder sb = new StringBuilder();
        sb.append(root.getPath().getValue());
        sb.append(File.separatorChar);
        sb.append(root.getName().getValue());
        sb.append(File.separatorChar);
        sb.append(ofile.getPath().getValue());
        sb.append(File.separatorChar);
        sb.append(ofile.getName().getValue());
        return new File(sb.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkLocation(File location, RawFileStorePrx rawFileStore) throws ServerError, IOException {
        String uuid = UUID.randomUUID().toString();
        if (location.exists()) {
            throw new RuntimeException(location + " exists!");
        }
        try {
            rawFileStore.write(uuid.getBytes(), 0L, uuid.getBytes().length);
        }
        finally {
            rawFileStore.close();
        }
        try {
            if (!location.exists()) {
                throw this.failLocationCheck(location, "does not exist");
            }
            if (!location.canRead()) {
                throw this.failLocationCheck(location, "cannot be read");
            }
            if (!uuid.equals(FileUtils.readFileToString(location))) {
                throw this.failLocationCheck(location, "does not match check text");
            }
        }
        finally {
            if (!location.canWrite()) {
                throw this.failLocationCheck(location, "cannot be modified locally");
            }
            boolean deleted = FileUtils.deleteQuietly(location);
            if (!deleted) {
                throw this.failLocationCheck(location, "could not be cleaned up");
            }
        }
    }

    protected RuntimeException failLocationCheck(File location, String msg) {
        StringBuilder sb = new StringBuilder();
        sb.append(LINE);
        sb.append(String.format("Check failed: %s %s!\n", location, msg));
        sb.append("You likely do not have access to the ManagedRepository ");
        sb.append("for in-place import.\n");
        sb.append("Aborting...");
        sb.append(LINE);
        throw new RuntimeException(sb.toString());
    }

    protected void exec(File file2, File location) throws IOException {
        ProcessBuilder pb = this.createProcessBuilder(file2, location);
        pb.redirectErrorStream(true);
        Process process = pb.start();
        Integer rcode = null;
        while (rcode == null) {
            try {
                rcode = process.waitFor();
                break;
            }
            catch (InterruptedException e) {
            }
        }
        if (rcode == null || rcode != 0) {
            StringWriter sw = new StringWriter();
            sw.append("transfer process returned: ");
            sw.append(Integer.toString(rcode));
            sw.append("\n");
            sw.append("command:");
            for (String arg : pb.command()) {
                sw.append(" ");
                sw.append(arg);
            }
            sw.append("\n");
            sw.append("output:");
            sw.append(LINE);
            String line = "";
            BufferedReader br = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = br.readLine()) != null) {
                sw.append(line);
                sw.append(SEPARATOR);
            }
            sw.append(LINE);
            String msg = sw.toString();
            this.log.error(msg);
            throw new RuntimeException(msg);
        }
    }

    protected void checkTarget(File location, TransferState state) throws ServerError {
        try {
            state.getUploader("r").size();
        }
        catch (Throwable t) {
            String message = t instanceof ServerError ? ((ServerError)t).message : t.getMessage();
            StringBuilder sb = new StringBuilder();
            sb.append(t.getClass().getName());
            sb.append(" : ");
            sb.append(message);
            sb.append("\nThe server could not check the size of the file:\n");
            sb.append("-----------------------------------------------\n");
            sb.append(location);
            sb.append("\n-----------------------------------------------\n");
            sb.append("Most likely the server process has no read access\n");
            sb.append("and therefore in-place import cannot proceed. You\n");
            sb.append("should delete this file manually if you are sure\n");
            sb.append("that the original is safe.\n");
            throw new RuntimeException(sb.toString());
        }
    }

    protected abstract ProcessBuilder createProcessBuilder(File var1, File var2);

    @Override
    protected void printLine() {
        this.log.error("*******************************************");
    }
}

