/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.importer.cli;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import loci.formats.in.DefaultMetadataOptions;
import loci.formats.in.MetadataLevel;
import ome.formats.OMEROMetadataStoreClient;
import ome.formats.importer.ImportCandidates;
import ome.formats.importer.ImportConfig;
import ome.formats.importer.ImportContainer;
import ome.formats.importer.ImportEvent;
import ome.formats.importer.ImportLibrary;
import ome.formats.importer.OMEROWrapper;
import ome.formats.importer.cli.ErrorHandler;
import ome.formats.importer.cli.ImportCloser;
import ome.formats.importer.cli.ImportOutput;
import ome.formats.importer.cli.LoggingImportMonitor;
import ome.formats.importer.exclusions.AbstractFileExclusion;
import ome.formats.importer.exclusions.FileExclusion;
import ome.formats.importer.transfers.AbstractFileTransfer;
import ome.formats.importer.transfers.CleanupFailure;
import ome.formats.importer.transfers.FileTransfer;
import ome.formats.importer.transfers.UploadFileTransfer;
import omero.model.Annotation;
import omero.model.CommentAnnotationI;
import omero.rtypes;
import org.apache.commons.lang.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandLineImporter {
    public static final int DEFAULT_WAIT = -1;
    private static Logger log = LoggerFactory.getLogger(CommandLineImporter.class);
    private final StopWatch sw = new StopWatch();
    private static final String APP_NAME = "importer-cli";
    public final ImportConfig config;
    public final FileTransfer transfer;
    public final List<FileExclusion> exclusions = new ArrayList<FileExclusion>();
    public final ImportLibrary library;
    public final ErrorHandler handler;
    private final OMEROWrapper reader;
    private final OMEROMetadataStoreClient store;
    private final ImportCandidates candidates;
    private final boolean getUsedFiles;
    private ImportOutput importOutput = ImportOutput.ids;

    public CommandLineImporter(ImportConfig config, String[] paths, boolean getUsedFiles) throws Exception {
        this(config, paths, getUsedFiles, new UploadFileTransfer(), -1);
    }

    public CommandLineImporter(ImportConfig config, String[] paths, boolean getUsedFiles, FileTransfer transfer, int minutesToWait) throws Exception {
        this(config, paths, getUsedFiles, new UploadFileTransfer(), null, -1);
    }

    public CommandLineImporter(ImportConfig config, String[] paths, boolean getUsedFiles, FileTransfer transfer, List<FileExclusion> exclusions, int minutesToWait) throws Exception {
        this.config = config;
        config.loadAll();
        this.getUsedFiles = getUsedFiles;
        this.reader = new OMEROWrapper(config);
        this.handler = new ErrorHandler(config);
        this.transfer = transfer;
        if (exclusions != null) {
            this.exclusions.addAll(exclusions);
        }
        this.candidates = new ImportCandidates(this.reader, paths, this.handler);
        if (paths == null || paths.length == 0 || getUsedFiles) {
            this.store = null;
            this.library = null;
        } else {
            if (!config.canLogin()) {
                CommandLineImporter.usage();
            }
            if (((Boolean)config.checkUpgrade.get()).booleanValue()) {
                config.isUpgradeNeeded();
            } else {
                log.debug("UpgradeCheck disabled.");
            }
            this.store = config.createStore();
            this.store.logVersionInfo(config.getIniVersionNumber());
            this.reader.setMetadataOptions(new DefaultMetadataOptions(MetadataLevel.ALL));
            this.library = new ImportLibrary(this.store, this.reader, transfer, exclusions, minutesToWait);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                CommandLineImporter.this.cleanup();
            }
        });
    }

    public static int closeCompleted(ImportConfig config) throws Exception {
        config.loadAll();
        OMEROMetadataStoreClient client2 = config.createStore();
        ImportCloser closer = new ImportCloser(client2);
        closer.closeCompleted();
        log.info("{} service(s) processed", (Object)closer.getProcessed());
        return closer.getErrors();
    }

    public static int waitCompleted(ImportConfig config) throws Exception {
        long wait = 5000L;
        config.loadAll();
        OMEROMetadataStoreClient client2 = config.createStore();
        while (true) {
            ImportCloser closer = new ImportCloser(client2);
            closer.closeCompleted();
            if (closer.getProcessed() == 0) {
                return 0;
            }
            int closed = closer.getClosed();
            int open = closer.getProcessed() - closed;
            int errs = closer.getErrors();
            if (errs > 0) {
                log.warn("{} open. {} closed. {} errors", open, closed, errs);
            } else {
                log.info("{} open. {} closed.", (Object)open, (Object)closed);
            }
            try {
                log.debug("Sleeping {} ms", (Object)wait);
                Thread.sleep(wait);
            }
            catch (Exception exception) {
            }
        }
    }

    public ImportOutput setImportOutput(ImportOutput importOutput) {
        ImportOutput old = importOutput;
        if (importOutput == null) {
            this.importOutput = ImportOutput.ids;
        }
        this.importOutput = importOutput;
        return old;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int start() {
        boolean successful = true;
        if (this.getUsedFiles) {
            try {
                switch (this.importOutput) {
                    case yaml: {
                        this.candidates.printYaml();
                        break;
                    }
                    default: {
                        this.candidates.print();
                    }
                }
                return this.candidates.size() == 0 ? 125 : 0;
            }
            catch (Throwable t) {
                log.error("Error retrieving used files.", t);
                return 1;
            }
        }
        if (this.candidates.size() < 1) {
            if (this.handler.errorCount() > 0) {
                System.err.println("No imports due to errors!");
                this.report();
            } else {
                System.err.println("No imports found");
                try {
                    this.cleanup();
                }
                finally {
                    CommandLineImporter.usage();
                }
            }
        } else {
            this.sw.start();
            LoggingImportMonitor lim = new LoggingImportMonitor();
            lim.setImportOutput(this.importOutput);
            this.library.addObserver(lim);
            this.library.addObserver(this.handler);
            successful = this.library.importCandidates(this.config, this.candidates);
            try {
                ArrayList<String> paths = new ArrayList<String>();
                for (ImportContainer ic : this.candidates.getContainers()) {
                    paths.addAll(Arrays.asList(ic.getUsedFiles()));
                }
                this.transfer.afterTransfer(this.handler.errorCount(), paths);
            }
            catch (CleanupFailure e) {
                log.error("Failed to cleanup {} files", (Object)e.getFailedFiles().size());
                int n = 3;
                return n;
            }
            finally {
                this.sw.stop();
                this.report();
            }
        }
        return successful ? 0 : 2;
    }

    void report() {
        boolean report = (Boolean)this.config.sendReport.get();
        boolean files = (Boolean)this.config.sendFiles.get();
        boolean logs = (Boolean)this.config.sendLogFile.get();
        if (report) {
            this.handler.update(null, new ImportEvent.DEBUG_SEND(files, logs));
        }
        this.library.notifyObservers(new ImportEvent.IMPORT_SUMMARY(this.sw.getTime(), this.handler.errorCount()));
    }

    public void cleanup() {
        if (this.store != null) {
            this.store.logout();
        }
    }

    public static void usage() {
        System.err.println(String.format("\n Usage:  %s [OPTION]... [path [path ...]]... \n   or:   %s [OPTION]... - \n\nImport any number of files into an OMERO instance.\nIf \"-\" is the only path, a list of files or directories \nis read from standard in. Directories will be searched for \nall valid imports.\n\nSession arguments:\n  Mandatory arguments for creating a session are 1- either the OMERO server hostname,\nusername and password or 2- the OMERO server hostname and a valid session key.\n  -s SERVER\tOMERO server hostname\n  -u USER\tOMERO username\n  -w PASSWORD\tOMERO password\n  -k KEY\tOMERO session key (UUID of an active session)\n  -p PORT\tOMERO server port (default: 4064)\n\nNaming arguments:\nAll naming arguments are optional\n  -n NAME\t\t\t\tImage or plate name to use\n  -x DESCRIPTION\t\t\tImage or plate description to use\n  --name NAME\t\t\t\tImage or plate name to use\n  --description DESCRIPTION\t\tImage or plate description to use\n\nOptional arguments:\n  -h\t\t\t\t\tDisplay this help and exit\n  -f\t\t\t\t\tDisplay the used files and exit\n  -c\t\t\t\t\tContinue importing after errors\n  -l READER_FILE\t\t\tUse the list of readers rather than the default\n  -d DATASET_ID\t\t\t\tOMERO dataset ID to import image into\n  -r SCREEN_ID\t\t\t\tOMERO screen ID to import plate into\n  -T TARGET\t\t\t\ttarget for imports\n  --report\t\t\t\tReport errors to the OME team\n  --upload\t\t\t\tUpload broken files and log file (if any) with report. Required --report\n  --logs\t\t\t\tUpload log file (if any) with report. Required --report\n  --email EMAIL\t\t\t\tEmail for reported errors. Required --report\n  --debug LEVEL\t\t\t\tTurn debug logging on (optional level)\n  --annotation-ns ANNOTATION_NS\t\tNamespace to use for subsequent annotation\n  --annotation-text ANNOTATION_TEXT\tContent for a text annotation\n  --annotation-link ANNOTATION_LINK\tComment annotation ID to link all images to\n\nExamples:\n\n  $ %s -s localhost -u user -w password -d 50 foo.tiff\n  $ %s -s localhost -u user -w password -d Dataset:50 foo.tiff\n  $ %s -f foo.tiff\n  $ %s -s localhost -u username -w password -d 50 --debug ALL foo.tiff\n\nFor additional information, see:\nhttp://www.openmicroscopy.org/site/support/omero5.2/users/cli/import.html\nReport bugs to <ome-users@lists.openmicroscopy.org.uk>", APP_NAME, APP_NAME, APP_NAME, APP_NAME, APP_NAME, APP_NAME));
        System.exit(1);
    }

    public static void advUsage() {
        System.err.println("\nADVANCED OPTIONS:\n\n  These options are not intended for general use. Make sure you have read the\n  documentation regarding them. They may change in future releases.\n\n  In-place imports:\n  -----------------\n\n    --transfer=ARG          \tFile transfer method\n\n        General options:    \t\n          upload          \t# Default\n          upload_rm       \t# Caution! File upload followed by source deletion.\n          some.class.Name \t# Use a class on the CLASSPATH.\n\n        Server-side options:\t\n          ln              \t# Use hard-link.\n          ln_s            \t# Use soft-link.\n          ln_rm           \t# Caution! Hard-link followed by source deletion.\n          cp              \t# Use local copy command.\n          cp_rm           \t# Caution! Copy followed by source deletion.\n\n\n  e.g. $ bin/omero import -- --transfer=ln_s foo.tiff\n       $ ./importer-cli --transfer=ln bar.tiff\n       $ CLASSPATH=mycode.jar ./importer-cli --transfer=com.example.MyTransfer baz.tiff\n\n  Background imports:\n  -------------------\n\n    --auto-close            \tClose completed imports immediately.\n\n    --minutes-wait=ARG      \tChoose how long the importer will wait on server-side processing.\n                            \tARG > 0 implies the number of minutes to wait.\n                            \tARG = 0 exits immediately. Use a *-completed option to clean up.\n                            \tARG < 0 waits indefinitely. This is the default.\n\n    --close-completed       \tClose completed imports.\n\n    --wait-completed        \tWait for all background imports to complete.\n\n\n  e.g. $ bin/omero import -- --minutes-wait=0 file1.tiff file2.tiff file3.tiff\n       $ ./importer-cli --minutes-wait=0 some_directory/\n       $ ./importer-cli --wait-completed # Waits on all 3 imports.\n\n  File exclusion:\n  ---------------\n\n    --exclude=filename      \tExclude files based on filename.\n\n    --exclude=clientpath    \tExclude files based on the original path.\n\n\n  e.g. $ bin/omero import -- --exclude=filename foo.tiff # First-time imports\n       $ bin/omero import -- --exclude=filename foo.tiff # Second-time skips\n\n  Import speed:\n  -------------\n\n    --checksum-algorithm=ARG\tChoose a possibly faster algorithm for detecting file corruption,\n                            \te.g. Adler-32 (fast), CRC-32 (fast), File-Size-64 (fast),\n                            \t     MD5-128, Murmur3-32, Murmur3-128,\n                            \t     SHA1-160 (slow, default)\n\n  e.g. $ bin/omero import -- --checksum-algorithm=CRC-32 foo.tiff\n       $ ./importer-cli --checksum-algorithm=Murmur3-128 bar.tiff\n\n    --no-stats-info\t\tDisable calculation of minima and maxima when as part of the Bio-Formats reader metadata\n\n  e.g. $ bin/omero import -- --no-stats-info foo.tiff\n       $ ./importer-cli --no-stats-info bar.tiff\n\n  --no-thumbnails\t\tDo not perform thumbnailing after import\n\n  e.g. $ bin/omero import -- --no-thumbnails foo.tiff\n       $ ./importer-cli --no-thumbnails bar.tiff\n\n    --no-upgrade-check\t\tDisable upgrade check for each import\n  e.g. $ bin/omero import -- --no-upgrade-check foo.tiff\n       $ ./importer-cli --no-upgrade-check bar.tiff\n\n\n  Feedback:\n  ---------\n\n    --qa-baseurl=ARG\tSpecify the base URL for reporting feedback\n  e.g. $ bin/omero import broken_image.tif -- --email EMAIL --report --upload --logs --qa-baseurl=https://qa.staging.openmicroscopy.org/qa\n       $ ./importer-cli broken_image.tif --email EMAIL --report --upload --logs --qa-baseurl=https://qa.staging.openmicroscopy.org/qa\n\nReport bugs to <ome-users@lists.openmicroscopy.org.uk>");
        System.exit(1);
    }

    private static List<Annotation> toTextAnnotations(List<String> namespaces, List<String> strings) {
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        if (namespaces.size() != strings.size()) {
            String ns = null;
            if (namespaces.size() == 1) {
                ns = namespaces.get(0);
            }
            for (int i = 0; i < strings.size(); ++i) {
                CommentAnnotationI annotation = new CommentAnnotationI();
                if (ns != null) {
                    annotation.setTextValue(rtypes.rstring(ns));
                }
                annotation.setTextValue(rtypes.rstring(strings.get(i)));
                annotations.add(annotation);
            }
        } else {
            for (int i = 0; i < namespaces.size(); ++i) {
                CommentAnnotationI annotation = new CommentAnnotationI();
                annotation.setNs(rtypes.rstring(namespaces.get(i)));
                annotation.setTextValue(rtypes.rstring(strings.get(i)));
                annotations.add(annotation);
            }
        }
        return annotations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        int a;
        int minutesToWait = -1;
        FileTransfer transfer = new UploadFileTransfer();
        ImportConfig config = new ImportConfig();
        config.email.set("");
        config.sendFiles.set(false);
        config.sendLogFile.set(false);
        config.sendReport.set(false);
        config.contOnError.set(false);
        config.debug.set(false);
        config.encryptedConnection.set(false);
        LongOpt debug = new LongOpt("debug", 2, null, 1);
        LongOpt report = new LongOpt("report", 0, null, 2);
        LongOpt upload = new LongOpt("upload", 0, null, 3);
        LongOpt logs = new LongOpt("logs", 0, null, 4);
        LongOpt email = new LongOpt("email", 1, null, 5);
        LongOpt name = new LongOpt("name", 1, null, 6);
        LongOpt description = new LongOpt("description", 1, null, 7);
        LongOpt noThumbnails = new LongOpt("no-thumbnails", 0, null, 8);
        LongOpt agent = new LongOpt("agent", 1, null, 9);
        LongOpt annotationNamespace = new LongOpt("annotation-ns", 1, null, 10);
        LongOpt annotationText = new LongOpt("annotation-text", 1, null, 11);
        LongOpt annotationLink = new LongOpt("annotation-link", 1, null, 12);
        LongOpt advancedHelp = new LongOpt("advanced-help", 0, null, 13);
        LongOpt transferOpt = new LongOpt("transfer", 1, null, 14);
        LongOpt checksumAlgorithm = new LongOpt("checksum-algorithm", 1, null, 15);
        LongOpt minutesWait = new LongOpt("minutes-wait", 1, null, 16);
        LongOpt closeCompleted = new LongOpt("close-completed", 0, null, 17);
        LongOpt waitCompleted = new LongOpt("wait-completed", 0, null, 18);
        LongOpt autoClose = new LongOpt("auto-close", 0, null, 19);
        LongOpt exclude = new LongOpt("exclude", 1, null, 20);
        LongOpt target = new LongOpt("target", 1, null, 21);
        LongOpt qaBaseURL = new LongOpt("qa-baseurl", 1, null, 22);
        LongOpt noStatsInfo = new LongOpt("no-stats-info", 0, null, 23);
        LongOpt noUpgradeCheck = new LongOpt("no-upgrade-check", 0, null, 24);
        LongOpt outputFormat = new LongOpt("output", 1, null, 25);
        LongOpt minutesWaitDeprecated = new LongOpt("minutes_wait", 1, null, 86);
        LongOpt closeCompletedDeprecated = new LongOpt("close_completed", 0, null, 87);
        LongOpt waitCompletedDeprecated = new LongOpt("wait_completed", 0, null, 88);
        LongOpt autoCloseDeprecated = new LongOpt("auto_close", 0, null, 89);
        LongOpt plateName = new LongOpt("plate_name", 1, null, 90);
        LongOpt plateDescription = new LongOpt("plate_description", 1, null, 91);
        LongOpt noThumbnailsDeprecated = new LongOpt("no_thumbnails", 0, null, 92);
        LongOpt checksumAlgorithmDeprecated = new LongOpt("checksum_algorithm", 1, null, 93);
        LongOpt annotationNamespaceDeprecated = new LongOpt("annotation_ns", 1, null, 94);
        LongOpt annotationTextDeprecated = new LongOpt("annotation_text", 1, null, 95);
        LongOpt annotationLinkDeprecated = new LongOpt("annotation_link", 1, null, 96);
        LongOpt plateDescription2 = new LongOpt("plate-description", 1, null, 97);
        LongOpt plateName2 = new LongOpt("plate-name", 1, null, 98);
        Getopt g = new Getopt(APP_NAME, args, "cfl:s:u:w:d:r:T:k:x:n:p:h", new LongOpt[]{debug, report, upload, logs, email, name, description, noThumbnails, agent, annotationNamespace, annotationText, annotationLink, transferOpt, advancedHelp, checksumAlgorithm, minutesWait, closeCompleted, waitCompleted, autoClose, exclude, target, noStatsInfo, noUpgradeCheck, qaBaseURL, outputFormat, plateName, plateName2, plateDescription, plateDescription2, noThumbnailsDeprecated, checksumAlgorithmDeprecated, annotationNamespaceDeprecated, annotationTextDeprecated, annotationLinkDeprecated, minutesWaitDeprecated, closeCompletedDeprecated, waitCompletedDeprecated, autoCloseDeprecated});
        ImportOutput outputChoice = ImportOutput.ids;
        boolean doCloseCompleted = false;
        boolean doWaitCompleted = false;
        boolean getUsedFiles = false;
        config.agent.set(APP_NAME);
        HashMap<String, Boolean> conflictingArguments = new HashMap<String, Boolean>();
        conflictingArguments.put("userSpecifiedName", false);
        conflictingArguments.put("userSpecifiedDescription", false);
        conflictingArguments.put("checksumAlgorithm", false);
        ArrayList<String> annotationNamespaces = new ArrayList<String>();
        ArrayList<String> textAnnotations = new ArrayList<String>();
        ArrayList<Long> annotationIds = new ArrayList<Long>();
        ArrayList<FileExclusion> exclusions = new ArrayList<FileExclusion>();
        block52: while ((a = g.getopt()) != -1) {
            switch (a) {
                case 1: {
                    config.configureDebug(g.getOptarg());
                    continue block52;
                }
                case 2: {
                    config.sendReport.set(true);
                    continue block52;
                }
                case 3: {
                    config.sendFiles.set(true);
                    continue block52;
                }
                case 4: {
                    config.sendLogFile.set(true);
                    continue block52;
                }
                case 5: {
                    config.email.set(g.getOptarg());
                    continue block52;
                }
                case 6: {
                    CommandLineImporter.setArgument(conflictingArguments, "userSpecifiedName");
                    config.userSpecifiedName.set(g.getOptarg());
                    continue block52;
                }
                case 7: {
                    CommandLineImporter.setArgument(conflictingArguments, "userSpecifiedDescription");
                    config.userSpecifiedDescription.set(g.getOptarg());
                    continue block52;
                }
                case 8: {
                    log.info("Skipping thumbnails creation");
                    config.doThumbnails.set(false);
                    continue block52;
                }
                case 9: {
                    config.agent.set(g.getOptarg());
                    continue block52;
                }
                case 10: {
                    annotationNamespaces.add(g.getOptarg());
                    continue block52;
                }
                case 11: {
                    textAnnotations.add(g.getOptarg());
                    continue block52;
                }
                case 12: {
                    annotationIds.add(Long.parseLong(g.getOptarg()));
                    continue block52;
                }
                case 13: {
                    CommandLineImporter.advUsage();
                    continue block52;
                }
                case 14: {
                    String arg = g.getOptarg();
                    log.info("Setting transfer to {}", (Object)arg);
                    transfer = AbstractFileTransfer.createTransfer(arg);
                    continue block52;
                }
                case 15: {
                    CommandLineImporter.setArgument(conflictingArguments, "checksumAlgorithm");
                    String arg = g.getOptarg();
                    log.info("Setting checksum algorithm to {}", (Object)arg);
                    config.checksumAlgorithm.set(arg);
                    continue block52;
                }
                case 16: 
                case 86: {
                    minutesToWait = Integer.parseInt(g.getOptarg());
                    log.info("Setting minutes to wait to {}", (Object)minutesToWait);
                    continue block52;
                }
                case 17: 
                case 87: {
                    doCloseCompleted = true;
                    continue block52;
                }
                case 18: 
                case 88: {
                    doWaitCompleted = true;
                    continue block52;
                }
                case 19: 
                case 89: {
                    minutesToWait = 0;
                    config.autoClose.set(true);
                    continue block52;
                }
                case 20: {
                    String arg = g.getOptarg();
                    log.info("Adding exclusion: {}", (Object)arg);
                    FileExclusion exclusion = AbstractFileExclusion.createExclusion(arg);
                    if (exclusion == null) continue block52;
                    exclusions.add(exclusion);
                    continue block52;
                }
                case 21: 
                case 84: {
                    config.target.set(g.getOptarg());
                    continue block52;
                }
                case 22: {
                    config.qaBaseURL.set(g.getOptarg());
                    continue block52;
                }
                case 23: {
                    log.info("Skipping minimum/maximum computation");
                    config.noStatsInfo.set(true);
                    continue block52;
                }
                case 24: {
                    log.info("Disabling upgrade check");
                    config.checkUpgrade.set(false);
                    continue block52;
                }
                case 25: {
                    String outputArg = g.getOptarg();
                    log.info("Setting output format: {}", (Object)outputArg);
                    outputChoice = ImportOutput.valueOf(outputArg);
                    continue block52;
                }
                case 90: 
                case 98: {
                    CommandLineImporter.setArgument(conflictingArguments, "userSpecifiedName");
                    config.userSpecifiedName.set(g.getOptarg());
                    continue block52;
                }
                case 91: 
                case 97: {
                    CommandLineImporter.setArgument(conflictingArguments, "userSpecifiedDescription");
                    config.userSpecifiedDescription.set(g.getOptarg());
                    continue block52;
                }
                case 92: {
                    log.info("Skipping thumbnails creation");
                    config.doThumbnails.set(false);
                    continue block52;
                }
                case 93: {
                    CommandLineImporter.setArgument(conflictingArguments, "checksumAlgorithm");
                    String arg = g.getOptarg();
                    log.info("Setting checksum algorithm to {}", (Object)arg);
                    config.checksumAlgorithm.set(arg);
                    continue block52;
                }
                case 94: {
                    annotationNamespaces.add(g.getOptarg());
                    continue block52;
                }
                case 95: {
                    textAnnotations.add(g.getOptarg());
                    continue block52;
                }
                case 96: {
                    annotationIds.add(Long.parseLong(g.getOptarg()));
                    continue block52;
                }
                case 115: {
                    config.hostname.set(g.getOptarg());
                    continue block52;
                }
                case 117: {
                    config.username.set(g.getOptarg());
                    continue block52;
                }
                case 119: {
                    config.password.set(g.getOptarg());
                    continue block52;
                }
                case 107: {
                    config.sessionKey.set(g.getOptarg());
                    continue block52;
                }
                case 112: {
                    config.port.set(Integer.parseInt(g.getOptarg()));
                    continue block52;
                }
                case 100: {
                    String datasetString = g.getOptarg();
                    if (!datasetString.startsWith("Dataset:")) {
                        datasetString = "Dataset:" + Long.valueOf(datasetString).toString();
                    }
                    config.target.set(datasetString);
                    continue block52;
                }
                case 114: {
                    String screenString = g.getOptarg();
                    if (!screenString.startsWith("Screen:")) {
                        screenString = "Screen:" + Long.valueOf(screenString).toString();
                    }
                    config.target.set(screenString);
                    continue block52;
                }
                case 110: {
                    CommandLineImporter.setArgument(conflictingArguments, "userSpecifiedName");
                    config.userSpecifiedName.set(g.getOptarg());
                    continue block52;
                }
                case 120: {
                    CommandLineImporter.setArgument(conflictingArguments, "userSpecifiedDescription");
                    config.userSpecifiedDescription.set(g.getOptarg());
                    continue block52;
                }
                case 102: {
                    getUsedFiles = true;
                    continue block52;
                }
                case 99: {
                    config.contOnError.set(true);
                    continue block52;
                }
                case 108: {
                    config.readersPath.set(g.getOptarg());
                    continue block52;
                }
                case 104: {
                    CommandLineImporter.usage();
                }
            }
            CommandLineImporter.usage();
        }
        log.info(String.format("Log levels -- Bio-Formats: %s OMERO.importer: %s", ((ch.qos.logback.classic.Logger)LoggerFactory.getLogger("loci")).getLevel(), ((ch.qos.logback.classic.Logger)LoggerFactory.getLogger("ome.formats")).getLevel()));
        Object[] rest = new String[args.length - g.getOptind()];
        System.arraycopy(args, g.getOptind(), rest, 0, args.length - g.getOptind());
        if (doCloseCompleted || doWaitCompleted) {
            if (rest.length > 0) {
                log.error("Files found with completed option: " + Arrays.toString(rest));
                System.exit(-2);
            } else if (doCloseCompleted) {
                System.exit(CommandLineImporter.closeCompleted(config));
            } else if (doWaitCompleted) {
                System.exit(CommandLineImporter.waitCompleted(config));
            }
        }
        List<Annotation> annotations = CommandLineImporter.toTextAnnotations(annotationNamespaces, textAnnotations);
        for (Long id : annotationIds) {
            CommentAnnotationI unloadedAnnotation = new CommentAnnotationI(id, false);
            annotations.add(unloadedAnnotation);
        }
        config.annotations.set(annotations);
        CommandLineImporter c = null;
        int rc = 0;
        try {
            if (rest.length == 1 && "-".equals(rest[0])) {
                rest = CommandLineImporter.stdin();
            }
            c = new CommandLineImporter(config, (String[])rest, getUsedFiles, transfer, exclusions, minutesToWait);
            c.setImportOutput(outputChoice);
            rc = c.start();
        }
        catch (Throwable t) {
            log.error("Error during import process.", t);
            rc = 2;
        }
        finally {
            if (c != null) {
                c.cleanup();
            }
        }
        System.exit(rc);
    }

    public static void setArgument(Map<String, Boolean> map, String key) {
        if (map.get(key).booleanValue()) {
            log.error("Conflicting arguments setting {}.", (Object)key);
            CommandLineImporter.usage();
        }
        map.put(key, true);
    }

    static String[] stdin() throws IOException {
        String str;
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        ArrayList<String> files = new ArrayList<String>();
        while ((str = in.readLine()) != null) {
            if ((str = str.trim()).length() <= 0) continue;
            files.add(str);
        }
        return files.toArray(new String[0]);
    }
}

